/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.query.QueryPlugin;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;

class ProcedureBatchHandler {
    private Call proc;
    private ProcedureExecution procExec;
    private int paramCols = 0;
    private int resultSetCols = 0;
    private List filler;

    public ProcedureBatchHandler(Call proc, ProcedureExecution procExec) {
        this.proc = proc;
        this.procExec = procExec;
        List params = proc.getArguments();
        this.resultSetCols = proc.getResultSetColumnTypes().length;
        if (proc.getReturnType() != null) {
            ++this.paramCols;
        }
        if (params != null && !params.isEmpty()) {
            for (Argument param : params) {
                if (param.getDirection() != Argument.Direction.OUT && param.getDirection() != Argument.Direction.INOUT) continue;
                ++this.paramCols;
            }
        }
        if (this.paramCols > 0) {
            this.filler = Collections.nCopies(this.paramCols, null);
        }
    }

    List padRow(List row) throws TranslatorException {
        if (row.size() != this.resultSetCols) {
            throw new TranslatorException(QueryPlugin.Util.getString("ConnectorWorker.ConnectorWorker_result_set_unexpected_columns", new Object[]{this.proc, new Integer(this.resultSetCols), new Integer(row.size())}));
        }
        if (this.paramCols == 0) {
            return row;
        }
        ArrayList result = new ArrayList(this.resultSetCols + this.paramCols);
        result.addAll(row);
        result.addAll(this.filler);
        return result;
    }

    List getParameterRow() throws TranslatorException {
        if (this.paramCols == 0) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(new Object[this.resultSetCols]));
        result.addAll(this.procExec.getOutputParameterValues());
        return result;
    }
}

