/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.util.ArrayList;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.cache.Cachable;
import org.teiid.cache.Cache;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.process.AccessInfo;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.ElementSymbol;

public class CachedResults
implements Serializable,
Cachable {
    private static final long serialVersionUID = -5603182134635082207L;
    private transient Command command;
    private transient TupleBuffer results;
    private String[] types;
    private CacheHint hint;
    private int batchSize;
    private String uuid;
    private int rowCount;
    private boolean hasLobs;
    private AccessInfo accessInfo = new AccessInfo();

    public String getId() {
        return this.uuid;
    }

    public TupleBuffer getResults() {
        return this.results;
    }

    public void setResults(TupleBuffer results, ProcessorPlan plan) {
        this.results = results;
        this.batchSize = results.getBatchSize();
        this.types = TupleBuffer.getTypeNames(results.getSchema());
        this.rowCount = results.getRowCount();
        this.uuid = results.getId();
        this.hasLobs = results.isLobs();
        this.accessInfo.populate(plan.getContext(), true);
    }

    public void setCommand(Command command) {
        this.command = command;
        this.hint = command.getCacheHint();
    }

    public void setHint(CacheHint hint) {
        this.hint = hint;
    }

    public CacheHint getHint() {
        return this.hint;
    }

    public synchronized Command getCommand(String sql, QueryMetadataInterface metadata, ParseInfo info) throws QueryParserException, QueryResolverException, TeiidComponentException {
        if (this.command == null) {
            this.command = QueryParser.getQueryParser().parseCommand(sql, info);
        }
        QueryResolver.resolveCommand(this.command, metadata);
        return this.command;
    }

    @Override
    public boolean prepare(Cache cache, BufferManager bufferManager) {
        Assertion.assertTrue((!this.results.isForwardOnly() ? 1 : 0) != 0);
        bufferManager.addTupleBuffer(this.results);
        return true;
    }

    @Override
    public synchronized boolean restore(Cache cache, BufferManager bufferManager) {
        if (this.results == null) {
            if (this.hasLobs) {
                return false;
            }
            TupleBuffer buffer = null;
            try {
                ArrayList<ElementSymbol> schema = new ArrayList<ElementSymbol>(this.types.length);
                for (String type : this.types) {
                    ElementSymbol es = new ElementSymbol("x");
                    es.setType(DataTypeManager.getDataTypeClass((String)type));
                    schema.add(es);
                }
                buffer = bufferManager.createTupleBuffer(schema, "cached", BufferManager.TupleSourceType.FINAL);
                buffer.setBatchSize(this.batchSize);
                buffer.setId(this.uuid);
                if (this.hint != null) {
                    buffer.setPrefersMemory(this.hint.getPrefersMemory());
                }
                for (int row = 1; row <= this.rowCount; row += this.batchSize) {
                    TupleBatch batch = (TupleBatch)cache.get(this.uuid + "," + row);
                    if (batch == null) {
                        LogManager.logInfo((String)"org.teiid.PROCESSOR", (String)QueryPlugin.Util.getString("not_found_cache"));
                        buffer.remove();
                        return false;
                    }
                    buffer.addTupleBatch(batch, true);
                    cache.remove(this.uuid + "," + row);
                }
                this.results = buffer;
                bufferManager.addTupleBuffer(this.results);
                this.results.close();
                this.accessInfo.restore();
            }
            catch (TeiidException e) {
                LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (String)QueryPlugin.Util.getString("unexpected_exception_restoring_results"));
                if (buffer != null) {
                    buffer.remove();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public AccessInfo getAccessInfo() {
        return this.accessInfo;
    }
}

