/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;

public class FunctionDescriptor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5374103983118037242L;
    private static final boolean ALLOW_NAN_INFINITY = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.allowNanInfinity", (boolean)false);
    private Class<?>[] types;
    private Class<?> returnType;
    private boolean requiresContext;
    private FunctionMethod method;
    private String schema;
    private Object metadataID;
    private transient Method invocationMethod;

    FunctionDescriptor() {
    }

    FunctionDescriptor(FunctionMethod method, Class<?>[] types, Class<?> outputType, Method invocationMethod, boolean requiresContext) {
        this.types = types;
        this.returnType = outputType;
        this.invocationMethod = invocationMethod;
        this.requiresContext = requiresContext;
        this.method = method;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.method.getName();
    }

    public FunctionMethod.PushDown getPushdown() {
        return this.method.getPushdown();
    }

    public Class<?>[] getTypes() {
        return this.types;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    Method getInvocationMethod() {
        return this.invocationMethod;
    }

    public boolean requiresContext() {
        return this.requiresContext;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.method.getName());
        str.append("(");
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != null) {
                str.append(this.types[i].getName());
            } else {
                str.append("null");
            }
            if (i >= this.types.length - 1) continue;
            str.append(", ");
        }
        str.append(") : ");
        if (this.returnType == null) {
            str.append("null");
        } else {
            str.append(this.returnType.getName());
        }
        return str.toString();
    }

    public boolean isNullDependent() {
        return !this.method.isNullOnNull();
    }

    public FunctionMethod.Determinism getDeterministic() {
        return this.method.getDeterminism();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public FunctionMethod getMethod() {
        return this.method;
    }

    void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    public void setMetadataID(Object metadataID) {
        this.metadataID = metadataID;
    }

    public Object invokeFunction(Object[] values) throws FunctionExecutionException {
        Method method;
        if (!this.isNullDependent()) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                return null;
            }
        }
        if ((method = this.getInvocationMethod()) == null) {
            throw new FunctionExecutionException("ERR.015.001.0002", QueryPlugin.Util.getString("ERR.015.001.0002", new Object[]{this.getName()}));
        }
        try {
            if (method.isVarArgs()) {
                int i = method.getParameterTypes().length;
                Object[] newValues = Arrays.copyOf(values, i);
                newValues[i - 1] = Arrays.copyOfRange(values, i - 1, values.length);
                values = newValues;
            }
            Object result = method.invoke(null, values);
            return FunctionDescriptor.importValue(result, this.getReturnType());
        }
        catch (ArithmeticException e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0003", QueryPlugin.Util.getString("ERR.015.001.0003", new Object[]{this.getName()}));
        }
        catch (InvocationTargetException e) {
            throw new FunctionExecutionException(e.getTargetException(), "ERR.015.001.0003", QueryPlugin.Util.getString("ERR.015.001.0003", new Object[]{this.getName()}));
        }
        catch (IllegalAccessException e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0004", QueryPlugin.Util.getString("ERR.015.001.0004", new Object[]{method.toString()}));
        }
        catch (TransformationException e) {
            throw new FunctionExecutionException(e, e.getMessage());
        }
    }

    public static Object importValue(Object result, Class<?> expectedType) throws ArithmeticException, TransformationException {
        String s;
        Number floatVal;
        if (!ALLOW_NAN_INFINITY && (result instanceof Double ? Double.isInfinite((Double)(floatVal = (Double)result)) || Double.isNaN((Double)floatVal) : result instanceof Float && (Float.isInfinite(((Float)(floatVal = (Float)result)).floatValue()) || Float.isNaN(((Float)floatVal).floatValue())))) {
            throw new ArithmeticException("Infinite or invalid result");
        }
        result = DataTypeManager.convertToRuntimeType((Object)result);
        if ((result = DataTypeManager.transformValue((Object)result, expectedType)) instanceof String && (s = (String)result).length() > 4000) {
            return s.substring(0, 4000);
        }
        return result;
    }
}

