/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.SingleElementSymbol;

public class TempMetadataStore
implements Serializable {
    private static final long serialVersionUID = 4055072385672022478L;
    private Map<String, TempMetadataID> tempGroups;

    public TempMetadataStore() {
        this(new HashMap<String, TempMetadataID>());
    }

    public TempMetadataStore(Map<String, TempMetadataID> data) {
        this.tempGroups = data == null ? new HashMap<String, TempMetadataID>() : data;
    }

    public Map<String, TempMetadataID> getData() {
        return this.tempGroups;
    }

    public TempMetadataID addTempGroup(String tempGroup, List tempSymbols) {
        return this.addTempGroup(tempGroup, tempSymbols, true);
    }

    public TempMetadataID addTempGroup(String tempGroup, List tempSymbols, boolean isVirtual) {
        return this.addTempGroup(tempGroup, tempSymbols, isVirtual, false);
    }

    public TempMetadataID addTempGroup(String tempGroup, List<? extends SingleElementSymbol> tempSymbols, boolean isVirtual, boolean isTempTable) {
        String tempName = tempGroup.toUpperCase();
        ArrayList<TempMetadataID> elementIDs = new ArrayList<TempMetadataID>(tempSymbols.size());
        for (SingleElementSymbol singleElementSymbol : tempSymbols) {
            TempMetadataID elementID = this.createElementSymbol(tempName, singleElementSymbol, isTempTable);
            elementIDs.add(elementID);
        }
        TempMetadataID groupID = new TempMetadataID(tempName, elementIDs, isVirtual ? TempMetadataID.Type.VIRTUAL : TempMetadataID.Type.TEMP);
        this.tempGroups.put(tempName, groupID);
        return groupID;
    }

    private TempMetadataID createElementSymbol(String tempName, SingleElementSymbol symbol, boolean isTempTable) {
        String elementName = tempName + "." + symbol.getShortName();
        Object metadataID = null;
        if (symbol instanceof AliasSymbol) {
            AliasSymbol as = (AliasSymbol)symbol;
            symbol = as.getSymbol();
        }
        if (symbol instanceof ExpressionSymbol && !(symbol instanceof AggregateSymbol)) {
            Expression expr = ((ExpressionSymbol)symbol).getExpression();
            if (expr instanceof Reference) {
                expr = ((Reference)expr).getExpression();
            }
            if (expr instanceof ElementSymbol) {
                symbol = (ElementSymbol)expr;
            }
        }
        if (symbol instanceof ElementSymbol) {
            metadataID = ((ElementSymbol)symbol).getMetadataID();
        }
        while (metadataID != null && metadataID instanceof TempMetadataID) {
            metadataID = ((TempMetadataID)metadataID).getOriginalMetadataID();
        }
        TempMetadataID elementID = new TempMetadataID(elementName, symbol.getType(), metadataID);
        elementID.setTempTable(isTempTable);
        return elementID;
    }

    public TempMetadataID addElementSymbolToTempGroup(String tempGroup, SingleElementSymbol symbol) {
        String tempName = tempGroup.toUpperCase();
        TempMetadataID groupID = this.tempGroups.get(tempName);
        if (groupID != null) {
            TempMetadataID elementID = this.createElementSymbol(tempName, symbol, false);
            groupID.addElement(elementID);
            return elementID;
        }
        return null;
    }

    public TempMetadataID getTempGroupID(String tempGroup) {
        return this.tempGroups.get(tempGroup.toUpperCase());
    }

    public TempMetadataID getTempElementID(String tempElement) {
        int index = tempElement.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        String groupName = tempElement.substring(0, index);
        TempMetadataID groupID = this.tempGroups.get(groupName.toUpperCase());
        if (groupID != null) {
            for (TempMetadataID elementID : groupID.getElements()) {
                if (!elementID.getID().equalsIgnoreCase(tempElement)) continue;
                return elementID;
            }
        }
        return null;
    }

    public List<TempMetadataID> getTempElementElementIDs(String tempGroup) {
        TempMetadataID groupID = this.getTempGroupID(tempGroup);
        if (groupID != null) {
            return groupID.getElements();
        }
        return null;
    }

    public void addElementToTempGroup(String tempGroup, ElementSymbol symbol) {
        TempMetadataID groupID = this.tempGroups.get(tempGroup.toUpperCase());
        if (groupID != null) {
            groupID.addElement((TempMetadataID)symbol.getMetadataID());
        }
    }

    public TempMetadataID removeTempGroup(String tempGroup) {
        return this.tempGroups.remove(tempGroup.toUpperCase());
    }
}

