/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.client.plan.Annotation;
import org.teiid.common.buffer.LobManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.dqp.internal.process.Request;
import org.teiid.metadata.Procedure;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.BasicQueryMetadata;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.TriggerActionPlanner;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.PartitionAnalyzer;
import org.teiid.query.optimizer.relational.PlanHints;
import org.teiid.query.optimizer.relational.PlanToProcessConverter;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.optimizer.relational.rules.RuleCollapseSource;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RuleMergeCriteria;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.lang.TranslatableProcedureContainer;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.query.validator.ValidationVisitor;

public class RelationalPlanner {
    public static final String MAT_PREFIX = "#MAT_";
    private AnalysisRecord analysisRecord;
    private Command parentCommand;
    private IDGenerator idGenerator;
    private CommandContext context;
    private CapabilitiesFinder capFinder;
    private QueryMetadataInterface metadata;
    private PlanHints hints = new PlanHints();
    private Option option;
    private SourceHint sourceHint;
    private static ThreadLocal<Boolean> planningLoop = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public ProcessorPlan optimize(Command command) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        PlanNode plan;
        boolean debug = this.analysisRecord.recordDebug();
        if (debug) {
            this.analysisRecord.println("\n----------------------------------------------------------------------------");
            this.analysisRecord.println("GENERATE CANONICAL: \n" + command);
        }
        PlanToProcessConverter planToProcessConverter = null;
        if (this.context != null) {
            planToProcessConverter = this.context.getPlanToProcessConverter();
        }
        if (planToProcessConverter == null) {
            planToProcessConverter = new PlanToProcessConverter(this.metadata, this.idGenerator, this.analysisRecord, this.capFinder);
        }
        List<WithQueryCommand> withList = null;
        Object modelID = null;
        boolean supportsWithPushdown = true;
        ArrayList<WithQueryCommand> pushDownWith = null;
        if (command instanceof QueryCommand) {
            QueryCommand queryCommand = (QueryCommand)command;
            HashSet<String> names = new HashSet<String>();
            if (queryCommand.getWith() != null) {
                withList = queryCommand.getWith();
                for (WithQueryCommand with : queryCommand.getWith()) {
                    QueryCommand subCommand = with.getCommand();
                    ProcessorPlan procPlan = QueryOptimizer.optimizePlan(subCommand, this.metadata, this.idGenerator, this.capFinder, this.analysisRecord, this.context);
                    subCommand.setProcessorPlan(procPlan);
                    AccessNode aNode = CriteriaCapabilityValidatorVisitor.getAccessNode(procPlan);
                    if (aNode != null && supportsWithPushdown) {
                        modelID = CriteriaCapabilityValidatorVisitor.validateCommandPushdown(modelID, this.metadata, this.capFinder, aNode);
                    }
                    QueryCommand withCommand = CriteriaCapabilityValidatorVisitor.getQueryCommand(aNode);
                    if (modelID == null || withCommand == null) {
                        supportsWithPushdown = false;
                    } else {
                        if (pushDownWith == null) {
                            pushDownWith = new ArrayList<WithQueryCommand>();
                        }
                        WithQueryCommand wqc = new WithQueryCommand(with.getGroupSymbol(), with.getColumns(), withCommand);
                        pushDownWith.add(wqc);
                    }
                    names.add(with.getGroupSymbol().getCanonicalName());
                }
                if (modelID != null && supportsWithPushdown) {
                    supportsWithPushdown = CapabilitiesUtil.supports(SourceCapabilities.Capability.COMMON_TABLE_EXPRESSIONS, modelID, this.metadata, this.capFinder);
                }
                if (supportsWithPushdown) {
                    this.addModelIds(command, modelID, names);
                }
            }
        }
        try {
            plan = this.generatePlan(command, true);
        }
        catch (TeiidProcessingException e) {
            throw new QueryPlannerException(e, e.getMessage());
        }
        if (debug) {
            this.analysisRecord.println("\nCANONICAL PLAN: \n" + plan);
        }
        this.connectSubqueryContainers(plan);
        ArrayList<SingleElementSymbol> topCols = LanguageObject.Util.deepClone(command.getProjectedSymbols(), SingleElementSymbol.class);
        RuleStack rules = this.buildRules();
        plan = this.executeRules(rules, plan);
        RelationalPlan result = planToProcessConverter.convert(plan);
        if (withList != null && supportsWithPushdown) {
            AccessNode aNode = CriteriaCapabilityValidatorVisitor.getAccessNode(result);
            if (aNode != null) {
                QueryCommand queryCommand = CriteriaCapabilityValidatorVisitor.getQueryCommand(aNode);
                if (queryCommand == null || CriteriaCapabilityValidatorVisitor.validateCommandPushdown(modelID, this.metadata, this.capFinder, aNode) == null) {
                    supportsWithPushdown = false;
                } else {
                    queryCommand.setWith(pushDownWith);
                }
            } else {
                supportsWithPushdown = false;
            }
        }
        if (!supportsWithPushdown) {
            result.setWith(withList);
        }
        result.setOutputElements(topCols);
        result.setSourceHint(this.sourceHint);
        return result;
    }

    private void addModelIds(Command command, final Object modelID, final HashSet<String> names) {
        PreOrPostOrderNavigator.doVisit(command, new LanguageVisitor(){

            @Override
            public void visit(UnaryFromClause obj) {
                GroupSymbol group = obj.getGroup();
                if (names.contains(group.getNonCorrelationName().toUpperCase())) {
                    group.setModelMetadataId(modelID);
                }
            }
        }, false, true);
    }

    public void initialize(Command command, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) {
        this.parentCommand = command;
        this.idGenerator = idGenerator;
        this.metadata = metadata;
        this.capFinder = capFinder;
        this.analysisRecord = analysisRecord;
        this.context = context;
    }

    private void connectSubqueryContainers(PlanNode plan) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Set<GroupSymbol> groupSymbols = RelationalPlanner.getGroupSymbols(plan);
        for (PlanNode node : NodeEditor.findAllNodes(plan, 92)) {
            List<SubqueryContainer> subqueryContainers = node.getSubqueryContainers();
            if (subqueryContainers.isEmpty()) continue;
            Set<GroupSymbol> localGroupSymbols = groupSymbols;
            if (node.getType() == 4) {
                localGroupSymbols = RelationalPlanner.getGroupSymbols(node);
            }
            for (SubqueryContainer container : subqueryContainers) {
                Command subCommand = (Command)((Command)container.getCommand()).clone();
                ArrayList<Reference> correlatedReferences = new ArrayList<Reference>();
                CorrelatedReferenceCollectorVisitor.collectReferences(subCommand, localGroupSymbols, correlatedReferences);
                ProcessorPlan procPlan = QueryOptimizer.optimizePlan(subCommand, this.metadata, this.idGenerator, this.capFinder, this.analysisRecord, this.context);
                ((Command)container.getCommand()).setProcessorPlan(procPlan);
                this.setCorrelatedReferences(container, correlatedReferences);
            }
            node.addGroups(GroupsUsedByElementsVisitor.getGroups(node.getCorrelatedReferenceElements()));
        }
    }

    private void setCorrelatedReferences(SubqueryContainer<?> container, List<Reference> correlatedReferences) {
        if (!correlatedReferences.isEmpty()) {
            SymbolMap map = new SymbolMap();
            for (Reference reference : correlatedReferences) {
                map.addMapping(reference.getExpression(), reference.getExpression());
            }
            ((Command)container.getCommand()).setCorrelatedReferences(map);
        }
    }

    private static Set<GroupSymbol> getGroupSymbols(PlanNode plan) {
        HashSet<GroupSymbol> groupSymbols = new HashSet<GroupSymbol>();
        for (PlanNode source : NodeEditor.findAllNodes(plan, 64)) {
            groupSymbols.addAll(source.getGroups());
        }
        return groupSymbols;
    }

    private void distributeDependentHints(Collection<String> groups, PlanNode plan, NodeConstants.Info hintProperty) throws QueryMetadataException, TeiidComponentException {
        if (groups == null || groups.isEmpty()) {
            return;
        }
        List<PlanNode> nodes = NodeEditor.findAllNodes(plan, 64);
        for (String groupName : groups) {
            boolean appliedHint = RelationalPlanner.applyHint(nodes, groupName, hintProperty);
            if (appliedHint) continue;
            Collection groupNames = this.metadata.getGroupsForPartialName(groupName);
            if (groupNames.size() == 1) {
                groupName = (String)groupNames.iterator().next();
                appliedHint = RelationalPlanner.applyHint(nodes, groupName, hintProperty);
            }
            if (appliedHint) continue;
            String msg = QueryPlugin.Util.getString("ERR.015.004.0010", new Object[]{groupName});
            if (!this.analysisRecord.recordAnnotations()) continue;
            this.analysisRecord.addAnnotation(new Annotation("Hints", msg, "ignoring hint", Annotation.Priority.MEDIUM));
        }
    }

    private static boolean applyHint(List<PlanNode> nodes, String groupName, NodeConstants.Info hintProperty) {
        boolean appliedHint = false;
        for (PlanNode node : nodes) {
            GroupSymbol nodeGroup = node.getGroups().iterator().next();
            String sDefinition = nodeGroup.getDefinition();
            if (!nodeGroup.getName().equalsIgnoreCase(groupName) && (sDefinition == null || !sDefinition.equalsIgnoreCase(groupName))) continue;
            node.setProperty(hintProperty, Boolean.TRUE);
            appliedHint = true;
        }
        return appliedHint;
    }

    public RuleStack buildRules() {
        RuleStack rules = new RuleStack();
        rules.push(RuleConstants.COLLAPSE_SOURCE);
        rules.push(RuleConstants.PLAN_SORTS);
        if (this.hints.hasJoin || this.hints.hasCriteria) {
            rules.push(new RuleMergeCriteria(this.idGenerator, this.capFinder, this.analysisRecord, this.context, this.metadata));
        }
        if (this.hints.hasJoin) {
            rules.push(RuleConstants.IMPLEMENT_JOIN_STRATEGY);
        }
        rules.push(RuleConstants.CALCULATE_COST);
        rules.push(new RuleAssignOutputElements(true));
        if (this.hints.hasLimit) {
            rules.push(RuleConstants.PUSH_LIMIT);
        }
        if (this.hints.hasRelationalProc) {
            rules.push(RuleConstants.PLAN_PROCEDURES);
        }
        if (this.hints.hasAggregates) {
            rules.push(new RulePushAggregates(this.idGenerator));
        }
        if (this.hints.hasJoin) {
            rules.push(RuleConstants.CHOOSE_DEPENDENT);
            rules.push(RuleConstants.CHOOSE_JOIN_STRATEGY);
            rules.push(RuleConstants.RAISE_ACCESS);
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
            rules.push(RuleConstants.PLAN_JOINS);
        }
        rules.push(RuleConstants.RAISE_ACCESS);
        if (this.hints.hasSetQuery) {
            rules.push(RuleConstants.PLAN_UNIONS);
        }
        if (this.hints.hasCriteria || this.hints.hasJoin || this.hints.hasVirtualGroups) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
        }
        if (this.hints.hasJoin) {
            rules.push(RuleConstants.COPY_CRITERIA);
            rules.push(RuleConstants.PUSH_NON_JOIN_CRITERIA);
        }
        if (this.hints.hasVirtualGroups) {
            rules.push(RuleConstants.MERGE_VIRTUAL);
        }
        if (this.hints.hasCriteria) {
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        if (this.hints.hasJoin && this.hints.hasSetQuery) {
            rules.push(RuleConstants.DECOMPOSE_JOIN);
            rules.push(RuleConstants.MERGE_VIRTUAL);
        }
        if (this.hints.hasJoin && this.hints.hasOptionalJoin) {
            rules.push(RuleConstants.REMOVE_OPTIONAL_JOINS);
        }
        if (this.hints.hasVirtualGroups || this.hints.hasJoin && this.hints.hasOptionalJoin) {
            rules.push(new RuleAssignOutputElements(false));
        }
        rules.push(RuleConstants.PLACE_ACCESS);
        return rules;
    }

    private PlanNode executeRules(RuleStack rules, PlanNode plan) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean debug = this.analysisRecord.recordDebug();
        while (!rules.isEmpty()) {
            if (debug) {
                this.analysisRecord.println("\n============================================================================");
            }
            OptimizerRule rule = rules.pop();
            if (debug) {
                this.analysisRecord.println("EXECUTING " + rule);
            }
            plan = rule.execute(plan, this.metadata, this.capFinder, rules, this.analysisRecord, this.context);
            if (!debug) continue;
            this.analysisRecord.println("\nAFTER: \n" + plan);
        }
        return plan;
    }

    public PlanNode generatePlan(Command cmd, boolean useSourceHint) throws TeiidComponentException, TeiidProcessingException {
        if (useSourceHint && cmd.getSourceHint() != null && this.sourceHint == null) {
            this.sourceHint = cmd.getSourceHint();
        }
        Option savedOption = this.option;
        this.option = cmd.getOption();
        if (this.option == null) {
            if (savedOption != null) {
                this.option = savedOption;
            }
        } else if (savedOption != null && savedOption.isNoCache()) {
            if (savedOption.getNoCacheGroups() == null || savedOption.getNoCacheGroups().isEmpty()) {
                if (this.option.getNoCacheGroups() != null) {
                    this.option.getNoCacheGroups().clear();
                }
            } else if (this.option.getNoCacheGroups() != null && !this.option.getNoCacheGroups().isEmpty()) {
                for (String noCache : savedOption.getNoCacheGroups()) {
                    this.option.addNoCacheGroup(noCache);
                }
            }
            this.option.setNoCache(true);
        }
        PlanNode result = null;
        switch (cmd.getType()) {
            case 1: {
                result = this.createQueryPlan((QueryCommand)cmd);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                result = this.createUpdatePlan(cmd);
                break;
            }
            case 6: {
                result = this.createStoredProcedurePlan((StoredProcedure)cmd);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid command type");
            }
        }
        if (cmd.getOption() != null) {
            if (cmd.getOption().getDependentGroups() != null) {
                this.distributeDependentHints(cmd.getOption().getDependentGroups(), result, NodeConstants.Info.MAKE_DEP);
            }
            if (cmd.getOption().getNotDependentGroups() != null) {
                this.distributeDependentHints(cmd.getOption().getNotDependentGroups(), result, NodeConstants.Info.MAKE_NOT_DEP);
            }
        }
        this.option = savedOption;
        return result;
    }

    PlanNode createUpdatePlan(Command command) throws TeiidComponentException, TeiidProcessingException {
        Insert insert;
        PlanNode projectNode = NodeFactory.getNewNode(8);
        List<SingleElementSymbol> cols = command.getProjectedSymbols();
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, cols);
        PlanNode sourceNode = NodeFactory.getNewNode(64);
        sourceNode.setProperty(NodeConstants.Info.ATOMIC_REQUEST, command);
        sourceNode.setProperty(NodeConstants.Info.VIRTUAL_COMMAND, command);
        boolean usingTriggerAction = false;
        if (command instanceof ProcedureContainer) {
            ProcedureContainer container = (ProcedureContainer)command;
            usingTriggerAction = this.addNestedProcedure(sourceNode, container, container.getGroup().getMetadataID());
        }
        GroupSymbol target = ((TargetedCommand)((Object)command)).getGroup();
        sourceNode.addGroup(target);
        Object id = RelationalPlanner.getTrackableGroup(target, this.metadata);
        if (id != null) {
            this.context.accessedPlanningObject(id);
        }
        RelationalPlanner.attachLast(projectNode, sourceNode);
        if (!usingTriggerAction && command instanceof Insert && (insert = (Insert)command).getQueryExpression() != null) {
            PlanNode plan = this.generatePlan(insert.getQueryExpression(), true);
            RelationalPlanner.attachLast(sourceNode, plan);
            RelationalPlanner.mergeTempMetadata(insert.getQueryExpression(), insert);
            projectNode.setProperty(NodeConstants.Info.INTO_GROUP, insert.getGroup());
        }
        return projectNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addNestedProcedure(PlanNode sourceNode, ProcedureContainer container, Object metadataId) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        StoredProcedure sp;
        if (container instanceof StoredProcedure && (sp = (StoredProcedure)container).getProcedureID() instanceof Procedure) {
            this.context.accessedPlanningObject(sp.getProcedureID());
        }
        for (SubqueryContainer subqueryContainer : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(container)) {
            if (((Command)subqueryContainer.getCommand()).getCorrelatedReferences() != null) continue;
            ArrayList<Reference> correlatedReferences = new ArrayList<Reference>();
            CorrelatedReferenceCollectorVisitor.collectReferences(subqueryContainer.getCommand(), Arrays.asList(container.getGroup()), correlatedReferences);
            this.setCorrelatedReferences(subqueryContainer, correlatedReferences);
        }
        String cacheString = "transformation/" + container.getClass().getSimpleName().toUpperCase();
        Command c = (Command)this.metadata.getFromMetadataCache(metadataId, cacheString);
        if (c == null) {
            c = QueryResolver.expandCommand(container, this.metadata, this.analysisRecord);
            if (c != null) {
                Request.validateWithVisitor(new ValidationVisitor(), this.metadata, c);
                this.metadata.addToMetadataCache(metadataId, cacheString, c.clone());
            }
        } else if ((c = (Command)c.clone()) instanceof CreateUpdateProcedureCommand) {
            ((CreateUpdateProcedureCommand)c).setUserCommand(container);
        }
        if (c != null) {
            if (c instanceof TriggerAction) {
                TriggerAction ta = (TriggerAction)c;
                ProcessorPlan plan = new TriggerActionPlanner().optimize((ProcedureContainer)container.clone(), ta, this.idGenerator, this.metadata, this.capFinder, this.analysisRecord, this.context);
                sourceNode.setProperty(NodeConstants.Info.PROCESSOR_PLAN, plan);
                return true;
            }
            if (c.getCacheHint() != null && container instanceof StoredProcedure) {
                boolean noCache = RelationalPlanner.isNoCacheGroup(this.metadata, ((StoredProcedure)container).getProcedureID(), this.option);
                if (!noCache) {
                    if (this.context.isResultSetCacheEnabled() && container.areResultsCachable() && LobManager.getLobIndexes(new ArrayList<ElementSymbol>(container.getProcedureParameters().keySet())) == null) {
                        container.getGroup().setGlobalTable(true);
                        container.setCacheHint(c.getCacheHint());
                        RelationalPlanner.recordAnnotation(this.analysisRecord, "Cached Procedure", Annotation.Priority.LOW, "SimpleQueryResolver.procedure_cache_used", container.getGroup());
                        return false;
                    }
                    RelationalPlanner.recordAnnotation(this.analysisRecord, "Cached Procedure", Annotation.Priority.MEDIUM, "SimpleQueryResolver.procedure_cache_not_usable", container.getGroup());
                } else {
                    RelationalPlanner.recordAnnotation(this.analysisRecord, "Cached Procedure", Annotation.Priority.LOW, "SimpleQueryResolver.procedure_cache_not_used", container.getGroup());
                }
            }
            this.addNestedCommand(sourceNode, container.getGroup(), container, c, false);
        } else if (!container.getGroup().isTempTable() && container instanceof TranslatableProcedureContainer && !CriteriaCapabilityValidatorVisitor.canPushLanguageObject(container, this.metadata.getModelID(container.getGroup().getMetadataID()), this.metadata, this.capFinder, this.analysisRecord)) {
            if (this.metadata.getUniqueKeysInGroup(container.getGroup().getMetadataID()).isEmpty() || !CapabilitiesUtil.supports(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, this.metadata.getModelID(container.getGroup().getMetadataID()), this.metadata, this.capFinder)) {
                throw new QueryPlannerException(QueryPlugin.Util.getString("RelationalPlanner.nonpushdown_command", new Object[]{container}));
            }
            try {
                if (planningLoop.get().booleanValue()) {
                    throw new QueryPlannerException(QueryPlugin.Util.getString("RelationalPlanner.nonpushdown_expression", new Object[]{container}));
                }
                planningLoop.set(Boolean.TRUE);
                c = container instanceof Update ? QueryRewriter.createUpdateProcedure((Update)container, this.metadata, this.context) : QueryRewriter.createDeleteProcedure((Delete)container, this.metadata, this.context);
                this.addNestedCommand(sourceNode, container.getGroup(), container, c, false);
                return false;
            }
            finally {
                planningLoop.set(Boolean.FALSE);
            }
        }
        for (SubqueryContainer subqueryContainer : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(container)) {
            if (c == null && container.getGroup().isTempTable()) {
                if (((Command)subqueryContainer.getCommand()).getCorrelatedReferences() != null) throw new QueryPlannerException(QueryPlugin.Util.getString("RelationalPlanner.nonpushdown_command", new Object[]{container}));
                if (subqueryContainer instanceof ScalarSubquery) {
                    ((ScalarSubquery)subqueryContainer).setShouldEvaluate(true);
                } else {
                    if (!(subqueryContainer instanceof ExistsCriteria)) throw new QueryPlannerException(QueryPlugin.Util.getString("RelationalPlanner.nonpushdown_command", new Object[]{container}));
                    ((ExistsCriteria)subqueryContainer).setShouldEvaluate(true);
                }
            }
            ProcessorPlan plan = QueryOptimizer.optimizePlan(subqueryContainer.getCommand(), this.metadata, null, this.capFinder, this.analysisRecord, this.context);
            ((Command)subqueryContainer.getCommand()).setProcessorPlan(plan);
            if (c != null) continue;
            RuleCollapseSource.prepareSubquery(subqueryContainer);
        }
        return false;
    }

    PlanNode createStoredProcedurePlan(StoredProcedure storedProc) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        PlanNode projectNode = NodeFactory.getNewNode(8);
        List cols = storedProc.getProjectedSymbols();
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, cols);
        PlanNode sourceNode = NodeFactory.getNewNode(64);
        sourceNode.setProperty(NodeConstants.Info.VIRTUAL_COMMAND, storedProc);
        this.addNestedProcedure(sourceNode, storedProc, storedProc.getProcedureID());
        this.hints.hasRelationalProc |= storedProc.isProcedureRelational();
        sourceNode.addGroup(storedProc.getGroup());
        RelationalPlanner.attachLast(projectNode, sourceNode);
        return projectNode;
    }

    PlanNode createQueryPlan(QueryCommand command) throws TeiidComponentException, TeiidProcessingException {
        PlanNode node = null;
        if (command instanceof Query) {
            node = this.createQueryPlan((Query)command);
        } else {
            this.hints.hasSetQuery = true;
            SetQuery query = (SetQuery)command;
            boolean hasSourceHint = this.sourceHint != null;
            PlanNode leftPlan = this.createQueryPlan(query.getLeftQuery());
            PlanNode rightPlan = this.createQueryPlan(query.getRightQuery());
            if (!hasSourceHint) {
                this.sourceHint = null;
            }
            node = NodeFactory.getNewNode(256);
            node.setProperty(NodeConstants.Info.SET_OPERATION, (Object)query.getOperation());
            node.setProperty(NodeConstants.Info.USE_ALL, query.isAll());
            RelationalPlanner.attachLast(node, leftPlan);
            RelationalPlanner.attachLast(node, rightPlan);
        }
        if (command.getOrderBy() != null) {
            node = RelationalPlanner.attachSorting(node, command.getOrderBy());
        }
        if (command.getLimit() != null) {
            node = RelationalPlanner.attachTupleLimit(node, command.getLimit(), this.hints);
        }
        return node;
    }

    private PlanNode createQueryPlan(Query query) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        PlanNode plan = null;
        LinkedHashSet windowFunctions = new LinkedHashSet();
        if (query.getFrom() != null) {
            boolean hasGrouping;
            FromClause fromClause = RelationalPlanner.mergeClauseTrees(query.getFrom());
            PlanNode dummyRoot = new PlanNode();
            this.buildTree(fromClause, dummyRoot);
            plan = dummyRoot.getFirstChild();
            this.hints.hasJoin = this.hints.hasJoin | plan.getType() == 4;
            if (query.getCriteria() != null) {
                plan = RelationalPlanner.attachCriteria(plan, query.getCriteria(), false);
                this.hints.hasCriteria = true;
            }
            LinkedHashSet<AggregateSymbol> aggs = new LinkedHashSet<AggregateSymbol>();
            AggregateSymbolCollectorVisitor.getAggregates(query.getSelect(), aggs, null, null, windowFunctions, null);
            boolean bl = hasGrouping = !aggs.isEmpty();
            if (query.getHaving() != null) {
                aggs.addAll(AggregateSymbolCollectorVisitor.getAggregates(query.getHaving(), true));
                hasGrouping = true;
            }
            if (query.getGroupBy() != null) {
                hasGrouping = true;
            }
            if (hasGrouping) {
                plan = this.attachGrouping(plan, query, aggs);
            }
            if (query.getHaving() != null) {
                plan = RelationalPlanner.attachCriteria(plan, query.getHaving(), true);
                this.hints.hasCriteria = true;
            }
        }
        plan = RelationalPlanner.attachProject(plan, query.getSelect());
        if (query.getOrderBy() != null) {
            AggregateSymbolCollectorVisitor.getAggregates(query.getOrderBy(), null, null, null, windowFunctions, null);
        }
        if (!windowFunctions.isEmpty()) {
            plan.setProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS, true);
        }
        if (query.getSelect().isDistinct()) {
            plan = RelationalPlanner.attachDupRemoval(plan);
        }
        return plan;
    }

    private static FromClause mergeClauseTrees(From from) {
        List<FromClause> clauses = from.getClauses();
        while (clauses.size() > 1) {
            FromClause first = from.getClauses().remove(0);
            FromClause second = from.getClauses().remove(0);
            JoinPredicate jp = new JoinPredicate(first, second, JoinType.JOIN_CROSS);
            clauses.add(0, jp);
        }
        return clauses.get(0);
    }

    void buildTree(FromClause clause, PlanNode parent) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        PlanNode node = null;
        if (clause instanceof UnaryFromClause) {
            Command nestedCommand;
            UnaryFromClause ufc = (UnaryFromClause)clause;
            GroupSymbol group = ufc.getGroup();
            if (this.metadata.isVirtualGroup(group.getMetadataID())) {
                this.hints.hasVirtualGroups = true;
            }
            if ((nestedCommand = ufc.getExpandedCommand()) == null && !group.isProcedure()) {
                Object id = RelationalPlanner.getTrackableGroup(group, this.metadata);
                if (id != null) {
                    this.context.accessedPlanningObject(id);
                }
                if (!group.isTempGroupSymbol() && this.metadata.isVirtualGroup(group.getMetadataID())) {
                    nestedCommand = this.resolveVirtualGroup(group);
                }
            }
            node = NodeFactory.getNewNode(64);
            if (group.getModelMetadataId() != null) {
                node.setProperty(NodeConstants.Info.MODEL_ID, group.getModelMetadataId());
            }
            if (ufc.isNoUnnest()) {
                node.setProperty(NodeConstants.Info.NO_UNNEST, Boolean.TRUE);
            }
            node.addGroup(group);
            if (nestedCommand != null) {
                UpdateValidator.UpdateInfo info = ProcedureContainerResolver.getUpdateInfo(group, this.metadata);
                if (info != null && info.getPartitionInfo() != null && !info.getPartitionInfo().isEmpty()) {
                    node.setProperty(NodeConstants.Info.PARTITION_INFO, info.getPartitionInfo());
                }
                if (parent.getType() != 4 && nestedCommand.getSourceHint() != null && this.sourceHint == null) {
                    this.sourceHint = nestedCommand.getSourceHint();
                }
                this.addNestedCommand(node, group, nestedCommand, nestedCommand, true);
            }
            parent.addLastChild(node);
        } else if (clause instanceof JoinPredicate) {
            JoinPredicate jp = (JoinPredicate)clause;
            node = NodeFactory.getNewNode(4);
            node.setProperty(NodeConstants.Info.JOIN_TYPE, jp.getJoinType());
            node.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.NESTED_LOOP);
            node.setProperty(NodeConstants.Info.JOIN_CRITERIA, jp.getJoinCriteria());
            if (jp.getJoinType() == JoinType.JOIN_LEFT_OUTER) {
                this.hints.hasOptionalJoin = true;
            }
            parent.addLastChild(node);
            FromClause[] clauses = new FromClause[]{jp.getLeftClause(), jp.getRightClause()};
            for (int i = 0; i < 2; ++i) {
                this.buildTree(clauses[i], node);
                for (PlanNode child : node.getChildren()) {
                    node.addGroups(child.getGroups());
                }
            }
        } else if (clause instanceof SubqueryFromClause) {
            Map<ElementSymbol, List<Set<Constant>>> partitionInfo;
            SubqueryFromClause sfc = (SubqueryFromClause)clause;
            GroupSymbol group = sfc.getGroupSymbol();
            Command nestedCommand = sfc.getCommand();
            node = NodeFactory.getNewNode(64);
            if (sfc.isTable()) {
                sfc.getCommand().setCorrelatedReferences(this.getCorrelatedReferences(parent, node, sfc));
            }
            if (sfc.isNoUnnest()) {
                node.setProperty(NodeConstants.Info.NO_UNNEST, Boolean.TRUE);
            }
            node.addGroup(group);
            this.addNestedCommand(node, group, nestedCommand, nestedCommand, true);
            if (nestedCommand instanceof SetQuery && !(partitionInfo = PartitionAnalyzer.extractPartionInfo((SetQuery)nestedCommand, ResolverUtil.resolveElementsInGroup(group, this.metadata))).isEmpty()) {
                node.setProperty(NodeConstants.Info.PARTITION_INFO, partitionInfo);
            }
            this.hints.hasVirtualGroups = true;
            parent.addLastChild(node);
        } else if (clause instanceof TableFunctionReference) {
            TableFunctionReference tt = (TableFunctionReference)clause;
            GroupSymbol group = tt.getGroupSymbol();
            node = NodeFactory.getNewNode(64);
            node.setProperty(NodeConstants.Info.TABLE_FUNCTION, tt);
            tt.setCorrelatedReferences(this.getCorrelatedReferences(parent, node, tt));
            node.addGroup(group);
            parent.addLastChild(node);
        } else {
            throw new AssertionError((Object)"Unknown Type");
        }
        if (clause.isOptional()) {
            node.setProperty(NodeConstants.Info.IS_OPTIONAL, Boolean.TRUE);
            this.hints.hasOptionalJoin = true;
        }
        if (clause.isMakeDep()) {
            node.setProperty(NodeConstants.Info.MAKE_DEP, Boolean.TRUE);
        } else if (clause.isMakeNotDep()) {
            node.setProperty(NodeConstants.Info.MAKE_NOT_DEP, Boolean.TRUE);
        }
        if (clause.isMakeInd()) {
            node.setProperty(NodeConstants.Info.MAKE_IND, Boolean.TRUE);
        }
    }

    public static Object getTrackableGroup(GroupSymbol group, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        if (group.isTempGroupSymbol()) {
            QueryMetadataInterface qmi = metadata.getSessionMetadata();
            try {
                if (group.isGlobalTable() || qmi != null && qmi.getGroupID(group.getNonCorrelationName()) == group.getMetadataID()) {
                    return group.getMetadataID();
                }
            }
            catch (QueryMetadataException queryMetadataException) {}
        } else {
            return group.getMetadataID();
        }
        return null;
    }

    private SymbolMap getCorrelatedReferences(PlanNode parent, PlanNode node, LanguageObject lo) {
        PlanNode rootJoin = parent;
        while (rootJoin.getParent() != null && rootJoin.getParent().getType() == 4 && !rootJoin.getParent().getGroups().isEmpty()) {
            rootJoin = rootJoin.getParent();
        }
        ArrayList<Reference> correlatedReferences = new ArrayList<Reference>();
        CorrelatedReferenceCollectorVisitor.collectReferences(lo, rootJoin.getGroups(), correlatedReferences);
        if (correlatedReferences.isEmpty()) {
            return null;
        }
        SymbolMap map = new SymbolMap();
        for (Reference reference : correlatedReferences) {
            map.addMapping(reference.getExpression(), reference.getExpression());
        }
        node.setProperty(NodeConstants.Info.CORRELATED_REFERENCES, map);
        return map;
    }

    private void addNestedCommand(PlanNode node, GroupSymbol group, Command nestedCommand, Command toPlan, boolean merge) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        if (nestedCommand instanceof QueryCommand) {
            QueryCommand queryCommand = (QueryCommand)nestedCommand;
            if (queryCommand.getLimit() == null) {
                queryCommand.setOrderBy(null);
            }
            if (merge && queryCommand.getWith() != null) {
                merge = false;
            }
        }
        node.setProperty(NodeConstants.Info.NESTED_COMMAND, nestedCommand);
        if (merge && nestedCommand instanceof Query && QueryResolver.isXMLQuery((Query)nestedCommand, this.metadata)) {
            merge = false;
        }
        if (merge) {
            RelationalPlanner.mergeTempMetadata(nestedCommand, this.parentCommand);
            PlanNode childRoot = this.generatePlan(nestedCommand, false);
            node.addFirstChild(childRoot);
            List<SingleElementSymbol> projectCols = nestedCommand.getProjectedSymbols();
            SymbolMap map = SymbolMap.createSymbolMap(group, projectCols, this.metadata);
            node.setProperty(NodeConstants.Info.SYMBOL_MAP, map);
        } else {
            QueryMetadataInterface actualMetadata = this.metadata;
            if (actualMetadata instanceof TempMetadataAdapter) {
                actualMetadata = ((TempMetadataAdapter)this.metadata).getMetadata();
            }
            ProcessorPlan plan = QueryOptimizer.optimizePlan(toPlan, actualMetadata, this.idGenerator, this.capFinder, this.analysisRecord, this.context);
            node.setProperty(NodeConstants.Info.PROCESSOR_PLAN, plan);
        }
    }

    private static PlanNode attachCriteria(PlanNode plan, Criteria criteria, boolean isHaving) {
        List<Criteria> crits = Criteria.separateCriteriaByAnd(criteria);
        for (Criteria crit : crits) {
            PlanNode critNode = RelationalPlanner.createSelectNode(crit, isHaving);
            RelationalPlanner.attachLast(critNode, plan);
            plan = critNode;
        }
        return plan;
    }

    public static PlanNode createSelectNode(Criteria crit, boolean isHaving) {
        PlanNode critNode = NodeFactory.getNewNode(16);
        critNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, crit);
        if (isHaving && !ElementCollectorVisitor.getAggregates(crit, false).isEmpty()) {
            critNode.setProperty(NodeConstants.Info.IS_HAVING, Boolean.TRUE);
        }
        critNode.addGroups(GroupsUsedByElementsVisitor.getGroups(crit));
        critNode.addGroups(GroupsUsedByElementsVisitor.getGroups(critNode.getCorrelatedReferenceElements()));
        return critNode;
    }

    private PlanNode attachGrouping(PlanNode plan, Query query, Collection<AggregateSymbol> aggs) throws QueryMetadataException, TeiidComponentException {
        GroupBy groupBy = query.getGroupBy();
        List<Expression> groupingCols = null;
        if (groupBy != null) {
            groupingCols = groupBy.getSymbols();
        }
        PlanNode groupNode = NodeFactory.getNewNode(128);
        Map<Expression, ElementSymbol> mapping = RelationalPlanner.buildGroupingNode(aggs, groupingCols, groupNode, this.context, this.idGenerator).inserseMapping();
        RelationalPlanner.attachLast(groupNode, plan);
        ExpressionMappingVisitor.mapExpressions(query.getHaving(), mapping);
        ExpressionMappingVisitor.mapExpressions(query.getSelect(), mapping);
        ExpressionMappingVisitor.mapExpressions(query.getOrderBy(), mapping);
        this.hints.hasAggregates = true;
        return groupNode;
    }

    public static SymbolMap buildGroupingNode(Collection<AggregateSymbol> aggs, List<? extends Expression> groupingCols, PlanNode groupNode, CommandContext cc, IDGenerator idGenerator) throws QueryMetadataException, TeiidComponentException {
        AliasSymbol as;
        SymbolMap map = new SymbolMap();
        aggs = LanguageObject.Util.deepClone(aggs, AggregateSymbol.class);
        groupingCols = LanguageObject.Util.deepClone(groupingCols, Expression.class);
        GroupSymbol group = new GroupSymbol("anon_grp" + idGenerator.nextInt());
        if (!cc.getGroups().add(group.getName())) {
            group = RulePlaceAccess.recontextSymbol(group, cc.getGroups());
        }
        TempMetadataStore tms = new TempMetadataStore();
        int i = 0;
        LinkedList<AliasSymbol> symbols = new LinkedList<AliasSymbol>();
        LinkedList<Expression> targets = new LinkedList<Expression>();
        if (groupingCols != null) {
            groupNode.setProperty(NodeConstants.Info.GROUP_COLS, groupingCols);
            groupNode.addGroups(GroupsUsedByElementsVisitor.getGroups(groupingCols));
            for (Expression expression : groupingCols) {
                as = new AliasSymbol("gcol" + i++, new ExpressionSymbol("expr", expression));
                targets.add(expression);
                symbols.add(as);
            }
        }
        i = 0;
        for (AggregateSymbol aggregateSymbol : aggs) {
            as = new AliasSymbol("agg" + i++, new ExpressionSymbol("expr", aggregateSymbol));
            targets.add(aggregateSymbol);
            symbols.add(as);
        }
        group.setMetadataID(tms.addTempGroup(group.getName(), symbols, true, false));
        Iterator targetIter = targets.iterator();
        for (ElementSymbol es : ResolverUtil.resolveElementsInGroup(group, new TempMetadataAdapter(new BasicQueryMetadata(), tms))) {
            Expression target = (Expression)targetIter.next();
            es.setAggregate(target instanceof AggregateSymbol);
            map.addMapping(es, target);
        }
        groupNode.setProperty(NodeConstants.Info.SYMBOL_MAP, map);
        groupNode.addGroup(group);
        return map;
    }

    private static PlanNode attachSorting(PlanNode plan, OrderBy orderBy) {
        PlanNode sortNode = NodeFactory.getNewNode(32);
        sortNode.setProperty(NodeConstants.Info.SORT_ORDER, orderBy);
        if (orderBy.hasUnrelated()) {
            sortNode.setProperty(NodeConstants.Info.UNRELATED_SORT, true);
        }
        sortNode.addGroups(GroupsUsedByElementsVisitor.getGroups(orderBy));
        RelationalPlanner.attachLast(sortNode, plan);
        return sortNode;
    }

    private static PlanNode attachTupleLimit(PlanNode plan, Limit limit, PlanHints hints) {
        hints.hasLimit = true;
        PlanNode limitNode = NodeFactory.getNewNode(1024);
        boolean attach = false;
        if (limit.getOffset() != null) {
            limitNode.setProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT, limit.getOffset());
            attach = true;
        }
        if (limit.getRowLimit() != null) {
            limitNode.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, limit.getRowLimit());
            attach = true;
        }
        if (attach) {
            if (limit.isImplicit()) {
                limitNode.setProperty(NodeConstants.Info.IS_IMPLICIT_LIMIT, true);
            }
            if (limit.isStrict()) {
                limitNode.setProperty(NodeConstants.Info.IS_STRICT, true);
            }
            RelationalPlanner.attachLast(limitNode, plan);
            plan = limitNode;
        }
        return plan;
    }

    private static PlanNode attachDupRemoval(PlanNode plan) {
        PlanNode dupNode = NodeFactory.getNewNode(2);
        RelationalPlanner.attachLast(dupNode, plan);
        return dupNode;
    }

    private static PlanNode attachProject(PlanNode plan, Select select) {
        PlanNode projectNode = NodeFactory.getNewNode(8);
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, select.getProjectedSymbols());
        projectNode.addGroups(GroupsUsedByElementsVisitor.getGroups(select));
        RelationalPlanner.attachLast(projectNode, plan);
        return projectNode;
    }

    static final void attachLast(PlanNode parent, PlanNode child) {
        if (child != null) {
            parent.addLastChild(child);
        }
    }

    static void mergeTempMetadata(Command childCommand, Command parentCommand) {
        Map childTempMetadata = childCommand.getTemporaryMetadata();
        if (childTempMetadata != null && !childTempMetadata.isEmpty()) {
            Map parentTempMetadata = parentCommand.getTemporaryMetadata();
            if (parentTempMetadata == null) {
                parentCommand.setTemporaryMetadata(new HashMap(childTempMetadata));
            } else {
                parentTempMetadata.putAll(childTempMetadata);
            }
        }
    }

    private Command resolveVirtualGroup(GroupSymbol virtualGroup) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        QueryNode qnode = null;
        Object metadataID = virtualGroup.getMetadataID();
        boolean noCache = RelationalPlanner.isNoCacheGroup(this.metadata, metadataID, this.option);
        boolean isMaterializedGroup = this.metadata.hasMaterialization(metadataID);
        String cacheString = "SELECT";
        if (isMaterializedGroup) {
            boolean isImplicitGlobal;
            Object matMetadataId = this.metadata.getMaterialization(metadataID);
            String matTableName = null;
            CacheHint hint = null;
            boolean bl = isImplicitGlobal = matMetadataId == null;
            if (isImplicitGlobal) {
                TempMetadataID tid = this.context.getGlobalTableStore().getGlobalTempTableMetadataId(metadataID);
                matTableName = tid.getID();
                hint = tid.getCacheHint();
                if (hint != null) {
                    RelationalPlanner.recordAnnotation(this.analysisRecord, "Materialized View", Annotation.Priority.LOW, "SimpleQueryResolver.cache_hint_used", virtualGroup, matTableName, tid);
                }
                matMetadataId = tid;
            } else {
                matTableName = this.metadata.getFullName(matMetadataId);
            }
            if (noCache) {
                qnode = this.metadata.getVirtualPlan(metadataID);
                RelationalPlanner.recordAnnotation(this.analysisRecord, "Materialized View", Annotation.Priority.LOW, "SimpleQueryResolver.materialized_table_not_used", virtualGroup, matTableName);
            } else {
                this.context.accessedPlanningObject(matMetadataId);
                qnode = new QueryNode(null);
                Query query = RelationalPlanner.createMatViewQuery(matMetadataId, matTableName, Arrays.asList(new MultipleElementSymbol()), isImplicitGlobal);
                query.setCacheHint(hint);
                qnode.setCommand(query);
                cacheString = "matview";
                RelationalPlanner.recordAnnotation(this.analysisRecord, "Materialized View", Annotation.Priority.LOW, "SimpleQueryResolver.Query_was_redirected_to_Mat_table", virtualGroup, matTableName);
            }
        } else {
            qnode = this.metadata.getVirtualPlan(metadataID);
        }
        Command result = (Command)QueryResolver.resolveView(virtualGroup, qnode, cacheString, this.metadata).getCommand().clone();
        return QueryRewriter.rewrite(result, this.metadata, this.context);
    }

    public static Query createMatViewQuery(Object matMetadataId, String matTableName, List<? extends SelectSymbol> select, boolean isGlobal) {
        Query query = new Query();
        query.setSelect(new Select(select));
        GroupSymbol gs = new GroupSymbol(matTableName);
        gs.setGlobalTable(isGlobal);
        gs.setMetadataID(matMetadataId);
        query.setFrom(new From(Arrays.asList(new UnaryFromClause(gs))));
        return query;
    }

    public static boolean isNoCacheGroup(QueryMetadataInterface metadata, Object metadataID, Option option) throws QueryMetadataException, TeiidComponentException {
        if (option == null || !option.isNoCache()) {
            return false;
        }
        if (option.getNoCacheGroups() == null || option.getNoCacheGroups().isEmpty()) {
            return true;
        }
        String fullName = metadata.getFullName(metadataID);
        for (String groupName : option.getNoCacheGroups()) {
            if (!groupName.equalsIgnoreCase(fullName)) continue;
            return true;
        }
        return false;
    }

    private static void recordAnnotation(AnalysisRecord analysis, String type, Annotation.Priority priority, String msgKey, Object ... parts) {
        if (analysis.recordAnnotations()) {
            Annotation annotation = new Annotation(type, QueryPlugin.Util.getString(msgKey, parts), null, priority);
            analysis.addAnnotation(annotation);
        }
    }
}

