/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.query.util.CommandContext;

public class BatchCollector {
    private BatchProducer sourceNode;
    private boolean done = false;
    private TupleBuffer buffer;
    private boolean forwardOnly;

    public BatchCollector(BatchProducer sourceNode, BufferManager bm, CommandContext context, boolean forwardOnly) throws TeiidComponentException {
        this.sourceNode = sourceNode;
        this.forwardOnly = forwardOnly;
        if (!this.sourceNode.hasFinalBuffer()) {
            this.buffer = bm.createTupleBuffer(sourceNode.getOutputElements(), context.getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
            this.buffer.setForwardOnly(forwardOnly);
        }
    }

    public TupleBuffer collectTuples() throws TeiidComponentException, TeiidProcessingException {
        TupleBatch batch = null;
        while (!this.done) {
            if (this.sourceNode.hasFinalBuffer()) {
                if (this.buffer == null) {
                    TupleBuffer finalBuffer = this.sourceNode.getFinalBuffer();
                    Assertion.isNotNull((Object)finalBuffer);
                    this.buffer = finalBuffer;
                }
                if (this.buffer.isFinal()) {
                    this.buffer.setForwardOnly(this.forwardOnly);
                    this.done = true;
                    break;
                }
            }
            batch = this.sourceNode.nextBatch();
            this.flushBatch(batch);
            if (!batch.getTerminationFlag()) continue;
            this.done = true;
            if (this.sourceNode.hasFinalBuffer()) break;
            this.buffer.close();
            break;
        }
        return this.buffer;
    }

    public TupleBuffer getTupleBuffer() {
        return this.buffer;
    }

    private void flushBatch(TupleBatch batch) throws TeiidComponentException, TeiidProcessingException {
        if (batch.getRowCount() == 0 && !batch.getTerminationFlag()) {
            return;
        }
        this.flushBatchDirect(batch, true);
    }

    protected void flushBatchDirect(TupleBatch batch, boolean add) throws TeiidComponentException, TeiidProcessingException {
        if (!this.sourceNode.hasFinalBuffer()) {
            this.buffer.addTupleBatch(batch, add);
        }
    }

    public int getRowCount() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getRowCount();
    }

    public static class BatchProducerTupleSource
    implements TupleSource {
        private final BatchProducer sourceNode;
        private TupleBatch sourceBatch;
        private int sourceRow = 1;

        public BatchProducerTupleSource(BatchProducer sourceNode) {
            this.sourceNode = sourceNode;
        }

        public List<Object> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            while (true) {
                if (this.sourceBatch == null) {
                    this.sourceBatch = this.sourceNode.nextBatch();
                }
                if (this.sourceBatch.getRowCount() > 0 && this.sourceRow <= this.sourceBatch.getEndRow()) {
                    List<Object> tuple = this.sourceBatch.getTuple(this.sourceRow);
                    tuple = this.updateTuple(tuple);
                    ++this.sourceRow;
                    return tuple;
                }
                if (this.sourceBatch.getTerminationFlag()) {
                    this.sourceBatch = null;
                    return null;
                }
                this.sourceBatch = null;
            }
        }

        protected List<?> updateTuple(List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
            return tuple;
        }

        @Override
        public void closeSource() {
        }
    }

    public static interface BatchProducer {
        public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException;

        public List getOutputElements();

        public TupleBuffer getFinalBuffer() throws BlockedException, TeiidComponentException, TeiidProcessingException;

        public boolean hasFinalBuffer();
    }
}

