/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.util.CommandContext;

public class DdlPlan
extends ProcessorPlan {
    private Command command;
    private ProcessorDataManager pdm;

    public static void alterView(VDBMetaData vdb, Table t, String sql) {
        t.setSelectTransformation(sql);
        t.setLastModified(System.currentTimeMillis());
        TransformationMetadata indexMetadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        indexMetadata.addToMetadataCache(t, "transformation/SELECT", null);
    }

    public static void alterProcedureDefinition(VDBMetaData vdb, Procedure p, String sql) {
        p.setQueryPlan(sql);
        p.setLastModified(System.currentTimeMillis());
        TransformationMetadata indexMetadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        indexMetadata.addToMetadataCache(p, "transformation/" + StoredProcedure.class.getSimpleName().toUpperCase(), null);
    }

    public static void alterInsteadOfTrigger(VDBMetaData vdb, Table t, String sql, Boolean enabled, Table.TriggerEvent event) {
        switch (event) {
            case DELETE: {
                if (sql != null) {
                    t.setDeletePlan(sql);
                    break;
                }
                t.setDeletePlanEnabled(enabled.booleanValue());
                break;
            }
            case INSERT: {
                if (sql != null) {
                    t.setInsertPlan(sql);
                    break;
                }
                t.setInsertPlanEnabled(enabled.booleanValue());
                break;
            }
            case UPDATE: {
                if (sql != null) {
                    t.setUpdatePlan(sql);
                    break;
                }
                t.setUpdatePlanEnabled(enabled.booleanValue());
            }
        }
        TransformationMetadata indexMetadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        indexMetadata.addToMetadataCache(t, "transformation/" + event, null);
        t.setLastModified(System.currentTimeMillis());
    }

    private static String getPlanForEvent(Table t, Table.TriggerEvent event) {
        switch (event) {
            case DELETE: {
                return t.getDeletePlan();
            }
            case INSERT: {
                return t.getInsertPlan();
            }
            case UPDATE: {
                return t.getUpdatePlan();
            }
        }
        throw new AssertionError();
    }

    public DdlPlan(Command command) {
        this.command = command;
    }

    @Override
    public ProcessorPlan clone() {
        return new DdlPlan(this.command);
    }

    @Override
    public void close() throws TeiidComponentException {
    }

    @Override
    public List getOutputElements() {
        return this.command.getProjectedSymbols();
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.setContext(context);
        this.pdm = dataMgr;
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        TupleBatch tupleBatch = new TupleBatch(1, new List[]{Arrays.asList(0)});
        tupleBatch.setTerminationFlag(true);
        return tupleBatch;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        AlterProcessor ap = new AlterProcessor();
        ap.workContext = DQPWorkContext.getWorkContext();
        try {
            this.command.acceptVisitor(ap);
        }
        catch (TeiidRuntimeException e) {
            throw (TeiidProcessingException)e.getCause();
        }
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Query", this.command.toString());
        return props;
    }

    class AlterProcessor
    extends LanguageVisitor {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();

        AlterProcessor() {
        }

        @Override
        public void visit(AlterView obj) {
            VDBMetaData vdb = this.workContext.getVDB();
            Table t = (Table)obj.getTarget().getMetadataID();
            String sql = ((QueryCommand)obj.getDefinition()).toString();
            if (DdlPlan.this.pdm.getMetadataRepository() != null) {
                DdlPlan.this.pdm.getMetadataRepository().setViewDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), t, sql);
            }
            DdlPlan.alterView(vdb, t, sql);
            if (DdlPlan.this.pdm.getEventDistributor() != null) {
                DdlPlan.this.pdm.getEventDistributor().setViewDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), ((Schema)t.getParent()).getName(), t.getName(), sql);
            }
        }

        @Override
        public void visit(AlterProcedure obj) {
            VDBMetaData vdb = this.workContext.getVDB();
            Procedure p = (Procedure)obj.getTarget().getMetadataID();
            String sql = ((CreateUpdateProcedureCommand)obj.getDefinition()).toString();
            if (DdlPlan.this.pdm.getMetadataRepository() != null) {
                DdlPlan.this.pdm.getMetadataRepository().setProcedureDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), p, sql);
            }
            DdlPlan.alterProcedureDefinition(vdb, p, sql);
            if (DdlPlan.this.pdm.getEventDistributor() != null) {
                DdlPlan.this.pdm.getEventDistributor().setProcedureDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), p.getParent().getName(), p.getName(), sql);
            }
        }

        @Override
        public void visit(AlterTrigger obj) {
            VDBMetaData vdb = this.workContext.getVDB();
            Table t = (Table)obj.getTarget().getMetadataID();
            String sql = null;
            Table.TriggerEvent event = obj.getEvent();
            if (obj.getEnabled() == null) {
                if (obj.isCreate()) {
                    if (DdlPlan.getPlanForEvent(t, event) != null) {
                        throw new TeiidRuntimeException((Throwable)new TeiidProcessingException(QueryPlugin.Util.getString("DdlPlan.event_already_exists", new Object[]{t.getName(), obj.getEvent()})));
                    }
                } else if (DdlPlan.getPlanForEvent(t, event) == null) {
                    throw new TeiidRuntimeException((Throwable)new TeiidProcessingException(QueryPlugin.Util.getString("DdlPlan.event_not_exists", new Object[]{t.getName(), obj.getEvent()})));
                }
                sql = ((TriggerAction)obj.getDefinition()).toString();
            } else if (DdlPlan.getPlanForEvent(t, event) == null) {
                throw new TeiidRuntimeException((Throwable)new TeiidProcessingException(QueryPlugin.Util.getString("DdlPlan.event_not_exists", new Object[]{t.getName(), obj.getEvent()})));
            }
            if (DdlPlan.this.pdm.getMetadataRepository() != null) {
                if (sql != null) {
                    DdlPlan.this.pdm.getMetadataRepository().setInsteadOfTriggerDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), t, obj.getEvent(), sql);
                } else {
                    DdlPlan.this.pdm.getMetadataRepository().setInsteadOfTriggerEnabled(this.workContext.getVdbName(), this.workContext.getVdbVersion(), t, obj.getEvent(), obj.getEnabled().booleanValue());
                }
            }
            DdlPlan.alterInsteadOfTrigger(vdb, t, sql, obj.getEnabled(), event);
            if (DdlPlan.this.pdm.getEventDistributor() != null) {
                DdlPlan.this.pdm.getEventDistributor().setInsteadOfTriggerDefinition(this.workContext.getVdbName(), this.workContext.getVdbVersion(), ((Schema)t.getParent()).getName(), t.getName(), obj.getEvent(), sql, obj.getEnabled());
            }
        }
    }
}

