/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.logging.LogManager;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.processor.xml.Element;
import org.teiid.query.processor.xml.NodeDescriptor;
import org.xml.sax.SAXException;

public class DocumentInProgress {
    private TransformerHandler handler;
    private Transformer transformer;
    private Element currentParent;
    private Element currentObject;
    private boolean finished;
    private boolean isFormatted = MappingNodeConstants.Defaults.DEFAULT_FORMATTED_DOCUMENT;
    private SQLXMLImpl xml;

    public DocumentInProgress(FileStore store, String encoding) throws TeiidComponentException {
        FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(store, encoding);
        this.xml = new SQLXMLImpl((InputStreamFactory)fsisf);
        this.xml.setEncoding(encoding);
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        try {
            this.handler = factory.newTransformerHandler();
            this.handler.setResult(new StreamResult(fsisf.getOuputStream()));
        }
        catch (Exception e) {
            throw new TeiidComponentException((Throwable)e);
        }
        this.transformer = this.handler.getTransformer();
        this.transformer.setOutputProperty("encoding", encoding);
    }

    public SQLXMLImpl getSQLXML() {
        return this.xml;
    }

    public void setDocumentFormat(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public boolean moveToParent() throws SAXException {
        this.showState("moveToParent - TOP");
        this.endElement(this.currentObject);
        if (this.currentParent == null) {
            return false;
        }
        this.showState("moveToParent - before processWorkingElements, second time");
        this.currentObject = this.currentParent;
        this.currentParent = this.currentParent.getParent();
        this.showState("moveToParent - BOT");
        return true;
    }

    public boolean moveToLastChild() {
        this.showState("moveToLastChild - TOP");
        this.currentParent = this.currentObject;
        this.currentObject = null;
        this.showState("moveToLastChild - BOT");
        return true;
    }

    public boolean addElement(NodeDescriptor descriptor, NodeDescriptor nillableDescriptor) {
        return this.addElement(descriptor, null, nillableDescriptor);
    }

    public boolean addElement(NodeDescriptor descriptor, String content) {
        return this.addElement(descriptor, content, null);
    }

    private boolean addElement(NodeDescriptor descriptor, String content, NodeDescriptor nillableDescriptor) {
        this.showState("addElement(2) - TOP");
        try {
            Element element;
            if (this.currentParent == null) {
                this.showState("addElement(2) - before StartDocument()");
                this.startDocument();
            }
            if ((element = this.makeElement(descriptor)) != null) {
                if (content != null) {
                    element.setContent(DocumentInProgress.normalizeText(content, descriptor.getTextNormalizationMode()));
                    this.markAsNonOptional(element);
                } else {
                    element.setNillableDescriptor(nillableDescriptor);
                }
                this.showState("addElement(2) - before markAsNonOptional()");
                this.endElement(this.currentObject);
                this.currentObject = element;
                return true;
            }
        }
        catch (SAXException e) {
            LogManager.logError((String)"org.teiid.PROCESSOR.XML_PLAN", (Throwable)e, (String)e.getMessage());
            return false;
        }
        this.showState("addElement(2) - BOT");
        return false;
    }

    private void endElement(Element element) throws SAXException {
        this.showState("endElement(2) - TOP");
        if (element == null) {
            return;
        }
        if (element.isOptional()) {
            if (element.getParent() != null) {
                element.getParent().getChildren().remove(element);
            }
            return;
        }
        NodeDescriptor nillableDescriptor = element.getNillableDescriptor();
        if (nillableDescriptor != null) {
            this.addAttribute(nillableDescriptor, nillableDescriptor.getDefaultValue(), element);
        }
        if (element.hadOptionalParent()) {
            return;
        }
        this.startElement(element);
        this.processChildren(element);
        element.endElement();
        if (element.getParent() != null) {
            element.getParent().getChildren().remove(element);
        }
        this.showState("endElement(2) - BOT");
    }

    private void startElement(Element element) throws SAXException {
        Element parent = element.getParent();
        while (parent != null && !parent.isElementStarted()) {
            parent.setNillableDescriptor(null);
            this.startElement(parent);
        }
        element.startElement();
    }

    private void processChildren(Element element) throws SAXException {
        Iterator i = element.getChildren().iterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            i.remove();
            child.startElement();
            this.processChildren(child);
            child.endElement();
        }
    }

    private void markAsNonOptional(Element element) {
        while (element != null) {
            element.setOptional(false);
            element = element.getParent();
        }
    }

    public boolean addAttribute(NodeDescriptor descriptor, String attributeValue, Element element) {
        element.setAttribute(descriptor, DocumentInProgress.normalizeText(attributeValue, descriptor.getTextNormalizationMode()));
        if (!descriptor.isOptional()) {
            this.markAsNonOptional(element);
        }
        return true;
    }

    public boolean addAttribute(NodeDescriptor descriptor, String attributeValue) {
        return this.addAttribute(descriptor, attributeValue, this.currentParent);
    }

    public boolean addComment(String commentText) {
        this.currentParent.setComment(commentText);
        return true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void markAsFinished() throws TeiidComponentException {
        try {
            this.endDocument();
        }
        catch (SAXException e) {
            throw new TeiidComponentException((Throwable)e);
        }
        this.finished = true;
    }

    private Element makeElement(NodeDescriptor descripter) {
        this.showState("makeElement - TOP");
        Element element = new Element(descripter, this.handler);
        element.setParent(this.currentParent);
        if (this.currentParent != null) {
            this.currentParent.addChild(element);
        }
        this.showState("makeElement - BOT");
        return element;
    }

    private void startDocument() throws SAXException {
        this.showState("startDocument - TOP");
        if (this.isFormatted) {
            this.transformer.setOutputProperty("indent", "yes");
        }
        this.handler.startDocument();
        this.showState("startDocument - BOT");
    }

    private void endDocument() throws SAXException {
        this.endElement(this.currentObject);
        this.handler.endDocument();
    }

    public static String normalizeText(String content, String textNormalizationMode) {
        String result = content;
        String singleSpace = " ";
        if (textNormalizationMode.equalsIgnoreCase("replace")) {
            result = result.replaceAll("\\s", singleSpace);
        } else if (textNormalizationMode.equalsIgnoreCase("collapse")) {
            result = result.replaceAll("\\s+", singleSpace);
            result = result.trim();
        }
        return result;
    }

    private void showState(String sOccasion) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR.XML_PLAN", (int)6)) {
            LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"\n [showState] State Vars at: " + sOccasion});
            LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"[showState] currentParent: " + this.currentParent});
            LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"[showState] currentObject: " + this.currentObject});
            if (this.currentObject != null) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"[showState] currentObject.getNillableDescriptor(): " + this.currentObject.getNillableDescriptor()});
                LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"[showState] workingElements: " + this.currentObject.getChildren()});
            }
            if (this.currentParent != null) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"[showState] currentParent.getParent(): " + this.currentParent.getParent()});
            } else {
                LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"[showState] currentParent.getParent(): is NULL "});
            }
        }
    }
}

