/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public abstract class Criteria
implements Expression {
    @Override
    public abstract Object clone();

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public static List<Criteria> separateCriteriaByAnd(Criteria crit) {
        if (crit == null) {
            return Collections.emptyList();
        }
        ArrayList<Criteria> parts = new ArrayList<Criteria>();
        Criteria.separateCriteria(crit, parts);
        return parts;
    }

    public static Criteria combineCriteria(List parts) {
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        if (parts.size() == 1) {
            return (Criteria)parts.get(0);
        }
        return new CompoundCriteria(parts);
    }

    private static void separateCriteria(Criteria crit, Collection<Criteria> parts) {
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            if (compCrit.getOperator() == 0) {
                for (Criteria conjunct : compCrit.getCriteria()) {
                    Criteria.separateCriteria(conjunct, parts);
                }
            } else {
                parts.add(crit);
            }
        } else {
            parts.add(crit);
        }
    }

    public static Criteria combineCriteria(Criteria primaryCrit, Criteria additionalCrit) {
        return Criteria.combineCriteria(primaryCrit, additionalCrit, false);
    }

    public static Criteria combineCriteria(Criteria primaryCrit, Criteria additionalCrit, boolean disjunctively) {
        if (primaryCrit == null) {
            return additionalCrit;
        }
        if (additionalCrit == null) {
            return primaryCrit;
        }
        CompoundCriteria compCrit = new CompoundCriteria();
        compCrit.setOperator(disjunctively ? 1 : 0);
        if (primaryCrit instanceof CompoundCriteria && ((CompoundCriteria)primaryCrit).getOperator() == (disjunctively ? 1 : 0)) {
            compCrit.getCriteria().addAll(((CompoundCriteria)primaryCrit).getCriteria());
        } else {
            compCrit.addCriteria(primaryCrit);
        }
        if (additionalCrit instanceof CompoundCriteria && ((CompoundCriteria)additionalCrit).getOperator() == (disjunctively ? 1 : 0)) {
            compCrit.getCriteria().addAll(((CompoundCriteria)additionalCrit).getCriteria());
        } else {
            compCrit.addCriteria(additionalCrit);
        }
        return compCrit;
    }

    public static Criteria applyDemorgan(Criteria input) {
        if (input instanceof NotCriteria) {
            NotCriteria not = (NotCriteria)input;
            return not.getCriteria();
        }
        if (!(input instanceof CompoundCriteria)) {
            return new NotCriteria(input);
        }
        CompoundCriteria compCrit = (CompoundCriteria)input;
        int operator = compCrit.getOperator() == 1 ? 0 : 1;
        ArrayList<Criteria> criteria = new ArrayList<Criteria>(compCrit.getCriteria().size());
        for (Criteria crit : compCrit.getCriteria()) {
            crit = new NotCriteria(crit);
            criteria.add(crit);
        }
        return new CompoundCriteria(operator, criteria);
    }

    @Override
    public Class<?> getType() {
        return DataTypeManager.DefaultDataClasses.BOOLEAN;
    }

    @Override
    public boolean isResolved() {
        return true;
    }
}

