/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class XMLSerialize
implements Expression {
    private static final long serialVersionUID = -6574662238317329252L;
    private Boolean document;
    private Expression expression;
    private String typeString;
    private Class<?> type;

    @Override
    public Class<?> getType() {
        if (this.type == null) {
            this.type = this.typeString == null ? DataTypeManager.DefaultDataClasses.CLOB : DataTypeManager.getDataTypeClass((String)this.typeString);
        }
        return this.type;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Boolean isDocument() {
        return this.document;
    }

    public void setDocument(Boolean document) {
        this.document = document;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setTypeString(String typeString) {
        this.typeString = typeString;
    }

    public String getTypeString() {
        return this.typeString;
    }

    @Override
    public boolean isResolved() {
        return this.expression.isResolved();
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public XMLSerialize clone() {
        XMLSerialize clone = new XMLSerialize();
        clone.document = this.document;
        clone.expression = (Expression)this.expression.clone();
        clone.typeString = this.typeString;
        clone.type = this.type;
        return clone;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XMLSerialize)) {
            return false;
        }
        XMLSerialize other = (XMLSerialize)obj;
        return this.document == other.document && this.expression.equals(other.expression) && this.getType() == other.getType();
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

