/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core;

import junit.framework.TestCase;
import org.teiid.core.TeiidRuntimeException;

public final class TestMetaMatrixRuntimeException
extends TestCase {
    public TestMetaMatrixRuntimeException(String name) {
        super(name);
    }

    public void testFailMetaMatrixRuntimeExceptionWithNullMessage() {
        Throwable e = null;
        try {
            new TeiidRuntimeException((String)null);
            TestMetaMatrixRuntimeException.fail((String)"Should not get here");
        }
        catch (Throwable ex) {
            e = ex;
        }
        TestMetaMatrixRuntimeException.assertNotNull((Object)e);
    }

    public void testMetaMatrixRuntimeExceptionWithNullThrowable() {
        TeiidRuntimeException err = new TeiidRuntimeException((Throwable)null);
        TestMetaMatrixRuntimeException.assertNull((Object)err.getCause());
        TestMetaMatrixRuntimeException.assertNull((Object)err.getCode());
        TestMetaMatrixRuntimeException.assertNull((Object)err.getMessage());
    }

    public void testMetaMatrixRuntimeExceptionWithMessage() {
        TeiidRuntimeException err = new TeiidRuntimeException("Test");
        TestMetaMatrixRuntimeException.assertNull((Object)err.getCause());
        TestMetaMatrixRuntimeException.assertNull((Object)err.getCode());
        TestMetaMatrixRuntimeException.assertEquals((String)"Test", (String)err.getMessage());
    }

    public void testMetaMatrixRuntimeExceptionWithCodeAndMessage() {
        String code = "1234";
        TeiidRuntimeException err = new TeiidRuntimeException("1234", "Test");
        TestMetaMatrixRuntimeException.assertNull((Object)err.getCause());
        TestMetaMatrixRuntimeException.assertEquals((String)"1234", (String)err.getCode());
        TestMetaMatrixRuntimeException.assertEquals((String)"Test", (String)err.getMessage());
    }

    public void testMetaMatrixRuntimeExceptionWithExceptionAndMessage() {
        String code = "1234";
        TeiidRuntimeException child = new TeiidRuntimeException("1234", "Child");
        TeiidRuntimeException err = new TeiidRuntimeException((Throwable)child, "Test");
        TestMetaMatrixRuntimeException.assertSame((Object)child, (Object)err.getCause());
        TestMetaMatrixRuntimeException.assertEquals((String)"1234", (String)err.getCode());
        TestMetaMatrixRuntimeException.assertEquals((String)"Test", (String)err.getMessage());
    }

    public void testMetaMatrixRuntimeExceptionWithExceptionAndCodeAndMessage() {
        String code = "1234";
        TeiidRuntimeException child = new TeiidRuntimeException("1234", "Child");
        TeiidRuntimeException err = new TeiidRuntimeException((Throwable)child, "Code", "Test");
        TestMetaMatrixRuntimeException.assertSame((Object)child, (Object)err.getCause());
        TestMetaMatrixRuntimeException.assertEquals((String)"Code", (String)err.getCode());
        TestMetaMatrixRuntimeException.assertEquals((String)"Test", (String)err.getMessage());
    }
}

