/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.TestDataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.StringToSQLXMLTransform;
import org.teiid.query.unittest.TimestampUtil;

public class TestTransforms {
    static Object[][] testData = new Object[][]{{"1", "0", "123"}, {new Character('1'), new Character('0'), new Character('1')}, {Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}, {new Byte(1), new Byte(0), new Byte(123)}, {new Short(1), new Short(0), new Short(123)}, {new Integer(1), new Integer(0), new Integer(123)}, {new Long(1L), new Long(0L), new Long(123L)}, {new BigInteger("1"), new BigInteger("0"), new BigInteger("123")}, {new Float(1.0f), new Float(0.0f), new Float(123.0f)}, {new Double(1.0), new Double(0.0), new Double(123.0)}, {new BigDecimal("1"), new BigDecimal("0"), new BigDecimal("123")}, {new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())}, {new Time(System.currentTimeMillis()), new Time(System.currentTimeMillis()), new Time(System.currentTimeMillis())}, {new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())}, {null, null, null}, {null, null, null}, {new ClobType(ClobImpl.createClob((char[])"ClobData".toCharArray())), new ClobType(ClobImpl.createClob((char[])"0".toCharArray())), new ClobType(ClobImpl.createClob((char[])"123".toCharArray()))}, {new XMLType((SQLXML)new SQLXMLImpl("<foo>bar</foo>")), new XMLType((SQLXML)new SQLXMLImpl("<foo>bar</foo>")), new XMLType((SQLXML)new SQLXMLImpl("<foo>bar</foo>"))}};
    private String[] dataTypes = TestDataTypeManager.dataTypes;
    private char[][] conversions = TestDataTypeManager.conversions;

    private static void helpTestTransform(Object value, Object expectedValue) throws TransformationException {
        Transform transform = DataTypeManager.getTransform(value.getClass(), expectedValue.getClass());
        Object result = transform.transform(value);
        Assert.assertEquals((Object)expectedValue, (Object)result);
    }

    private static void validateTransform(String src, Object value, String target, Object expectedValue) throws TransformationException {
        block2: {
            try {
                Transform transform = DataTypeManager.getTransform((Class)DataTypeManager.getDataTypeClass((String)src), expectedValue.getClass());
                Object result = transform.transform(value);
                Assert.assertTrue((boolean)expectedValue.getClass().isAssignableFrom(result.getClass()));
                Assert.assertFalse((String)("Expected exception for " + src + " to " + target), (boolean)TestTransforms.isException(DataTypeManager.getDataTypeName(value.getClass()), target, value));
            }
            catch (TransformationException e) {
                if (TestTransforms.isException(DataTypeManager.getDataTypeName(value.getClass()), target, value)) break block2;
                throw e;
            }
        }
    }

    private static void helpTransformException(Object value, Class<?> target, String msg) {
        block2: {
            try {
                Transform transform = DataTypeManager.getTransform(value.getClass(), target);
                transform.transform(value);
                Assert.fail((String)"Expected to get an exception during the transformation");
            }
            catch (TransformationException e) {
                if (msg == null) break block2;
                Assert.assertEquals((Object)msg, (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testBigDecimalToBigInteger_Defect16875() throws TransformationException {
        TestTransforms.helpTestTransform(new BigDecimal("0.5867"), new BigInteger("0"));
    }

    @Test
    public void testString2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new String("1"), Boolean.TRUE);
        TestTransforms.helpTestTransform(new String("0"), Boolean.FALSE);
        TestTransforms.helpTestTransform(new String("true"), Boolean.TRUE);
        TestTransforms.helpTestTransform(new String("false"), Boolean.FALSE);
        TestTransforms.helpTestTransform(new String("foo"), Boolean.TRUE);
    }

    @Test
    public void testByte2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new Byte(1), Boolean.TRUE);
        TestTransforms.helpTestTransform(new Byte(0), Boolean.FALSE);
        TestTransforms.helpTestTransform(new Byte(12), Boolean.TRUE);
    }

    @Test
    public void testShort2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new Short(1), Boolean.TRUE);
        TestTransforms.helpTestTransform(new Short(0), Boolean.FALSE);
        TestTransforms.helpTestTransform(new Short(12), Boolean.TRUE);
    }

    @Test
    public void testInteger2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new Integer(1), Boolean.TRUE);
        TestTransforms.helpTestTransform(new Integer(0), Boolean.FALSE);
        TestTransforms.helpTestTransform(new Integer(12), Boolean.TRUE);
    }

    @Test
    public void testLong2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new Long(1L), Boolean.TRUE);
        TestTransforms.helpTestTransform(new Long(0L), Boolean.FALSE);
        TestTransforms.helpTestTransform(new Long(12L), Boolean.TRUE);
    }

    @Test
    public void testBigInteger2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new BigInteger("1"), Boolean.TRUE);
        TestTransforms.helpTestTransform(new BigInteger("0"), Boolean.FALSE);
        TestTransforms.helpTestTransform(new BigInteger("12"), Boolean.TRUE);
    }

    @Test
    public void testBigDecimal2Boolean() throws TransformationException {
        TestTransforms.helpTestTransform(new BigDecimal("1"), Boolean.TRUE);
        TestTransforms.helpTestTransform(new BigDecimal("0"), Boolean.FALSE);
        TestTransforms.helpTestTransform(new BigDecimal("0.00"), Boolean.FALSE);
    }

    private static boolean isException(String src, String tgt, Object source) {
        return src.equals("string") && tgt.equals("xml") || src.equals("string") && tgt.equals("time") || src.equals("string") && tgt.equals("timestamp") || src.equals("string") && tgt.equals("date") || src.equals("clob") && tgt.equals("xml");
    }

    @Test
    public void testAllConversions() throws TransformationException {
        for (int src = 0; src < this.dataTypes.length; ++src) {
            for (int tgt = 0; tgt < this.dataTypes.length; ++tgt) {
                char c = this.conversions[src][tgt];
                if (c != 'I' && c != 'C') continue;
                Object[] srcdata = testData[src];
                Object[] tgtdata = testData[tgt];
                for (int i = 0; i < tgtdata.length; ++i) {
                    if (tgtdata[i] == null || srcdata[i] == null) continue;
                    TestTransforms.validateTransform(this.dataTypes[src], srcdata[i], this.dataTypes[tgt], tgtdata[i]);
                }
            }
        }
    }

    @Test
    public void testAllConversionsAsObject() throws TransformationException {
        for (int src = 0; src < this.dataTypes.length; ++src) {
            for (int tgt = 0; tgt < this.dataTypes.length; ++tgt) {
                char c = this.conversions[src][tgt];
                if (c != 'I' && c != 'C') continue;
                Object[] srcdata = testData[src];
                Object[] tgtdata = testData[tgt];
                for (int i = 0; i < tgtdata.length; ++i) {
                    if (tgtdata[i] == null || srcdata[i] == null) continue;
                    TestTransforms.validateTransform("object", srcdata[i], this.dataTypes[tgt], tgtdata[i]);
                }
            }
        }
    }

    @Test
    public void testObjectToAnyTransformFailure() {
        Transform transform = DataTypeManager.getTransform((Class)DataTypeManager.DefaultDataClasses.OBJECT, (Class)DataTypeManager.DefaultDataClasses.TIME);
        try {
            transform.transform((Object)"1");
            Assert.fail((String)"expected exception");
        }
        catch (TransformationException e) {
            Assert.assertEquals((Object)"TEIID10076 Invalid conversion from type class java.lang.Object with value '1' to type class java.sql.Time", (Object)e.getMessage());
        }
    }

    @Test
    public void testSQLXMLToStringTransform() throws Exception {
        StringBuffer xml = new StringBuffer();
        int iters = 400;
        for (int i = 0; i < iters; ++i) {
            if (i < iters / 2) {
                xml.append("<opentag>1");
                continue;
            }
            xml.append("</opentag>");
        }
        String expected = "";
        expected = expected + xml.substring(0, 4000 - expected.length());
        TestTransforms.helpTestTransform(new StringToSQLXMLTransform().transformDirect((Object)xml.toString()), expected);
    }

    @Test
    public void testStringToTimestampOutOfRange() throws Exception {
        TestTransforms.helpTransformException("2005-13-01 11:13:01", DataTypeManager.DefaultDataClasses.TIMESTAMP, null);
    }

    @Test
    public void testStringToTimeTimestampWithWS() throws Exception {
        TestTransforms.helpTestTransform(" 2005-12-01 11:13:01 ", TimestampUtil.createTimestamp(105, 11, 1, 11, 13, 1, 0));
    }

    @Test
    public void testStringToTimestampFails() throws Exception {
        TestTransforms.helpTransformException("2005-12-01 11:88:60", Timestamp.class, "TEIID10060 The string representation '2005-12-01 11:88:60' of a Timestamp value is not valid.");
    }

    @Test
    public void testStringToLongWithWS() throws Exception {
        TestTransforms.helpTestTransform(" 1 ", 1L);
    }

    @Test
    public void testEngineeringNotationFloatToBigInteger() throws Exception {
        TestTransforms.helpTestTransform(Float.valueOf(Float.MIN_VALUE), new BigDecimal(1.4E-45f).toBigInteger());
    }

    @Test
    public void testRangeCheck() throws Exception {
        TestTransforms.helpTransformException(300, DataTypeManager.DefaultDataClasses.BYTE, "TEIID10058 The Integer value '300' is outside the of range for Byte");
    }

    @Test
    public void testRangeCheck1() throws Exception {
        TestTransforms.helpTransformException(new Double("1E11"), DataTypeManager.DefaultDataClasses.INTEGER, "TEIID10058 The Double value '100,000,000,000' is outside the of range for Integer");
    }
}

