/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;
import org.teiid.client.DQP;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.core.util.SqlUtil;
import org.teiid.jdbc.CallableStatementImpl;
import org.teiid.jdbc.DatabaseMetaDataImpl;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidConnection;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.WrapperImpl;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.SocketServerConnection;

public class ConnectionImpl
extends WrapperImpl
implements TeiidConnection {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    public static final int DEFAULT_ISOLATION = 2;
    private static final String SERVER_NAME = "Teiid Server";
    private static final String EMBEDDED_NAME = "Teiid Embedded";
    private long requestIDGenerator;
    private String url;
    protected Properties propInfo;
    private boolean closed = false;
    private boolean autoCommitFlag = true;
    private boolean inLocalTxn;
    private Collection<StatementImpl> statements = Collections.newSetFromMap(new ConcurrentHashMap());
    private DatabaseMetaDataImpl dbmm;
    private XidImpl transactionXid;
    private boolean readOnly = false;
    private boolean disableLocalTransactions = false;
    private DQP dqp;
    protected ServerConnection serverConn;
    private int transactionIsolation = 2;
    private PlanNode currentPlanDescription;
    private String debugLog;
    private Collection<Annotation> annotations;
    private Properties connectionProps;
    private Properties payload;

    public ConnectionImpl(ServerConnection serverConn, Properties info, String url) {
        this.connectionProps = info;
        this.serverConn = serverConn;
        this.url = url;
        this.dqp = serverConn.getService(DQP.class);
        logger.fine(JDBCPlugin.Util.getString("MMConnection.Session_success"));
        this.logConnectionProperties(url, info);
        this.setExecutionProperties(info);
        this.disableLocalTransactions = Boolean.valueOf(this.propInfo.getProperty("disableLocalTxn"));
    }

    boolean isInLocalTxn() {
        return this.inLocalTxn;
    }

    private void setExecutionProperties(Properties info) {
        String defaultFetchSize;
        this.propInfo = new Properties();
        String overrideProp = info.getProperty("autoCommitTxn");
        if (overrideProp == null || overrideProp.trim().length() == 0) {
            this.propInfo.put("autoCommitTxn", "DETECT");
        }
        if ((defaultFetchSize = info.getProperty("fetchSize")) != null) {
            this.propInfo.put("fetchSize", defaultFetchSize);
        } else {
            this.propInfo.put("fetchSize", String.valueOf(2048));
        }
        String partialResultsMode = info.getProperty("partialResultsMode");
        if (partialResultsMode != null) {
            this.propInfo.put("partialResultsMode", partialResultsMode);
        } else {
            this.propInfo.put("partialResultsMode", "FALSE");
        }
        String resultSetCacheMode = info.getProperty("resultSetCacheMode");
        if (resultSetCacheMode != null) {
            this.propInfo.put("resultSetCacheMode", resultSetCacheMode);
        } else {
            this.propInfo.put("resultSetCacheMode", "FALSE");
        }
        String ansiQuotes = info.getProperty("ansiQuotedIdentifiers");
        if (ansiQuotes != null) {
            this.propInfo.put("ansiQuotedIdentifiers", ansiQuotes);
        } else {
            this.propInfo.put("ansiQuotedIdentifiers", Boolean.TRUE.toString());
        }
        block0: for (String key : info.stringPropertyNames()) {
            for (String prop : JDBCURL.EXECUTION_PROPERTIES) {
                if (!prop.equalsIgnoreCase(key)) continue;
                this.propInfo.setProperty(key, info.getProperty(key));
                continue block0;
            }
        }
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Collection<Annotation> annotations) {
        this.annotations = annotations;
    }

    public String getDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(String debugLog) {
        this.debugLog = debugLog;
    }

    public PlanNode getCurrentPlanDescription() {
        return this.currentPlanDescription;
    }

    public void setCurrentPlanDescription(PlanNode currentPlanDescription) {
        this.currentPlanDescription = currentPlanDescription;
    }

    protected Properties getExecutionProperties() {
        return this.propInfo;
    }

    DQP getDQP() {
        return this.dqp;
    }

    private void logConnectionProperties(String connUrl, Properties info) {
        StringBuffer modifiedUrl = new StringBuffer();
        if (connUrl != null) {
            int startIndex = connUrl.indexOf("password=");
            if (startIndex != -1) {
                modifiedUrl.append(connUrl.substring(0, startIndex));
                modifiedUrl.append("password=***");
                int endIndex = connUrl.indexOf(";", startIndex + 9);
                if (endIndex != -1) {
                    modifiedUrl.append(";").append(connUrl.substring(endIndex));
                }
            }
            logger.fine("Connection Url=" + modifiedUrl);
        }
        if (info != null) {
            Enumeration<Object> enumeration = info.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object anObj = info.get(key);
                if ("password".equalsIgnoreCase(key)) continue;
                logger.fine(key + "=" + anObj);
            }
        }
    }

    String getUrl() {
        return this.url;
    }

    public String getConnectionId() {
        return this.serverConn.getLogonResult().getSessionID();
    }

    protected synchronized long nextRequestID() {
        return this.requestIDGenerator++;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        SQLException firstException = null;
        if (this.closed) {
            return;
        }
        try {
            try {
                this.closeStatements();
            }
            catch (SQLException se) {
                firstException = se;
            }
            finally {
                this.serverConn.close();
                if (firstException != null) {
                    throw firstException;
                }
            }
        }
        catch (SQLException se) {
            throw TeiidSQLException.create(se, JDBCPlugin.Util.getString("MMConnection.Err_connection_close", new Object[]{se.getMessage()}));
        }
        finally {
            logger.fine(JDBCPlugin.Util.getString("MMConnection.Connection_close_success"));
            this.closed = true;
        }
    }

    void closeStatements() throws SQLException {
        ArrayList<StatementImpl> statementsSafe = new ArrayList<StatementImpl>(this.statements);
        SQLException ex = null;
        for (StatementImpl statement : statementsSafe) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw TeiidSQLException.create(ex, JDBCPlugin.Util.getString("MMConnection.Err_closing_stmts"));
        }
    }

    void closeStatement(Statement statement) {
        this.statements.remove(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        this.checkConnection();
        if (!this.autoCommitFlag) {
            try {
                this.directCommit();
            }
            finally {
                this.inLocalTxn = false;
            }
        }
    }

    private void directCommit() throws SQLException {
        if (this.inLocalTxn) {
            try {
                ResultsFuture<?> future = this.dqp.commit();
                future.get();
            }
            catch (Exception e) {
                throw TeiidSQLException.create(e);
            }
            logger.fine(JDBCPlugin.Util.getString("MMConnection.Commit_success"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginLocalTxnIfNeeded() throws SQLException {
        if (this.transactionXid != null || this.inLocalTxn || this.autoCommitFlag || this.disableLocalTransactions) {
            return;
        }
        try {
            try {
                this.dqp.begin();
            }
            catch (XATransactionException e) {
                throw TeiidSQLException.create((Throwable)((Object)e));
            }
            this.inLocalTxn = true;
        }
        finally {
            if (!this.inLocalTxn) {
                this.autoCommitFlag = true;
            }
        }
    }

    @Override
    public StatementImpl createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public StatementImpl createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    private void validateResultSetType(int resultSetType) throws TeiidSQLException {
        if (resultSetType == 1005) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Scrollable_type_not_supported", new Object[]{"ResultSet.TYPE_SCROLL_SENSITIVE"});
            throw new TeiidSQLException(msg);
        }
    }

    private void validateResultSetConcurrency(int resultSetConcurrency) throws TeiidSQLException {
        if (resultSetConcurrency == 1008) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Concurrency_type_not_supported", new Object[]{"ResultSet.CONCUR_UPDATABLE"});
            throw new TeiidSQLException(msg);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        return this.autoCommitFlag;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getVdbName();
    }

    ServerConnection getServerConnection() throws SQLException {
        this.checkConnection();
        return this.serverConn;
    }

    String getVDBName() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getVdbName();
    }

    public int getVDBVersion() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getVdbVersion();
    }

    String getUserName() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getUserName();
    }

    @Override
    public DatabaseMetaDataImpl getMetaData() throws SQLException {
        this.checkConnection();
        if (this.dbmm == null) {
            this.dbmm = new DatabaseMetaDataImpl(this);
        }
        return this.dbmm;
    }

    public String getDatabaseName() {
        if (this.serverConn instanceof SocketServerConnection) {
            return SERVER_NAME;
        }
        return EMBEDDED_NAME;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolation;
    }

    public Map getTypeMap() throws SQLException {
        this.checkConnection();
        return new HashMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public CallableStatementImpl prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1004, 1007);
    }

    @Override
    public CallableStatementImpl prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 1);
    }

    private void validateSQL(String sql) throws TeiidSQLException {
        if (sql == null) {
            String msg = JDBCPlugin.Util.getString("MMConnection.SQL_cannot_be_null");
            throw new TeiidSQLException(msg);
        }
    }

    @Override
    public PreparedStatementImpl prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatementImpl prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public PreparedStatementImpl prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        PreparedStatementImpl newStatement = new PreparedStatementImpl(this, sql, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    @Override
    public void rollback() throws SQLException {
        this.rollback(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(boolean startTxn) throws SQLException {
        block8: {
            this.checkConnection();
            if (!this.autoCommitFlag) {
                try {
                    if (!this.inLocalTxn) break block8;
                    this.inLocalTxn = false;
                    try {
                        ResultsFuture<?> future = this.dqp.rollback();
                        future.get();
                    }
                    catch (Exception e) {
                        throw TeiidSQLException.create(e);
                    }
                    logger.fine(JDBCPlugin.Util.getString("MMConnection.Rollback_success"));
                }
                finally {
                    if (startTxn) {
                        this.inLocalTxn = false;
                    } else {
                        this.autoCommitFlag = true;
                    }
                }
            }
        }
    }

    public ResultsFuture<?> submitSetAutoCommitTrue(boolean commit) throws SQLException {
        this.checkConnection();
        if (this.autoCommitFlag) {
            return ResultsFuture.NULL_FUTURE;
        }
        this.autoCommitFlag = true;
        try {
            if (commit) {
                return this.dqp.commit();
            }
            return this.dqp.rollback();
        }
        catch (XATransactionException e) {
            throw TeiidSQLException.create((Throwable)((Object)e));
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkConnection();
        if (autoCommit == this.autoCommitFlag) {
            return;
        }
        this.autoCommitFlag = autoCommit;
        if (autoCommit) {
            this.directCommit();
        } else {
            this.inLocalTxn = false;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.readOnly == readOnly) {
            return;
        }
        if (!this.autoCommitFlag || this.transactionXid != null) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Invalid_During_Transaction", new Object[]{"setReadOnly(" + readOnly + ")"}));
        }
        this.readOnly = readOnly;
    }

    void checkConnection() throws SQLException {
        if (this.closed) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMConnection.Cant_use_closed_connection"));
        }
    }

    protected void commitTransaction(XidImpl arg0, boolean arg1) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        this.autoCommitFlag = true;
        try {
            ResultsFuture<?> future = this.dqp.commit(arg0, arg1);
            future.get();
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e);
        }
    }

    protected void endTransaction(XidImpl arg0, int arg1) throws SQLException {
        this.checkConnection();
        this.autoCommitFlag = true;
        try {
            ResultsFuture<?> future = this.dqp.end(arg0, arg1);
            future.get();
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e);
        }
    }

    protected void forgetTransaction(XidImpl arg0) throws SQLException {
        this.checkConnection();
        try {
            ResultsFuture<?> future = this.dqp.forget(arg0);
            future.get();
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e);
        }
    }

    protected int prepareTransaction(XidImpl arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        try {
            ResultsFuture<Integer> future = this.dqp.prepare(arg0);
            return future.get();
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e);
        }
    }

    protected Xid[] recoverTransaction(int arg0) throws SQLException {
        this.checkConnection();
        try {
            ResultsFuture<Xid[]> future = this.dqp.recover(arg0);
            return future.get();
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e);
        }
    }

    protected void rollbackTransaction(XidImpl arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        this.autoCommitFlag = true;
        try {
            ResultsFuture<?> future = this.dqp.rollback(arg0);
            future.get();
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e);
        }
    }

    protected void startTransaction(XidImpl arg0, int arg1, int timeout) throws SQLException {
        this.checkConnection();
        try {
            ResultsFuture<?> future = this.dqp.start(arg0, arg1, timeout);
            future.get();
        }
        catch (Exception e) {
            throw TeiidSQLException.create(e);
        }
        this.transactionXid = arg0;
        this.autoCommitFlag = false;
    }

    protected XidImpl getTransactionXid() {
        return this.transactionXid;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.getServerConnection().isOpen(timeout * 1000);
    }

    public void recycleConnection() {
        this.payload = null;
        try {
            this.closeStatements();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, JDBCPlugin.Util.getString("MMXAConnection.rolling_back_error"), e);
        }
        try {
            if (!this.getAutoCommit()) {
                logger.warning(JDBCPlugin.Util.getString("MMXAConnection.rolling_back"));
                if (this.getTransactionXid() == null) {
                    this.rollback(false);
                } else {
                    this.rollbackTransaction(this.getTransactionXid());
                }
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, JDBCPlugin.Util.getString("MMXAConnection.rolling_back_error"), e);
        }
        this.serverConn.cleanUp();
    }

    public boolean isSameProcess(ConnectionImpl conn) throws CommunicationException {
        return this.serverConn.isSameInstance(conn.serverConn);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public StatementImpl createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        StatementImpl newStatement = new StatementImpl(this, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public CallableStatementImpl prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        CallableStatementImpl newStatement = new CallableStatementImpl(this, sql, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    Object setPassword(Object newPassword) {
        if (newPassword != null) {
            return this.connectionProps.put("password", newPassword);
        }
        return this.connectionProps.remove("password");
    }

    String getPassword() {
        Object result = this.connectionProps.get("password");
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    @Override
    public void changeUser(String userName, String newPassword) throws SQLException {
        Object oldName = null;
        Object oldPassword = null;
        oldName = userName != null ? this.connectionProps.put("user", userName) : this.connectionProps.remove("user");
        oldPassword = this.setPassword(newPassword);
        boolean success = false;
        try {
            this.serverConn.authenticate();
            success = true;
        }
        catch (ConnectionException e) {
            throw TeiidSQLException.create((Throwable)((Object)e));
        }
        catch (CommunicationException e) {
            throw TeiidSQLException.create((Throwable)((Object)e));
        }
        finally {
            if (!success) {
                if (oldName != null) {
                    this.connectionProps.put("user", oldName);
                } else {
                    this.connectionProps.remove("user");
                }
                this.setPassword(oldPassword);
            }
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.closed) {
            return;
        }
        this.close();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    public Properties getPayload() {
        return this.payload;
    }

    public void setPayload(Properties payload) {
        this.payload = payload;
    }
}

