/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class RuleChooseJoinStrategy
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, TeiidComponentException {
        for (PlanNode joinNode : NodeEditor.findAllNodes(plan, 4, 1)) {
            RuleChooseJoinStrategy.chooseJoinStrategy(joinNode, metadata);
        }
        return plan;
    }

    static void chooseJoinStrategy(PlanNode joinNode, QueryMetadataInterface metadata) {
        JoinType jtype = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals(JoinType.JOIN_CROSS)) {
            return;
        }
        PlanNode leftChild = joinNode.getFirstChild();
        if ((leftChild = FrameUtil.findJoinSourceNode(leftChild)) == null) {
            return;
        }
        PlanNode rightChild = joinNode.getLastChild();
        if ((rightChild = FrameUtil.findJoinSourceNode(rightChild)) == null) {
            return;
        }
        Set<GroupSymbol> leftGroups = leftChild.getGroups();
        Set<GroupSymbol> rightGroups = rightChild.getGroups();
        ArrayList<Expression> leftExpressions = new ArrayList<Expression>();
        ArrayList<Expression> rightExpressions = new ArrayList<Expression>();
        List crits = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        RuleChooseJoinStrategy.filterOptionalCriteria(crits);
        if (crits.isEmpty() && jtype == JoinType.JOIN_INNER) {
            joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_CROSS);
            return;
        }
        ArrayList<Criteria> nonEquiJoinCriteria = new ArrayList<Criteria>();
        RuleChooseJoinStrategy.separateCriteria(leftGroups, rightGroups, leftExpressions, rightExpressions, crits, nonEquiJoinCriteria);
        if (!leftExpressions.isEmpty()) {
            joinNode.setProperty(NodeConstants.Info.LEFT_EXPRESSIONS, RuleChooseJoinStrategy.createExpressionSymbols(leftExpressions));
            joinNode.setProperty(NodeConstants.Info.RIGHT_EXPRESSIONS, RuleChooseJoinStrategy.createExpressionSymbols(rightExpressions));
            joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
            joinNode.setProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA, nonEquiJoinCriteria);
        } else if (nonEquiJoinCriteria.isEmpty()) {
            joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, nonEquiJoinCriteria);
            if (joinNode.getProperty(NodeConstants.Info.JOIN_TYPE) == JoinType.JOIN_INNER) {
                joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_CROSS);
            }
        }
    }

    public static void separateCriteria(Collection<GroupSymbol> leftGroups, Collection<GroupSymbol> rightGroups, List<Expression> leftExpressions, List<Expression> rightExpressions, List<Criteria> crits, List<Criteria> nonEquiJoinCriteria) {
        for (Criteria theCrit : crits) {
            Set<GroupSymbol> critGroups = GroupsUsedByElementsVisitor.getGroups(theCrit);
            if (leftGroups.containsAll(critGroups) || rightGroups.containsAll(critGroups)) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            if (!(theCrit instanceof CompareCriteria)) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            CompareCriteria crit = (CompareCriteria)theCrit;
            if (crit.getOperator() != 1) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            Expression leftExpr = crit.getLeftExpression();
            Expression rightExpr = crit.getRightExpression();
            Set<GroupSymbol> leftExprGroups = GroupsUsedByElementsVisitor.getGroups(leftExpr);
            Set<GroupSymbol> rightExprGroups = GroupsUsedByElementsVisitor.getGroups(rightExpr);
            if (leftGroups.isEmpty() || rightGroups.isEmpty()) {
                nonEquiJoinCriteria.add(theCrit);
                continue;
            }
            if (leftGroups.containsAll(leftExprGroups) && rightGroups.containsAll(rightExprGroups)) {
                leftExpressions.add(leftExpr);
                rightExpressions.add(rightExpr);
                continue;
            }
            if (rightGroups.containsAll(leftExprGroups) && leftGroups.containsAll(rightExprGroups)) {
                leftExpressions.add(rightExpr);
                rightExpressions.add(leftExpr);
                continue;
            }
            nonEquiJoinCriteria.add(theCrit);
        }
    }

    public static List<Expression> createExpressionSymbols(List<? extends Expression> expressions) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            if (expression instanceof Symbol) {
                result.add(expression);
                continue;
            }
            result.add(new ExpressionSymbol("expr", expression));
        }
        return result;
    }

    static void filterOptionalCriteria(List<Criteria> crits) {
        Iterator<Criteria> iter = crits.iterator();
        while (iter.hasNext()) {
            CompareCriteria cc;
            Criteria crit = iter.next();
            if (!(crit instanceof CompareCriteria) || !(cc = (CompareCriteria)crit).isOptional()) continue;
            iter.remove();
        }
    }

    public String toString() {
        return "ChooseJoinStrategy";
    }
}

