/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.query.QueryPlugin;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.SQLParser;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.query.parser.Token;
import org.teiid.query.parser.TokenMgrError;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.symbol.Expression;

public class QueryParser {
    private static ThreadLocal<QueryParser> QUERY_PARSER = new ThreadLocal<QueryParser>(){

        @Override
        protected QueryParser initialValue() {
            return new QueryParser();
        }
    };
    private static final String LINE_MARKER = "line ";
    private static final String COL_MARKER = "column ";
    private static final String XQUERY_DECLARE = "declare";
    private static final String XML_OPEN_BRACKET = "<";
    private SQLParser parser;

    public static QueryParser getQueryParser() {
        return QUERY_PARSER.get();
    }

    private SQLParser getSqlParser(String sql) {
        return this.getSqlParser(new StringReader(sql));
    }

    private SQLParser getSqlParser(Reader sql) {
        if (this.parser == null) {
            this.parser = new SQLParser(sql);
        } else {
            this.parser.ReInit(sql);
        }
        return this.parser;
    }

    public Command parseCommand(String sql) throws QueryParserException {
        return this.parseCommand(sql, new ParseInfo());
    }

    public Command parseProcedure(String sql, boolean update) throws QueryParserException {
        try {
            if (update) {
                return this.getSqlParser(sql).forEachRowTriggerAction(new ParseInfo());
            }
            CreateProcedureCommand result = this.getSqlParser(sql).procedureBodyCommand(new ParseInfo());
            result.setCacheHint(SQLParserUtil.getQueryCacheOption(sql));
            return result;
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            throw this.handleTokenMgrError(tme);
        }
    }

    public Command parseCommand(String sql, ParseInfo parseInfo) throws QueryParserException {
        return this.parseCommand(sql, parseInfo, false);
    }

    public Command parseDesignerCommand(String sql) throws QueryParserException {
        return this.parseCommand(sql, new ParseInfo(), true);
    }

    public Command parseCommand(String sql, ParseInfo parseInfo, boolean designerCommands) throws QueryParserException {
        if (sql == null || sql.length() == 0) {
            throw new QueryParserException((BundleUtil.Event)QueryPlugin.Event.TEIID30377, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30377, new Object[0]));
        }
        Command result = null;
        try {
            result = designerCommands ? this.getSqlParser(sql).designerCommand(parseInfo) : this.getSqlParser(sql).command(parseInfo);
            result.setCacheHint(SQLParserUtil.getQueryCacheOption(sql));
        }
        catch (ParseException pe) {
            if (sql.startsWith(XML_OPEN_BRACKET) || sql.startsWith(XQUERY_DECLARE)) {
                throw new QueryParserException(QueryPlugin.Event.TEIID30378, pe, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30378, new Object[]{sql}));
            }
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            if (sql.startsWith(XML_OPEN_BRACKET) || sql.startsWith(XQUERY_DECLARE)) {
                throw new QueryParserException(QueryPlugin.Event.TEIID30378, tme, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30378, new Object[]{sql}));
            }
            throw this.handleTokenMgrError(tme);
        }
        return result;
    }

    public CacheHint parseCacheHint(String sql) {
        if (sql == null || sql.length() == 0) {
            return null;
        }
        return SQLParserUtil.getQueryCacheOption(sql);
    }

    public Criteria parseCriteria(String sql) throws QueryParserException {
        if (sql == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("QueryParser.nullSqlCrit"));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Criteria result = null;
        try {
            result = this.getSqlParser(sql).criteria(dummyInfo);
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            throw this.handleTokenMgrError(tme);
        }
        return result;
    }

    private QueryParserException convertParserException(ParseException pe) {
        QueryParserException qpe = new QueryParserException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31100, new Object[]{QueryParser.getMessage(pe, 1, 10)}));
        qpe.setParseException(pe);
        if (pe.currentToken == null) {
            pe.currentToken = this.parser.token;
        }
        return qpe;
    }

    public static String getMessage(ParseException pe, int maxTokenSequence, int maxExpansions) {
        int i;
        if (!pe.specialConstructor) {
            return pe.getMessage();
        }
        StringBuffer expected = new StringBuffer();
        int[][] expectedTokenSequences = pe.expectedTokenSequences;
        String[] tokenImage = pe.tokenImage;
        String eol = pe.eol;
        Token currentToken = pe.currentToken;
        HashSet expansions = new HashSet();
        Arrays.sort(expectedTokenSequences, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return o2.length - o1.length;
            }
        });
        int maxSize = expectedTokenSequences[0].length;
        StringBuilder retval = new StringBuilder("Encountered \"");
        Token tok = currentToken.next;
        for (i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval.append(" ");
            }
            if (tok.kind == 0) {
                retval.append(tokenImage[0]);
                break;
            }
            retval.append(pe.add_escapes(tok.image));
            tok = tok.next;
        }
        retval.append("\" at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn);
        retval.append("." + eol);
        for (i = 0; i < expectedTokenSequences.length; ++i) {
            int j;
            boolean truncateStart = expectedTokenSequences[i].length == maxSize && maxSize > 1 && maxSize > maxTokenSequence;
            int start = 0;
            if (truncateStart) {
                start = expectedTokenSequences[i].length - maxTokenSequence;
            }
            ArrayList<Integer> expansion = new ArrayList<Integer>(Math.min(maxTokenSequence, expectedTokenSequences[i].length));
            for (j = start; j < start + maxTokenSequence; ++j) {
                expansion.add(expectedTokenSequences[i][j]);
            }
            if (!expansions.add(expansion) || !truncateStart && expectedTokenSequences[i][start] == currentToken.next.kind) continue;
            if (expansions.size() > maxExpansions) {
                expected.append("...").append(eol).append("    ");
                break;
            }
            if (truncateStart) {
                expected.append("... ");
            }
            for (j = start; j < expectedTokenSequences[i].length && j < start + maxTokenSequence; ++j) {
                expected.append(tokenImage[expectedTokenSequences[i][j]]).append(" ");
            }
            if (expectedTokenSequences[i][Math.min(maxTokenSequence, expectedTokenSequences[i].length - 1)] != 0) {
                expected.append("...");
            }
            expected.append(eol).append("    ");
        }
        if (expansions.size() == 1) {
            retval.append("Was expecting:" + eol + "    ");
        } else {
            retval.append("Was expecting one of:" + eol + "    ");
        }
        retval.append(expected.toString());
        return retval.toString();
    }

    public Expression parseExpression(String sql) throws QueryParserException {
        if (sql == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("QueryParser.nullSqlExpr"));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Expression result = null;
        try {
            result = this.getSqlParser(sql).expression(dummyInfo);
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            throw this.handleTokenMgrError(tme);
        }
        return result;
    }

    public Expression parseSelectExpression(String sql) throws QueryParserException {
        if (sql == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("QueryParser.nullSqlExpr"));
        }
        ParseInfo dummyInfo = new ParseInfo();
        Expression result = null;
        try {
            result = this.getSqlParser(sql).selectExpression(dummyInfo);
        }
        catch (ParseException pe) {
            throw this.convertParserException(pe);
        }
        catch (TokenMgrError tme) {
            throw this.handleTokenMgrError(tme);
        }
        return result;
    }

    private QueryParserException handleTokenMgrError(TokenMgrError tme) {
        String msg = tme.getMessage();
        int index = msg.indexOf(LINE_MARKER);
        if (index > 0) {
            index += LINE_MARKER.length();
            int lastIndex = msg.indexOf(",", index);
            if ((index = msg.indexOf(COL_MARKER, lastIndex)) > 0) {
                lastIndex = msg.indexOf(".", index += COL_MARKER.length());
                return new QueryParserException(QueryPlugin.Util.getString("QueryParser.lexicalError", new Object[]{tme.getMessage()}));
            }
        }
        return new QueryParserException(QueryPlugin.Util.getString("QueryParser.parsingError", new Object[]{tme.getMessage()}));
    }

    public void parseDDL(MetadataFactory factory, String ddl) throws ParseException {
        this.parseDDL(factory, new StringReader(ddl));
    }

    public void parseDDL(MetadataFactory factory, Reader ddl) throws ParseException {
        this.getSqlParser(ddl).parseMetadata(factory);
        HashSet<FunctionMethod> functions = new HashSet<FunctionMethod>();
        for (FunctionMethod functionMethod : factory.getSchema().getFunctions().values()) {
            if (functions.add(functionMethod)) continue;
            throw new DuplicateRecordException(DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60015, new Object[]{functionMethod.getName()}));
        }
    }
}

