/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Array
implements Expression {
    private Class<?> baseType;
    private List<Expression> expressions;

    public Array(Class<?> baseType, List<Expression> expresssions) {
        this.baseType = baseType;
        this.expressions = expresssions;
    }

    @Override
    public Class<?> getType() {
        return DataTypeManager.DefaultDataClasses.OBJECT;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Array clone() {
        return new Array(this.baseType, LanguageObject.Util.deepClone(this.getExpressions(), Expression.class));
    }

    public Class<?> getBaseType() {
        return this.baseType;
    }

    public void setBaseType(Class<?> baseType) {
        this.baseType = baseType;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getExpressions()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Array)) {
            return false;
        }
        Array other = (Array)obj;
        return EquivalenceUtil.areEqual(this.baseType, other.baseType) && EquivalenceUtil.areEqual(this.expressions, other.expressions);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

