/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.RequestMessage;
import org.teiid.client.metadata.MetadataResult;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.MetaDataProcessor;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TestDQPCoreRequestHandling;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionService;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestMetaDataProcessor {
    private boolean asLegacyClient;

    @Before
    public void setup() {
        this.asLegacyClient = false;
    }

    public Map[] helpGetMetadata(String sql, QueryMetadataInterface metadata, VDBMetaData vdb) throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        SessionAwareCache prepPlanCache = new SessionAwareCache();
        DQPCore requestMgr = new DQPCore();
        requestMgr.setTransactionService((TransactionService)new FakeTransactionService());
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext(metadata, vdb);
        if (this.asLegacyClient) {
            workContext.setClientVersion(DQPWorkContext.Version.SEVEN_3);
        }
        RequestID requestID = workContext.getRequestID(1L);
        RequestMessage requestMsg = new RequestMessage(sql);
        TestDQPCoreRequestHandling.addRequest(requestMgr, requestMsg, requestID, command, null);
        MetaDataProcessor mdProc = new MetaDataProcessor(requestMgr, prepPlanCache, "MyVDB", 1);
        return mdProc.processMessage(requestID, workContext, null, true).getColumnMetadata();
    }

    @Test
    public void testSimpleQuery() throws Exception {
        Map[] metadata = this.helpGetMetadata("SELECT pm1.g1.e1 FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), RealMetadataFactory.example1VDB());
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)1L, (long)metadata.length);
        Assert.assertEquals((Object)"e1", metadata[0].get(ResultsMetadataConstants.ELEMENT_NAME));
        Assert.assertEquals((Object)"e1", metadata[0].get(ResultsMetadataConstants.ELEMENT_LABEL));
    }

    @Test
    public void testLegacyClient() throws Exception {
        this.asLegacyClient = true;
        Map[] metadata = this.helpGetMetadata("SELECT e1 as e2 FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), RealMetadataFactory.example1VDB());
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)1L, (long)metadata.length);
        Assert.assertEquals((Object)"e2", metadata[0].get(ResultsMetadataConstants.ELEMENT_NAME));
        Assert.assertEquals((Object)"e2", metadata[0].get(ResultsMetadataConstants.ELEMENT_LABEL));
    }

    @Test
    public void testSimpleUpdate() throws Exception {
        Map[] metadata = this.helpGetMetadata("INSERT INTO pm1.g1 (e1) VALUES ('x')", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), RealMetadataFactory.example1VDB());
        Assert.assertNull((Object)metadata);
        metadata = this.helpGetMetadata("DELETE FROM pm1.g1 WHERE e1 = 'x'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), RealMetadataFactory.example1VDB());
        Assert.assertNull((Object)metadata);
        metadata = this.helpGetMetadata("UPDATE pm1.g1 SET e1='y' WHERE e1 = 'x'", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), RealMetadataFactory.example1VDB());
        Assert.assertNull((Object)metadata);
        metadata = this.helpGetMetadata("SELECT e1, e2, e3, e4 INTO pm1.g2 FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), RealMetadataFactory.example1VDB());
        Assert.assertNull((Object)metadata);
    }

    @Test
    public void testElementLabel() throws Exception {
        Map[] metadata = this.helpGetMetadata("SELECT E2 FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), RealMetadataFactory.example1VDB());
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)1L, (long)metadata.length);
        Assert.assertEquals((Object)"e2", metadata[0].get(ResultsMetadataConstants.ELEMENT_NAME));
        Assert.assertEquals((Object)"E2", metadata[0].get(ResultsMetadataConstants.ELEMENT_LABEL));
    }

    @Test
    public void testSimpleExec() throws Exception {
        Map[] metadata = this.helpGetMetadata("EXEC pm1.sq1()", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), RealMetadataFactory.example1VDB());
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)2L, (long)metadata.length);
    }

    @Test
    public void testExecNoResultColumns() throws Exception {
        Map[] metadata = this.helpGetMetadata("EXEC pm1.sp5()", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), RealMetadataFactory.example1VDB());
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)0L, (long)metadata.length);
    }

    private MetadataResult helpTestQuery(QueryMetadataInterface metadata, String sql, VDBMetaData vdb) throws Exception {
        SessionAwareCache prepPlanCache = new SessionAwareCache();
        MetaDataProcessor mdProc = new MetaDataProcessor(new DQPCore(), prepPlanCache, "MyVDB", 1);
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext(metadata, vdb);
        return mdProc.processMessage(workContext.getRequestID(1L), workContext, sql, true);
    }

    private void helpCheckNumericAttributes(MetadataResult message, int column, int expectedSize, int expectedPrecision, int expectedScale) {
        Map[] md = message.getColumnMetadata();
        Assert.assertNotNull((Object)md);
        Assert.assertEquals((Object)new Integer(expectedSize), md[column].get(ResultsMetadataConstants.DISPLAY_SIZE));
        Assert.assertEquals((Object)new Integer(expectedPrecision), md[column].get(ResultsMetadataConstants.PRECISION));
        Assert.assertEquals((Object)new Integer(expectedScale), md[column].get(ResultsMetadataConstants.SCALE));
    }

    @Test
    public void testDefect16629_moneyType() throws Exception {
        TransformationMetadata metadata = TestMetaDataProcessor.examplePrivatePhysicalModel();
        String sql = "SELECT e1 FROM pm1.g2";
        MetadataResult response = this.helpTestQuery((QueryMetadataInterface)metadata, sql, TestMetaDataProcessor.examplePrivatePhysicalModelVDB());
        this.helpCheckNumericAttributes(response, 0, 21, 19, 4);
    }

    @Test
    public void testDefect16629_aggregatesOnMoneyType() throws Exception {
        TransformationMetadata metadata = TestMetaDataProcessor.examplePrivatePhysicalModel();
        String sql = "SELECT min(e1), max(e1), sum(e1), avg(e1) FROM pm1.g2";
        MetadataResult response = this.helpTestQuery((QueryMetadataInterface)metadata, sql, TestMetaDataProcessor.examplePrivatePhysicalModelVDB());
        this.helpCheckNumericAttributes(response, 0, 21, 19, 4);
        this.helpCheckNumericAttributes(response, 1, 21, 19, 4);
        this.helpCheckNumericAttributes(response, 2, 22, 20, 0);
        this.helpCheckNumericAttributes(response, 3, 22, 20, 0);
    }

    @Test
    public void testWindowFunction() throws Exception {
        TransformationMetadata metadata = TestMetaDataProcessor.examplePrivatePhysicalModel();
        String sql = "SELECT min(e1) over () FROM pm1.g2";
        MetadataResult response = this.helpTestQuery((QueryMetadataInterface)metadata, sql, TestMetaDataProcessor.examplePrivatePhysicalModelVDB());
        this.helpCheckNumericAttributes(response, 0, 21, 19, 4);
        Assert.assertEquals((Object)"e1", response.getColumnMetadata()[0].get(ResultsMetadataConstants.ELEMENT_NAME));
        Assert.assertEquals((Object)"expr1", response.getColumnMetadata()[0].get(ResultsMetadataConstants.ELEMENT_LABEL));
    }

    @Test
    public void testMetadataGenerationForAllTypes() throws Exception {
        Set dataTypes = DataTypeManager.getAllDataTypeNames();
        for (String type : dataTypes) {
            Class typeClass = DataTypeManager.getDataTypeClass((String)type);
            MetaDataProcessor processor = new MetaDataProcessor(null, null, "vdb", 1);
            Map columnMetadata = processor.getDefaultColumn("t", "c", typeClass);
            this.verifyColumn(columnMetadata, type);
        }
    }

    private void verifyColumn(Map column, String dataType) {
        this.verifyAttribute(column, ResultsMetadataConstants.AUTO_INCREMENTING, false, Boolean.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.CASE_SENSITIVE, false, Boolean.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.CURRENCY, false, Boolean.class, dataType);
        Object dt = this.verifyAttribute(column, ResultsMetadataConstants.DATA_TYPE, false, String.class, dataType);
        Assert.assertEquals((Object)dataType, (Object)dt);
        this.verifyAttribute(column, ResultsMetadataConstants.DISPLAY_SIZE, false, Integer.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.ELEMENT_LABEL, true, String.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.ELEMENT_NAME, false, String.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.GROUP_NAME, true, String.class, dataType);
        Object nullable = this.verifyAttribute(column, ResultsMetadataConstants.NULLABLE, false, Integer.class, dataType);
        this.verifyNullable((Integer)nullable);
        this.verifyAttribute(column, ResultsMetadataConstants.PRECISION, false, Integer.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.RADIX, false, Integer.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.SCALE, false, Integer.class, dataType);
        Object searchable = this.verifyAttribute(column, ResultsMetadataConstants.SEARCHABLE, false, Integer.class, dataType);
        this.verifySearchable((Integer)searchable);
        this.verifyAttribute(column, ResultsMetadataConstants.SIGNED, false, Boolean.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, false, String.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION, false, Integer.class, dataType);
        this.verifyAttribute(column, ResultsMetadataConstants.WRITABLE, false, Boolean.class, dataType);
    }

    private Object verifyAttribute(Map column, Integer attributeType, boolean nullsAllowed, Class<?> expectedClass, String columnDataType) {
        Object value = column.get(attributeType);
        if (!nullsAllowed) {
            Assert.assertNotNull((String)("Got null when not allowed for column of type " + columnDataType), value);
        }
        if (value != null) {
            Assert.assertEquals((String)("Got attribute of incorrect class for column of type " + columnDataType), expectedClass, value.getClass());
        }
        return value;
    }

    private void verifyNullable(Integer nullable) {
        if (!(nullable.equals(ResultsMetadataConstants.NULL_TYPES.NOT_NULL) || nullable.equals(ResultsMetadataConstants.NULL_TYPES.NULLABLE) || nullable.equals(ResultsMetadataConstants.NULL_TYPES.UNKNOWN))) {
            Assert.fail((String)("Invalid nullable constant value: " + nullable));
        }
    }

    private void verifySearchable(Integer searchable) {
        if (!(searchable.equals(ResultsMetadataConstants.SEARCH_TYPES.ALLEXCEPTLIKE) || searchable.equals(ResultsMetadataConstants.SEARCH_TYPES.LIKE_ONLY) || searchable.equals(ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE) || searchable.equals(ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE))) {
            Assert.fail((String)("Invalid searchable constant value: " + searchable));
        }
    }

    public static TransformationMetadata examplePrivatePhysicalModel() {
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("g1", pm1);
        QueryNode vm1g1n1 = new QueryNode("SELECT * FROM pm1.g1");
        Table vm1g1 = RealMetadataFactory.createVirtualGroup("g1", vm1, vm1g1n1);
        Table pm1g2 = RealMetadataFactory.createPhysicalGroup("g2", pm1);
        RealMetadataFactory.createElements(pm1g1, new String[]{"e1"}, new String[]{"short"});
        List<Column> pm1g2e = RealMetadataFactory.createElements(pm1g2, new String[]{"e1"}, new String[]{"bigdecimal"});
        Column e1 = pm1g2e.get(0);
        e1.setPrecision(19);
        e1.setLength(21);
        e1.setScale(4);
        RealMetadataFactory.createElements(vm1g1, new String[]{"e1"}, new String[]{"string"});
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example", new FunctionTree[0]);
    }

    public static VDBMetaData examplePrivatePhysicalModelVDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("example1");
        vdb.setVersion(1);
        ModelMetaData m = RealMetadataFactory.createModel("pm1", true);
        m.setVisible(Boolean.valueOf(false));
        vdb.addModel(m);
        vdb.addModel(RealMetadataFactory.createModel("vm1", false));
        return vdb;
    }
}

