/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestMultiSourceMetadataWrapper {
    @Test
    public void testMultiSourcePseudoElement() throws Exception {
        HashSet<String> multiSourceModels = new HashSet<String>();
        multiSourceModels.add("BQT1");
        MultiSourceMetadataWrapper wrapper = new MultiSourceMetadataWrapper((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), multiSourceModels);
        Object groupID = wrapper.getGroupID("BQT1.SmallA");
        List elements = wrapper.getElementIDsInGroupID(groupID);
        Assert.assertEquals((long)18L, (long)elements.size());
        Object instanceElementID = elements.get(elements.size() - 1);
        Assert.assertTrue((boolean)(instanceElementID instanceof MultiSourceElement));
        String fullName = wrapper.getFullName(instanceElementID);
        Assert.assertEquals((Object)"BQT1.SmallA.SOURCE_NAME", (Object)fullName);
        Assert.assertEquals(instanceElementID, (Object)wrapper.getElementID(fullName));
        Assert.assertEquals((Object)groupID, (Object)wrapper.getGroupIDForElementID(instanceElementID));
        Assert.assertEquals(null, (Object)wrapper.getMaximumValue(instanceElementID));
        Assert.assertEquals(null, (Object)wrapper.getMinimumValue(instanceElementID));
        Assert.assertEquals((Object)wrapper.getModelID(groupID), (Object)wrapper.getModelID(instanceElementID));
        Assert.assertEquals(null, (Object)wrapper.getDefaultValue(instanceElementID));
        Assert.assertEquals((long)255L, (long)wrapper.getElementLength(instanceElementID));
        Assert.assertEquals((Object)"string", (Object)wrapper.getElementType(instanceElementID));
        Assert.assertEquals((Object)new Properties(), (Object)wrapper.getExtensionProperties(instanceElementID));
        Assert.assertEquals(null, (Object)wrapper.getNameInSource(instanceElementID));
        Assert.assertEquals(null, (Object)wrapper.getNativeType(instanceElementID));
        Assert.assertEquals((long)18L, (long)wrapper.getPosition(instanceElementID));
        Assert.assertEquals((long)0L, (long)wrapper.getPrecision(instanceElementID));
        Assert.assertEquals((long)0L, (long)wrapper.getScale(instanceElementID));
        Assert.assertEquals((long)0L, (long)wrapper.getRadix(instanceElementID));
        Assert.assertEquals((Object)"SOURCE_NAME", (Object)Symbol.getShortName((String)fullName));
        Assert.assertEquals((Object)fullName, (Object)(wrapper.getFullName(groupID) + "." + "SOURCE_NAME"));
        TempMetadataAdapter tma = new TempMetadataAdapter((QueryMetadataInterface)wrapper, new TempMetadataStore());
        ElementSymbol elementSymbol = new ElementSymbol("y");
        elementSymbol.setType(DataTypeManager.DefaultDataClasses.STRING);
        TempMetadataID id = tma.getMetadataStore().addTempGroup("x", Arrays.asList(elementSymbol));
        Assert.assertFalse((boolean)tma.isMultiSourceElement(id.getElements().get(0)));
        Assert.assertTrue((boolean)tma.isMultiSourceElement(instanceElementID));
    }
}

