/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.metadata;

import junit.framework.TestCase;
import org.teiid.api.exception.query.FunctionMetadataException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionMetadataValidator;

public class TestFunctionMetadataValidator
extends TestCase {
    public TestFunctionMetadataValidator(String name) {
        super(name);
    }

    public void helpTestValidateName(String name) {
        try {
            FunctionMetadataValidator.validateName((String)name);
        }
        catch (FunctionMetadataException e) {
            TestFunctionMetadataValidator.fail((String)("Got exception but did not expect it: " + e.getMessage()));
        }
    }

    public void helpTestValidateNameFail(String name) {
        try {
            FunctionMetadataValidator.validateName((String)name);
            TestFunctionMetadataValidator.fail((String)"Expected exception but did not get one");
        }
        catch (FunctionMetadataException functionMetadataException) {
            // empty catch block
        }
    }

    public void helpTestValidateFunction(String className, String methodName, FunctionMethod.PushDown pushdown) {
        try {
            FunctionMetadataValidator.validateInvocationMethod((String)className, (String)methodName, (FunctionMethod.PushDown)pushdown);
        }
        catch (FunctionMetadataException e) {
            TestFunctionMetadataValidator.fail((String)("Got exception but did not expect it: " + e.getMessage()));
        }
    }

    public void helpTestValidateFunctionFail(String className, String methodName, FunctionMethod.PushDown pushdown) {
        try {
            FunctionMetadataValidator.validateInvocationMethod((String)className, (String)methodName, (FunctionMethod.PushDown)pushdown);
            TestFunctionMetadataValidator.fail((String)"Expected exception but did not get one");
        }
        catch (FunctionMetadataException e) {
            // empty catch block
        }
    }

    public void testValidateName1() {
        this.helpTestValidateName("abc");
    }

    public void testValidateName2() {
        this.helpTestValidateName("a13");
    }

    public void testValidateName3() {
        this.helpTestValidateName("a_c");
    }

    public void testValidateName4() {
        this.helpTestValidateName("a");
    }

    public void testValidateNameFail1() {
        this.helpTestValidateNameFail(null);
    }

    public void testValidateNameFail3() {
        this.helpTestValidateNameFail("a.b");
    }

    public void testValidateFunction1() {
        this.helpTestValidateFunction("a", "b", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunction2() {
        this.helpTestValidateFunction("a.b", "b", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunction3() {
        this.helpTestValidateFunction("a.b.c", "b", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunction4() {
        this.helpTestValidateFunction("a$1", "b", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunction5() {
        this.helpTestValidateFunction(null, null, FunctionMethod.PushDown.MUST_PUSHDOWN);
    }

    public void testValidateFunctionFail1() {
        this.helpTestValidateFunctionFail(null, null, FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunctionFail2() {
        this.helpTestValidateFunctionFail(null, "a", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunctionFail3() {
        this.helpTestValidateFunctionFail("a", null, FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunctionFail4() {
        this.helpTestValidateFunctionFail("1", "b", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunctionFail5() {
        this.helpTestValidateFunctionFail("a", "2", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunctionFail6() {
        this.helpTestValidateFunctionFail("a@(", "b", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunctionFail7() {
        this.helpTestValidateFunctionFail("a.b.", "b", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunctionFail8() {
        this.helpTestValidateFunctionFail("a", "b.c", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunctionFail9() {
        this.helpTestValidateFunctionFail("a", "b@", FunctionMethod.PushDown.CAN_PUSHDOWN);
    }

    public void testValidateFunctionFail10() {
        this.helpTestValidateFunctionFail(null, null, FunctionMethod.PushDown.CAN_PUSHDOWN);
        this.helpTestValidateFunctionFail(null, null, FunctionMethod.PushDown.CANNOT_PUSHDOWN);
    }
}

