/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.TestDDLParser;

public class TestDDLStringVisitor {
    @Test
    public void testForeignTable() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1 (\n\te1 integer PRIMARY KEY,\n\te2 string(10) UNIQUE,\n\te3 date NOT NULL UNIQUE,\n\te4 bigdecimal(12,3),\n\te5 integer AUTO_INCREMENT INDEX OPTIONS (UUID 'uuid', NAMEINSOURCE 'nis', SELECTABLE false),\n\te6 string INDEX DEFAULT 'hello'\n) OPTIONS (ANNOTATION 'Test Table', CARDINALITY '12', FOO 'BAR', UPDATABLE 'true', UUID 'uuid2');";
        MetadataFactory mf = new MetadataFactory("test", 1, "model", TestDDLParser.getDataTypes(), new Properties(), null);
        Table table = mf.addTable("G1");
        table.setVirtual(false);
        mf.addColumn("e1", "integer", (ColumnSet)table);
        Column e2 = mf.addColumn("e2", "varchar", (ColumnSet)table);
        e2.setLength(10);
        Column e3 = mf.addColumn("e3", "date", (ColumnSet)table);
        e3.setNullType(BaseColumn.NullType.No_Nulls);
        Column e4 = mf.addColumn("e4", "decimal", (ColumnSet)table);
        e4.setPrecision(12);
        e4.setScale(3);
        Column e5 = mf.addColumn("e5", "integer", (ColumnSet)table);
        e5.setAutoIncremented(true);
        e5.setUUID("uuid");
        e5.setNameInSource("nis");
        e5.setSelectable(false);
        Column e6 = mf.addColumn("e6", "varchar", (ColumnSet)table);
        e6.setDefaultValue("hello");
        mf.addPrimaryKey("PK", Arrays.asList("e1"), table);
        mf.addIndex("UK", false, Arrays.asList("e2"), table);
        mf.addIndex("UK2", false, Arrays.asList("e3"), table);
        mf.addIndex("IDX", true, Arrays.asList("e5"), table);
        mf.addIndex("IDX2", true, Arrays.asList("e6"), table);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("CARDINALITY", "12");
        options.put("UUID", "uuid2");
        options.put("UPDATABLE", "true");
        options.put("FOO", "BAR");
        options.put("ANNOTATION", "Test Table");
        table.setProperties(options);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        Assert.assertEquals((Object)ddl, (Object)metadataDDL);
    }

    @Test
    public void testMultiKeyPK() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date CONSTRAINT PRIMARY KEY (e1, e2))";
        String expected = "CREATE FOREIGN TABLE G1 (\n\te1 integer,\n\te2 string,\n\te3 date\n\tCONSTRAINT PRIMARY KEY(e1, e2)\n);";
        this.helpTest(ddl, expected);
    }

    @Test
    public void testConstraints2() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date CONSTRAINT ACCESSPATTERN(e1), UNIQUE(e1), ACCESSPATTERN(e2, e3))";
        String expected = "CREATE FOREIGN TABLE G1 (\n\te1 integer UNIQUE,\n\te2 string,\n\te3 date\n\tCONSTRAINT ACCESSPATTERN(e1), ACCESSPATTERN(e2, e3)\n);";
        this.helpTest(ddl, expected);
    }

    @Test
    public void testFK() throws Exception {
        String ddl = "CREATE FOREIGN TABLE G1(\"g1-e1\" integer, g1e2 varchar CONSTRAINT PRIMARY KEY(\"g1-e1\", g1e2));\nCREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar CONSTRAINT FOREIGN KEY (g2e1, g2e2) REFERENCES G1 (g1e1, g1e2))";
        String expected = "CREATE FOREIGN TABLE G1 (\n\t\"g1-e1\" integer,\n\tg1e2 string\n\tCONSTRAINT PRIMARY KEY(\"g1-e1\", g1e2)\n);\n\nCREATE FOREIGN TABLE G2 (\n\tg2e1 integer,\n\tg2e2 string\n\tCONSTRAINT FOREIGN KEY(g2e1, g2e2) REFERENCES G1 (g1e1, g1e2)\n);";
        this.helpTest(ddl, expected);
    }

    @Test
    public void testOptionalFK() throws Exception {
        String ddl = "CREATE FOREIGN TABLE \"G1+\"(g1e1 integer, g1e2 varchar CONSTRAINT PRIMARY KEY(g1e1, g1e2));\nCREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar CONSTRAINT PRIMARY KEY(g2e1, g2e2),FOREIGN KEY (g2e1, g2e2) REFERENCES G1)";
        String expected = "CREATE FOREIGN TABLE \"G1+\" (\n\tg1e1 integer,\n\tg1e2 string\n\tCONSTRAINT PRIMARY KEY(g1e1, g1e2)\n);\n\nCREATE FOREIGN TABLE G2 (\n\tg2e1 integer,\n\tg2e2 string\n\tCONSTRAINT PRIMARY KEY(g2e1, g2e2), FOREIGN KEY(g2e1, g2e2) REFERENCES G1 \n);";
        this.helpTest(ddl, expected);
    }

    @Test
    public void testMultipleCommands() throws Exception {
        String ddl = "CREATE VIEW V1 AS SELECT * FROM PM1.G1 CREATE PROCEDURE FOO(P1 integer) RETURNS (e1 integer, e2 varchar) AS SELECT * FROM PM1.G1;";
        String expected = "CREATE VIEW V1\nAS\nSELECT * FROM PM1.G1;\n\nCREATE VIRTUAL PROCEDURE FOO(IN P1 integer) RETURNS TABLE (e1 integer, e2 string)\nAS\nSELECT * FROM PM1.G1;";
        this.helpTest(ddl, expected);
    }

    @Test
    public void testView() throws Exception {
        String ddl = "CREATE View G1( e1 integer, e2 varchar) OPTIONS (CARDINALITY 12) AS select e1, e2 from foo.bar";
        String expected = "CREATE VIEW G1 (\n\te1 integer,\n\te2 string\n) OPTIONS (CARDINALITY 12)\nAS\nSELECT e1, e2 FROM foo.bar;";
        this.helpTest(ddl, expected);
    }

    @Test
    public void testInsteadOfTrigger() throws Exception {
        String ddl = "CREATE VIEW G1( e1 integer, e2 varchar) AS select * from foo;CREATE TRIGGER ON G1 INSTEAD OF INSERT AS FOR EACH ROW \nBEGIN ATOMIC \ninsert into g1 (e1, e2) values (1, 'trig');\nEND;";
        String expected = "CREATE VIEW G1 (\n\te1 integer,\n\te2 string\n)\nAS\nSELECT * FROM foo;\n\nCREATE TRIGGER ON G1 INSTEAD OF INSERT AS\nFOR EACH ROW\nBEGIN ATOMIC\nINSERT INTO g1 (e1, e2) VALUES (1, 'trig');\nEND;";
        this.helpTest(ddl, expected);
    }

    @Test
    public void testSourceProcedure() throws Exception {
        String ddl = "CREATE FOREIGN PROCEDURE myProc(OUT p1 boolean, p2 varchar, INOUT p3 decimal) RETURNS (r1 varchar, r2 decimal)OPTIONS(RANDOM 'any', UUID 'uuid', NAMEINSOURCE 'nis', ANNOTATION 'desc', UPDATECOUNT '2');";
        String expected = "CREATE FOREIGN PROCEDURE myProc(OUT p1 boolean, IN p2 string, INOUT p3 bigdecimal) RETURNS TABLE (r1 string, r2 bigdecimal)\nOPTIONS (UUID 'uuid', ANNOTATION 'desc', NAMEINSOURCE 'nis', UPDATECOUNT 2, RANDOM 'any')";
        this.helpTest(ddl, expected);
    }

    @Test
    public void testPushdownFunctionNoArgs() throws Exception {
        String ddl = "CREATE FOREIGN FUNCTION SourceFunc() RETURNS integer OPTIONS (UUID 'hello world')";
        String expected = "CREATE FOREIGN FUNCTION SourceFunc() RETURNS integer\nOPTIONS (UUID 'hello world');";
        this.helpTest(ddl, expected);
    }

    @Test
    public void testNonPushdownFunction() throws Exception {
        String ddl = "CREATE FUNCTION SourceFunc(p1 integer, p2 varchar) RETURNS integer OPTIONS (JAVA_CLASS 'foo', JAVA_MEHTOD 'bar')";
        String expected = "CREATE VIRTUAL FUNCTION SourceFunc(p1 integer, p2 string) RETURNS integer\nOPTIONS (JAVA_CLASS 'foo', JAVA_MEHTOD 'bar');";
        this.helpTest(ddl, expected);
    }

    private void helpTest(String ddl, String expected) throws ParseException {
        Schema s = TestDDLParser.helpParse(ddl, "model").getSchema();
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)s, null, null);
        Assert.assertEquals((Object)expected, (Object)metadataDDL);
    }
}

