/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.core.TeiidException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.SortSpecification;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.parser.SQLParser;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BranchingStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseErrorStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TestCaseExpression;
import org.teiid.query.sql.symbol.TestSearchedCaseExpression;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.util.SymbolMap;

public class TestParser {
    static void helpTest(String sql, String expectedString, Command expectedCommand) {
        TestParser.helpTest(sql, expectedString, expectedCommand, new ParseInfo());
    }

    static void helpTest(String sql, String expectedString, Command expectedCommand, ParseInfo info) {
        Command actualCommand = null;
        String actualString = null;
        try {
            actualCommand = QueryParser.getQueryParser().parseCommand(sql, info);
            actualString = actualCommand.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((String)"Parse string does not match: ", (Object)expectedString, (Object)actualString);
        Assert.assertEquals((String)"Command objects do not match: ", (Object)expectedCommand, (Object)actualCommand);
        Assert.assertEquals((String)"Cloned command objects do not match: ", (Object)expectedCommand, (Object)actualCommand.clone());
    }

    static void helpTestExpression(String sql, String expectedString, Expression expected) throws QueryParserException {
        Expression actual = QueryParser.getQueryParser().parseExpression(sql);
        String actualString = actual.toString();
        Assert.assertEquals((String)"Parse string does not match: ", (Object)expectedString, (Object)actualString);
        Assert.assertEquals((String)"Command objects do not match: ", (Object)expected, (Object)actual);
        Assert.assertEquals((String)"Cloned command objects do not match: ", (Object)expected, (Object)actual.clone());
    }

    static void helpException(String sql) {
        TestParser.helpException(sql, null);
    }

    static void helpException(String sql, String expected) {
        block2: {
            try {
                QueryParser.getQueryParser().parseCommand(sql);
                Assert.fail((String)("Expected exception for parsing " + sql));
            }
            catch (TeiidException e) {
                if (expected == null) break block2;
                Assert.assertEquals((Object)expected, (Object)e.getMessage());
            }
        }
    }

    private void helpBlockTest(String block, String expectedString, Block expectedBlock) throws ParseException {
        Block actualBlock = SQLParserUtil.asBlock((Statement)new SQLParser((Reader)new StringReader(block)).statement(new ParseInfo()));
        String actualString = actualBlock.toString();
        Assert.assertEquals((String)"Parse string does not match: ", (Object)expectedString, (Object)actualString);
        Assert.assertEquals((String)"Block does not match: ", (Object)expectedBlock, (Object)actualBlock);
    }

    private void helpStmtTest(String stmt, String expectedString, Statement expectedStmt) throws ParseException {
        Statement actualStmt = new SQLParser((Reader)new StringReader(stmt)).statement(new ParseInfo());
        String actualString = actualStmt.toString();
        Assert.assertEquals((String)"Parse string does not match: ", (Object)expectedString, (Object)actualString);
        Assert.assertEquals((String)"Language objects do not match: ", (Object)expectedStmt, (Object)actualStmt);
    }

    @Test
    public void testInnerJoin() {
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("g1"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("g2"));
        CompareCriteria jcrit = new CompareCriteria((Expression)new ElementSymbol("g1.a1"), 1, (Expression)new ElementSymbol("g2.a2"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(jcrit);
        JoinPredicate jp = new JoinPredicate((FromClause)g1, (FromClause)g2, JoinType.JOIN_INNER, crits);
        From from = new From();
        from.addClause((FromClause)jp);
        MultipleElementSymbol all = new MultipleElementSymbol();
        Select select = new Select();
        select.addSymbol((Expression)all);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM g1 inner join g2 on g1.a1=g2.a2", "SELECT * FROM g1 INNER JOIN g2 ON g1.a1 = g2.a2", (Command)query);
    }

    @Test
    public void testCrossJoin() {
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("g1"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("g2"));
        JoinPredicate jp = new JoinPredicate((FromClause)g1, (FromClause)g2, JoinType.JOIN_CROSS);
        From from = new From();
        from.addClause((FromClause)jp);
        MultipleElementSymbol all = new MultipleElementSymbol();
        Select select = new Select();
        select.addSymbol((Expression)all);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM g1 cross join g2", "SELECT * FROM g1 CROSS JOIN g2", (Command)query);
    }

    @Test
    public void testFromClauses() {
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("g1"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("g2"));
        JoinPredicate jp = new JoinPredicate((FromClause)g1, (FromClause)g2, JoinType.JOIN_CROSS);
        From from = new From();
        from.addClause((FromClause)jp);
        from.addClause((FromClause)new UnaryFromClause(new GroupSymbol("g3")));
        MultipleElementSymbol all = new MultipleElementSymbol();
        Select select = new Select();
        select.addSymbol((Expression)all);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM (g1 cross join g2), g3", "SELECT * FROM g1 CROSS JOIN g2, g3", (Command)query);
    }

    @Test
    public void testInvalidInnerJoin() {
        TestParser.helpException("SELECT * FROM g1 inner join g2");
    }

    @Test
    public void testMultiCrossJoin() {
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("g1"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("g2"));
        JoinPredicate jp = new JoinPredicate((FromClause)g1, (FromClause)g2, JoinType.JOIN_CROSS);
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp, (FromClause)new UnaryFromClause(new GroupSymbol("g3")), JoinType.JOIN_CROSS);
        From from = new From();
        from.addClause((FromClause)jp2);
        MultipleElementSymbol all = new MultipleElementSymbol();
        Select select = new Select();
        select.addSymbol((Expression)all);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM (g1 cross join g2) cross join g3", "SELECT * FROM (g1 CROSS JOIN g2) CROSS JOIN g3", (Command)query);
    }

    @Test
    public void testMultiCrossJoin2() {
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("g1"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("g2"));
        JoinPredicate jp = new JoinPredicate((FromClause)g1, (FromClause)g2, JoinType.JOIN_CROSS);
        UnaryFromClause g3 = new UnaryFromClause(new GroupSymbol("g3"));
        UnaryFromClause g4 = new UnaryFromClause(new GroupSymbol("g4"));
        JoinPredicate jp2 = new JoinPredicate((FromClause)g3, (FromClause)g4, JoinType.JOIN_CROSS);
        JoinPredicate jp3 = new JoinPredicate((FromClause)jp, (FromClause)jp2, JoinType.JOIN_CROSS);
        From from = new From();
        from.addClause((FromClause)jp3);
        MultipleElementSymbol all = new MultipleElementSymbol();
        Select select = new Select();
        select.addSymbol((Expression)all);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM (g1 cross join g2) cross join (g3 cross join g4)", "SELECT * FROM (g1 CROSS JOIN g2) CROSS JOIN (g3 CROSS JOIN g4)", (Command)query);
    }

    @Test
    public void testMultiCrossJoin3() {
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("g1"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("g2"));
        UnaryFromClause g3 = new UnaryFromClause(new GroupSymbol("g3"));
        JoinPredicate jp = new JoinPredicate((FromClause)g2, (FromClause)g3, JoinType.JOIN_CROSS);
        JoinPredicate jp2 = new JoinPredicate((FromClause)g1, (FromClause)jp, JoinType.JOIN_CROSS);
        From from = new From();
        from.addClause((FromClause)jp2);
        MultipleElementSymbol all = new MultipleElementSymbol();
        Select select = new Select();
        select.addSymbol((Expression)all);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM g1 cross join (g2 cross join g3)", "SELECT * FROM g1 CROSS JOIN (g2 CROSS JOIN g3)", (Command)query);
    }

    @Test
    public void testMixedJoin() {
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("g1"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("g2"));
        UnaryFromClause g3 = new UnaryFromClause(new GroupSymbol("g3"));
        JoinPredicate jp = new JoinPredicate((FromClause)g2, (FromClause)g3, JoinType.JOIN_CROSS);
        JoinPredicate jp2 = new JoinPredicate((FromClause)g1, (FromClause)jp, JoinType.JOIN_CROSS);
        From from = new From();
        from.addClause((FromClause)jp2);
        from.addClause((FromClause)new UnaryFromClause(new GroupSymbol("g4")));
        MultipleElementSymbol all = new MultipleElementSymbol();
        Select select = new Select();
        select.addSymbol((Expression)all);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM g1 cross join (g2 cross join g3), g4", "SELECT * FROM g1 CROSS JOIN (g2 CROSS JOIN g3), g4", (Command)query);
    }

    @Test
    public void testMixedJoin2() {
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("g1"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("g2"));
        UnaryFromClause g3 = new UnaryFromClause(new GroupSymbol("g3"));
        UnaryFromClause g4 = new UnaryFromClause(new GroupSymbol("g4"));
        UnaryFromClause g5 = new UnaryFromClause(new GroupSymbol("g5"));
        UnaryFromClause g6 = new UnaryFromClause(new GroupSymbol("g6"));
        JoinPredicate jp = new JoinPredicate((FromClause)g2, (FromClause)g3, JoinType.JOIN_CROSS);
        JoinPredicate jp2 = new JoinPredicate((FromClause)g1, (FromClause)jp, JoinType.JOIN_CROSS);
        JoinPredicate jp3 = new JoinPredicate((FromClause)g5, (FromClause)g6, JoinType.JOIN_CROSS);
        From from = new From();
        from.addClause((FromClause)jp2);
        from.addClause((FromClause)g4);
        from.addClause((FromClause)jp3);
        MultipleElementSymbol all = new MultipleElementSymbol();
        Select select = new Select();
        select.addSymbol((Expression)all);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM g1 cross join (g2 cross join g3), g4, g5 cross join g6", "SELECT * FROM g1 CROSS JOIN (g2 CROSS JOIN g3), g4, g5 CROSS JOIN g6", (Command)query);
    }

    @Test
    public void testMixedJoin3() {
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("g1"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("g2"));
        UnaryFromClause g3 = new UnaryFromClause(new GroupSymbol("g3"));
        CompareCriteria jcrit = new CompareCriteria((Expression)new ElementSymbol("g2.a"), 1, (Expression)new ElementSymbol("g3.a"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(jcrit);
        JoinPredicate jp = new JoinPredicate((FromClause)g2, (FromClause)g3, JoinType.JOIN_INNER, crits);
        From from = new From();
        from.addClause((FromClause)g1);
        from.addClause((FromClause)jp);
        MultipleElementSymbol all = new MultipleElementSymbol();
        Select select = new Select();
        select.addSymbol((Expression)all);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM g1, g2 inner join g3 on g2.a=g3.a", "SELECT * FROM g1, g2 INNER JOIN g3 ON g2.a = g3.a", (Command)query);
    }

    @Test
    public void testRightOuterJoinWithAliases() {
        UnaryFromClause g = new UnaryFromClause(new GroupSymbol("myG", "g"));
        UnaryFromClause h = new UnaryFromClause(new GroupSymbol("myH", "h"));
        CompareCriteria jcrit = new CompareCriteria((Expression)new ElementSymbol("myG.x"), 1, (Expression)new ElementSymbol("myH.x"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(jcrit);
        JoinPredicate jp = new JoinPredicate((FromClause)g, (FromClause)h, JoinType.JOIN_RIGHT_OUTER, crits);
        From from = new From();
        from.addClause((FromClause)jp);
        AliasSymbol as = new AliasSymbol("myA", (Expression)new ElementSymbol("myG.a"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        select.addSymbol((Expression)new ElementSymbol("myH.b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select myG.a myA, myH.b from g myG right outer join h myH on myG.x=myH.x", "SELECT myG.a AS myA, myH.b FROM g AS myG RIGHT OUTER JOIN h AS myH ON myG.x = myH.x", (Command)query);
    }

    @Test
    public void testRightJoinWithAliases() {
        UnaryFromClause g = new UnaryFromClause(new GroupSymbol("myG", "g"));
        UnaryFromClause h = new UnaryFromClause(new GroupSymbol("myH", "h"));
        CompareCriteria jcrit = new CompareCriteria((Expression)new ElementSymbol("myG.x"), 1, (Expression)new ElementSymbol("myH.x"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(jcrit);
        JoinPredicate jp = new JoinPredicate((FromClause)g, (FromClause)h, JoinType.JOIN_RIGHT_OUTER, crits);
        From from = new From();
        from.addClause((FromClause)jp);
        AliasSymbol as = new AliasSymbol("myA", (Expression)new ElementSymbol("myG.a"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        select.addSymbol((Expression)new ElementSymbol("myH.b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select myG.a myA, myH.b from g myG right join h myH on myG.x=myH.x", "SELECT myG.a AS myA, myH.b FROM g AS myG RIGHT OUTER JOIN h AS myH ON myG.x = myH.x", (Command)query);
    }

    @Test
    public void testLeftOuterJoinWithAliases() {
        UnaryFromClause g = new UnaryFromClause(new GroupSymbol("myG", "g"));
        UnaryFromClause h = new UnaryFromClause(new GroupSymbol("myH", "h"));
        CompareCriteria jcrit = new CompareCriteria((Expression)new ElementSymbol("myG.x"), 1, (Expression)new ElementSymbol("myH.x"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(jcrit);
        JoinPredicate jp = new JoinPredicate((FromClause)g, (FromClause)h, JoinType.JOIN_LEFT_OUTER, crits);
        From from = new From();
        from.addClause((FromClause)jp);
        AliasSymbol as = new AliasSymbol("myA", (Expression)new ElementSymbol("myG.a"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        select.addSymbol((Expression)new ElementSymbol("myH.b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select myG.a myA, myH.b from g myG left outer join h myH on myG.x=myH.x", "SELECT myG.a AS myA, myH.b FROM g AS myG LEFT OUTER JOIN h AS myH ON myG.x = myH.x", (Command)query);
    }

    @Test
    public void testLeftJoinWithAliases() {
        UnaryFromClause g = new UnaryFromClause(new GroupSymbol("myG", "g"));
        UnaryFromClause h = new UnaryFromClause(new GroupSymbol("myH", "h"));
        CompareCriteria jcrit = new CompareCriteria((Expression)new ElementSymbol("myG.x"), 1, (Expression)new ElementSymbol("myH.x"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(jcrit);
        JoinPredicate jp = new JoinPredicate((FromClause)g, (FromClause)h, JoinType.JOIN_LEFT_OUTER, crits);
        From from = new From();
        from.addClause((FromClause)jp);
        AliasSymbol as = new AliasSymbol("myA", (Expression)new ElementSymbol("myG.a"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        select.addSymbol((Expression)new ElementSymbol("myH.b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select myG.a myA, myH.b from g myG left join h myH on myG.x=myH.x", "SELECT myG.a AS myA, myH.b FROM g AS myG LEFT OUTER JOIN h AS myH ON myG.x = myH.x", (Command)query);
    }

    @Test
    public void testFullOuterJoinWithAliases() {
        UnaryFromClause g = new UnaryFromClause(new GroupSymbol("myG", "g"));
        UnaryFromClause h = new UnaryFromClause(new GroupSymbol("myH", "h"));
        CompareCriteria jcrit = new CompareCriteria((Expression)new ElementSymbol("myG.x"), 1, (Expression)new ElementSymbol("myH.x"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(jcrit);
        JoinPredicate jp = new JoinPredicate((FromClause)g, (FromClause)h, JoinType.JOIN_FULL_OUTER, crits);
        From from = new From();
        from.addClause((FromClause)jp);
        AliasSymbol as = new AliasSymbol("myA", (Expression)new ElementSymbol("myG.a"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        select.addSymbol((Expression)new ElementSymbol("myH.b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select myG.a myA, myH.b from g myG full outer join h myH on myG.x=myH.x", "SELECT myG.a AS myA, myH.b FROM g AS myG FULL OUTER JOIN h AS myH ON myG.x = myH.x", (Command)query);
    }

    @Test
    public void testFullJoin() {
        UnaryFromClause g = new UnaryFromClause(new GroupSymbol("g"));
        UnaryFromClause h = new UnaryFromClause(new GroupSymbol("h"));
        CompareCriteria jcrit = new CompareCriteria((Expression)new ElementSymbol("g.x"), 1, (Expression)new ElementSymbol("h.x"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(jcrit);
        JoinPredicate jp = new JoinPredicate((FromClause)g, (FromClause)h, JoinType.JOIN_FULL_OUTER, crits);
        From from = new From();
        from.addClause((FromClause)jp);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("g.a"));
        select.addSymbol((Expression)new ElementSymbol("h.b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select g.a, h.b from g full join h on g.x=h.x", "SELECT g.a, h.b FROM g FULL OUTER JOIN h ON g.x = h.x", (Command)query);
    }

    @Test
    public void testConversionFunction() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("CONVERT", new Expression[]{new ElementSymbol("a", false), new Constant((Object)"string")});
        Select select = new Select();
        select.addSymbol((Expression)f);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT CONVERT(a, string) FROM g", "SELECT CONVERT(a, string) FROM g", (Command)query);
    }

    @Test
    public void testConversionFunction2() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("CONVERT", new Expression[]{new ElementSymbol("a", false), new Constant((Object)"timestamp")});
        Function f2 = new Function("CONVERT", new Expression[]{f, new Constant((Object)"string")});
        Select select = new Select();
        select.addSymbol((Expression)f2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT CONVERT(CONVERT(a, timestamp), string) FROM g", "SELECT CONVERT(CONVERT(a, timestamp), string) FROM g", (Command)query);
    }

    @Test
    public void testMultiFunction() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("concat", new Expression[]{new ElementSymbol("a", false), new Constant((Object)"x")});
        Function f2 = new Function("length", new Expression[]{f});
        Function f3 = new Function("+", new Expression[]{new Constant((Object)new Integer(5)), f2});
        Select select = new Select();
        select.addSymbol((Expression)f3);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 5 + length(concat(a, 'x')) FROM g", "SELECT (5 + length(concat(a, 'x'))) FROM g", (Command)query);
    }

    @Test
    public void testSignedExpression() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("*", new Expression[]{new Constant((Object)-1), new ElementSymbol("x")});
        Select select = new Select();
        select.addSymbol((Expression)f);
        select.addSymbol((Expression)new ElementSymbol("x"));
        select.addSymbol((Expression)new Constant((Object)5));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT -x, +x, +5 FROM g", "SELECT (-1 * x), x, 5 FROM g", (Command)query);
    }

    @Test
    public void testAliasedFunction() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("replace", new Expression[]{new ElementSymbol("a", false), new Constant((Object)"x"), new Constant((Object)"y")});
        AliasSymbol as = new AliasSymbol("y", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT REPLACE(a, 'x', 'y') AS y FROM g", "SELECT REPLACE(a, 'x', 'y') AS y FROM g", (Command)query);
    }

    @Test
    public void testCastFunction() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("cast", new Expression[]{new ElementSymbol("a", false), new Constant((Object)"string")});
        Select select = new Select();
        select.addSymbol((Expression)f);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT cast(a as string) FROM g", "SELECT cast(a AS string) FROM g", (Command)query);
    }

    @Test
    public void testMultiCastFunction() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("cast", new Expression[]{new ElementSymbol("a", false), new Constant((Object)"timestamp")});
        Function f2 = new Function("cast", new Expression[]{f, new Constant((Object)"string")});
        Select select = new Select();
        select.addSymbol((Expression)f2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT cast(cast(a as timestamp) as string) FROM g", "SELECT cast(cast(a AS timestamp) AS string) FROM g", (Command)query);
    }

    @Test
    public void testLeftFunction() {
        GroupSymbol g = new GroupSymbol("sys.groups");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("left", new Expression[]{new ElementSymbol("fullname", false), new Constant((Object)new Integer(3))});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT left(fullname, 3) as x FROM sys.groups", "SELECT left(fullname, 3) AS x FROM sys.groups", (Command)query);
    }

    @Test
    public void testRightFunction() {
        GroupSymbol g = new GroupSymbol("sys.groups");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("right", new Expression[]{new ElementSymbol("fullname", false), new Constant((Object)new Integer(3))});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT right(fullname, 3) as x FROM sys.groups", "SELECT right(fullname, 3) AS x FROM sys.groups", (Command)query);
    }

    @Test
    public void testCharFunction() {
        GroupSymbol g = new GroupSymbol("sys.groups");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("char", new Expression[]{new Constant((Object)"x")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT char('x') AS x FROM sys.groups", "SELECT char('x') AS x FROM sys.groups", (Command)query);
    }

    @Test
    public void testInsertFunction() {
        GroupSymbol g = new GroupSymbol("sys.groups");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("insert", new Expression[]{new Constant((Object)"x"), new Constant((Object)new Integer(1)), new Constant((Object)"a")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT insert('x', 1, 'a') AS x FROM sys.groups", "SELECT insert('x', 1, 'a') AS x FROM sys.groups", (Command)query);
    }

    @Test
    public void testInsertIntoSelect() {
        GroupSymbol g = new GroupSymbol("sys.groups");
        From from = new From();
        from.addGroup(g);
        Insert insert = new Insert();
        GroupSymbol groupSymbol = new GroupSymbol("tempA");
        insert.setGroup(groupSymbol);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)1));
        Query query = new Query();
        query.setSelect(select);
        insert.setQueryExpression((QueryCommand)query);
        TestParser.helpTest("insert into tempA SELECT 1", "INSERT INTO tempA SELECT 1", (Command)insert);
    }

    @Test
    public void testTranslateFunction() {
        GroupSymbol g = new GroupSymbol("sys.groups");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("translate", new Expression[]{new Constant((Object)"x"), new Constant((Object)"x"), new Constant((Object)"y")});
        Select select = new Select();
        select.addSymbol((Expression)f);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT translate('x', 'x', 'y') FROM sys.groups", "SELECT translate('x', 'x', 'y') FROM sys.groups", (Command)query);
    }

    @Test
    public void testTimestampaddFunctionFracSecond() {
        GroupSymbol g = new GroupSymbol("my.group1");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("timestampadd", new Expression[]{new Constant((Object)"SQL_TSI_FRAC_SECOND"), new Constant((Object)new Integer(10)), new Constant((Object)"2003-05-01 10:20:30")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT timestampadd(SQL_TSI_FRAC_SECOND, 10, '2003-05-01 10:20:30') AS x FROM my.group1", "SELECT timestampadd(SQL_TSI_FRAC_SECOND, 10, '2003-05-01 10:20:30') AS x FROM my.group1", (Command)query);
    }

    @Test
    public void testTimestampaddFunctionSecond() {
        GroupSymbol g = new GroupSymbol("my.group1");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("timestampadd", new Expression[]{new Constant((Object)"SQL_TSI_SECOND"), new Constant((Object)new Integer(10)), new Constant((Object)"2003-05-01 10:20:30")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT timestampadd(SQL_TSI_SECOND, 10, '2003-05-01 10:20:30') AS x FROM my.group1", "SELECT timestampadd(SQL_TSI_SECOND, 10, '2003-05-01 10:20:30') AS x FROM my.group1", (Command)query);
    }

    @Test
    public void testTimestampaddFunctionMinute() {
        GroupSymbol g = new GroupSymbol("my.group1");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("timestampadd", new Expression[]{new Constant((Object)"SQL_TSI_MINUTE"), new Constant((Object)new Integer(10)), new Constant((Object)"2003-05-01 10:20:30")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT timestampadd(SQL_TSI_MINUTE, 10, '2003-05-01 10:20:30') AS x FROM my.group1", "SELECT timestampadd(SQL_TSI_MINUTE, 10, '2003-05-01 10:20:30') AS x FROM my.group1", (Command)query);
    }

    @Test
    public void testTimestampaddFunctionHour() {
        GroupSymbol g = new GroupSymbol("my.group1");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("timestampadd", new Expression[]{new Constant((Object)"SQL_TSI_HOUR"), new Constant((Object)new Integer(10)), new Constant((Object)"2003-05-01 10:20:30")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT timestampadd(SQL_TSI_HOUR, 10, '2003-05-01 10:20:30') AS x FROM my.group1", "SELECT timestampadd(SQL_TSI_HOUR, 10, '2003-05-01 10:20:30') AS x FROM my.group1", (Command)query);
    }

    @Test
    public void testTimestampaddFunctionDay() {
        GroupSymbol g = new GroupSymbol("my.group1");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("timestampadd", new Expression[]{new Constant((Object)"SQL_TSI_DAY"), new Constant((Object)new Integer(10)), new Constant((Object)"2003-05-01 10:20:30")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT timestampadd(SQL_TSI_DAY, 10, '2003-05-01 10:20:30') AS x FROM my.group1", "SELECT timestampadd(SQL_TSI_DAY, 10, '2003-05-01 10:20:30') AS x FROM my.group1", (Command)query);
    }

    @Test
    public void testTimestampaddFunctionWeek() {
        GroupSymbol g = new GroupSymbol("my.group1");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("timestampadd", new Expression[]{new Constant((Object)"SQL_TSI_WEEK"), new Constant((Object)new Integer(10)), new Constant((Object)"2003-05-01 10:20:30")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT timestampadd(SQL_TSI_WEEK, 10, '2003-05-01 10:20:30') AS x FROM my.group1", "SELECT timestampadd(SQL_TSI_WEEK, 10, '2003-05-01 10:20:30') AS x FROM my.group1", (Command)query);
    }

    @Test
    public void testTimestampaddFunctionQuarter() {
        GroupSymbol g = new GroupSymbol("my.group1");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("timestampadd", new Expression[]{new Constant((Object)"SQL_TSI_QUARTER"), new Constant((Object)new Integer(10)), new Constant((Object)"2003-05-01 10:20:30")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT timestampadd(SQL_TSI_QUARTER, 10, '2003-05-01 10:20:30') AS x FROM my.group1", "SELECT timestampadd(SQL_TSI_QUARTER, 10, '2003-05-01 10:20:30') AS x FROM my.group1", (Command)query);
    }

    @Test
    public void testTimestampaddFunctionYear() {
        GroupSymbol g = new GroupSymbol("my.group1");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("timestampadd", new Expression[]{new Constant((Object)"SQL_TSI_YEAR"), new Constant((Object)new Integer(10)), new Constant((Object)"2003-05-01 10:20:30")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT timestampadd(SQL_TSI_YEAR, 10, '2003-05-01 10:20:30') AS x FROM my.group1", "SELECT timestampadd(SQL_TSI_YEAR, 10, '2003-05-01 10:20:30') AS x FROM my.group1", (Command)query);
    }

    @Test
    public void testTimestampdiffFunctionFracSecond() {
        GroupSymbol g = new GroupSymbol("my.group1");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("timestampdiff", new Expression[]{new Constant((Object)"SQL_TSI_FRAC_SECOND"), new Constant((Object)"2003-05-01 10:20:10"), new Constant((Object)"2003-05-01 10:20:30")});
        AliasSymbol as = new AliasSymbol("x", (Expression)f);
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT timestampdiff(SQL_TSI_FRAC_SECOND, '2003-05-01 10:20:10', '2003-05-01 10:20:30') AS x FROM my.group1", "SELECT timestampdiff(SQL_TSI_FRAC_SECOND, '2003-05-01 10:20:10', '2003-05-01 10:20:30') AS x FROM my.group1", (Command)query);
    }

    @Test
    public void testArithmeticOperatorPrecedence1() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("+", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)new Integer(2))});
        Function f2 = new Function("+", new Expression[]{f, new Constant((Object)new Integer(3))});
        Select select = new Select();
        select.addSymbol((Expression)f2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 5 + 2 + 3 FROM g", "SELECT ((5 + 2) + 3) FROM g", (Command)query);
    }

    @Test
    public void testArithmeticOperatorPrecedence2() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("+", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)new Integer(2))});
        Function f2 = new Function("-", new Expression[]{f, new Constant((Object)new Integer(3))});
        Select select = new Select();
        select.addSymbol((Expression)f2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 5 + 2 - 3 FROM g", "SELECT ((5 + 2) - 3) FROM g", (Command)query);
    }

    @Test
    public void testArithmeticOperatorPrecedence3() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("*", new Expression[]{new Constant((Object)new Integer(2)), new Constant((Object)new Integer(3))});
        Function f2 = new Function("+", new Expression[]{new Constant((Object)new Integer(5)), f});
        Select select = new Select();
        select.addSymbol((Expression)f2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 5 + 2 * 3 FROM g", "SELECT (5 + (2 * 3)) FROM g", (Command)query);
    }

    @Test
    public void testArithmeticOperatorPrecedence4() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("*", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)new Integer(2))});
        Function f2 = new Function("+", new Expression[]{f, new Constant((Object)new Integer(3))});
        Select select = new Select();
        select.addSymbol((Expression)f2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 5 * 2 + 3 FROM g", "SELECT ((5 * 2) + 3) FROM g", (Command)query);
    }

    @Test
    public void testArithmeticOperatorPrecedence5() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("*", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)new Integer(2))});
        Function f2 = new Function("*", new Expression[]{f, new Constant((Object)new Integer(3))});
        Select select = new Select();
        select.addSymbol((Expression)f2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 5 * 2 * 3 FROM g", "SELECT ((5 * 2) * 3) FROM g", (Command)query);
    }

    @Test
    public void testArithmeticOperatorPrecedenceMixed1() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("*", new Expression[]{new Constant((Object)new Integer(2)), new Constant((Object)new Integer(3))});
        Function f2 = new Function("*", new Expression[]{new Constant((Object)new Integer(4)), new Constant((Object)new Integer(5))});
        Function f3 = new Function("+", new Expression[]{new Constant((Object)new Integer(1)), f});
        Function f4 = new Function("+", new Expression[]{f3, f2});
        Select select = new Select();
        select.addSymbol((Expression)f4);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 1 + 2 * 3 + 4 * 5 FROM g", "SELECT ((1 + (2 * 3)) + (4 * 5)) FROM g", (Command)query);
    }

    @Test
    public void testArithmeticOperatorPrecedenceMixed2() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("*", new Expression[]{new Constant((Object)new Integer(1)), new Constant((Object)new Integer(2))});
        Function f2 = new Function("*", new Expression[]{new Constant((Object)new Integer(3)), new Constant((Object)new Integer(4))});
        Function f3 = new Function("+", new Expression[]{f, f2});
        Function f4 = new Function("+", new Expression[]{f3, new Constant((Object)new Integer(5))});
        Select select = new Select();
        select.addSymbol((Expression)f4);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 1 * 2 + 3 * 4 + 5 FROM g", "SELECT (((1 * 2) + (3 * 4)) + 5) FROM g", (Command)query);
    }

    @Test
    public void testLeftAssociativeExpressions1() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("-", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)new Integer(4))});
        Function f2 = new Function("-", new Expression[]{f, new Constant((Object)new Integer(3))});
        Function f3 = new Function("-", new Expression[]{f2, new Constant((Object)new Integer(2))});
        Select select = new Select();
        select.addSymbol((Expression)f3);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 5 - 4 - 3 - 2 FROM g", "SELECT (((5 - 4) - 3) - 2) FROM g", (Command)query);
    }

    @Test
    public void testLeftAssociativeExpressions2() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("/", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)new Integer(4))});
        Function f2 = new Function("/", new Expression[]{f, new Constant((Object)new Integer(3))});
        Function f3 = new Function("/", new Expression[]{f2, new Constant((Object)new Integer(2))});
        Select select = new Select();
        select.addSymbol((Expression)f3);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 5 / 4 / 3 / 2 FROM g", "SELECT (((5 / 4) / 3) / 2) FROM g", (Command)query);
    }

    @Test
    public void testConcatOperator1() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("||", new Expression[]{new Constant((Object)"a"), new Constant((Object)"b")});
        Function f2 = new Function("||", new Expression[]{f, new Constant((Object)"c")});
        Select select = new Select();
        select.addSymbol((Expression)f2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 'a' || 'b' || 'c' FROM g", "SELECT (('a' || 'b') || 'c') FROM g", (Command)query);
    }

    @Test
    public void testMixedOperators1() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Function f = new Function("*", new Expression[]{new Constant((Object)new Integer(1)), new Constant((Object)new Integer(2))});
        Function f2 = new Function("+", new Expression[]{new Constant((Object)new Integer(5)), f});
        Function f3 = new Function("+", new Expression[]{new Constant((Object)new Integer(2)), new Constant((Object)new Integer(3))});
        Function f4 = new Function("||", new Expression[]{f3, f2});
        Select select = new Select();
        select.addSymbol((Expression)f4);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 2 + 3 || 5 + 1 * 2 FROM g", "SELECT ((2 + 3) || (5 + (1 * 2))) FROM g", (Command)query);
    }

    @Test
    public void testGroupBy() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a", false));
        GroupBy groupBy = new GroupBy();
        groupBy.addSymbol((Expression)new ElementSymbol("b", false));
        groupBy.addSymbol((Expression)new ElementSymbol("c", false));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setGroupBy(groupBy);
        TestParser.helpTest("SELECT a FROM m.g GROUP BY b, c", "SELECT a FROM m.g GROUP BY b, c", (Command)query);
    }

    @Test
    public void testGroupByHaving() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a", false));
        GroupBy groupBy = new GroupBy();
        groupBy.addSymbol((Expression)new ElementSymbol("b", false));
        groupBy.addSymbol((Expression)new ElementSymbol("c", false));
        CompareCriteria having = new CompareCriteria((Expression)new ElementSymbol("b", false), 1, (Expression)new Constant((Object)new Integer(5)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setGroupBy(groupBy);
        query.setHaving((Criteria)having);
        TestParser.helpTest("SELECT a FROM m.g GROUP BY b, c HAVING b=5", "SELECT a FROM m.g GROUP BY b, c HAVING b = 5", (Command)query);
    }

    @Test
    public void testAggregateFunction() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new AliasSymbol("c", (Expression)new AggregateSymbol("COUNT", false, (Expression)new ElementSymbol("a", false))));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT COUNT(a) AS c FROM m.g", "SELECT COUNT(a) AS c FROM m.g", (Command)query);
    }

    @Test
    public void testAggregateFunctionWithParens() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new AliasSymbol("c", (Expression)new AggregateSymbol("COUNT", false, (Expression)new ElementSymbol("a", false))));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT (COUNT(a)) AS c FROM m.g", "SELECT COUNT(a) AS c FROM m.g", (Command)query);
    }

    @Test
    public void testHavingFunction() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        GroupBy groupBy = new GroupBy();
        groupBy.addSymbol((Expression)new ElementSymbol("a"));
        CompareCriteria having = new CompareCriteria((Expression)new AggregateSymbol("COUNT", false, (Expression)new ElementSymbol("b", false)), 4, (Expression)new Constant((Object)new Integer(0)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setGroupBy(groupBy);
        query.setHaving((Criteria)having);
        TestParser.helpTest("SELECT a FROM m.g GROUP BY a HAVING COUNT(b) > 0", "SELECT a FROM m.g GROUP BY a HAVING COUNT(b) > 0", (Command)query);
    }

    @Test
    public void testCompoundHaving() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        GroupBy groupBy = new GroupBy();
        groupBy.addSymbol((Expression)new ElementSymbol("a"));
        groupBy.addSymbol((Expression)new ElementSymbol("b"));
        CompoundCriteria having = new CompoundCriteria();
        having.setOperator(0);
        having.addCriteria((Criteria)new CompareCriteria((Expression)new AggregateSymbol("COUNT", false, (Expression)new ElementSymbol("b", false)), 4, (Expression)new Constant((Object)new Integer(0))));
        having.addCriteria((Criteria)new CompareCriteria((Expression)new Function("+", new Expression[]{new ElementSymbol("b", false), new Constant((Object)new Integer(5))}), 4, (Expression)new Constant((Object)new Integer(0))));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setGroupBy(groupBy);
        query.setHaving((Criteria)having);
        TestParser.helpTest("SELECT a FROM m.g GROUP BY a, b HAVING COUNT(b) > 0 AND b+5 > 0", "SELECT a FROM m.g GROUP BY a, b HAVING (COUNT(b) > 0) AND ((b + 5) > 0)", (Command)query);
    }

    @Test
    public void testFailNestedAggregateInHaving() {
        TestParser.helpException("SELECT a FROM m.g GROUP BY a, b HAVING COUNT(b) AS x = 5");
    }

    @Test
    public void testFailAliasInHaving() {
        TestParser.helpException("SELECT a FROM m.g GROUP BY a, b AS x");
    }

    @Test(expected=QueryParserException.class)
    public void testExceptionLength() throws Exception {
        String sql = "SELECT * FROM Customer where Customer.Name = (select lastname from CUSTOMER where acctid = 9";
        QueryParser.getQueryParser().parseCommand(sql);
    }

    @Test
    public void testFunctionOfAggregates() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        AggregateSymbol agg1 = new AggregateSymbol("COUNT", false, (Expression)new ElementSymbol("a", false));
        AggregateSymbol agg2 = new AggregateSymbol("SUM", false, (Expression)new ElementSymbol("a", false));
        Function f = new Function("*", new Expression[]{agg1, agg2});
        AliasSymbol alias = new AliasSymbol("c", (Expression)f);
        select.addSymbol((Expression)alias);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT COUNT(a) * SUM(a) AS c FROM m.g", "SELECT (COUNT(a) * SUM(a)) AS c FROM m.g", (Command)query);
    }

    @Test
    public void testArithmeticNullFunction() {
        GroupSymbol g = new GroupSymbol("a.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Function("-", new Expression[]{new Constant((Object)new Integer(5)), new Constant(null)}));
        select.addSymbol((Expression)new ElementSymbol("a.g1.c1"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 5-null, a.g1.c1 FROM a.g1", "SELECT (5 - null), a.g1.c1 FROM a.g1", (Command)query);
    }

    @Test
    public void testStringLiteral() {
        GroupSymbol g = new GroupSymbol("a.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)"abc"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 'abc' FROM a.g1", "SELECT 'abc' FROM a.g1", (Command)query);
    }

    @Test
    public void testStringLiteralEscapedTick() {
        GroupSymbol g = new GroupSymbol("a.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)"O'Leary"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 'O''Leary' FROM a.g1", "SELECT 'O''Leary' FROM a.g1", (Command)query);
    }

    @Test
    public void testStringLiteralEscapedTick2() {
        GroupSymbol g = new GroupSymbol("a.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)"'abc'"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT '''abc''' FROM a.g1", "SELECT '''abc''' FROM a.g1", (Command)query);
    }

    @Test
    public void testStringLiteralEscapedTick3() {
        GroupSymbol g = new GroupSymbol("a.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)"a'b'c"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 'a''b''c' FROM a.g1", "SELECT 'a''b''c' FROM a.g1", (Command)query);
    }

    @Test
    public void testStringLiteralEscapedTick4() {
        GroupSymbol g = new GroupSymbol("a.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol(" \" "));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT \" \"\" \" FROM a.g1", "SELECT \" \"\" \" FROM a.g1", (Command)query);
    }

    @Test
    public void testLongLiteral() {
        GroupSymbol g = new GroupSymbol("a.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)new Long(123456789012L)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 123456789012 FROM a.g1", "SELECT 123456789012 FROM a.g1", (Command)query);
    }

    @Test
    public void testBigIntegerLiteral() {
        GroupSymbol g = new GroupSymbol("a.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)new BigInteger("1000000000000000000000000")));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 1000000000000000000000000 FROM a.g1", "SELECT 1000000000000000000000000 FROM a.g1", (Command)query);
    }

    @Test
    public void testFloatWithE() {
        GroupSymbol g = new GroupSymbol("a.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)new Double(1.3E8)));
        select.addSymbol((Expression)new Constant((Object)new Double(-1.3E8)));
        select.addSymbol((Expression)new Constant((Object)new Double(1.3E-8)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 1.3e8, -1.3e+8, +1.3e-8 FROM a.g1", "SELECT 1.3E8, -1.3E8, 1.3E-8 FROM a.g1", (Command)query);
    }

    @Test
    public void testDateLiteral1() {
        GroupSymbol g = new GroupSymbol("m.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)Date.valueOf("2002-10-02")));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT {d'2002-10-02'} FROM m.g1", "SELECT {d'2002-10-02'} FROM m.g1", (Command)query);
    }

    @Test
    public void testDateLiteral2() {
        GroupSymbol g = new GroupSymbol("m.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)Date.valueOf("2002-09-01")));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT {d'2002-09-01'} FROM m.g1", "SELECT {d'2002-09-01'} FROM m.g1", (Command)query);
    }

    @Test
    public void testDateLiteralFail() {
        TestParser.helpException("SELECT {d'bad'} FROM m.g1");
    }

    @Test
    public void testTimeLiteral1() {
        GroupSymbol g = new GroupSymbol("m.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)Time.valueOf("11:10:00")));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT {t '11:10:00' } FROM m.g1", "SELECT {t'11:10:00'} FROM m.g1", (Command)query);
    }

    @Test
    public void testTimeLiteral2() {
        GroupSymbol g = new GroupSymbol("m.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)Time.valueOf("5:10:00")));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT {t '05:10:00'} FROM m.g1", "SELECT {t'05:10:00'} FROM m.g1", (Command)query);
    }

    @Test
    public void testTimeLiteralFail() {
        TestParser.helpException("SELECT {t 'xyz'} FROM m.g1");
    }

    @Test
    public void testTimestampLiteral() {
        GroupSymbol g = new GroupSymbol("m.g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)Timestamp.valueOf("2002-10-02 19:00:02.50")));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT {ts'2002-10-02 19:00:02.50'} FROM m.g1", "SELECT {ts'2002-10-02 19:00:02.5'} FROM m.g1", (Command)query);
    }

    @Test
    public void testBooleanLiteralTrue() {
        Boolean expected = Boolean.TRUE;
        Class expectedType = DataTypeManager.DefaultDataClasses.BOOLEAN;
        String sql = "SELECT {b'true'}";
        String expectedSql = "SELECT TRUE";
        this.helpTestLiteral(expected, expectedType, sql, expectedSql);
    }

    private void helpTestLiteral(Boolean expected, Class<?> expectedType, String sql, String expectedSql) {
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)expected, expectedType));
        Query query = new Query();
        query.setSelect(select);
        TestParser.helpTest(sql, expectedSql, (Command)query);
    }

    @Test
    public void testBooleanLiteralTrue2() {
        Boolean expected = Boolean.TRUE;
        Class expectedType = DataTypeManager.DefaultDataClasses.BOOLEAN;
        String sql = "SELECT TRUE";
        String expectedSql = "SELECT TRUE";
        this.helpTestLiteral(expected, expectedType, sql, expectedSql);
    }

    @Test
    public void testBooleanLiteralFalse() {
        Boolean expected = Boolean.FALSE;
        Class expectedType = DataTypeManager.DefaultDataClasses.BOOLEAN;
        String sql = "SELECT {b'false'}";
        String expectedSql = "SELECT FALSE";
        this.helpTestLiteral(expected, expectedType, sql, expectedSql);
    }

    @Test
    public void testBooleanLiteralFalse2() {
        Boolean expected = Boolean.FALSE;
        Class expectedType = DataTypeManager.DefaultDataClasses.BOOLEAN;
        String sql = "SELECT {b'false'}";
        String expectedSql = "SELECT FALSE";
        this.helpTestLiteral(expected, expectedType, sql, expectedSql);
    }

    @Test
    public void testBooleanLiteralUnknown() {
        Boolean expected = null;
        Class expectedType = DataTypeManager.DefaultDataClasses.BOOLEAN;
        String sql = "SELECT {b'unknown'}";
        String expectedSql = "SELECT UNKNOWN";
        this.helpTestLiteral(expected, expectedType, sql, expectedSql);
    }

    @Test
    public void testBooleanLiteralUnknown2() {
        Boolean expected = null;
        Class expectedType = DataTypeManager.DefaultDataClasses.BOOLEAN;
        String sql = "SELECT UNKNOWN";
        String expectedSql = "SELECT UNKNOWN";
        this.helpTestLiteral(expected, expectedType, sql, expectedSql);
    }

    @Test
    public void testSelectDistinct() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        select.setDistinct(true);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT DISTINCT a FROM g", "SELECT DISTINCT a FROM g", (Command)query);
    }

    @Test
    public void testSelectAll() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        select.setDistinct(false);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT ALL a FROM g", "SELECT a FROM g", (Command)query);
    }

    @Test
    public void testAliasInSelect() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        AliasSymbol as = new AliasSymbol("myA", (Expression)new ElementSymbol("a"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        select.addSymbol((Expression)new ElementSymbol("b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT a AS myA, b FROM g", "SELECT a AS myA, b FROM g", (Command)query);
    }

    @Test
    public void testAliasInSelect2() {
        GroupSymbol g = new GroupSymbol("g");
        GroupSymbol h = new GroupSymbol("h");
        From from = new From();
        from.addGroup(g);
        from.addGroup(h);
        AliasSymbol as = new AliasSymbol("myA", (Expression)new ElementSymbol("a"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        select.addSymbol((Expression)new ElementSymbol("b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT a myA, b FROM g, h", "SELECT a AS myA, b FROM g, h", (Command)query);
    }

    @Test
    public void testAliasInFrom() {
        GroupSymbol g = new GroupSymbol("myG", "g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("myG.a"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT myG.a FROM g AS myG", "SELECT myG.a FROM g AS myG", (Command)query);
    }

    @Test
    public void testAliasesInFrom() {
        GroupSymbol g = new GroupSymbol("myG", "g");
        GroupSymbol h = new GroupSymbol("myH", "h");
        From from = new From();
        from.addGroup(g);
        from.addGroup(h);
        Select select = new Select();
        MultipleElementSymbol myG = new MultipleElementSymbol("myG");
        select.addSymbol((Expression)myG);
        select.addSymbol((Expression)new ElementSymbol("myH.b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT myG.*, myH.b FROM g AS myG, h AS myH", "SELECT myG.*, myH.b FROM g AS myG, h AS myH", (Command)query);
    }

    @Test
    public void testHiddenAliasesInFrom() {
        GroupSymbol g = new GroupSymbol("myG", "g");
        GroupSymbol h = new GroupSymbol("myH", "h");
        From from = new From();
        from.addGroup(g);
        from.addGroup(h);
        Select select = new Select();
        MultipleElementSymbol myG = new MultipleElementSymbol("myG");
        select.addSymbol((Expression)myG);
        select.addSymbol((Expression)new ElementSymbol("myH.b"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT myG.*, myH.b FROM g myG, h myH", "SELECT myG.*, myH.b FROM g AS myG, h AS myH", (Command)query);
    }

    @Test
    public void testAliasInSelectUsingKeywordFails() {
        TestParser.helpException("SELECT a AS or FROM g");
    }

    @Test
    public void testAliasInFromUsingKeywordFails() {
        TestParser.helpException("SELECT or.a FROM g AS or");
    }

    @Test
    public void testIsNullCriteria1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        IsNullCriteria crit = new IsNullCriteria((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("Select a From db.g Where a IS NULL", "SELECT a FROM db.g WHERE a IS NULL", (Command)query);
    }

    @Test
    public void testIsNullCriteria2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        IsNullCriteria crit = new IsNullCriteria((Expression)a);
        crit.setNegated(true);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("Select a From db.g Where a IS NOT NULL", "SELECT a FROM db.g WHERE a IS NOT NULL", (Command)query);
    }

    @Test
    public void testNotIsNullCriteria() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        NotCriteria crit = new NotCriteria((Criteria)new IsNullCriteria((Expression)a));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("Select a From db.g Where Not a IS NULL", "SELECT a FROM db.g WHERE NOT (a IS NULL)", (Command)query);
    }

    @Test
    public void testStringNotEqualDoubleTicks() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        ElementSymbol ex = new ElementSymbol("value");
        CompareCriteria crit = new CompareCriteria((Expression)a, 2, (Expression)ex);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where a <> \"value\"", "SELECT a FROM db.g WHERE a <> \"value\"", (Command)query);
    }

    @Test
    public void testNotEquals2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant constant = new Constant((Object)"value");
        CompareCriteria crit = new CompareCriteria((Expression)a, 2, (Expression)constant);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where a != 'value'", "SELECT a FROM db.g WHERE a <> 'value'", (Command)query);
    }

    @Test
    public void testPartlyQuotedGroup() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        CompareCriteria crit = new CompareCriteria((Expression)a, 1, (Expression)new Constant((Object)new Integer(5)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.\"g\" where a = 5", "SELECT a FROM db.g WHERE a = 5", (Command)query);
    }

    @Test
    public void testFullyQuotedGroup() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        CompareCriteria crit = new CompareCriteria((Expression)a, 1, (Expression)new Constant((Object)new Integer(5)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from \"db\".\"g\" where a = 5", "SELECT a FROM db.g WHERE a = 5", (Command)query);
    }

    @Test
    public void testPartlyQuotedElement1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("db.g.a");
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT \"db\".g.a from db.g", "SELECT db.g.a FROM db.g", (Command)query);
    }

    @Test
    public void testPartlyQuotedElement2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("db.g.a");
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT \"db\".\"g\".a from db.g", "SELECT db.g.a FROM db.g", (Command)query);
    }

    @Test
    public void testPartlyQuotedElement3() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("db.g.a");
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT \"db\".\"g\".\"a\" from db.g", "SELECT db.g.a FROM db.g", (Command)query);
    }

    @Test
    public void testStringLiteralLikeQuotedElement() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("g\".\"a"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT \"g\"\".\"\"a\" from g", "SELECT \"g\"\"\".\"\"\"a\" FROM g", (Command)query);
    }

    @Test
    public void testStringLiteralLikeQuotedElement1() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new Constant((Object)"g\".\"a"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        ParseInfo info = new ParseInfo();
        info.ansiQuotedIdentifiers = false;
        TestParser.helpTest("SELECT \"g\"\".\"\"a\" from g", "SELECT 'g\".\"a' FROM g", (Command)query, info);
    }

    @Test
    public void testQuotedAlias() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        AliasSymbol a = new AliasSymbol("select", (Expression)new ElementSymbol("g.x"));
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT g.x AS \"select\" FROM g", "SELECT g.x AS \"select\" FROM g", (Command)query);
    }

    @Test
    public void testQuotedAlias2() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        AliasSymbol a = new AliasSymbol("year", (Expression)new ElementSymbol("g.x"));
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT g.x AS \"year\" FROM g", "SELECT g.x AS \"year\" FROM g", (Command)query);
    }

    @Test
    public void testQuotedAlias3() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        AliasSymbol a = new AliasSymbol("some year", (Expression)new ElementSymbol("g.x"));
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT g.x AS \"some year\" FROM g", "SELECT g.x AS \"some year\" FROM g", (Command)query);
    }

    @Test
    public void testReservedWordElement1() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("g.select");
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT g.\"select\" FROM g", "SELECT g.\"select\" FROM g", (Command)query);
    }

    @Test
    public void testReservedWordElement2() {
        GroupSymbol g = new GroupSymbol("newModel5.ResultSetDocument.MappingClasses.from.from.Query1InputSet");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("newModel5.ResultSetDocument.MappingClasses.from.from.Query1InputSet.x");
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT newModel5.ResultSetDocument.MappingClasses.from.from.Query1InputSet.x FROM newModel5.ResultSetDocument.MappingClasses.from.from.Query1InputSet", "SELECT newModel5.ResultSetDocument.MappingClasses.\"from\".\"from\".Query1InputSet.x FROM newModel5.ResultSetDocument.MappingClasses.\"from\".\"from\".Query1InputSet", (Command)query);
    }

    @Test
    public void testReservedWordGroup1() {
        GroupSymbol g = new GroupSymbol("newModel5.ResultSetDocument.MappingClasses.from.from.Query1InputSet");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM newModel5.ResultSetDocument.MappingClasses.from.from.Query1InputSet", "SELECT * FROM newModel5.ResultSetDocument.MappingClasses.\"from\".\"from\".Query1InputSet", (Command)query);
    }

    @Test
    public void testReservedWordGroup2() {
        GroupSymbol g = new GroupSymbol("newModel5.ResultSetDocument.MappingClasses.from.from.Query1InputSet");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM newModel5.\"ResultSetDocument.MappingClasses.from.from.Query1InputSet\"", "SELECT * FROM newModel5.ResultSetDocument.MappingClasses.\"from\".\"from\".Query1InputSet", (Command)query);
    }

    @Test
    public void testXMLCriteriaWithAttribute() {
        GroupSymbol g = new GroupSymbol("model.doc");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        ElementSymbol elem = new ElementSymbol("ab.cd.@ef");
        query.setCriteria((Criteria)new CompareCriteria((Expression)elem, 1, (Expression)new Constant((Object)"abc")));
        TestParser.helpTest("SELECT * FROM model.doc WHERE ab.cd.@ef = 'abc'", "SELECT * FROM model.doc WHERE ab.cd.@ef = 'abc'", (Command)query);
    }

    @Test
    public void testStringNotEqual() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant constant = new Constant((Object)"value");
        CompareCriteria crit = new CompareCriteria((Expression)a, 2, (Expression)constant);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where a <> 'value'", "SELECT a FROM db.g WHERE a <> 'value'", (Command)query);
    }

    @Test
    public void testBetween1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant constant1 = new Constant((Object)new Integer(1000));
        Constant constant2 = new Constant((Object)new Integer(2000));
        BetweenCriteria crit = new BetweenCriteria((Expression)a, (Expression)constant1, (Expression)constant2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where a BETWEEN 1000 AND 2000", "SELECT a FROM db.g WHERE a BETWEEN 1000 AND 2000", (Command)query);
    }

    @Test
    public void testBetween2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant constant1 = new Constant((Object)new Integer(1000));
        Constant constant2 = new Constant((Object)new Integer(2000));
        BetweenCriteria crit = new BetweenCriteria((Expression)a, (Expression)constant1, (Expression)constant2);
        crit.setNegated(true);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where a NOT BETWEEN 1000 AND 2000", "SELECT a FROM db.g WHERE a NOT BETWEEN 1000 AND 2000", (Command)query);
    }

    @Test
    public void testCompareLT() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant constant = new Constant((Object)new Integer(1000));
        CompareCriteria crit = new CompareCriteria((Expression)a, 3, (Expression)constant);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where a < 1000", "SELECT a FROM db.g WHERE a < 1000", (Command)query);
    }

    @Test
    public void testCompareGT() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant constant = new Constant((Object)new Integer(1000));
        CompareCriteria crit = new CompareCriteria((Expression)a, 4, (Expression)constant);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where a > 1000", "SELECT a FROM db.g WHERE a > 1000", (Command)query);
    }

    @Test
    public void testCompareLE() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant constant = new Constant((Object)new Integer(1000));
        CompareCriteria crit = new CompareCriteria((Expression)a, 5, (Expression)constant);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where a <= 1000", "SELECT a FROM db.g WHERE a <= 1000", (Command)query);
    }

    @Test
    public void testCompareGE() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant constant = new Constant((Object)new Integer(1000));
        CompareCriteria crit = new CompareCriteria((Expression)a, 6, (Expression)constant);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where a >= 1000", "SELECT a FROM db.g WHERE a >= 1000", (Command)query);
    }

    @Test
    public void testCompoundCompare1() {
        this.helpTestCompoundCompare("SELECT a from db.g where b = x and a = 1000");
    }

    @Test
    public void testCompoundCompare2() {
        this.helpTestCompoundCompare("SELECT a from db.g where (b = x and a = 1000)");
    }

    @Test
    public void testCompoundCompare3() {
        this.helpTestCompoundCompare("SELECT a from db.g where ((b = x) and (a = 1000))");
    }

    @Test
    public void testCompoundCompare4() {
        this.helpTestCompoundCompare("SELECT a from db.g where (((b = x) and (a = 1000)))");
    }

    private void helpTestCompoundCompare(String testSQL) {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        CompareCriteria crit1 = new CompareCriteria((Expression)new ElementSymbol("b"), 1, (Expression)new ElementSymbol("x"));
        Constant constant = new Constant((Object)new Integer(1000));
        CompareCriteria crit2 = new CompareCriteria((Expression)a, 1, (Expression)constant);
        CompoundCriteria crit = new CompoundCriteria(0, (Criteria)crit1, (Criteria)crit2);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest(testSQL, "SELECT a FROM db.g WHERE (b = x) AND (a = 1000)", (Command)query);
    }

    @Test
    public void testSetCriteria0() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        Constant constant1 = new Constant((Object)new Integer(1000));
        Constant constant2 = new Constant((Object)new Integer(5000));
        ArrayList<Constant> constants = new ArrayList<Constant>(2);
        constants.add(constant1);
        constants.add(constant2);
        SetCriteria crit = new SetCriteria((Expression)new ElementSymbol("b"), constants);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a FROM db.g WHERE b IN (1000,5000)", "SELECT a FROM db.g WHERE b IN (1000, 5000)", (Command)query);
    }

    @Test
    public void testSetCriteria1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        Constant constant1 = new Constant((Object)new Integer(1000));
        Constant constant2 = new Constant((Object)new Integer(5000));
        ArrayList<Constant> constants = new ArrayList<Constant>(2);
        constants.add(constant1);
        constants.add(constant2);
        SetCriteria crit = new SetCriteria((Expression)new ElementSymbol("b"), constants);
        crit.setNegated(true);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a FROM db.g WHERE b NOT IN (1000,5000)", "SELECT a FROM db.g WHERE b NOT IN (1000, 5000)", (Command)query);
    }

    @Test
    public void testOrderBy() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("b"), 1, (Expression)new ElementSymbol("aString"));
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(new ElementSymbol("c"));
        OrderBy orderBy = new OrderBy(elements);
        Query query = new Query(select, from, (Criteria)crit, orderBy, null);
        TestParser.helpTest("SELECT a FROM db.g WHERE b = aString ORDER BY c", "SELECT a FROM db.g WHERE b = aString ORDER BY c", (Command)query);
    }

    @Test
    public void testOrderByDesc() {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(new ElementSymbol("c"));
        ArrayList<Boolean> orderTypes = new ArrayList<Boolean>();
        orderTypes.add(Boolean.FALSE);
        OrderBy orderBy = new OrderBy(elements, orderTypes);
        Query query = this.getOrderByQuery(orderBy);
        TestParser.helpTest("SELECT a FROM db.g WHERE b = aString ORDER BY c desc", "SELECT a FROM db.g WHERE b = aString ORDER BY c DESC", (Command)query);
    }

    private Query getOrderByQuery(OrderBy orderBy) {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("b"), 1, (Expression)new ElementSymbol("aString"));
        Query query = new Query(select, from, (Criteria)crit, orderBy, null);
        return query;
    }

    @Test
    public void testOrderBys() {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(new ElementSymbol("c"));
        elements.add(new ElementSymbol("d"));
        OrderBy orderBy = new OrderBy(elements);
        Query query = this.getOrderByQuery(orderBy);
        TestParser.helpTest("SELECT a FROM db.g WHERE b = aString ORDER BY c,d", "SELECT a FROM db.g WHERE b = aString ORDER BY c, d", (Command)query);
    }

    @Test
    public void testOrderBysDesc() {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(new ElementSymbol("c"));
        elements.add(new ElementSymbol("d"));
        ArrayList<Boolean> orderTypes = new ArrayList<Boolean>();
        orderTypes.add(Boolean.FALSE);
        orderTypes.add(Boolean.FALSE);
        OrderBy orderBy = new OrderBy(elements, orderTypes);
        Query query = this.getOrderByQuery(orderBy);
        TestParser.helpTest("SELECT a FROM db.g WHERE b = aString ORDER BY c desc,d desc", "SELECT a FROM db.g WHERE b = aString ORDER BY c DESC, d DESC", (Command)query);
    }

    @Test
    public void testMixedOrderBys() {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(new ElementSymbol("c"));
        elements.add(new ElementSymbol("d"));
        ArrayList<Boolean> orderTypes = new ArrayList<Boolean>();
        orderTypes.add(Boolean.FALSE);
        orderTypes.add(Boolean.TRUE);
        OrderBy orderBy = new OrderBy(elements, orderTypes);
        Query query = this.getOrderByQuery(orderBy);
        TestParser.helpTest("SELECT a FROM db.g WHERE b = aString ORDER BY c desc,d", "SELECT a FROM db.g WHERE b = aString ORDER BY c DESC, d", (Command)query);
    }

    @Test
    public void testOrderByNullOrdering() {
        OrderBy orderBy = new OrderBy();
        OrderByItem item = new OrderByItem((Expression)new ElementSymbol("c"), true);
        item.setNullOrdering(SortSpecification.NullOrdering.FIRST);
        orderBy.getOrderByItems().add(item);
        item = new OrderByItem((Expression)new ElementSymbol("d"), false);
        item.setNullOrdering(SortSpecification.NullOrdering.LAST);
        orderBy.getOrderByItems().add(item);
        Query query = this.getOrderByQuery(orderBy);
        TestParser.helpTest("SELECT a FROM db.g WHERE b = aString ORDER BY c NULLS FIRST,d desc nulls last", "SELECT a FROM db.g WHERE b = aString ORDER BY c NULLS FIRST, d DESC NULLS LAST", (Command)query);
    }

    @Test
    public void testLike0() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant string1 = new Constant((Object)"aString");
        MatchCriteria crit = new MatchCriteria((Expression)new ElementSymbol("b"), (Expression)string1);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a FROM db.g WHERE b LIKE 'aString'", "SELECT a FROM db.g WHERE b LIKE 'aString'", (Command)query);
    }

    @Test
    public void testLike1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant string1 = new Constant((Object)"aString");
        MatchCriteria crit = new MatchCriteria((Expression)new ElementSymbol("b"), (Expression)string1);
        crit.setNegated(true);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a FROM db.g WHERE b NOT LIKE 'aString'", "SELECT a FROM db.g WHERE b NOT LIKE 'aString'", (Command)query);
    }

    @Test
    public void testLikeWithEscape() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Constant string1 = new Constant((Object)"#String");
        MatchCriteria crit = new MatchCriteria((Expression)new ElementSymbol("b"), (Expression)string1, '#');
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where b like '#String' escape '#'", "SELECT a FROM db.g WHERE b LIKE '#String' ESCAPE '#'", (Command)query);
    }

    @Test
    public void testLikeWithEscapeException() {
        TestParser.helpException("SELECT a from db.g where b like '#String' escape '#1'", "TEIID31100 Parsing error: TEIID30398 LIKE/SIMILAR TO ESCAPE value must be a single character: [#1].");
    }

    @Test
    public void testReservedWordsInElement() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("date.time");
        select.addSymbol((Expression)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT \"date\".\"time\" from db.g", "SELECT \"date\".\"time\" FROM db.g", (Command)query);
    }

    @Test
    public void testNoFromClause() {
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        select.addSymbol((Expression)new Constant((Object)new Integer(5), Integer.class));
        Query query = new Query();
        query.setSelect(select);
        TestParser.helpTest("SELECT a, 5", "SELECT a, 5", (Command)query);
    }

    @Test
    public void testFailsNoSelectClause() {
        TestParser.helpException("FROM g WHERE a = 'aString'");
    }

    @Test
    public void testFailsNoFromClause() {
        TestParser.helpException("SELECT a WHERE a = 'aString'");
    }

    @Test
    public void testFailsWildcardInSelect() {
        TestParser.helpException("SELECT xx.yy%.a from xx.yy");
    }

    @Test
    public void testOrInSelect() {
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new CompoundCriteria(1, Arrays.asList(new ExpressionCriteria((Expression)new ElementSymbol("a")), new ExpressionCriteria((Expression)new ElementSymbol("b")))))));
        TestParser.helpTest("select a or b", "SELECT (a) OR (b)", (Command)query);
    }

    @Test
    public void testLikeWOConstant() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        ElementSymbol x = new ElementSymbol("x");
        MatchCriteria crit = new MatchCriteria((Expression)a, (Expression)x);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a FROM g WHERE a LIKE x", "SELECT a FROM g WHERE a LIKE x", (Command)query);
    }

    @Test
    public void testFailsDSCMisspelled() {
        TestParser.helpException("SELECT a from g ORDER BY b DSC");
    }

    @Test
    public void testReusabilityOfParserObject() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a", false));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT a FROM m.g", "SELECT a FROM m.g", (Command)query);
        TestParser.helpTest("SELECT a FROM m.g", "SELECT a FROM m.g", (Command)query);
    }

    @Test
    public void testParameter1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((Expression)a);
        Reference ref1 = new Reference(0);
        MatchCriteria crit = new MatchCriteria((Expression)new ElementSymbol("b"), (Expression)ref1);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT a from db.g where b LIKE ?", "SELECT a FROM db.g WHERE b LIKE ?", (Command)query);
    }

    @Test
    public void testParameter2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        Reference ref0 = new Reference(0);
        select.addSymbol((Expression)ref0);
        Reference ref1 = new Reference(1);
        MatchCriteria crit = new MatchCriteria((Expression)new ElementSymbol("b"), (Expression)ref1);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT ? from db.g where b LIKE ?", "SELECT ? FROM db.g WHERE b LIKE ?", (Command)query);
    }

    @Test
    public void testSubquery1() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol symbol = new ElementSymbol("c");
        select.addSymbol((Expression)symbol);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        SubqueryFromClause sfc = new SubqueryFromClause("y", (Command)query);
        From from2 = new From();
        from2.addClause((FromClause)sfc);
        Select select2 = new Select();
        select2.addSymbol((Expression)new ElementSymbol("a"));
        select2.addSymbol((Expression)new ElementSymbol("b"));
        Query query2 = new Query();
        query2.setSelect(select2);
        query2.setFrom(from2);
        TestParser.helpTest("SELECT a, b FROM (SELECT c FROM m.g) AS y", "SELECT a, b FROM (SELECT c FROM m.g) AS y", (Command)query2);
    }

    @Test
    public void testSubquery1a() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol symbol = new ElementSymbol("c");
        select.addSymbol((Expression)symbol);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        SubqueryFromClause sfc = new SubqueryFromClause("y", (Command)query);
        From from2 = new From();
        from2.addClause((FromClause)sfc);
        Select select2 = new Select();
        select2.addSymbol((Expression)new ElementSymbol("a"));
        select2.addSymbol((Expression)new ElementSymbol("b"));
        Query query2 = new Query();
        query2.setSelect(select2);
        query2.setFrom(from2);
        TestParser.helpTest("SELECT a, b FROM ((SELECT c FROM m.g)) AS y", "SELECT a, b FROM (SELECT c FROM m.g) AS y", (Command)query2);
    }

    @Test
    public void testSubquery2() {
        GroupSymbol g = new GroupSymbol("m.g2");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol symbol = new ElementSymbol("c");
        select.addSymbol((Expression)symbol);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        UnaryFromClause ufc = new UnaryFromClause(new GroupSymbol("m.g1"));
        SubqueryFromClause sfc = new SubqueryFromClause("y", (Command)query);
        CompareCriteria join = new CompareCriteria((Expression)new ElementSymbol("m.g1.a"), 1, (Expression)new ElementSymbol("y.c"));
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(join);
        JoinPredicate jp = new JoinPredicate((FromClause)ufc, (FromClause)sfc, JoinType.JOIN_INNER, crits);
        From from2 = new From();
        from2.addClause((FromClause)jp);
        Select select2 = new Select();
        select2.addSymbol((Expression)new ElementSymbol("a"));
        select2.addSymbol((Expression)new ElementSymbol("b"));
        Query query2 = new Query();
        query2.setSelect(select2);
        query2.setFrom(from2);
        TestParser.helpTest("SELECT a, b FROM m.g1 JOIN (SELECT c FROM m.g2) AS y ON m.g1.a = y.c", "SELECT a, b FROM m.g1 INNER JOIN (SELECT c FROM m.g2) AS y ON m.g1.a = y.c", (Command)query2);
    }

    @Test
    public void testSubqueryInvalid() {
        TestParser.helpException("SELECT a, b FROM (SELECT c FROM m.g2)");
    }

    @Test
    public void testInsertWithReference() {
        Insert insert = new Insert();
        insert.setGroup(new GroupSymbol("m.g"));
        ArrayList<ElementSymbol> vars = new ArrayList<ElementSymbol>();
        vars.add(new ElementSymbol("a"));
        insert.setVariables(vars);
        ArrayList<Reference> values = new ArrayList<Reference>();
        values.add(new Reference(0));
        insert.setValues(values);
        TestParser.helpTest("INSERT INTO m.g (a) VALUES (?)", "INSERT INTO m.g (a) VALUES (?)", (Command)insert);
    }

    @Test
    public void testStoredQueryWithNoParameter() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        TestParser.helpTest("exec proc1()", "EXEC proc1()", (Command)storedQuery);
        TestParser.helpTest("execute proc1()", "EXEC proc1()", (Command)storedQuery);
    }

    @Test
    public void testStoredQueryWithNoParameter2() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        From from = new From();
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)storedQuery);
        from.addClause((FromClause)sfc);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("X.A"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT X.A FROM (exec proc1()) AS X", "SELECT X.A FROM (EXEC proc1()) AS X", (Command)query);
    }

    @Test
    public void testStoredQuery() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        SPParameter parameter = new SPParameter(1, (Expression)new Constant((Object)"param1"));
        parameter.setParameterType(1);
        storedQuery.setParameter(parameter);
        TestParser.helpTest("Exec proc1('param1')", "EXEC proc1('param1')", (Command)storedQuery);
        TestParser.helpTest("execute proc1('param1')", "EXEC proc1('param1')", (Command)storedQuery);
    }

    @Test
    public void testStoredQuery2() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        SPParameter parameter = new SPParameter(1, (Expression)new Constant((Object)"param1"));
        storedQuery.setParameter(parameter);
        From from = new From();
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)storedQuery);
        from.addClause((FromClause)sfc);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("X.A"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT X.A FROM (exec proc1('param1')) AS X", "SELECT X.A FROM (EXEC proc1('param1')) AS X", (Command)query);
    }

    @Test
    public void testStoredQuery2SanityCheck() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        SPParameter parameter = new SPParameter(1, (Expression)new Constant((Object)"param1"));
        storedQuery.setParameter(parameter);
        From from = new From();
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)storedQuery);
        from.addClause((FromClause)sfc);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("x.a"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("exec proc1('param1')", "EXEC proc1('param1')", (Command)storedQuery);
    }

    public void testStoredQuerySubqueryMultipleParens() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        SPParameter parameter = new SPParameter(1, (Expression)new Constant((Object)"param1"));
        storedQuery.setParameter(parameter);
        From from = new From();
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)storedQuery);
        from.addClause((FromClause)sfc);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("x.a"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT X.A FROM ((exec proc1('param1'))) AS X", "SELECT X.A FROM (EXEC proc1('param1')) AS X", (Command)query);
    }

    @Test
    public void testErrorStatement() throws Exception {
        RaiseErrorStatement errStmt = new RaiseErrorStatement((Expression)new Constant((Object)"Test only"));
        this.helpStmtTest("ERROR 'Test only';", "ERROR 'Test only';", (Statement)errStmt);
    }

    @Test
    public void testIfStatement() throws Exception {
        ElementSymbol a = new ElementSymbol("a");
        String shortType = new String("short");
        DeclareStatement ifStmt = new DeclareStatement(a, shortType);
        ElementSymbol b = new ElementSymbol("b");
        DeclareStatement elseStmt = new DeclareStatement(b, shortType);
        Block ifBlock = new Block();
        ifBlock.addStatement((Statement)ifStmt);
        Block elseBlock = new Block();
        elseBlock.addStatement((Statement)elseStmt);
        ElementSymbol c = new ElementSymbol("c");
        CompareCriteria crit = new CompareCriteria((Expression)c, 1, (Expression)new Constant((Object)new Integer(5)));
        IfStatement stmt = new IfStatement((Criteria)crit, ifBlock, elseBlock);
        this.helpStmtTest("IF(c = 5) BEGIN DECLARE short a; END ELSE BEGIN DECLARE short b; END", "IF(c = 5)\nBEGIN\nDECLARE short a;\nEND\nELSE\nBEGIN\nDECLARE short b;\nEND", (Statement)stmt);
    }

    @Test
    public void testAssignStatement() throws Exception {
        ElementSymbol a = new ElementSymbol("a");
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(new ElementSymbol("a1"));
        Select select = new Select(symbols);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        CompareCriteria criteria = new CompareCriteria((Expression)new ElementSymbol("a2"), 1, (Expression)new Constant((Object)new Integer(5)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)criteria);
        Constant expr = new Constant((Object)"aString");
        AssignmentStatement queryStmt = new AssignmentStatement(a, (QueryCommand)query);
        AssignmentStatement exprStmt = new AssignmentStatement(a, (Expression)expr);
        this.helpStmtTest("a = SELECT a1 FROM g WHERE a2 = 5;", "a = (SELECT a1 FROM g WHERE a2 = 5);", (Statement)queryStmt);
        this.helpStmtTest("a = 'aString';", "a = 'aString';", (Statement)exprStmt);
    }

    @Test
    public void testDeclareStatement() throws Exception {
        ElementSymbol a = new ElementSymbol("a");
        String type = new String("short");
        DeclareStatement stmt = new DeclareStatement(a, type);
        this.helpStmtTest("DECLARE short a;", "DECLARE short a;", (Statement)stmt);
    }

    @Test
    public void testDeclareStatementWithAssignment() throws Exception {
        ElementSymbol a = new ElementSymbol("a");
        String type = new String("short");
        DeclareStatement stmt = new DeclareStatement(a, type, (Expression)new Constant(null));
        this.helpStmtTest("DECLARE short a = null;", "DECLARE short a = null;", (Statement)stmt);
    }

    @Test
    public void testDeclareStatementWithAssignment1() throws Exception {
        ElementSymbol a = new ElementSymbol("a");
        String type = new String("string");
        DeclareStatement stmt = new DeclareStatement(a, type, (Expression)new ScalarSubquery((QueryCommand)this.sampleQuery()));
        this.helpStmtTest("DECLARE string a = SELECT a1 FROM g WHERE a2 = 5;", "DECLARE string a = (SELECT a1 FROM g WHERE a2 = 5);", (Statement)stmt);
    }

    @Test
    public void testStatement() throws Exception {
        DeclareStatement declStmt;
        ElementSymbol a = new ElementSymbol("a");
        String type = new String("short");
        DeclareStatement stmt = declStmt = new DeclareStatement(a, type);
        this.helpStmtTest("DECLARE short a;", "DECLARE short a;", (Statement)stmt);
    }

    @Test
    public void testBlock() throws Exception {
        DeclareStatement declStmt;
        ElementSymbol a = new ElementSymbol("a");
        String type = new String("short");
        DeclareStatement stmt = declStmt = new DeclareStatement(a, type);
        Block block = new Block((Statement)stmt);
        this.helpBlockTest("BEGIN DECLARE short a; END", "BEGIN\nDECLARE short a;\nEND", block);
    }

    @Test
    public void testCommandStatement() throws Exception {
        Query query;
        Query sqlCmd = query = this.sampleQuery();
        CommandStatement cmdStmt = new CommandStatement((Command)sqlCmd);
        this.helpStmtTest("SELECT a1 FROM g WHERE a2 = 5;", "SELECT a1 FROM g WHERE a2 = 5;", (Statement)cmdStmt);
    }

    private Query sampleQuery() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(new ElementSymbol("a1"));
        Select select = new Select(symbols);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        CompareCriteria criteria = new CompareCriteria((Expression)new ElementSymbol("a2"), 1, (Expression)new Constant((Object)new Integer(5)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)criteria);
        return query;
    }

    @Test
    public void testDynamicCommandStatement() throws Exception {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        ElementSymbol a1 = new ElementSymbol("a1");
        a1.setType(DataTypeManager.DefaultDataClasses.STRING);
        symbols.add(a1);
        DynamicCommand sqlCmd = new DynamicCommand();
        Constant sql = new Constant((Object)"SELECT a1 FROM g WHERE a2 = 5");
        sqlCmd.setSql((Expression)sql);
        sqlCmd.setAsColumns(symbols);
        sqlCmd.setAsClauseSet(true);
        sqlCmd.setIntoGroup(new GroupSymbol("#g"));
        CommandStatement cmdStmt = new CommandStatement((Command)sqlCmd);
        this.helpStmtTest("exec string 'SELECT a1 FROM g WHERE a2 = 5' as a1 string into #g;", "EXECUTE IMMEDIATE 'SELECT a1 FROM g WHERE a2 = 5' AS a1 string INTO #g;", (Statement)cmdStmt);
    }

    @Test
    public void testDynamicCommandStatement1() throws Exception {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        ElementSymbol a1 = new ElementSymbol("a1");
        a1.setType(DataTypeManager.DefaultDataClasses.STRING);
        symbols.add(a1);
        ElementSymbol a2 = new ElementSymbol("a2");
        a1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        symbols.add(a2);
        DynamicCommand sqlCmd = new DynamicCommand();
        ElementSymbol sql = new ElementSymbol("z");
        sqlCmd.setSql((Expression)sql);
        sqlCmd.setAsColumns(symbols);
        sqlCmd.setAsClauseSet(true);
        sqlCmd.setIntoGroup(new GroupSymbol("#g"));
        sqlCmd.setUpdatingModelCount(1);
        CommandStatement cmdStmt = new CommandStatement((Command)sqlCmd);
        this.helpStmtTest("execute IMMEDIATE z as a1 string, a2 integer into #g update 1;", "EXECUTE IMMEDIATE z AS a1 string, a2 integer INTO #g UPDATE 1;", (Statement)cmdStmt);
    }

    @Test
    public void testDynamicCommandStatementWithUsing() throws Exception {
        SetClauseList using = new SetClauseList();
        ElementSymbol a = new ElementSymbol("a");
        using.addClause(a, (Expression)new ElementSymbol("b"));
        DynamicCommand sqlCmd = new DynamicCommand();
        ElementSymbol sql = new ElementSymbol("z");
        sqlCmd.setSql((Expression)sql);
        sqlCmd.setUsing(using);
        CommandStatement cmdStmt = new CommandStatement((Command)sqlCmd);
        this.helpStmtTest("execute immediate z using a=b;", "EXECUTE IMMEDIATE z USING a = b;", (Statement)cmdStmt);
    }

    @Test
    public void testDynamicCommandStatement2() {
        TestParser.helpException("create virtual procedure begin execute string z as variables.a1 string, a2 integer into #g; end");
    }

    @Test
    public void testDynamicCommandStatement3() {
        TestParser.helpException("create virtual procedure begin execute string z as a1 string, a2 integer into #g using variables.x=variables.y; end", "TEIID31100 Parsing error: Invalid simple identifier format: [variables.x]");
    }

    @Test
    public void testDynamicCommandStatement4() {
        TestParser.helpException("create virtual procedure begin execute string z into #g using x=variables.y; end");
    }

    @Test
    public void testSubquerySetCriteria0() {
        Query outer = TestParser.exampleIn(false);
        TestParser.helpTest("SELECT a FROM db.g WHERE b IN (SELECT a FROM db.g WHERE a2 = 5)", "SELECT a FROM db.g WHERE b IN (SELECT a FROM db.g WHERE a2 = 5)", (Command)outer);
    }

    static Query exampleIn(boolean semiJoin) {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        ElementSymbol expr = new ElementSymbol("b");
        CompareCriteria criteria = new CompareCriteria((Expression)new ElementSymbol("a2"), 1, (Expression)new Constant((Object)new Integer(5)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)criteria);
        SubquerySetCriteria subCrit = new SubquerySetCriteria((Expression)expr, (QueryCommand)query);
        subCrit.getSubqueryHint().setMergeJoin(semiJoin);
        Query outer = new Query();
        outer.setSelect(select);
        outer.setFrom(from);
        outer.setCriteria((Criteria)subCrit);
        return outer;
    }

    @Test
    public void testSubquerySetCriteria1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        ElementSymbol expr = new ElementSymbol("b");
        CompareCriteria criteria = new CompareCriteria((Expression)new ElementSymbol("a2"), 1, (Expression)new Constant((Object)new Integer(5)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)criteria);
        SubquerySetCriteria subCrit = new SubquerySetCriteria((Expression)expr, (QueryCommand)query);
        subCrit.setNegated(true);
        Query outer = new Query();
        outer.setSelect(select);
        outer.setFrom(from);
        outer.setCriteria((Criteria)subCrit);
        TestParser.helpTest("SELECT a FROM db.g WHERE b NOT IN (SELECT a FROM db.g WHERE a2 = 5)", "SELECT a FROM db.g WHERE b NOT IN (SELECT a FROM db.g WHERE a2 = 5)", (Command)outer);
    }

    @Test
    public void testSubquerySetCriteriaWithExec() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        ElementSymbol expr = new ElementSymbol("b");
        StoredProcedure exec = new StoredProcedure();
        exec.setProcedureName("m.sq1");
        Query query = new Query(new Select(Arrays.asList(new MultipleElementSymbol())), new From(Arrays.asList(new SubqueryFromClause("x", (Command)exec))), null, null, null);
        SubquerySetCriteria subCrit = new SubquerySetCriteria((Expression)expr, (QueryCommand)query);
        Query outer = new Query();
        outer.setSelect(select);
        outer.setFrom(from);
        outer.setCriteria((Criteria)subCrit);
        TestParser.helpTest("SELECT a FROM db.g WHERE b IN (EXEC m.sq1())", "SELECT a FROM db.g WHERE b IN (SELECT * FROM (EXEC m.sq1()) AS x)", (Command)outer);
    }

    @Test
    public void testSubquerySetCriteriaWithUnion() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("a"));
        ElementSymbol expr = new ElementSymbol("b");
        Query u1 = new Query();
        Select u1s = new Select();
        u1s.addSymbol((Expression)new ElementSymbol("x1"));
        u1.setSelect(u1s);
        From u1f = new From();
        u1f = new From();
        u1f.addClause((FromClause)new UnaryFromClause(new GroupSymbol("db.g2")));
        u1.setFrom(u1f);
        Query u2 = new Query();
        Select u2s = new Select();
        u2s.addSymbol((Expression)new ElementSymbol("x2"));
        u2.setSelect(u2s);
        From u2f = new From();
        u2f = new From();
        u2f.addClause((FromClause)new UnaryFromClause(new GroupSymbol("db.g3")));
        u2.setFrom(u2f);
        SetQuery union = new SetQuery(SetQuery.Operation.UNION, true, (QueryCommand)u1, (QueryCommand)u2);
        SubquerySetCriteria subCrit = new SubquerySetCriteria((Expression)expr, (QueryCommand)union);
        Query outer = new Query();
        outer.setSelect(select);
        outer.setFrom(from);
        outer.setCriteria((Criteria)subCrit);
        TestParser.helpTest("SELECT a FROM db.g WHERE b IN (SELECT x1 FROM db.g2 UNION ALL SELECT x2 FROM db.g3)", "SELECT a FROM db.g WHERE b IN (SELECT x1 FROM db.g2 UNION ALL SELECT x2 FROM db.g3)", (Command)outer);
    }

    @Test
    public void testVariablesInExec() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        SPParameter parameter = new SPParameter(1, (Expression)new ElementSymbol("param1"));
        parameter.setParameterType(1);
        storedQuery.setParameter(parameter);
        TestParser.helpTest("Exec proc1(param1)", "EXEC proc1(param1)", (Command)storedQuery);
        TestParser.helpTest("execute proc1(param1)", "EXEC proc1(param1)", (Command)storedQuery);
    }

    @Test
    public void testExecSubquery() {
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        from.addClause((FromClause)new UnaryFromClause(new GroupSymbol("newModel2.Table1")));
        StoredProcedure subquery = new StoredProcedure();
        subquery.setProcedureName("NewVirtual.StoredQuery");
        from.addClause((FromClause)new SubqueryFromClause("a", (Command)subquery));
        query.setFrom(from);
        TestParser.helpTest("SELECT * FROM newModel2.Table1, (EXEC NewVirtual.StoredQuery()) AS a", "SELECT * FROM newModel2.Table1, (EXEC NewVirtual.StoredQuery()) AS a", (Command)query);
    }

    @Test
    public void testUnicode1() {
        try {
            byte[] data = new byte[]{-48, -100, -48, -66, -47, -127, -48, -70, -48, -78, -48, -80};
            String string = new String(data, "UTF-8");
            String sql = "SELECT * FROM TestDocument.TestDocument WHERE Subject='" + string + "'";
            Query query = new Query();
            Select select = new Select();
            select.addSymbol((Expression)new MultipleElementSymbol());
            query.setSelect(select);
            From from = new From();
            from.addGroup(new GroupSymbol("TestDocument.TestDocument"));
            query.setFrom(from);
            CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("Subject"), 1, (Expression)new Constant((Object)string));
            query.setCriteria((Criteria)crit);
            TestParser.helpTest(sql, query.toString(), (Command)query);
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnicode2() {
        String sql = "SELECT * FROM TestDocument.TestDocument WHERE Subject='AZ'";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("TestDocument.TestDocument"));
        query.setFrom(from);
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("Subject"), 1, (Expression)new Constant((Object)"AZ"));
        query.setCriteria((Criteria)crit);
        TestParser.helpTest(sql, query.toString(), (Command)query);
    }

    @Test
    public void testUnicode3() {
        String sql = "SELECT '\u05e0'";
        Query query = new Query();
        Select select = new Select();
        Constant c = new Constant((Object)"\u05e0");
        select.addSymbol((Expression)c);
        query.setSelect(select);
        TestParser.helpTest(sql, query.toString(), (Command)query);
    }

    @Test
    public void testUnicode4() {
        String sql = "SELECT \u05e0 FROM g";
        Query query = new Query();
        Select select = new Select();
        ElementSymbol e = new ElementSymbol("\u05e0");
        select.addSymbol((Expression)e);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest(sql, query.toString(), (Command)query);
    }

    @Test
    public void testEscapedFunction1() {
        String sql = "SELECT * FROM a.thing WHERE e1 = {fn concat('a', 'b')}";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("a.thing"));
        query.setFrom(from);
        Function function = new Function("concat", new Expression[]{new Constant((Object)"a"), new Constant((Object)"b")});
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)function);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest(sql, "SELECT * FROM a.thing WHERE e1 = concat('a', 'b')", (Command)query);
    }

    @Test
    public void testEscapedFunction2() {
        String sql = "SELECT * FROM a.thing WHERE e1 = {fn convert(5, string)}";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("a.thing"));
        query.setFrom(from);
        Function function = new Function("convert", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)"string")});
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)function);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest(sql, "SELECT * FROM a.thing WHERE e1 = convert(5, string)", (Command)query);
    }

    @Test
    public void testEscapedFunction3() {
        String sql = "SELECT * FROM a.thing WHERE e1 = {fn cast(5 as string)}";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("a.thing"));
        query.setFrom(from);
        Function function = new Function("cast", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)"string")});
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)function);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest(sql, "SELECT * FROM a.thing WHERE e1 = cast(5 AS string)", (Command)query);
    }

    @Test
    public void testEscapedFunction4() {
        String sql = "SELECT * FROM a.thing WHERE e1 = {fn concat({fn concat('a', 'b')}, 'c')}";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("a.thing"));
        query.setFrom(from);
        Function func1 = new Function("concat", new Expression[]{new Constant((Object)"a"), new Constant((Object)"b")});
        Function func2 = new Function("concat", new Expression[]{func1, new Constant((Object)"c")});
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)func2);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest(sql, "SELECT * FROM a.thing WHERE e1 = concat(concat('a', 'b'), 'c')", (Command)query);
    }

    @Test
    public void testFunctionWithUnderscore() {
        String sql = "SELECT yowza_yowza() FROM a.thing";
        Query query = new Query();
        Select select = new Select();
        Function func1 = new Function("yowza_yowza", new Expression[0]);
        select.addSymbol((Expression)func1);
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("a.thing"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT yowza_yowza() FROM a.thing", (Command)query);
    }

    @Test
    public void testManyInnerJoins1() {
        String sql = "SELECT * FROM SQL1.dbo.Customers INNER JOIN SQL1.dbo.Orders ON SQL1.dbo.Customers.CustomerID = SQL1.dbo.Orders.CustomerID INNER JOIN SQL1.dbo.order_details ON SQL1.dbo.Orders.OrderID = SQL1.dbo.order_details.OrderID";
        String sqlExpected = "SELECT * FROM (SQL1.dbo.Customers INNER JOIN SQL1.dbo.Orders ON SQL1.dbo.Customers.CustomerID = SQL1.dbo.Orders.CustomerID) INNER JOIN SQL1.dbo.order_details ON SQL1.dbo.Orders.OrderID = SQL1.dbo.order_details.OrderID";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        GroupSymbol g1 = new GroupSymbol("SQL1.dbo.Customers");
        GroupSymbol g2 = new GroupSymbol("SQL1.dbo.Orders");
        GroupSymbol g3 = new GroupSymbol("SQL1.dbo.order_details");
        ElementSymbol e1 = new ElementSymbol("SQL1.dbo.Customers.CustomerID");
        ElementSymbol e2 = new ElementSymbol("SQL1.dbo.Orders.CustomerID");
        ElementSymbol e3 = new ElementSymbol("SQL1.dbo.Orders.OrderID");
        ElementSymbol e4 = new ElementSymbol("SQL1.dbo.order_details.OrderID");
        ArrayList<CompareCriteria> jcrits1 = new ArrayList<CompareCriteria>();
        jcrits1.add(new CompareCriteria((Expression)e1, 1, (Expression)e2));
        ArrayList<CompareCriteria> jcrits2 = new ArrayList<CompareCriteria>();
        jcrits2.add(new CompareCriteria((Expression)e3, 1, (Expression)e4));
        JoinPredicate jp1 = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, jcrits1);
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp1, (FromClause)new UnaryFromClause(g3), JoinType.JOIN_INNER, jcrits2);
        from.addClause((FromClause)jp2);
        query.setFrom(from);
        TestParser.helpTest(sql, sqlExpected, (Command)query);
    }

    @Test
    public void testManyInnerJoins2() {
        String sql = "SELECT * FROM A INNER JOIN (B RIGHT OUTER JOIN C ON b1 = c1) ON a1 = b1 INNER JOIN D ON a1 = d1";
        String sqlExpected = "SELECT * FROM (A INNER JOIN (B RIGHT OUTER JOIN C ON b1 = c1) ON a1 = b1) INNER JOIN D ON a1 = d1";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("A"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("B"));
        UnaryFromClause g3 = new UnaryFromClause(new GroupSymbol("C"));
        UnaryFromClause g4 = new UnaryFromClause(new GroupSymbol("D"));
        ElementSymbol e1 = new ElementSymbol("a1");
        ElementSymbol e2 = new ElementSymbol("b1");
        ElementSymbol e3 = new ElementSymbol("c1");
        ElementSymbol e4 = new ElementSymbol("d1");
        ArrayList<CompareCriteria> jcrits1 = new ArrayList<CompareCriteria>();
        jcrits1.add(new CompareCriteria((Expression)e1, 1, (Expression)e2));
        ArrayList<CompareCriteria> jcrits2 = new ArrayList<CompareCriteria>();
        jcrits2.add(new CompareCriteria((Expression)e2, 1, (Expression)e3));
        ArrayList<CompareCriteria> jcrits3 = new ArrayList<CompareCriteria>();
        jcrits3.add(new CompareCriteria((Expression)e1, 1, (Expression)e4));
        JoinPredicate jp1 = new JoinPredicate((FromClause)g2, (FromClause)g3, JoinType.JOIN_RIGHT_OUTER, jcrits2);
        JoinPredicate jp2 = new JoinPredicate((FromClause)g1, (FromClause)jp1, JoinType.JOIN_INNER, jcrits1);
        JoinPredicate jp3 = new JoinPredicate((FromClause)jp2, (FromClause)g4, JoinType.JOIN_INNER, jcrits3);
        from.addClause((FromClause)jp3);
        query.setFrom(from);
        TestParser.helpTest(sql, sqlExpected, (Command)query);
    }

    @Test
    public void testManyInnerJoins3() {
        String sql = "SELECT * FROM A INNER JOIN (B RIGHT OUTER JOIN C ON b1 = c1 CROSS JOIN D) ON a1 = d1";
        String sqlExpected = "SELECT * FROM A INNER JOIN ((B RIGHT OUTER JOIN C ON b1 = c1) CROSS JOIN D) ON a1 = d1";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause g1 = new UnaryFromClause(new GroupSymbol("A"));
        UnaryFromClause g2 = new UnaryFromClause(new GroupSymbol("B"));
        UnaryFromClause g3 = new UnaryFromClause(new GroupSymbol("C"));
        UnaryFromClause g4 = new UnaryFromClause(new GroupSymbol("D"));
        ElementSymbol e1 = new ElementSymbol("a1");
        ElementSymbol e2 = new ElementSymbol("b1");
        ElementSymbol e3 = new ElementSymbol("c1");
        ElementSymbol e4 = new ElementSymbol("d1");
        ArrayList<CompareCriteria> jcrits1 = new ArrayList<CompareCriteria>();
        jcrits1.add(new CompareCriteria((Expression)e2, 1, (Expression)e3));
        ArrayList<CompareCriteria> jcrits2 = new ArrayList<CompareCriteria>();
        jcrits2.add(new CompareCriteria((Expression)e1, 1, (Expression)e4));
        JoinPredicate jp1 = new JoinPredicate((FromClause)g2, (FromClause)g3, JoinType.JOIN_RIGHT_OUTER, jcrits1);
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp1, (FromClause)g4, JoinType.JOIN_CROSS);
        JoinPredicate jp3 = new JoinPredicate((FromClause)g1, (FromClause)jp2, JoinType.JOIN_INNER, jcrits2);
        from.addClause((FromClause)jp3);
        query.setFrom(from);
        TestParser.helpTest(sql, sqlExpected, (Command)query);
    }

    @Test
    public void testLoopStatement() throws Exception {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol c1 = new ElementSymbol("c1", false);
        select.addSymbol((Expression)c1);
        select.addSymbol((Expression)new ElementSymbol("c2", false));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        ElementSymbol x = new ElementSymbol("x");
        String intType = new String("integer");
        DeclareStatement dStmt = new DeclareStatement(x, intType);
        c1 = new ElementSymbol("mycursor.c1", true);
        AssignmentStatement assignmentStmt = new AssignmentStatement(x, (Expression)c1);
        Block block = new Block();
        block.addStatement((Statement)dStmt);
        block.addStatement((Statement)assignmentStmt);
        String cursor = "mycursor";
        LoopStatement loopStmt = new LoopStatement(block, (Command)query, cursor);
        this.helpStmtTest("LOOP ON (SELECT c1, c2 FROM m.g) AS mycursor BEGIN DECLARE integer x; x=mycursor.c1; END", "LOOP ON (SELECT c1, c2 FROM m.g) AS mycursor\nBEGIN\nDECLARE integer x;\nx = mycursor.c1;\nEND", (Statement)loopStmt);
    }

    @Test
    public void testLoopStatementWithOrderBy() throws Exception {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol c1 = new ElementSymbol("c1", false);
        select.addSymbol((Expression)c1);
        select.addSymbol((Expression)new ElementSymbol("c2", false));
        OrderBy orderBy = new OrderBy();
        orderBy.addVariable((Expression)c1);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOrderBy(orderBy);
        ElementSymbol x = new ElementSymbol("x");
        String intType = new String("integer");
        DeclareStatement dStmt = new DeclareStatement(x, intType);
        c1 = new ElementSymbol("mycursor.c1", true);
        AssignmentStatement assignmentStmt = new AssignmentStatement(x, (Expression)c1);
        Block block = new Block();
        block.addStatement((Statement)dStmt);
        block.addStatement((Statement)assignmentStmt);
        String cursor = "mycursor";
        LoopStatement loopStmt = new LoopStatement(block, (Command)query, cursor);
        this.helpStmtTest("LOOP ON (SELECT c1, c2 FROM m.g ORDER BY c1) AS mycursor BEGIN DECLARE integer x; x=mycursor.c1; END", "LOOP ON (SELECT c1, c2 FROM m.g ORDER BY c1) AS mycursor\nBEGIN\nDECLARE integer x;\nx = mycursor.c1;\nEND", (Statement)loopStmt);
    }

    @Test
    public void testWhileStatement() throws Exception {
        ElementSymbol x = new ElementSymbol("x", false);
        Function f = new Function("+", new Expression[]{x, new Constant((Object)new Integer(1))});
        AssignmentStatement assignmentStmt = new AssignmentStatement(x, (Expression)f);
        Block block = new Block();
        block.addStatement((Statement)assignmentStmt);
        CompareCriteria crit = new CompareCriteria((Expression)x, 3, (Expression)new Constant((Object)new Integer(100)));
        WhileStatement whileStmt = new WhileStatement((Criteria)crit, block);
        this.helpStmtTest("WHILE (x < 100) BEGIN x=x+1; END", "WHILE(x < 100)\nBEGIN\nx = (x + 1);\nEND", (Statement)whileStmt);
    }

    @Test
    public void testWhileStatement1() throws Exception {
        ElementSymbol x = new ElementSymbol("x", false);
        Function f = new Function("+", new Expression[]{x, new Constant((Object)new Integer(1))});
        AssignmentStatement assignmentStmt = new AssignmentStatement(x, (Expression)f);
        Block block = new Block();
        block.setAtomic(true);
        block.setLabel("1y");
        block.addStatement((Statement)assignmentStmt);
        BranchingStatement bs = new BranchingStatement(BranchingStatement.BranchingMode.CONTINUE);
        bs.setLabel("1y");
        block.addStatement((Statement)bs);
        CompareCriteria crit = new CompareCriteria((Expression)x, 3, (Expression)new Constant((Object)new Integer(100)));
        WhileStatement whileStmt = new WhileStatement((Criteria)crit, block);
        this.helpStmtTest("WHILE (x < 100) \"1y\": BEGIN ATOMIC x=x+1; CONTINUE \"1y\"; END", "WHILE(x < 100)\n\"1y\" : BEGIN ATOMIC\nx = (x + 1);\nCONTINUE \"1y\";\nEND", (Statement)whileStmt);
    }

    @Test
    public void testBreakStatement() throws Exception {
        BranchingStatement breakStmt = new BranchingStatement();
        this.helpStmtTest("break;", "BREAK;", (Statement)breakStmt);
    }

    @Test
    public void testContinueStatement() throws Exception {
        BranchingStatement contStmt = new BranchingStatement(BranchingStatement.BranchingMode.CONTINUE);
        this.helpStmtTest("continue;", "CONTINUE;", (Statement)contStmt);
    }

    @Test
    public void testContinueStatement1() throws Exception {
        BranchingStatement contStmt = new BranchingStatement(BranchingStatement.BranchingMode.CONTINUE);
        contStmt.setLabel("x");
        this.helpStmtTest("continue x;", "CONTINUE x;", (Statement)contStmt);
    }

    @Test
    public void testVirtualProcedure() {
        ElementSymbol x = new ElementSymbol("x");
        String intType = new String("integer");
        DeclareStatement dStmt = new DeclareStatement(x, intType);
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol c1 = new ElementSymbol("c1", false);
        select.addSymbol((Expression)c1);
        select.addSymbol((Expression)new ElementSymbol("c2", false));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        x = new ElementSymbol("x");
        c1 = new ElementSymbol("mycursor.c1", true);
        AssignmentStatement assignmentStmt = new AssignmentStatement(x, (Expression)c1);
        Block block = new Block();
        block.addStatement((Statement)assignmentStmt);
        Block ifBlock = new Block();
        BranchingStatement continueStmt = new BranchingStatement(BranchingStatement.BranchingMode.CONTINUE);
        ifBlock.addStatement((Statement)continueStmt);
        CompareCriteria crit = new CompareCriteria((Expression)x, 4, (Expression)new Constant((Object)new Integer(5)));
        IfStatement ifStmt = new IfStatement((Criteria)crit, ifBlock);
        block.addStatement((Statement)ifStmt);
        String cursor = "mycursor";
        LoopStatement loopStmt = new LoopStatement(block, (Command)query, cursor);
        block = new Block();
        block.addStatement((Statement)dStmt);
        block.addStatement((Statement)loopStmt);
        CommandStatement cmdStmt = new CommandStatement((Command)query);
        block.addStatement((Statement)cmdStmt);
        CreateProcedureCommand virtualProcedureCommand = new CreateProcedureCommand();
        virtualProcedureCommand.setBlock(block);
        TestParser.helpTest("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT c1, c2 FROM m.g) AS mycursor BEGIN x=mycursor.c1; IF(x > 5) BEGIN CONTINUE; END END SELECT c1, c2 FROM m.g; END", "CREATE VIRTUAL PROCEDURE\nBEGIN\nDECLARE integer x;\nLOOP ON (SELECT c1, c2 FROM m.g) AS mycursor\nBEGIN\nx = mycursor.c1;\nIF(x > 5)\nBEGIN\nCONTINUE;\nEND\nEND\nSELECT c1, c2 FROM m.g;\nEND", (Command)virtualProcedureCommand);
    }

    @Test
    public void testScalarSubqueryExpressionInSelect() {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        s2.addSymbol((Expression)new ScalarSubquery((QueryCommand)q1));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        TestParser.helpTest("SELECT e1, (SELECT e1 FROM m.g1) FROM m.g2", "SELECT e1, (SELECT e1 FROM m.g1) FROM m.g2", (Command)q2);
    }

    @Test
    public void testScalarSubqueryExpressionInSelect2() {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((Expression)new ScalarSubquery((QueryCommand)q1));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        TestParser.helpTest("SELECT (SELECT e1 FROM m.g1) FROM m.g2", "SELECT (SELECT e1 FROM m.g1) FROM m.g2", (Command)q2);
    }

    @Test
    public void testScalarSubqueryExpressionInSelect3() {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((Expression)new ScalarSubquery((QueryCommand)q1));
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        TestParser.helpTest("SELECT (SELECT e1 FROM m.g1), e1 FROM m.g2", "SELECT (SELECT e1 FROM m.g1), e1 FROM m.g2", (Command)q2);
    }

    @Test
    public void testScalarSubqueryExpressionWithAlias() {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        s2.addSymbol((Expression)new AliasSymbol("X", (Expression)new ScalarSubquery((QueryCommand)q1)));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        TestParser.helpTest("SELECT e1, (SELECT e1 FROM m.g1) as X FROM m.g2", "SELECT e1, (SELECT e1 FROM m.g1) AS X FROM m.g2", (Command)q2);
    }

    @Test
    public void testScalarSubqueryExpressionInComplexExpression() throws QueryParserException {
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        s2.addSymbol((Expression)new AliasSymbol("X", QueryParser.getQueryParser().parseExpression("(SELECT e1 FROM m.g1) + 2")));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        TestParser.helpTest("SELECT e1, ((SELECT e1 FROM m.g1) + 2) as X FROM m.g2", "SELECT e1, ((SELECT e1 FROM m.g1) + 2) AS X FROM m.g2", (Command)q2);
    }

    @Test
    public void testScalarSubqueryExpressionInComplexExpression2() throws QueryParserException {
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        s2.addSymbol((Expression)new AliasSymbol("X", QueryParser.getQueryParser().parseExpression("3 + (SELECT e1 FROM m.g1)")));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        TestParser.helpTest("SELECT e1, (3 + (SELECT e1 FROM m.g1)) as X FROM m.g2", "SELECT e1, (3 + (SELECT e1 FROM m.g1)) AS X FROM m.g2", (Command)q2);
    }

    @Test
    public void testScalarSubqueryExpressionInComplexExpression3() throws QueryParserException {
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        s2.addSymbol((Expression)new AliasSymbol("X", QueryParser.getQueryParser().parseExpression("(SELECT e1 FROM m.g1) + (SELECT e3 FROM m.g3)")));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        TestParser.helpTest("SELECT e1, ((SELECT e1 FROM m.g1) + (SELECT e3 FROM m.g3)) as X FROM m.g2", "SELECT e1, ((SELECT e1 FROM m.g1) + (SELECT e3 FROM m.g3)) AS X FROM m.g2", (Command)q2);
    }

    @Test
    public void testScalarSubqueryExpressionInFunction() throws QueryParserException {
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        s2.addSymbol((Expression)new AliasSymbol("X", QueryParser.getQueryParser().parseExpression("length((SELECT e1 FROM m.g1))")));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        TestParser.helpTest("SELECT e1, length((SELECT e1 FROM m.g1)) as X FROM m.g2", "SELECT e1, length((SELECT e1 FROM m.g1)) AS X FROM m.g2", (Command)q2);
    }

    @Test
    public void testBadScalarSubqueryExpression() {
        TestParser.helpException("SELECT e1, length(SELECT e1 FROM m.g1) as X FROM m.g2");
    }

    @Test
    public void testExistsPredicateCriteria() {
        Query q2 = TestParser.exampleExists(false);
        TestParser.helpTest("SELECT e1 FROM m.g2 WHERE Exists (SELECT e1 FROM m.g1)", "SELECT e1 FROM m.g2 WHERE EXISTS (SELECT e1 FROM m.g1)", (Command)q2);
    }

    static Query exampleExists(boolean semiJoin) {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        ExistsCriteria existsCrit = new ExistsCriteria((QueryCommand)q1);
        existsCrit.getSubqueryHint().setMergeJoin(semiJoin);
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        q2.setCriteria((Criteria)existsCrit);
        return q2;
    }

    @Test
    public void testAnyQuantifierSubqueryComparePredicate() {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        SubqueryCompareCriteria left = new SubqueryCompareCriteria((Expression)new ElementSymbol("e3"), (QueryCommand)q1, 6, 3);
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        q2.setCriteria((Criteria)left);
        TestParser.helpTest("SELECT e1 FROM m.g2 WHERE e3 >= ANY (SELECT e1 FROM m.g1)", "SELECT e1 FROM m.g2 WHERE e3 >= ANY (SELECT e1 FROM m.g1)", (Command)q2);
    }

    @Test
    public void testSomeQuantifierSubqueryComparePredicate() {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        SubqueryCompareCriteria left = new SubqueryCompareCriteria((Expression)new ElementSymbol("e3"), (QueryCommand)q1, 4, 2);
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        q2.setCriteria((Criteria)left);
        TestParser.helpTest("SELECT e1 FROM m.g2 WHERE e3 > some (SELECT e1 FROM m.g1)", "SELECT e1 FROM m.g2 WHERE e3 > SOME (SELECT e1 FROM m.g1)", (Command)q2);
    }

    @Test
    public void testAllQuantifierSubqueryComparePredicate() {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        SubqueryCompareCriteria left = new SubqueryCompareCriteria((Expression)new ElementSymbol("e3"), (QueryCommand)q1, 1, 4);
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        q2.setCriteria((Criteria)left);
        TestParser.helpTest("SELECT e1 FROM m.g2 WHERE e3 = all (SELECT e1 FROM m.g1)", "SELECT e1 FROM m.g2 WHERE e3 = ALL (SELECT e1 FROM m.g1)", (Command)q2);
    }

    @Test
    public void testScalarSubqueryComparePredicate() {
        Select s1 = new Select();
        s1.addSymbol((Expression)new ElementSymbol("e1"));
        From f1 = new From();
        f1.addGroup(new GroupSymbol("m.g1"));
        Query q1 = new Query();
        q1.setSelect(s1);
        q1.setFrom(f1);
        Select s2 = new Select();
        s2.addSymbol((Expression)new ElementSymbol("e1"));
        From f2 = new From();
        f2.addGroup(new GroupSymbol("m.g2"));
        CompareCriteria left = new CompareCriteria((Expression)new ElementSymbol("e3"), 3, (Expression)new ScalarSubquery((QueryCommand)q1));
        Query q2 = new Query();
        q2.setSelect(s2);
        q2.setFrom(f2);
        q2.setCriteria((Criteria)left);
        TestParser.helpTest("SELECT e1 FROM m.g2 WHERE e3 < (SELECT e1 FROM m.g1)", "SELECT e1 FROM m.g2 WHERE e3 < (SELECT e1 FROM m.g1)", (Command)q2);
    }

    @Test
    public void testSelectInto() {
        GroupSymbol g = new GroupSymbol("m.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol c1 = new ElementSymbol("c1", false);
        select.addSymbol((Expression)c1);
        select.addSymbol((Expression)new ElementSymbol("c2", false));
        Into into = new Into(new GroupSymbol("#temp"));
        Query q = new Query();
        q.setSelect(select);
        q.setFrom(from);
        q.setInto(into);
        TestParser.helpTest("SELECT c1, c2 INTO #temp FROM m.g", "SELECT c1, c2 INTO #temp FROM m.g", (Command)q);
    }

    @Test
    public void testCaseExpression1() {
        CaseExpression expr = TestCaseExpression.example(4);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("y"));
        select.addSymbol((Expression)new ElementSymbol("z"));
        select.addSymbol((Expression)expr);
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        Query q = new Query();
        q.setSelect(select);
        q.setFrom(from);
        String query = new StringBuffer("SELECT y, z, ").append("CASE x").append(" WHEN 'a' THEN 0").append(" WHEN 'b' THEN 1").append(" WHEN 'c' THEN 2").append(" WHEN 'd' THEN 3").append(" ELSE 9999").append(" END").append(" FROM m.g").toString();
        TestParser.helpTest(query, query, (Command)q);
    }

    @Test
    public void testCaseExpression2() {
        CaseExpression expr = TestCaseExpression.example(4);
        expr.setElseExpression(null);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("y"));
        select.addSymbol((Expression)new ElementSymbol("z"));
        select.addSymbol((Expression)expr);
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        Query q = new Query();
        q.setSelect(select);
        q.setFrom(from);
        String query = new StringBuffer("SELECT y, z, ").append("CASE x").append(" WHEN 'a' THEN 0").append(" WHEN 'b' THEN 1").append(" WHEN 'c' THEN 2").append(" WHEN 'd' THEN 3").append(" END").append(" FROM m.g").toString();
        TestParser.helpTest(query, query, (Command)q);
    }

    @Test
    public void testCaseExpression3() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example2(4);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("y"));
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        CompareCriteria where = new CompareCriteria((Expression)new ElementSymbol("z"), 1, (Expression)expr);
        Query q = new Query();
        q.setSelect(select);
        q.setFrom(from);
        q.setCriteria((Criteria)where);
        String query = new StringBuffer("SELECT y FROM m.g ").append("WHERE z = CASE").append(" WHEN x = 'a' THEN 0").append(" WHEN x = 'b' THEN 1").append(" WHEN x = 'c' THEN 2").append(" WHEN x = 'd' THEN 3").append(" ELSE 9999").append(" END").toString();
        TestParser.helpTest(query, query, (Command)q);
    }

    @Test
    public void testSearchedCaseExpression1() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(4);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("y"));
        select.addSymbol((Expression)new ElementSymbol("z"));
        select.addSymbol((Expression)expr);
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        Query q = new Query();
        q.setSelect(select);
        q.setFrom(from);
        String query = new StringBuffer("SELECT y, z, ").append("CASE").append(" WHEN x = 0 THEN 0").append(" WHEN x = 1 THEN 1").append(" WHEN x = 2 THEN 2").append(" WHEN x = 3 THEN 3").append(" ELSE 9999").append(" END").append(" FROM m.g").toString();
        TestParser.helpTest(query, query, (Command)q);
    }

    @Test
    public void testSearchedCaseExpression2() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(4);
        expr.setElseExpression(null);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("y"));
        select.addSymbol((Expression)new ElementSymbol("z"));
        select.addSymbol((Expression)expr);
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        Query q = new Query();
        q.setSelect(select);
        q.setFrom(from);
        String query = new StringBuffer("SELECT y, z, ").append("CASE").append(" WHEN x = 0 THEN 0").append(" WHEN x = 1 THEN 1").append(" WHEN x = 2 THEN 2").append(" WHEN x = 3 THEN 3").append(" END").append(" FROM m.g").toString();
        TestParser.helpTest(query, query, (Command)q);
    }

    @Test
    public void testSearchedCaseExpression3() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(4);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("y"));
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        CompareCriteria where = new CompareCriteria((Expression)new ElementSymbol("z"), 1, (Expression)expr);
        Query q = new Query();
        q.setSelect(select);
        q.setFrom(from);
        q.setCriteria((Criteria)where);
        String query = new StringBuffer("SELECT y FROM m.g ").append("WHERE z = CASE").append(" WHEN x = 0 THEN 0").append(" WHEN x = 1 THEN 1").append(" WHEN x = 2 THEN 2").append(" WHEN x = 3 THEN 3").append(" ELSE 9999").append(" END").toString();
        TestParser.helpTest(query, query, (Command)q);
    }

    @Test
    public void testAndOrPrecedence_1575() {
        Select s = new Select();
        s.addSymbol((Expression)new MultipleElementSymbol());
        From f = new From();
        f.addGroup(new GroupSymbol("m.g1"));
        CompareCriteria c1 = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)new Integer(0)));
        CompareCriteria c2 = new CompareCriteria((Expression)new ElementSymbol("e2"), 1, (Expression)new Constant((Object)new Integer(1)));
        CompareCriteria c3 = new CompareCriteria((Expression)new ElementSymbol("e3"), 1, (Expression)new Constant((Object)new Integer(3)));
        CompoundCriteria cc1 = new CompoundCriteria(0, (Criteria)c2, (Criteria)c3);
        CompoundCriteria cc2 = new CompoundCriteria(1, (Criteria)c1, (Criteria)cc1);
        Query q = new Query();
        q.setSelect(s);
        q.setFrom(f);
        q.setCriteria((Criteria)cc2);
        TestParser.helpTest("SELECT * FROM m.g1 WHERE e1=0 OR e2=1 AND e3=3", "SELECT * FROM m.g1 WHERE (e1 = 0) OR ((e2 = 1) AND (e3 = 3))", (Command)q);
    }

    @Test
    public void testAndOrPrecedence2_1575() {
        Select s = new Select();
        s.addSymbol((Expression)new MultipleElementSymbol());
        From f = new From();
        f.addGroup(new GroupSymbol("m.g1"));
        CompareCriteria c1 = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)new Integer(0)));
        CompareCriteria c2 = new CompareCriteria((Expression)new ElementSymbol("e2"), 1, (Expression)new Constant((Object)new Integer(1)));
        CompareCriteria c3 = new CompareCriteria((Expression)new ElementSymbol("e3"), 1, (Expression)new Constant((Object)new Integer(3)));
        CompoundCriteria cc1 = new CompoundCriteria(0, (Criteria)c1, (Criteria)c2);
        CompoundCriteria cc2 = new CompoundCriteria(1, (Criteria)cc1, (Criteria)c3);
        Query q = new Query();
        q.setSelect(s);
        q.setFrom(f);
        q.setCriteria((Criteria)cc2);
        TestParser.helpTest("SELECT * FROM m.g1 WHERE e1=0 AND e2=1 OR e3=3", "SELECT * FROM m.g1 WHERE ((e1 = 0) AND (e2 = 1)) OR (e3 = 3)", (Command)q);
    }

    private void helpTestCompoundNonJoinCriteria(String sqlPred, PredicateCriteria predCrit) {
        Select s = new Select();
        s.addSymbol((Expression)new MultipleElementSymbol());
        From f = new From();
        CompareCriteria c1 = new CompareCriteria((Expression)new ElementSymbol("e1"), 1, (Expression)new Constant((Object)new Integer(0)));
        CompoundCriteria cc1 = new CompoundCriteria(0, (Criteria)c1, (Criteria)predCrit);
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(new GroupSymbol("m.g1")), (FromClause)new UnaryFromClause(new GroupSymbol("m.g2")), JoinType.JOIN_INNER, (Criteria)cc1);
        f.addClause((FromClause)jp);
        Query q = new Query();
        q.setSelect(s);
        q.setFrom(f);
        TestParser.helpTest("SELECT * FROM m.g1 JOIN m.g2 ON e1=0 AND " + sqlPred, "SELECT * FROM m.g1 INNER JOIN m.g2 ON e1 = 0 AND " + sqlPred, (Command)q);
    }

    @Test
    public void testCompoundNonJoinCriteriaInFromWithComparisonCriteria() {
        CompareCriteria c2 = new CompareCriteria((Expression)new ElementSymbol("e2"), 1, (Expression)new Constant((Object)new Integer(1)));
        this.helpTestCompoundNonJoinCriteria("e2 = 1", (PredicateCriteria)c2);
    }

    @Test
    public void testCompoundNonJoinCriteriaInFromWithIsNull() {
        this.helpTestCompoundNonJoinCriteria("e2 IS NULL", (PredicateCriteria)new IsNullCriteria((Expression)new ElementSymbol("e2")));
    }

    @Test
    public void testCompoundNonJoinCriteriaInFromUWithIN() {
        ArrayList<Constant> values = new ArrayList<Constant>();
        values.add(new Constant((Object)new Integer(0)));
        values.add(new Constant((Object)new Integer(1)));
        SetCriteria crit = new SetCriteria((Expression)new ElementSymbol("e2"), values);
        this.helpTestCompoundNonJoinCriteria("e2 IN (0, 1)", (PredicateCriteria)crit);
    }

    @Test
    public void testCompoundNonJoinCriteriaInFromUWithLIKE() {
        MatchCriteria crit = new MatchCriteria((Expression)new ElementSymbol("e2"), (Expression)new Constant((Object)"%"));
        this.helpTestCompoundNonJoinCriteria("e2 LIKE '%'", (PredicateCriteria)crit);
    }

    @Test
    public void testCompoundNonJoinCriteria_defect15167_1() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT A.alert_id, A.primary_entity_name, A.primary_entity_level_code, A.alert_description, A.create_date, A.alert_risk_score, S.scenario_name, A.alert_status_code, A.process_id, A.actual_values_text, S.SCENARIO_CATEGORY_DESC, A.primary_entity_number, A.scenario_id, A.primary_entity_key FROM (FSK_ALERT AS A LEFT OUTER JOIN FSK_SCENARIO AS S ON A.scenario_id = S.scenario_id) INNER JOIN FSC_ACCOUNT_DIM AS C ON A.primary_entity_key = C.ACCOUNT_KEY  AND ((S.current_ind = 'Y') OR (S.current_ind IS NULL)) WHERE (A.primary_entity_level_code = 'ACC') AND (C.ACCOUNT_KEY = 23923) AND (A.logical_delete_ind = 'N')");
    }

    @Test
    public void testCompoundNonJoinCriteria_defect15167_2() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT A.alert_id, A.primary_entity_name, A.primary_entity_level_code, A.alert_description, A.create_date, A.alert_risk_score, S.scenario_name, A.alert_status_code, A.process_id, A.actual_values_text, S.SCENARIO_CATEGORY_DESC, A.primary_entity_number, A.scenario_id, A.primary_entity_key FROM (FSK_ALERT AS A LEFT OUTER JOIN FSK_SCENARIO AS S ON A.scenario_id = S.scenario_id) INNER JOIN FSC_ACCOUNT_DIM AS C ON A.primary_entity_key = C.ACCOUNT_KEY  AND (S.current_ind = 'Y' OR S.current_ind IS NULL) WHERE (A.primary_entity_level_code = 'ACC') AND (C.ACCOUNT_KEY = 23923) AND (A.logical_delete_ind = 'N')");
    }

    @Test
    public void testCompoundNonJoinCriteria_defect15167_3() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT A.alert_id, A.primary_entity_name, A.primary_entity_level_code, A.alert_description, A.create_date, A.alert_risk_score, S.scenario_name, A.alert_status_code, A.process_id, A.actual_values_text, S.SCENARIO_CATEGORY_DESC, A.primary_entity_number, A.scenario_id, A.primary_entity_key FROM (FSK_ALERT AS A LEFT OUTER JOIN FSK_SCENARIO AS S ON A.scenario_id = S.scenario_id) INNER JOIN FSC_ACCOUNT_DIM AS C ON (A.primary_entity_key = C.ACCOUNT_KEY AND (S.current_ind = 'Y' OR S.current_ind IS NULL)) WHERE (A.primary_entity_level_code = 'ACC') AND (C.ACCOUNT_KEY = 23923) AND (A.logical_delete_ind = 'N')");
    }

    @Test
    public void testCompoundNonJoinCriteria_defect15167_4() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT A.alert_id, A.primary_entity_name, A.primary_entity_level_code, A.alert_description, A.create_date, A.alert_risk_score, S.scenario_name, A.alert_status_code, A.process_id, A.actual_values_text, S.SCENARIO_CATEGORY_DESC, A.primary_entity_number, A.scenario_id, A.primary_entity_key FROM (FSK_ALERT AS A LEFT OUTER JOIN FSK_SCENARIO AS S ON A.scenario_id = S.scenario_id) INNER JOIN FSC_ACCOUNT_DIM AS C ON (A.primary_entity_key = C.ACCOUNT_KEY AND S.current_ind = 'Y' OR S.current_ind IS NULL) WHERE (A.primary_entity_level_code = 'ACC') AND (C.ACCOUNT_KEY = 23923) AND (A.logical_delete_ind = 'N')");
    }

    @Test
    public void testFunctionInGroupBy() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT SUM(s), elem+1 FROM m.g GROUP BY elem+1");
    }

    @Test
    public void testCaseInGroupBy() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT SUM(elem+1), CASE elem WHEN 0 THEN 1 ELSE 2 END AS c FROM m.g GROUP BY CASE elem WHEN 0 THEN 1 ELSE 2 END");
    }

    @Test
    public void testNationCharString() throws Exception {
        Query query = (Query)QueryParser.getQueryParser().parseCommand("SELECT N'blah' FROM m.g");
        Select select = query.getSelect();
        Constant c = (Constant)SymbolMap.getExpression((Expression)select.getSymbol(0));
        Assert.assertEquals((Object)c, (Object)new Constant((Object)"blah"));
    }

    @Test
    public void testNationCharString2() throws Exception {
        Query query = (Query)QueryParser.getQueryParser().parseCommand("SELECT DISTINCT TABLE_QUALIFIER, NULL AS TABLE_OWNER, NULL AS TABLE_NAME, NULL AS TABLE_TYPE, NULL AS REMARKS FROM ATIODBCSYSTEM.OA_TABLES  WHERE TABLE_QUALIFIER LIKE N'%'  ESCAPE '\\'  ORDER BY TABLE_QUALIFIER  ");
        MatchCriteria matchCrit = (MatchCriteria)query.getCriteria();
        Constant c = (Constant)matchCrit.getRightExpression();
        Assert.assertEquals((Object)c, (Object)new Constant((Object)"%"));
    }

    @Test
    public void testScalarSubquery() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT (SELECT 1) FROM x");
    }

    @Test
    public void testElementInDoubleQuotes() throws Exception {
        GroupSymbol g = new GroupSymbol("x");
        From from = new From();
        from.addGroup(g);
        ElementSymbol e = new ElementSymbol("foo");
        Select select = new Select();
        select.addSymbol((Expression)e);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT \"foo\" FROM x", "SELECT foo FROM x", (Command)query);
    }

    @Test
    public void testElementInDoubleQuotes_Insert() throws Exception {
        GroupSymbol g = new GroupSymbol("x");
        From from = new From();
        from.addGroup(g);
        ElementSymbol e = new ElementSymbol("foo");
        Insert query = new Insert(g, new ArrayList(), new ArrayList());
        query.addVariable(e);
        query.addValue((Expression)new Constant((Object)"bar", String.class));
        TestParser.helpTest("insert into x (\"foo\") values ('bar')", "INSERT INTO x (foo) VALUES ('bar')", (Command)query);
    }

    @Test
    public void testElementInDoubleQuotes_Update() throws Exception {
        GroupSymbol g = new GroupSymbol("x");
        From from = new From();
        from.addGroup(g);
        ElementSymbol e = new ElementSymbol("foo");
        Update query = new Update();
        query.setGroup(g);
        query.addChange(e, (Expression)new Constant((Object)"bar", String.class));
        TestParser.helpTest("update x set \"foo\"='bar'", "UPDATE x SET foo = 'bar'", (Command)query);
    }

    @Test
    public void testElementInDoubleQuotes_delete() throws Exception {
        GroupSymbol g = new GroupSymbol("x");
        From from = new From();
        from.addGroup(g);
        ElementSymbol e = new ElementSymbol("foo");
        CompareCriteria c = new CompareCriteria((Expression)e, 1, (Expression)new Constant((Object)"bar", String.class));
        Delete query = new Delete(g, (Criteria)c);
        TestParser.helpTest("delete from x where \"foo\"='bar'", "DELETE FROM x WHERE foo = 'bar'", (Command)query);
    }

    @Test
    public void testAliasInDoubleQuotes() throws Exception {
        GroupSymbol g = new GroupSymbol("x");
        From from = new From();
        from.addGroup(g);
        AliasSymbol as = new AliasSymbol("fooAlias", (Expression)new ElementSymbol("fooKey"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT fooKey AS \"fooAlias\" FROM x", "SELECT fooKey AS fooAlias FROM x", (Command)query);
    }

    @Test
    public void testAliasInDoubleQuotesWithQuotedGroup() throws Exception {
        GroupSymbol g = new GroupSymbol("x.y.z");
        From from = new From();
        from.addGroup(g);
        AliasSymbol as = new AliasSymbol("fooAlias", (Expression)new ElementSymbol("fooKey"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        ElementSymbol a = new ElementSymbol("x.y.z.id");
        Constant c = new Constant((Object)new Integer(10));
        CompareCriteria crit = new CompareCriteria((Expression)a, 1, (Expression)c);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("SELECT fooKey AS \"fooAlias\" FROM \"x.y\".z where x.\"y.z\".id = 10", "SELECT fooKey AS fooAlias FROM x.y.z WHERE x.y.z.id = 10", (Command)query);
    }

    @Test
    public void testSingleQuotedConstant() throws Exception {
        GroupSymbol g = new GroupSymbol("x.y.z");
        From from = new From();
        from.addGroup(g);
        Constant as = new Constant((Object)"fooString");
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("SELECT 'fooString' FROM \"x.y.z\"", "SELECT 'fooString' FROM x.y.z", (Command)query);
    }

    @Test
    public void testAliasInSingleQuotes() throws Exception {
        GroupSymbol g = new GroupSymbol("x.y.z");
        From from = new From();
        from.addGroup(g);
        AliasSymbol as = new AliasSymbol("fooAlias", (Expression)new ElementSymbol("fooKey"));
        Select select = new Select();
        select.addSymbol((Expression)as);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpException("SELECT fooKey 'fooAlias' FROM x.\"y\".z");
    }

    @Test
    public void testQueryWithQuotes_MSQuery() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT \"PART_COLOR\", \"PART_ID\", \"PART_NAME\", \"PART_WEIGHT\" FROM \"VirtualParts.base\".\"Parts\"");
    }

    @Test
    public void testQueryWithQuotes_MSAccess() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT \"PART_COLOR\" ,\"PART_ID\" ,\"PART_NAME\" ,\"PART_WEIGHT\"  FROM \"parts_oracle.DEV_RRAMESH\".\"PARTS\"");
    }

    @Test
    public void testQueryWithQuotes_BODesigner() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT DISTINCT \"PARTS\".\"PART_NAME\" FROM   \"parts_oracle.DEV_RRAMESH\".\"PARTS\" \"PARTS\"");
    }

    @Test
    public void testQueryWithQuotes_CrystalReports() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT \"Oracle_PARTS\".\"PART_COLOR\", \"Oracle_PARTS\".\"PART_ID\", \"Oracle_PARTS\".\"PART_NAME\", \"Oracle_PARTS\".\"PART_WEIGHT\", \"SQL_PARTS\".\"PART_COLOR\", \"SQL_PARTS\".\"PART_ID\", \"SQL_PARTS\".\"PART_NAME\", \"SQL_PARTS\".\"PART_WEIGHT\" FROM   \"parts_oracle.DEV_RRAMESH\".\"PARTS\" \"Oracle_PARTS\", \"parts_sqlserver.dv_rreddy.dv_rreddy\".\"PARTS\" \"SQL_PARTS\" WHERE  (\"Oracle_PARTS\".\"PART_ID\"=\"SQL_PARTS\".\"PART_ID\")");
    }

    @Test
    public void testOrderByWithNumbers_InQuotes() throws Exception {
        GroupSymbol g = new GroupSymbol("z");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("x"));
        select.addSymbol((Expression)new ElementSymbol("y"));
        OrderBy orderby = new OrderBy();
        orderby.addVariable((Expression)new ElementSymbol("1"), true);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOrderBy(orderby);
        TestParser.helpTest("SELECT x, y from z order by \"1\"", "SELECT x, y FROM z ORDER BY \"1\"", (Command)query);
    }

    @Test
    public void testOrderByWithNumbers_AsInt() throws Exception {
        GroupSymbol g = new GroupSymbol("z");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((Expression)new ElementSymbol("x"));
        select.addSymbol((Expression)new ElementSymbol("y"));
        OrderBy orderby = new OrderBy();
        orderby.addVariable((Expression)new Constant((Object)1), true);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOrderBy(orderby);
        TestParser.helpTest("SELECT x, y FROM z order by 1", "SELECT x, y FROM z ORDER BY 1", (Command)query);
    }

    @Test(expected=QueryParserException.class)
    public void testOrderByWithNumbers_AsNegitiveInt() throws Exception {
        QueryParser.getQueryParser().parseCommand("SELECT x, y FROM z order by -1");
    }

    @Test
    public void testEmptyAndNullInputsGiveSameErrorMessage() throws Exception {
        String emptyMessage = null;
        try {
            QueryParser.getQueryParser().parseCommand("");
            Assert.fail((String)"Expected exception for parsing empty string");
        }
        catch (TeiidException e) {
            emptyMessage = e.getMessage();
        }
        String nullMessage = null;
        try {
            QueryParser.getQueryParser().parseCommand(null);
            Assert.fail((String)"Expected exception for parsing null string");
        }
        catch (TeiidException e) {
            nullMessage = e.getMessage();
        }
        Assert.assertTrue((String)"Expected same message for empty and null cases", (boolean)emptyMessage.equals(nullMessage));
    }

    @Test
    public void testCase3281NamedVariable() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setDisplayNamedParameters(true);
        storedQuery.setProcedureName("proc1");
        SPParameter parameter = new SPParameter(1, (Expression)new Constant((Object)"paramValue1"));
        parameter.setName("param1");
        parameter.setParameterType(1);
        storedQuery.setParameter(parameter);
        TestParser.helpTest("Exec proc1(param1 = 'paramValue1')", "EXEC proc1(param1 => 'paramValue1')", (Command)storedQuery);
        TestParser.helpTest("execute proc1(param1 = 'paramValue1')", "EXEC proc1(param1 => 'paramValue1')", (Command)storedQuery);
    }

    @Test
    public void testCase3281NamedVariables() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setDisplayNamedParameters(true);
        storedQuery.setProcedureName("proc1");
        SPParameter param1 = new SPParameter(1, (Expression)new Constant((Object)"paramValue1"));
        param1.setName("param1");
        param1.setParameterType(1);
        storedQuery.setParameter(param1);
        SPParameter param2 = new SPParameter(2, (Expression)new Constant((Object)"paramValue2"));
        param2.setName("param2");
        param2.setParameterType(1);
        storedQuery.setParameter(param2);
        TestParser.helpTest("Exec proc1(param1 = 'paramValue1', param2 = 'paramValue2')", "EXEC proc1(param1 => 'paramValue1', param2 => 'paramValue2')", (Command)storedQuery);
        TestParser.helpTest("execute proc1(param1 = 'paramValue1', param2 = 'paramValue2')", "EXEC proc1(param1 => 'paramValue1', param2 => 'paramValue2')", (Command)storedQuery);
    }

    @Test
    public void testCase3281QuotedNamedVariableFails2() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        SPParameter param1 = new SPParameter(1, (Expression)new CompareCriteria((Expression)new Constant((Object)"a"), 1, (Expression)new Constant((Object)"b")));
        param1.setParameterType(1);
        storedQuery.setParameter(param1);
        TestParser.helpTest("Exec proc1('a' = 'b')", "EXEC proc1(('a' = 'b'))", (Command)storedQuery);
    }

    @Test
    public void testCase3281NamedVariablesReservedWords() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setDisplayNamedParameters(true);
        storedQuery.setProcedureName("proc1");
        SPParameter param1 = new SPParameter(1, (Expression)new Constant((Object)"paramValue1"));
        param1.setName("in");
        param1.setParameterType(1);
        storedQuery.setParameter(param1);
        SPParameter param2 = new SPParameter(2, (Expression)new Constant((Object)"paramValue2"));
        param2.setName("in2");
        param2.setParameterType(1);
        storedQuery.setParameter(param2);
        TestParser.helpTest("Exec proc1(\"in\" = 'paramValue1', in2 = 'paramValue2')", "EXEC proc1(\"in\" => 'paramValue1', in2 => 'paramValue2')", (Command)storedQuery);
        TestParser.helpTest("execute proc1(\"in\" = 'paramValue1', in2 = 'paramValue2')", "EXEC proc1(\"in\" => 'paramValue1', in2 => 'paramValue2')", (Command)storedQuery);
    }

    @Test
    public void testExceptionMessageWithLocation() {
        try {
            QueryParser.getQueryParser().parseCommand("SELECT FROM");
        }
        catch (QueryParserException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("TEIID31100 Parsing error: Encountered \"FROM\" at line 1, column 8."));
        }
    }

    @Test
    public void testEmptyOuterJoinCriteria() {
        TestParser.helpException("select a from b left outer join c on ()");
    }

    @Test
    public void testCreateTempTable1() {
        Create create = new Create();
        create.setTable(new GroupSymbol("tempTable"));
        ArrayList<ElementSymbol> columns = new ArrayList<ElementSymbol>();
        ElementSymbol column = new ElementSymbol("c1");
        column.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
        columns.add(column);
        column = new ElementSymbol("c2");
        column.setType(DataTypeManager.DefaultDataClasses.BYTE);
        columns.add(column);
        create.setElementSymbolsAsColumns(columns);
        TestParser.helpTest("Create local TEMPORARY table tempTable (c1 boolean, c2 byte)", "CREATE LOCAL TEMPORARY TABLE tempTable (c1 boolean, c2 byte)", (Command)create);
    }

    @Test
    public void testCreateTempTable2() {
        Create create = new Create();
        create.setTable(new GroupSymbol("tempTable"));
        ArrayList<ElementSymbol> columns = new ArrayList<ElementSymbol>();
        ElementSymbol column = new ElementSymbol("c1");
        column.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
        columns.add(column);
        column = new ElementSymbol("c2");
        column.setType(DataTypeManager.DefaultDataClasses.BYTE);
        columns.add(column);
        create.setElementSymbolsAsColumns(columns);
        TestParser.helpTest("Create local TEMPORARY table tempTable(c1 boolean, c2 byte)", "CREATE LOCAL TEMPORARY TABLE tempTable (c1 boolean, c2 byte)", (Command)create);
    }

    @Test
    public void testCreateTempTable3() {
        TestParser.helpException("Create TEMPORARY table tempTable (c1 boolean, c2 byte)");
    }

    @Test
    public void testCreateTempTable4() {
        TestParser.helpException("Create table tempTable (c1 boolean, c2 byte)");
    }

    @Test
    public void testCreateTempTable5() {
        TestParser.helpException("Create  local TEMPORARY table tempTable (c1 boolean primary, c2 byte)");
    }

    @Test
    public void testCreateTempTable7() {
        TestParser.helpException("Create local TEMPORARY table tempTable (c1.x boolean, c2 byte)", "TEIID31100 Parsing error: Invalid simple identifier format: [c1.x]");
    }

    @Test
    public void testCreateTempTableWithPrimaryKey() {
        Create create = new Create();
        create.setTable(new GroupSymbol("tempTable"));
        ArrayList<ElementSymbol> columns = new ArrayList<ElementSymbol>();
        ElementSymbol column = new ElementSymbol("c1");
        column.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
        columns.add(column);
        column = new ElementSymbol("c2");
        column.setType(DataTypeManager.DefaultDataClasses.BYTE);
        columns.add(column);
        create.setElementSymbolsAsColumns(columns);
        create.getPrimaryKey().add(column);
        TestParser.helpTest("Create local TEMPORARY table tempTable(c1 boolean, c2 byte, primary key (c2))", "CREATE LOCAL TEMPORARY TABLE tempTable (c1 boolean, c2 byte, PRIMARY KEY(c2))", (Command)create);
    }

    @Test
    public void testDropTable() {
        Drop drop = new Drop();
        drop.setTable(new GroupSymbol("tempTable"));
        TestParser.helpTest("DROP table tempTable", "DROP TABLE tempTable", (Command)drop);
    }

    @Test
    public void testEscapedOuterJoin() {
        String sql = "SELECT * FROM {oj A LEFT OUTER JOIN B ON (A.x=B.x)}";
        String expected = "SELECT * FROM A LEFT OUTER JOIN B ON A.x = B.x";
        Query query = new Query();
        Select select = new Select();
        query.setSelect(select);
        select.addSymbol((Expression)new MultipleElementSymbol());
        From from = new From();
        query.setFrom(from);
        CompareCriteria compareCriteria = new CompareCriteria((Expression)new ElementSymbol("A.x"), 1, (Expression)new ElementSymbol("B.x"));
        UnaryFromClause f1 = new UnaryFromClause(new GroupSymbol("A"));
        UnaryFromClause f2 = new UnaryFromClause(new GroupSymbol("B"));
        JoinPredicate jp = new JoinPredicate((FromClause)f1, (FromClause)f2, JoinType.JOIN_LEFT_OUTER, Arrays.asList(compareCriteria));
        from.addClause((FromClause)jp);
        TestParser.helpTest(sql, expected, (Command)query);
    }

    @Test
    public void testBadAlias() {
        String sql = "select a as a.x from foo";
        TestParser.helpException(sql, "TEIID31100 Parsing error: Invalid alias format: [a.x]");
    }

    @Test
    public void testNameSpacedFunctionName() {
        String sql = "select a.x()";
        Query query = new Query();
        Select select = new Select();
        Function func1 = new Function("a.x", new Expression[0]);
        select.addSymbol((Expression)func1);
        query.setSelect(select);
        TestParser.helpTest(sql, "SELECT a.x()", (Command)query);
    }

    @Test
    public void testUnionJoin() {
        String sql = "select * from pm1.g1 union join pm1.g2 where g1.e1 = 1";
        String expected = "SELECT * FROM pm1.g1 UNION JOIN pm1.g2 WHERE g1.e1 = 1";
        Select select = new Select();
        select.addSymbol((Expression)new MultipleElementSymbol());
        From from = new From();
        from.addClause((FromClause)new JoinPredicate((FromClause)new UnaryFromClause(new GroupSymbol("pm1.g1")), (FromClause)new UnaryFromClause(new GroupSymbol("pm1.g2")), JoinType.JOIN_UNION));
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("g1.e1"), 1, (Expression)new Constant((Object)new Integer(1)));
        Query command = new Query(select, from, (Criteria)crit, null, null);
        TestParser.helpTest(sql, expected, (Command)command);
    }

    @Test
    public void testUnionJoin1() {
        String sql = "select * from pm1.g1 union all join pm1.g2 where g1.e1 = 1";
        TestParser.helpException(sql);
    }

    @Test
    public void testIfElseWithoutBeginEnd() {
        String sql = "CREATE VIRTUAL PROCEDURE BEGIN IF (x > 1) select 1; IF (x > 1) select 1; ELSE select 1; END";
        String expected = "CREATE VIRTUAL PROCEDURE\nBEGIN\nIF(x > 1)\nBEGIN\nSELECT 1;\nEND\nIF(x > 1)\nBEGIN\nSELECT 1;\nEND\nELSE\nBEGIN\nSELECT 1;\nEND\nEND";
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new Constant((Object)1))));
        CommandStatement commandStmt = new CommandStatement((Command)query);
        CompareCriteria criteria = new CompareCriteria((Expression)new ElementSymbol("x"), 4, (Expression)new Constant((Object)1));
        Block block = new Block();
        block.addStatement((Statement)commandStmt);
        IfStatement ifStmt = new IfStatement((Criteria)criteria, block);
        IfStatement ifStmt1 = (IfStatement)ifStmt.clone();
        Block block2 = new Block();
        block2.addStatement((Statement)commandStmt);
        ifStmt1.setElseBlock(block2);
        Block block3 = new Block();
        block3.addStatement((Statement)ifStmt);
        block3.addStatement((Statement)ifStmt1);
        CreateProcedureCommand command = new CreateProcedureCommand(block3);
        TestParser.helpTest(sql, expected, (Command)command);
    }

    @Test
    public void testBadCreate() {
        TestParser.helpException("create insert");
    }

    @Test
    public void testCommandWithSemicolon() throws Exception {
        TestParser.helpTest("select * from pm1.g1;", "SELECT * FROM pm1.g1", QueryParser.getQueryParser().parseCommand("select * from pm1.g1"));
    }

    @Test
    public void testLOBTypes() throws Exception {
        Function convert = new Function("convert", new Expression[]{new Constant(null), new Constant((Object)"blob")});
        Function convert1 = new Function("convert", new Expression[]{new Constant(null), new Constant((Object)"clob")});
        Function convert2 = new Function("convert", new Expression[]{new Constant(null), new Constant((Object)"xml")});
        Select select = new Select(Arrays.asList(convert, convert1, convert2));
        Query query = new Query();
        query.setSelect(select);
        TestParser.helpTest("select convert(null, blob), convert(null, clob), convert(null, xml)", "SELECT convert(null, blob), convert(null, clob), convert(null, xml)", (Command)query);
    }

    @Test
    public void testInsertWithoutColumns() {
        Insert insert = new Insert();
        insert.setGroup(new GroupSymbol("m.g"));
        insert.addValue((Expression)new Constant((Object)"a"));
        insert.addValue((Expression)new Constant((Object)"b"));
        TestParser.helpTest("INSERT INTO m.g VALUES ('a', 'b')", "INSERT INTO m.g VALUES ('a', 'b')", (Command)insert);
    }

    @Test
    public void testTypeAliases() {
        Create create = new Create();
        create.setTable(new GroupSymbol("tempTable"));
        ArrayList<ElementSymbol> columns = new ArrayList<ElementSymbol>();
        ElementSymbol column = new ElementSymbol("c1");
        column.setType(DataTypeManager.DefaultDataClasses.STRING);
        columns.add(column);
        column = new ElementSymbol("c2");
        column.setType(DataTypeManager.DefaultDataClasses.BYTE);
        columns.add(column);
        column = new ElementSymbol("c3");
        column.setType(DataTypeManager.DefaultDataClasses.SHORT);
        columns.add(column);
        column = new ElementSymbol("c4");
        column.setType(DataTypeManager.DefaultDataClasses.FLOAT);
        columns.add(column);
        column = new ElementSymbol("c5");
        column.setType(DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        columns.add(column);
        create.setElementSymbolsAsColumns(columns);
        TestParser.helpTest("Create local TEMPORARY table tempTable (c1 varchar, c2 tinyint, c3 smallint, c4 real, c5 decimal)", "CREATE LOCAL TEMPORARY TABLE tempTable (c1 varchar, c2 tinyint, c3 smallint, c4 real, c5 decimal)", (Command)create);
    }

    @Test
    public void testXmlElement() throws Exception {
        XMLElement f = new XMLElement("table", Arrays.asList(new Constant((Object)"x")));
        TestParser.helpTestExpression("xmlelement(name \"table\", 'x')", "XMLELEMENT(NAME \"table\", 'x')", (Expression)f);
    }

    @Test
    public void testXmlElement1() throws Exception {
        XMLElement f = new XMLElement("table", Arrays.asList(new Constant((Object)"x")));
        TestParser.helpTestExpression("xmlelement(\"table\", 'x')", "XMLELEMENT(NAME \"table\", 'x')", (Expression)f);
    }

    @Test
    public void testXmlElementWithAttributes() throws Exception {
        XMLElement f = new XMLElement("y", new ArrayList());
        f.setAttributes(new XMLAttributes(Arrays.asList(new DerivedColumn("val", (Expression)new Constant((Object)"a")))));
        TestParser.helpTestExpression("xmlelement(y, xmlattributes('a' as val))", "XMLELEMENT(NAME y, XMLATTRIBUTES('a' AS val))", (Expression)f);
    }

    @Test
    public void testXmlForest() throws Exception {
        XMLForest f = new XMLForest(Arrays.asList(new DerivedColumn("table", (Expression)new ElementSymbol("a"))));
        TestParser.helpTestExpression("xmlforest(a as \"table\")", "XMLFOREST(a AS \"table\")", (Expression)f);
    }

    @Test
    public void testXmlPi() throws Exception {
        Function f = new Function("xmlpi", new Expression[]{new Constant((Object)"a"), new ElementSymbol("val")});
        TestParser.helpTestExpression("xmlpi(NAME a, val)", "xmlpi(NAME a, val)", (Expression)f);
    }

    @Test
    public void testXmlNamespaces() throws Exception {
        XMLForest f = new XMLForest(Arrays.asList(new DerivedColumn("table", (Expression)new ElementSymbol("a"))));
        f.setNamespaces(new XMLNamespaces(Arrays.asList(new XMLNamespaces.NamespaceItem(), new XMLNamespaces.NamespaceItem("http://foo", "x"))));
        TestParser.helpTestExpression("xmlforest(xmlnamespaces(no default, 'http://foo' as x), a as \"table\")", "XMLFOREST(XMLNAMESPACES(NO DEFAULT, 'http://foo' AS x), a AS \"table\")", (Expression)f);
    }

    @Test
    public void testXmlAggWithOrderBy() throws Exception {
        String sql = "SELECT xmlAgg(1 order by e2)";
        AggregateSymbol as = new AggregateSymbol("XMLAGG", false, (Expression)new Constant((Object)1));
        as.setOrderBy(new OrderBy(Arrays.asList(new ElementSymbol("e2"))));
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(as)));
        TestParser.helpTest(sql, "SELECT XMLAGG(1 ORDER BY e2)", (Command)query);
    }

    @Test
    public void testTextAggWithOrderBy() throws Exception {
        ArrayList<DerivedColumn> expressions = new ArrayList<DerivedColumn>();
        expressions.add(new DerivedColumn("col1", (Expression)new ElementSymbol("e1")));
        expressions.add(new DerivedColumn("col2", (Expression)new ElementSymbol("e2")));
        TextLine tf = new TextLine();
        tf.setExpressions(expressions);
        tf.setDelimiter(new Character(','));
        tf.setIncludeHeader(true);
        AggregateSymbol as = new AggregateSymbol("TEXTAGG", false, (Expression)tf);
        as.setOrderBy(new OrderBy(Arrays.asList(new ElementSymbol("e2"))));
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(as)));
        String sql = "SELECT TextAgg(FOR e1 as col1, e2 as col2 delimiter ',' header order by e2)";
        TestParser.helpTest(sql, "SELECT TEXTAGG(FOR e1 AS col1, e2 AS col2 DELIMITER ',' HEADER ORDER BY e2)", (Command)query);
    }

    @Test
    public void testArrayAggWithOrderBy() throws Exception {
        String sql = "SELECT array_agg(1 order by e2)";
        AggregateSymbol as = new AggregateSymbol("ARRAY_AGG", false, (Expression)new Constant((Object)1));
        as.setOrderBy(new OrderBy(Arrays.asList(new ElementSymbol("e2"))));
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(as)));
        TestParser.helpTest(sql, "SELECT ARRAY_AGG(1 ORDER BY e2)", (Command)query);
    }

    @Test
    public void testArrayAggWithIndexing() throws Exception {
        String sql = "SELECT (array_agg(1))[1]";
        AggregateSymbol as = new AggregateSymbol("ARRAY_AGG", false, (Expression)new Constant((Object)1));
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new Function("array_get", new Expression[]{as, new Constant((Object)1)}))));
        TestParser.helpTest(sql, "SELECT array_get(ARRAY_AGG(1), 1)", (Command)query);
    }

    @Test
    public void testNestedTable() throws Exception {
        String sql = "SELECT * from TABLE(exec foo()) as x";
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new MultipleElementSymbol())));
        StoredProcedure sp = new StoredProcedure();
        sp.setProcedureName("foo");
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)sp);
        sfc.setTable(true);
        query.setFrom(new From(Arrays.asList(sfc)));
        TestParser.helpTest(sql, "SELECT * FROM TABLE(EXEC foo()) AS x", (Command)query);
    }

    @Test
    public void testTextTable() throws Exception {
        String sql = "SELECT * from texttable(file columns x string WIDTH 1, y date width 10 skip 10) as x";
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new MultipleElementSymbol())));
        TextTable tt = new TextTable();
        tt.setFile((Expression)new ElementSymbol("file"));
        ArrayList<TextTable.TextColumn> columns = new ArrayList<TextTable.TextColumn>();
        columns.add(new TextTable.TextColumn("x", "string", Integer.valueOf(1), false));
        columns.add(new TextTable.TextColumn("y", "date", Integer.valueOf(10), false));
        tt.setColumns(columns);
        tt.setSkip(Integer.valueOf(10));
        tt.setName("x");
        query.setFrom(new From(Arrays.asList(tt)));
        TestParser.helpTest(sql, "SELECT * FROM TEXTTABLE(file COLUMNS x string WIDTH 1, y date WIDTH 10 SKIP 10) AS x", (Command)query);
        sql = "SELECT * from texttable(file columns x string, y date delimiter ',' escape '\"' header skip 10) as x";
        tt.setDelimiter(Character.valueOf(','));
        tt.setQuote(Character.valueOf('\"'));
        tt.setEscape(true);
        tt.setHeader(Integer.valueOf(1));
        for (TextTable.TextColumn textColumn : columns) {
            textColumn.setWidth(null);
        }
        TestParser.helpTest(sql, "SELECT * FROM TEXTTABLE(file COLUMNS x string, y date DELIMITER ',' ESCAPE '\"' HEADER SKIP 10) AS x", (Command)query);
    }

    @Test
    public void testTextTableColumns() throws Exception {
        TestParser.helpException("SELECT * from texttable(foo x string)");
    }

    @Test
    public void testXMLTable() throws Exception {
        String sql = "SELECT * from xmltable(xmlnamespaces(no default), '/' columns x for ordinality, y date default {d'2000-01-01'} path '@date') as x";
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new MultipleElementSymbol())));
        XMLTable xt = new XMLTable();
        xt.setName("x");
        xt.setNamespaces(new XMLNamespaces(Arrays.asList(new XMLNamespaces.NamespaceItem())));
        xt.setXquery("/");
        ArrayList<XMLTable.XMLColumn> columns = new ArrayList<XMLTable.XMLColumn>();
        columns.add(new XMLTable.XMLColumn("x"));
        columns.add(new XMLTable.XMLColumn("y", "date", "@date", (Expression)new Constant((Object)Date.valueOf("2000-01-01"))));
        xt.setColumns(columns);
        query.setFrom(new From(Arrays.asList(xt)));
        TestParser.helpTest(sql, "SELECT * FROM XMLTABLE(XMLNAMESPACES(NO DEFAULT), '/' COLUMNS x FOR ORDINALITY, y date DEFAULT {d'2000-01-01'} PATH '@date') AS x", (Command)query);
    }

    @Test
    public void testXmlSerialize() throws Exception {
        XMLSerialize f = new XMLSerialize();
        f.setDocument(Boolean.valueOf(true));
        f.setExpression((Expression)new ElementSymbol("x"));
        f.setTypeString("CLOB");
        TestParser.helpTestExpression("xmlserialize(document x as CLOB)", "XMLSERIALIZE(DOCUMENT x AS CLOB)", (Expression)f);
    }

    @Test
    public void testXmlQuery() throws Exception {
        XMLQuery f = new XMLQuery();
        f.setXquery("/x");
        f.setEmptyOnEmpty(Boolean.valueOf(false));
        f.setPassing(Arrays.asList(new DerivedColumn(null, (Expression)new ElementSymbol("foo"))));
        TestParser.helpTestExpression("xmlquery('/x' passing foo null on empty)", "XMLQUERY('/x' PASSING foo NULL ON EMPTY)", (Expression)f);
    }

    @Test
    public void testXmlParse() throws Exception {
        XMLParse f = new XMLParse();
        f.setDocument(true);
        f.setExpression((Expression)new ElementSymbol("x"));
        f.setWellFormed(true);
        TestParser.helpTestExpression("xmlparse(document x wellformed)", "XMLPARSE(DOCUMENT x WELLFORMED)", (Expression)f);
    }

    @Test
    public void testXmlSerialize1() throws Exception {
        XMLSerialize f = new XMLSerialize();
        f.setExpression((Expression)new ElementSymbol("x"));
        f.setTypeString("CLOB");
        TestParser.helpTestExpression("xmlserialize(x as CLOB)", "XMLSERIALIZE(x AS CLOB)", (Expression)f);
    }

    @Test
    public void testExpressionCriteria() throws Exception {
        SearchedCaseExpression sce = new SearchedCaseExpression(Arrays.asList(new ExpressionCriteria((Expression)new ElementSymbol("x"))), Arrays.asList(new ElementSymbol("y")));
        TestParser.helpTestExpression("case when x then y end", "CASE WHEN x THEN y END", (Expression)sce);
    }

    @Test
    public void testExpressionCriteria1() throws Exception {
        SearchedCaseExpression sce = new SearchedCaseExpression(Arrays.asList(new NotCriteria((Criteria)new ExpressionCriteria((Expression)new ElementSymbol("x")))), Arrays.asList(new ElementSymbol("y")));
        TestParser.helpTestExpression("case when not x then y end", "CASE WHEN NOT (x) THEN y END", (Expression)sce);
    }

    @Test
    public void testWithClause() throws Exception {
        Query query = this.getOrderByQuery(null);
        query.setWith(Arrays.asList(new WithQueryCommand(new GroupSymbol("x"), null, (QueryCommand)this.getOrderByQuery(null))));
        TestParser.helpTest("WITH x AS (SELECT a FROM db.g WHERE b = aString) SELECT a FROM db.g WHERE b = aString", "WITH x AS (SELECT a FROM db.g WHERE b = aString) SELECT a FROM db.g WHERE b = aString", (Command)query);
    }

    @Test
    public void testExplicitTable() throws Exception {
        Query query = new Query();
        Select select = new Select();
        query.setSelect(select);
        select.addSymbol((Expression)new MultipleElementSymbol());
        From from = new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("X"))));
        query.setFrom(from);
        TestParser.helpTest("TABLE X", "SELECT * FROM X", (Command)query);
    }

    @Test
    public void testArrayTable() throws Exception {
        String sql = "SELECT * from arraytable(null columns x string, y date) as x";
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new MultipleElementSymbol())));
        ArrayTable tt = new ArrayTable();
        tt.setArrayValue((Expression)new Constant(null, DataTypeManager.DefaultDataClasses.OBJECT));
        ArrayList<TableFunctionReference.ProjectedColumn> columns = new ArrayList<TableFunctionReference.ProjectedColumn>();
        columns.add(new TableFunctionReference.ProjectedColumn("x", "string"));
        columns.add(new TableFunctionReference.ProjectedColumn("y", "date"));
        tt.setColumns(columns);
        tt.setName("x");
        query.setFrom(new From(Arrays.asList(tt)));
        TestParser.helpTest(sql, "SELECT * FROM ARRAYTABLE(null COLUMNS x string, y date) AS x", (Command)query);
    }

    @Test
    public void testPositionalReference() throws Exception {
        String sql = "select $1";
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new Reference(0))));
        TestParser.helpTest(sql, "SELECT ?", (Command)query);
    }

    @Test
    public void testNonReserved() throws Exception {
        String sql = "select count";
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new ElementSymbol("count"))));
        TestParser.helpTest(sql, "SELECT count", (Command)query);
    }

    @Test
    public void testAggFilter() throws Exception {
        String sql = "select count(*) filter (where x = 1) from g";
        Query query = new Query();
        AggregateSymbol aggregateSymbol = new AggregateSymbol(AggregateSymbol.Type.COUNT.name(), false, null);
        aggregateSymbol.setCondition((Expression)new CompareCriteria((Expression)new ElementSymbol("x"), 1, (Expression)new Constant((Object)1)));
        query.setSelect(new Select(Arrays.asList(aggregateSymbol)));
        query.setFrom(new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("g")))));
        TestParser.helpTest(sql, "SELECT COUNT(*) FILTER(WHERE x = 1) FROM g", (Command)query);
    }

    @Test
    public void testWindowFunction() throws Exception {
        String sql = "select row_number() over (partition by x order by y) from g";
        Query query = new Query();
        WindowFunction wf = new WindowFunction();
        wf.setFunction(new AggregateSymbol("ROW_NUMBER", false, null));
        WindowSpecification ws = new WindowSpecification();
        ws.setPartition(new ArrayList<ElementSymbol>(Arrays.asList(new ElementSymbol("x"))));
        ws.setOrderBy(new OrderBy(Arrays.asList(new ElementSymbol("y"))));
        wf.setWindowSpecification(ws);
        query.setSelect(new Select(Arrays.asList(wf)));
        query.setFrom(new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("g")))));
        TestParser.helpTest(sql, "SELECT ROW_NUMBER() OVER (PARTITION BY x ORDER BY y) FROM g", (Command)query);
    }

    @Test
    public void testTrim1() {
        TestParser.helpException("select trim('xy' from e1) from pm1.g1");
    }

    @Test
    public void testSubString() throws QueryParserException {
        Query actualCommand = (Query)QueryParser.getQueryParser().parseCommand("SELECT substring(RTRIM(MED.BATDAT), 4, 4) FROM FCC.MEDMAS AS MED", new ParseInfo());
        String actualString = actualCommand.toString();
        Assert.assertEquals((Object)"SELECT substring(RTRIM(MED.BATDAT), 4, 4) FROM FCC.MEDMAS AS MED", (Object)actualString);
    }

    @Test
    public void testExactFixedPoint() throws QueryParserException {
        Query actualCommand = (Query)QueryParser.getQueryParser().parseCommand("SELECT 1.1", new ParseInfo());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.BIG_DECIMAL, (Object)actualCommand.getSelect().getSymbol(0).getType());
    }

    @Test
    public void testBinaryStringLiteral() throws QueryParserException {
        Query actualCommand = (Query)QueryParser.getQueryParser().parseCommand("SELECT x'AABBCC0a'", new ParseInfo());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.VARBINARY, (Object)actualCommand.getSelect().getSymbol(0).getType());
        Assert.assertEquals((Object)"SELECT X'AABBCC0A'", (Object)actualCommand.toString());
    }

    @Test
    public void testUserDefinedAggregateParsing() throws QueryParserException {
        Query actualCommand = (Query)QueryParser.getQueryParser().parseCommand("SELECT foo(ALL x, y)", new ParseInfo());
        Assert.assertEquals((Object)"SELECT foo(ALL x, y)", (Object)actualCommand.toString());
    }

    @Test
    public void testUserDefinedAggregateParsing1() throws QueryParserException {
        Query actualCommand = (Query)QueryParser.getQueryParser().parseCommand("SELECT foo(x, y order by e1)", new ParseInfo());
        Assert.assertEquals((Object)"SELECT foo(ALL x, y ORDER BY e1)", (Object)actualCommand.toString());
    }

    @Test(expected=QueryParserException.class)
    public void testWindowedExpression() throws QueryParserException {
        QueryParser.getQueryParser().parseCommand("SELECT foo(x, y) over ()", new ParseInfo());
    }

    @Test
    public void testWindowedExpression1() throws QueryParserException {
        Query actualCommand = (Query)QueryParser.getQueryParser().parseCommand("SELECT foo(distinct x, y) over ()", new ParseInfo());
        Assert.assertEquals((Object)"SELECT foo(DISTINCT x, y) OVER ()", (Object)actualCommand.toString());
    }

    @Test
    public void testInvalidLimit() {
        TestParser.helpException("SELECT * FROM pm1.g1 LIMIT -5");
    }

    @Test
    public void testInvalidLimit_Offset() {
        TestParser.helpException("SELECT * FROM pm1.g1 LIMIT -1, 100");
    }

    @Test
    public void testTextTableNegativeWidth() {
        TestParser.helpException("SELECT * from texttable(null columns x string width -1) as x");
    }
}

