/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Test;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestArrayTable {
    @Test
    public void testCorrelatedTextTable() throws Exception {
        String sql = "select x.* from bqt1.smalla, arraytable(objectvalue COLUMNS x string, y integer) x";
        List[] expected = new List[]{Arrays.asList("a", 1), Arrays.asList("b", 3)};
        TestArrayTable.process(sql, expected);
    }

    @Test
    public void testCorrelatedTextTable1() throws Exception {
        String sql = "select z from bqt1.smalla, arraytable(objectvalue COLUMNS x string, y integer, z long) x";
        List[] expected = new List[]{Arrays.asList(2L), Arrays.asList(6L)};
        TestArrayTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testCorrelatedTextTable2() throws Exception {
        String sql = "select y from bqt1.smalla, arraytable(objectvalue COLUMNS y integer) x";
        List[] expected = new List[]{};
        TestArrayTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testCorrelatedTextTable3() throws Exception {
        String sql = "select x.* from bqt1.smalla, arraytable(objectvalue COLUMNS x string, y integer, z integer, aa object) x";
        List[] expected = new List[]{};
        TestArrayTable.process(sql, expected);
    }

    public static void process(String sql, List[] expectedResults) throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT BQT1.SmallA.ObjectValue FROM BQT1.SmallA", new List[]{Collections.singletonList(new Object[]{"a", 1, 2}), Collections.singletonList(new Object[]{"b", 3, 6}), Collections.singletonList(null)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, TestProcessor.createCommandContext(), dataManager, expectedResults);
    }
}

