/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class TestIsNullCriteria
extends TestCase {
    public TestIsNullCriteria(String name) {
        super(name);
    }

    public static IsNullCriteria example(String element, boolean negated) {
        IsNullCriteria crit = new IsNullCriteria();
        crit.setNegated(negated);
        crit.setExpression((Expression)new ElementSymbol(element));
        return crit;
    }

    public void testEquals1() {
        IsNullCriteria c1 = TestIsNullCriteria.example("abc", true);
        IsNullCriteria c2 = TestIsNullCriteria.example("abc", true);
        TestIsNullCriteria.assertTrue((String)("Equivalent is null criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    public void testEquals2() {
        IsNullCriteria c1 = TestIsNullCriteria.example("abc", false);
        IsNullCriteria c2 = (IsNullCriteria)c1.clone();
        TestIsNullCriteria.assertTrue((String)("Equivalent is null criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    public void testSelfEquivalence() {
        IsNullCriteria c1 = new IsNullCriteria();
        c1.setNegated(true);
        c1.setExpression((Expression)new Constant((Object)"abc"));
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c1);
    }

    public void testEquivalence() {
        IsNullCriteria c1 = TestIsNullCriteria.example("abc", true);
        IsNullCriteria c2 = TestIsNullCriteria.example("abc", true);
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    public void testCloneEquivalence() {
        IsNullCriteria c1 = TestIsNullCriteria.example("abc", false);
        IsNullCriteria c2 = (IsNullCriteria)c1.clone();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    public void testNonEquivalence1() {
        IsNullCriteria c1 = TestIsNullCriteria.example("abc", true);
        IsNullCriteria c2 = TestIsNullCriteria.example("xyz", true);
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    public void testNonEquivalence2() {
        IsNullCriteria c1 = TestIsNullCriteria.example("abc", true);
        IsNullCriteria c2 = TestIsNullCriteria.example("abc", false);
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }
}

