/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.unittest;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.function.UDFSource;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingOutputter;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.FakeFunctionMetadataSource;
import org.teiid.query.parser.TestDDLParser;

public class RealMetadataFactory {
    public static final SystemFunctionManager SFM = new SystemFunctionManager();
    private static TransformationMetadata CACHED_EXAMPLE1 = RealMetadataFactory.example1();
    private static TransformationMetadata CACHED_BQT = RealMetadataFactory.exampleBQT();
    static TransformationMetadata CACHED_AGGREGATES = RealMetadataFactory.exampleAggregates();

    private RealMetadataFactory() {
    }

    public static TransformationMetadata exampleBQTCached() {
        return CACHED_BQT;
    }

    public static TransformationMetadata example1Cached() {
        return CACHED_EXAMPLE1;
    }

    public static MetadataStore exampleBQTStore() {
        MetadataStore metadataStore = new MetadataStore();
        Schema bqt1 = RealMetadataFactory.createPhysicalModel("BQT1", metadataStore);
        Schema bqt2 = RealMetadataFactory.createPhysicalModel("BQT2", metadataStore);
        Schema bqt3 = RealMetadataFactory.createPhysicalModel("BQT3", metadataStore);
        Schema lob = RealMetadataFactory.createPhysicalModel("LOB", metadataStore);
        Schema vqt = RealMetadataFactory.createVirtualModel("VQT", metadataStore);
        Schema bvqt = RealMetadataFactory.createVirtualModel("BQT_V", metadataStore);
        Schema bvqt2 = RealMetadataFactory.createVirtualModel("BQT2_V", metadataStore);
        Table bqt1SmallA = RealMetadataFactory.createPhysicalGroup("SmallA", bqt1);
        Table bqt1SmallB = RealMetadataFactory.createPhysicalGroup("SmallB", bqt1);
        Table bqt1MediumA = RealMetadataFactory.createPhysicalGroup("MediumA", bqt1);
        Table bqt1MediumB = RealMetadataFactory.createPhysicalGroup("MediumB", bqt1);
        Table bqt2SmallA = RealMetadataFactory.createPhysicalGroup("SmallA", bqt2);
        Table bqt2SmallB = RealMetadataFactory.createPhysicalGroup("SmallB", bqt2);
        Table bqt2MediumA = RealMetadataFactory.createPhysicalGroup("MediumA", bqt2);
        Table bqt2MediumB = RealMetadataFactory.createPhysicalGroup("MediumB", bqt2);
        Table bqt3SmallA = RealMetadataFactory.createPhysicalGroup("SmallA", bqt3);
        Table bqt3SmallB = RealMetadataFactory.createPhysicalGroup("SmallB", bqt3);
        Table bqt3MediumA = RealMetadataFactory.createPhysicalGroup("MediumA", bqt3);
        Table bqt3MediumB = RealMetadataFactory.createPhysicalGroup("MediumB", bqt3);
        Table lobTable = RealMetadataFactory.createPhysicalGroup("LobTbl", lob);
        Table library = RealMetadataFactory.createPhysicalGroup("LOB_TESTING_ONE", lob);
        RealMetadataFactory.createElements(library, new String[]{"CLOB_COLUMN", "BLOB_COLUMN", "KEY_EMULATOR"}, new String[]{"clob", "blob", "integer"});
        QueryNode vqtn1 = new QueryNode("SELECT * FROM BQT1.SmallA");
        Table vqtg1 = RealMetadataFactory.createUpdatableVirtualGroup("SmallA", vqt, vqtn1);
        QueryNode vqtn2 = new QueryNode("SELECT Concat(stringKey, stringNum) as a12345 FROM BQT1.SmallA");
        Table vqtg2 = RealMetadataFactory.createUpdatableVirtualGroup("SmallB", vqt, vqtn2);
        QueryNode vqtn2589 = new QueryNode("SELECT * FROM BQT1.SmallA WHERE StringNum = '10'");
        Table vqtg2589 = RealMetadataFactory.createVirtualGroup("SmallA_2589", vqt, vqtn2589);
        QueryNode vqtn2589a = new QueryNode("SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.IntKey = SmallB.IntKey WHERE SmallA.StringNum = '10'");
        Table vqtg2589a = RealMetadataFactory.createVirtualGroup("SmallA_2589a", vqt, vqtn2589a);
        QueryNode vqtn2589b = new QueryNode("SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.StringKey = SmallB.StringKey WHERE SmallA.StringNum = '10'");
        Table vqtg2589b = RealMetadataFactory.createVirtualGroup("SmallA_2589b", vqt, vqtn2589b);
        QueryNode vqtn2589c = new QueryNode("SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.StringKey = SmallB.StringKey WHERE concat(SmallA.StringNum, SmallB.StringNum) = '1010'");
        Table vqtg2589c = RealMetadataFactory.createVirtualGroup("SmallA_2589c", vqt, vqtn2589c);
        QueryNode vqtn2589d = new QueryNode("SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.StringKey = SmallB.StringKey WHERE SmallA.StringNum = '10' AND SmallA.IntNum = 10");
        Table vqtg2589d = RealMetadataFactory.createVirtualGroup("SmallA_2589d", vqt, vqtn2589d);
        QueryNode vqtn2589f = new QueryNode("SELECT * FROM VQT.SmallA_2589");
        Table vqtg2589f = RealMetadataFactory.createVirtualGroup("SmallA_2589f", vqt, vqtn2589f);
        QueryNode vqtn2589g = new QueryNode("SELECT * FROM SmallA_2589b");
        Table vqtg2589g = RealMetadataFactory.createVirtualGroup("SmallA_2589g", vqt, vqtn2589g);
        QueryNode vqtn2589h = new QueryNode("SELECT VQT.SmallA_2589.* FROM VQT.SmallA_2589 INNER JOIN BQT1.SmallB ON VQT.SmallA_2589.StringKey = SmallB.StringKey");
        Table vqtg2589h = RealMetadataFactory.createVirtualGroup("SmallA_2589h", vqt, vqtn2589h);
        QueryNode vqtn2589i = new QueryNode("SELECT BQT1.SmallA.* FROM BQT1.SmallA INNER JOIN BQT1.SmallB ON SmallA.StringKey = SmallB.StringKey WHERE SmallA.StringNum = '10' AND SmallB.StringNum = '10'");
        Table vqtg2589i = RealMetadataFactory.createVirtualGroup("SmallA_2589i", vqt, vqtn2589i);
        QueryNode vqtn15355 = new QueryNode("SELECT convert(IntKey, string) as StringKey, BigIntegerValue FROM BQT1.SmallA UNION SELECT StringKey, (SELECT BigIntegerValue FROM BQT3.SmallA WHERE BQT3.SmallA.BigIntegerValue = BQT2.SmallA.StringNum) FROM BQT2.SmallA");
        Table vqtg15355 = RealMetadataFactory.createVirtualGroup("Defect15355", vqt, vqtn15355);
        QueryNode vqtn15355a = new QueryNode("SELECT StringKey, StringNum, BigIntegerValue FROM BQT1.SmallA UNION SELECT StringKey, StringNum, (SELECT BigIntegerValue FROM BQT3.SmallA WHERE BQT3.SmallA.BigIntegerValue = BQT2.SmallA.StringNum) FROM BQT2.SmallA");
        Table vqtg15355a = RealMetadataFactory.createVirtualGroup("Defect15355a", vqt, vqtn15355a);
        QueryNode vqtn15355b = new QueryNode("SELECT convert(IntKey, string) as IntKey, BigIntegerValue FROM BQT1.SmallA UNION SELECT StringKey, (SELECT BigIntegerValue FROM BQT3.SmallA WHERE BQT3.SmallA.BigIntegerValue = BQT2.SmallA.StringNum) FROM BQT2.SmallA");
        Table vqtg15355b = RealMetadataFactory.createVirtualGroup("Defect15355b", vqt, vqtn15355b);
        QueryNode bvqtn1 = new QueryNode("SELECT a.* FROM BQT1.SMALLA AS a WHERE a.INTNUM = (SELECT MIN(b.INTNUM) FROM BQT1.SMALLA AS b WHERE b.INTKEY = a.IntKey ) OPTION MAKEDEP a");
        Table bvqtg1 = RealMetadataFactory.createUpdatableVirtualGroup("BQT_V", bvqt, bvqtn1);
        QueryNode bvqt2n1 = new QueryNode("SELECT BQT2.SmallA.* FROM BQT2.SmallA, BQT_V.BQT_V WHERE BQT2.SmallA.IntKey = BQT_V.BQT_V.IntKey");
        Table bvqt2g1 = RealMetadataFactory.createUpdatableVirtualGroup("BQT2_V", bvqt2, bvqt2n1);
        String[] elemNames = new String[]{"IntKey", "StringKey", "IntNum", "StringNum", "FloatNum", "LongNum", "DoubleNum", "ByteNum", "DateValue", "TimeValue", "TimestampValue", "BooleanValue", "CharValue", "ShortValue", "BigIntegerValue", "BigDecimalValue", "ObjectValue"};
        String[] elemTypes = new String[]{"integer", "string", "integer", "string", "float", "long", "double", "byte", "date", "time", "timestamp", "boolean", "char", "short", "biginteger", "bigdecimal", "object"};
        List<Column> bqt1SmallAe = RealMetadataFactory.createElements(bqt1SmallA, elemNames, elemTypes);
        bqt1SmallAe.get(1).setNativeType("char");
        RealMetadataFactory.createElements(bqt1SmallB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt1MediumA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt1MediumB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt2SmallA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt2SmallB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt2MediumA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt2MediumB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt3SmallA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt3SmallB, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt3MediumA, elemNames, elemTypes);
        RealMetadataFactory.createElements(bqt3MediumB, elemNames, elemTypes);
        RealMetadataFactory.createElements(lobTable, new String[]{"ClobValue"}, new String[]{"clob"});
        RealMetadataFactory.createElements(vqtg1, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2, new String[]{"a12345"}, new String[]{"string"});
        RealMetadataFactory.createElements(vqtg15355, new String[]{"StringKey", "BigIntegerValue"}, new String[]{"string", "biginteger"});
        RealMetadataFactory.createElements(vqtg15355a, new String[]{"StringKey", "StringNum", "BigIntegerValue"}, new String[]{"string", "string", "biginteger"});
        RealMetadataFactory.createElements(vqtg15355b, new String[]{"IntKey", "BigIntegerValue"}, new String[]{"string", "biginteger"});
        RealMetadataFactory.createElements(vqtg2589, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589a, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589b, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589c, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589d, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589f, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589g, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589h, elemNames, elemTypes);
        RealMetadataFactory.createElements(vqtg2589i, elemNames, elemTypes);
        RealMetadataFactory.createElements(bvqtg1, elemNames, elemTypes);
        RealMetadataFactory.createElements(bvqt2g1, elemNames, elemTypes);
        ProcedureParameter rsp1 = RealMetadataFactory.createParameter("ret", 4, "integer");
        ProcedureParameter rsp2 = RealMetadataFactory.createParameter("inkey", 1, "integer");
        RealMetadataFactory.createVirtualProcedure("v_spTest9", bvqt, Arrays.asList(rsp1, rsp2), new QueryNode("ret = call pm4.spTest9(inkey);"));
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        ProcedureParameter rs1p1 = RealMetadataFactory.createParameter("intkey", 1, "integer");
        ColumnSet<Procedure> rs1 = RealMetadataFactory.createResultSet("rs1", new String[]{"IntKey", "StringKey"}, new String[]{"integer", "string"});
        Procedure spTest5 = RealMetadataFactory.createStoredProcedure("spTest5", pm1, Arrays.asList(rs1p1));
        spTest5.setResultSet(rs1);
        Schema pm2 = RealMetadataFactory.createPhysicalModel("pm2", metadataStore);
        ProcedureParameter rs2p1 = RealMetadataFactory.createParameter("inkey", 1, "integer");
        ProcedureParameter rs2p2 = RealMetadataFactory.createParameter("outkey", 2, "integer");
        ColumnSet<Procedure> rs2 = RealMetadataFactory.createResultSet("rs2", new String[]{"IntKey", "StringKey"}, new String[]{"integer", "string"});
        Procedure spTest8 = RealMetadataFactory.createStoredProcedure("spTest8", pm2, Arrays.asList(rs2p1, rs2p2));
        spTest8.setResultSet(rs2);
        ProcedureParameter rs2p2a = RealMetadataFactory.createParameter("outkey", 2, "integer");
        ColumnSet<Procedure> rs2a = RealMetadataFactory.createResultSet("rs2", new String[]{"IntKey", "StringKey"}, new String[]{"integer", "string"});
        Procedure spTest8a = RealMetadataFactory.createStoredProcedure("spTest8a", pm2, Arrays.asList(rs2p2a));
        spTest8a.setResultSet(rs2a);
        Schema pm4 = RealMetadataFactory.createPhysicalModel("pm4", metadataStore);
        ProcedureParameter rs4p1 = RealMetadataFactory.createParameter("ret", 4, "integer");
        ProcedureParameter rs4p2 = RealMetadataFactory.createParameter("inkey", 1, "integer");
        RealMetadataFactory.createStoredProcedure("spTest9", pm4, Arrays.asList(rs4p1, rs4p2));
        Schema pm3 = RealMetadataFactory.createPhysicalModel("pm3", metadataStore);
        ProcedureParameter rs3p1 = RealMetadataFactory.createParameter("inkey", 1, "integer");
        ProcedureParameter rs3p2 = RealMetadataFactory.createParameter("outkey", 3, "integer");
        ColumnSet<Procedure> rs3 = RealMetadataFactory.createResultSet("rs3", new String[]{"IntKey", "StringKey"}, new String[]{"integer", "string"});
        Procedure spTest11 = RealMetadataFactory.createStoredProcedure("spTest11", pm3, Arrays.asList(rs3p1, rs3p2));
        spTest11.setResultSet(rs3);
        Schema mmspTest1 = RealMetadataFactory.createVirtualModel("mmspTest1", metadataStore);
        ColumnSet<Procedure> vsprs1 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        QueryNode vspqn1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT intkey FROM bqt1.smallA) AS intKeyCursor BEGIN x= intKeyCursor.intkey - 1; END SELECT stringkey FROM bqt1.smalla where intkey=x; END");
        Procedure vsp1 = RealMetadataFactory.createVirtualProcedure("MMSP1", mmspTest1, null, vspqn1);
        vsp1.setResultSet(vsprs1);
        ColumnSet<Procedure> vsprs2 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        QueryNode vspqn2 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT intkey FROM bqt1.smallA) AS intKeyCursor1 BEGIN LOOP ON (SELECT intkey FROM bqt1.smallB) AS intKeyCursor2 BEGIN x= intKeyCursor1.intkey - intKeyCursor2.intkey; END END SELECT stringkey FROM bqt1.smalla where intkey=x; END");
        Procedure vsp2 = RealMetadataFactory.createVirtualProcedure("MMSP2", mmspTest1, null, vspqn2);
        vsp2.setResultSet(vsprs2);
        ColumnSet<Procedure> vsprs3 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        QueryNode vspqn3 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT intkey FROM bqt1.smallA) AS intKeyCursor BEGIN x= intKeyCursor.intkey - 1; if(x = 25) BEGIN BREAK; END ELSE BEGIN CONTINUE; END END SELECT stringkey FROM bqt1.smalla where intkey=x; END");
        Procedure vsp3 = RealMetadataFactory.createVirtualProcedure("MMSP3", mmspTest1, null, vspqn3);
        vsp3.setResultSet(vsprs3);
        ColumnSet<Procedure> vsprs4 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        QueryNode vspqn4 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE(x < 50) BEGIN x= x + 1; if(x = 25) BEGIN BREAK; END ELSE BEGIN CONTINUE; END END SELECT stringkey FROM bqt1.smalla where intkey=x; END");
        Procedure vsp4 = RealMetadataFactory.createVirtualProcedure("MMSP4", mmspTest1, null, vspqn4);
        vsp4.setResultSet(vsprs4);
        ColumnSet<Procedure> vsprs5 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        ProcedureParameter vsp5p1 = RealMetadataFactory.createParameter("param1", 1, "string");
        QueryNode vspqn5 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT 0; END");
        Procedure vsp5 = RealMetadataFactory.createVirtualProcedure("MMSP5", mmspTest1, Arrays.asList(vsp5p1), vspqn5);
        vsp5.setResultSet(vsprs5);
        ColumnSet<Procedure> vsprs6 = RealMetadataFactory.createResultSet("mmspTest1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        ProcedureParameter vsp6p1 = RealMetadataFactory.createParameter("p1", 1, "string");
        QueryNode vspqn6 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT p1 as StringKey; END");
        Procedure vsp6 = RealMetadataFactory.createVirtualProcedure("MMSP6", mmspTest1, Arrays.asList(vsp6p1), vspqn6);
        vsp6.setResultSet(vsprs6);
        RealMetadataFactory.createStoredProcedure("spRetOut", pm4, Arrays.asList(RealMetadataFactory.createParameter("ret", 4, "integer"), RealMetadataFactory.createParameter("x", 2, "integer")));
        ColumnSet<Procedure> vsprs7 = RealMetadataFactory.createResultSet("TEIIDSP7.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        ProcedureParameter vsp7p1 = RealMetadataFactory.createParameter("p1", 1, "integer");
        QueryNode vspqn7 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN declare integer x; x = exec spTest9(p1); declare integer y; exec spTest11(inkey=>x, outkey=>y); select convert(x, string) || y; END");
        Procedure vsp7 = RealMetadataFactory.createVirtualProcedure("TEIIDSP7", mmspTest1, Arrays.asList(vsp7p1), vspqn7);
        vsp7.setResultSet(vsprs7);
        ProcedureParameter vsp8p1 = RealMetadataFactory.createParameter("r", 4, "integer");
        ProcedureParameter vsp8p2 = RealMetadataFactory.createParameter("p1", 1, "integer");
        QueryNode vspqn8 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN r = p1; END");
        RealMetadataFactory.createVirtualProcedure("TEIIDSP8", mmspTest1, Arrays.asList(vsp8p1, vsp8p2), vspqn8);
        ColumnSet<Procedure> vsprs9 = RealMetadataFactory.createResultSet("TEIIDSP9.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        ProcedureParameter vsp9p1 = RealMetadataFactory.createParameter("r", 4, "integer");
        vsp9p1.setNullType(BaseColumn.NullType.No_Nulls);
        ProcedureParameter vsp9p2 = RealMetadataFactory.createParameter("p1", 1, "integer");
        ProcedureParameter vsp9p3 = RealMetadataFactory.createParameter("p2", 2, "integer");
        QueryNode vspqn9 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN if (p1 = 1) begin\n r = 1; end\n p2 = 10; select 'hello'; END");
        Procedure vsp9 = RealMetadataFactory.createVirtualProcedure("TEIIDSP9", mmspTest1, Arrays.asList(vsp9p1, vsp9p2, vsp9p3), vspqn9);
        vsp9.setResultSet(vsprs9);
        bqt1.addFunction(new FunctionMethod("reverse", "reverse", "misc", new FunctionParameter[]{new FunctionParameter("columnName", "string", "")}, new FunctionParameter("result", "string", "")));
        return metadataStore;
    }

    public static TransformationMetadata exampleBQT() {
        return RealMetadataFactory.createTransformationMetadata(RealMetadataFactory.exampleBQTStore(), "bqt", new FunctionTree[0]);
    }

    public static TransformationMetadata createTransformationMetadata(MetadataStore metadataStore, String vdbName, FunctionTree ... functionModels) {
        CompositeMetadataStore store = new CompositeMetadataStore(metadataStore);
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName(vdbName);
        vdbMetaData.setVersion(1);
        ArrayList<FunctionTree> udfs = new ArrayList<FunctionTree>();
        udfs.addAll(Arrays.asList(functionModels));
        for (Schema schema : metadataStore.getSchemas().values()) {
            vdbMetaData.addModel(RealMetadataFactory.createModel(schema.getName(), schema.isPhysical()));
            if (schema.getFunctions().isEmpty()) continue;
            udfs.add(new FunctionTree(schema.getName(), (FunctionMetadataSource)new UDFSource(schema.getFunctions().values()), true));
        }
        return new TransformationMetadata(vdbMetaData, store, null, SFM.getSystemFunctions(), udfs);
    }

    public static QueryMetadataInterface exampleMaterializedView() {
        MetadataStore metadataStore = new MetadataStore();
        Schema virtModel = RealMetadataFactory.createVirtualModel("MatView", metadataStore);
        Schema physModel = RealMetadataFactory.createPhysicalModel("MatTable", metadataStore);
        Schema physModel_virtSrc = RealMetadataFactory.createPhysicalModel("MatSrc", metadataStore);
        Table physTable = RealMetadataFactory.createPhysicalGroup("info", physModel);
        RealMetadataFactory.createElements(physTable, new String[]{"e1", "e2", "e3"}, new String[]{"string", "integer", "string"});
        Table physGroup = RealMetadataFactory.createPhysicalGroup("MatTable", physModel);
        RealMetadataFactory.createElements(physGroup, new String[]{"e1"}, new String[]{"string"});
        Table physGroupStage = RealMetadataFactory.createPhysicalGroup("MatStage", physModel);
        RealMetadataFactory.createElements(physGroupStage, new String[]{"e1"}, new String[]{"string"});
        Table physGroup1 = RealMetadataFactory.createPhysicalGroup("MatTable1", physModel);
        RealMetadataFactory.createElements(physGroup1, new String[]{"e1"}, new String[]{"string"});
        Table physGroupStage1 = RealMetadataFactory.createPhysicalGroup("MatStage1", physModel);
        RealMetadataFactory.createElements(physGroupStage, new String[]{"e1"}, new String[]{"string"});
        Table physGroup_virtSrc = RealMetadataFactory.createPhysicalGroup("MatSrc", physModel_virtSrc);
        RealMetadataFactory.createElements(physGroup_virtSrc, new String[]{"x"}, new String[]{"string"});
        QueryNode virtTrans = new QueryNode("SELECT x as e1 FROM MatSrc.MatSrc");
        Table virtGroup = RealMetadataFactory.createVirtualGroup("MatView", virtModel, virtTrans);
        RealMetadataFactory.createElements(virtGroup, new String[]{"e1"}, new String[]{"string"});
        virtGroup.setMaterialized(true);
        virtGroup.setMaterializedTable(physGroup);
        virtGroup.setMaterializedStageTable(physGroupStage);
        QueryNode vTrans = new QueryNode("SELECT e1 FROM MatView.MatView option NOCACHE");
        Table vGroup = RealMetadataFactory.createVirtualGroup("VGroup", virtModel, vTrans);
        RealMetadataFactory.createElements(vGroup, new String[]{"e1"}, new String[]{"string"});
        QueryNode virtTrans1 = new QueryNode("SELECT e1 FROM MatView.MatView where e1 = 1");
        Table virtGroup1 = RealMetadataFactory.createVirtualGroup("MatView1", virtModel, virtTrans1);
        RealMetadataFactory.createElements(virtGroup1, new String[]{"e1"}, new String[]{"string"});
        virtGroup1.setMaterializedTable(physGroup1);
        virtGroup1.setMaterializedStageTable(physGroupStage1);
        QueryNode vTrans2 = new QueryNode("SELECT x FROM matsrc");
        Table vGroup2 = RealMetadataFactory.createVirtualGroup("VGroup2", virtModel, vTrans2);
        vGroup2.setMaterialized(true);
        RealMetadataFactory.createElements(vGroup2, new String[]{"x"}, new String[]{"string"});
        QueryNode vTrans3 = new QueryNode("SELECT x, 'z' || substring(x, 2) as y FROM matsrc");
        Table vGroup3 = RealMetadataFactory.createVirtualGroup("VGroup3", virtModel, vTrans3);
        vGroup3.setMaterialized(true);
        List<Column> vElements3 = RealMetadataFactory.createElements(vGroup3, new String[]{"x", "y"}, new String[]{"string", "string"});
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "pk", vGroup3, vElements3.subList(0, 1));
        RealMetadataFactory.createKey(KeyRecord.Type.Index, "idx", vGroup3, vElements3.subList(1, 2));
        QueryNode vTrans4 = new QueryNode("/*+ cache(ttl:100) */ SELECT x FROM matsrc");
        Table vGroup4 = RealMetadataFactory.createVirtualGroup("VGroup4", virtModel, vTrans4);
        vGroup4.setMaterialized(true);
        RealMetadataFactory.createElements(vGroup4, new String[]{"x"}, new String[]{"string"});
        QueryNode vTrans5 = new QueryNode("SELECT x, 'z' || substring(x, 2) as y, 1 as z FROM matsrc");
        Table vGroup5 = RealMetadataFactory.createVirtualGroup("VGroup5", virtModel, vTrans5);
        vGroup5.setMaterialized(true);
        List<Column> vElements5 = RealMetadataFactory.createElements(vGroup5, new String[]{"x", "y", "z"}, new String[]{"string", "string", "integer"});
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "pk", vGroup5, vElements5.subList(0, 1));
        RealMetadataFactory.createKey(KeyRecord.Type.Index, "idx", vGroup5, vElements5.subList(1, 2));
        QueryNode vTrans6 = new QueryNode("SELECT x, 'z' || substring(x, 2) as y FROM matsrc");
        Table vGroup6 = RealMetadataFactory.createVirtualGroup("VGroup6", virtModel, vTrans6);
        vGroup6.setMaterialized(true);
        List<Column> vElements6 = RealMetadataFactory.createElements(vGroup6, new String[]{"x", "y"}, new String[]{"string", "string"});
        RealMetadataFactory.createKey(KeyRecord.Type.Index, "idx", vGroup6, vElements6.subList(1, 2));
        QueryNode vTrans7 = new QueryNode("SELECT '1', 'z' || substring(x, 2) as y, 1 as z FROM matsrc");
        Table vGroup7 = RealMetadataFactory.createVirtualGroup("VGroup7", virtModel, vTrans7);
        vGroup7.setMaterialized(true);
        List<Column> vElements7 = RealMetadataFactory.createElements(vGroup7, new String[]{"x", "y", "z"}, new String[]{"string", "string", "integer"});
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "pk", vGroup7, vElements7.subList(1, 2));
        Schema sp = RealMetadataFactory.createVirtualModel("sp", metadataStore);
        ColumnSet<Procedure> rs = RealMetadataFactory.createResultSet("sp1.vsprs1", new String[]{"StringKey"}, new String[]{"string"});
        ProcedureParameter param = RealMetadataFactory.createParameter("param1", 1, "string");
        param.setNullType(BaseColumn.NullType.Nullable);
        QueryNode sp1qn = new QueryNode("/*+ cache */ CREATE VIRTUAL PROCEDURE BEGIN SELECT x as StringKey from matsrc where x = param1; END");
        Procedure vsp5 = RealMetadataFactory.createVirtualProcedure("sp1", sp, Arrays.asList(param), sp1qn);
        vsp5.setResultSet(rs);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "", new FunctionTree[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static MetadataStore example1Store() {
        void vsp63;
        void vspqn63;
        void vsp62;
        void vspqn62;
        void vsp61;
        void vspqn61;
        void vsp60;
        void vspqn60;
        void vsp59;
        void vspqn59;
        void vsp58;
        void vspqn58;
        void vspp58;
        void vsp57;
        void vspqn57;
        void vsp56;
        void vspqn56;
        void vsp55;
        void vspqn55;
        void vspp55;
        void vsp54rs;
        void vsp54;
        void vspqn54;
        void vsp54p2;
        void vsp53rs;
        void vsp53;
        void vspqn53;
        void vsp53p2;
        void vsp52rs;
        void vsp52;
        void vspqn52;
        void vsp51rs;
        void vsp51;
        void vspqn51;
        void vsp50rs;
        void vsp50;
        void vspqn50;
        void vsp49rs;
        void vsp49;
        void vspqn49;
        void vsp48rs;
        void vsp48;
        void vspqn48;
        void vsp48p2;
        void vsp46;
        void vspqn46;
        void vsp43;
        void vspqn43;
        void vspp43;
        void vsp44;
        void vspqn44;
        void vspp44;
        void vsprs42;
        void vsp42;
        void vspqn42;
        void vsp42p2;
        void vsprs36;
        void vsp36;
        void vspqn36;
        void vsp36p2;
        void vm1g35e1;
        void vm1g35;
        void vm1g35n1;
        void vgvp6e2;
        void vgvp6e1;
        void vgvp6;
        void vgvpn6;
        void vgvp5e2;
        void vgvp5e1;
        void vgvp5;
        void vgvpn5;
        void vgvp4e2;
        void vgvp4e1;
        void vgvp4;
        void vgvpn4;
        void vgvp3e2;
        void vgvp3e1;
        void vgvp3;
        void vgvpn3;
        void vgvp2e2;
        void vgvp2e1;
        void vgvp2;
        void vgvpn2;
        void vgvp1e2;
        void vgvp1e1;
        void vgvp1;
        void vgvpn1;
        void vsprs3;
        void vsp26;
        void vspqn26;
        void vspp26_2;
        void vspp26_1;
        void vsp32;
        void vspqn32;
        void vgvp7e2;
        void vgvp7e1;
        void vgvp7;
        void vgvpn7;
        void vsprs47;
        void vsp47;
        void vspqn47;
        void vspp47_3;
        void vspp47_2;
        void vsp45;
        void vspqn45;
        void vsp34;
        void vspqn34;
        void vsprs35;
        void vsp35;
        void vspqn35;
        void vsp31p2;
        void vsp33;
        void vspqn33;
        void vsp37;
        void vspqn37;
        void vsp41;
        void vspqn41;
        void vsp40;
        void vspqn40;
        void vsp39;
        void vspqn39;
        void vsp38;
        void vspqn38;
        void vsprs31;
        void vsp31;
        void vspqn31;
        void vsprs30;
        void vsp30;
        void vspqn30;
        void vsp29;
        void vspqn29;
        void vsp28;
        void vspqn28;
        void vsp27;
        void vspqn27;
        void vsp25;
        void vspqn25;
        void vsp24;
        void vspqn24;
        void vsp23;
        void vspqn23;
        void vspp23;
        void vsp22;
        void vspqn22;
        void vspp22;
        void vsp21;
        void vspqn21;
        void vspp21;
        void vsp20;
        void vspqn20;
        void vsp19;
        void vspqn19;
        void vsp18;
        void vspqn18;
        void vsp17;
        void vspqn17;
        void vsp16;
        void vspqn16;
        void vsp15;
        void vspqn15;
        void vsp14;
        void vspqn14;
        void vsprs2;
        void vsp13;
        void vspqn13;
        void vsp12;
        void vspqn12;
        void vsp11;
        void vspqn11;
        void vspqn10;
        void vspp3;
        void vsp9;
        void vspqn9;
        void vspp9;
        void vsp8;
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        pm1.addFunction(new FakeFunctionMetadataSource().getFunctionMethods().iterator().next());
        Schema pm2 = RealMetadataFactory.createPhysicalModel("pm2", metadataStore);
        Schema pm3 = RealMetadataFactory.createPhysicalModel("pm3", metadataStore);
        Schema pm4 = RealMetadataFactory.createPhysicalModel("pm4", metadataStore);
        Schema pm5 = RealMetadataFactory.createPhysicalModel("pm5", metadataStore);
        Schema pm6 = RealMetadataFactory.createPhysicalModel("pm6", metadataStore);
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        Schema vm2 = RealMetadataFactory.createVirtualModel("vm2", metadataStore);
        Schema xmltest = RealMetadataFactory.createVirtualModel("xmltest", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("g1", pm1);
        Table pm1g2 = RealMetadataFactory.createPhysicalGroup("g2", pm1);
        Table pm1g3 = RealMetadataFactory.createPhysicalGroup("g3", pm1);
        Table pm1g4 = RealMetadataFactory.createPhysicalGroup("g4", pm1);
        Table pm1g5 = RealMetadataFactory.createPhysicalGroup("g5", pm1);
        Table pm1g6 = RealMetadataFactory.createPhysicalGroup("g6", pm1);
        Table pm1table = RealMetadataFactory.createPhysicalGroup("table1", pm1);
        Table pm2g1 = RealMetadataFactory.createPhysicalGroup("g1", pm2);
        Table pm2g2 = RealMetadataFactory.createPhysicalGroup("g2", pm2);
        Table pm2g3 = RealMetadataFactory.createPhysicalGroup("g3", pm2);
        Table pm3g1 = RealMetadataFactory.createPhysicalGroup("g1", pm3);
        Table pm3g2 = RealMetadataFactory.createPhysicalGroup("g2", pm3);
        Table pm4g1 = RealMetadataFactory.createPhysicalGroup("g1", pm4);
        Table pm4g2 = RealMetadataFactory.createPhysicalGroup("g2", pm4);
        Table pm5g1 = RealMetadataFactory.createPhysicalGroup("g1", pm5);
        Table pm5g2 = RealMetadataFactory.createPhysicalGroup("g2", pm5);
        Table pm5g3 = RealMetadataFactory.createPhysicalGroup("g3", pm5);
        Table pm6g1 = RealMetadataFactory.createPhysicalGroup("g1", pm6);
        RealMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<Column> pm1g4e = RealMetadataFactory.createElements(pm1g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        pm1g4e.get(1).setSelectable(false);
        pm1g4e.get(3).setSelectable(false);
        List<Column> pm1g5e = RealMetadataFactory.createElements(pm1g5, new String[]{"e1"}, new String[]{"string"});
        pm1g5e.get(0).setSelectable(false);
        RealMetadataFactory.createElements(pm1g6, new String[]{"in", "in3"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(pm1table, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm3g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "date", "time", "timestamp"});
        RealMetadataFactory.createElements(pm3g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "date", "time", "timestamp"});
        List<Column> pm4g1e = RealMetadataFactory.createElements(pm4g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<Column> pm4g2e = RealMetadataFactory.createElements(pm4g2, new String[]{"e1", "e2", "e3", "e4", "e5", "e6"}, new String[]{"string", "integer", "boolean", "double", "string", "integer"});
        List<Column> pm5g1e = RealMetadataFactory.createElements(pm5g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<Column> pm5g2e = RealMetadataFactory.createElements(pm5g2, new String[]{"e1", "e2", "e3", "e4", "e5", "e6"}, new String[]{"string", "integer", "boolean", "double", "string", "integer"});
        RealMetadataFactory.createElements(pm5g3, new String[]{"e1", "e2"}, new String[]{"string", "short"});
        RealMetadataFactory.createElements(pm6g1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ArrayList<Object> elements = new ArrayList<Column>(1);
        elements.add(pm4g1e.iterator().next());
        RealMetadataFactory.createAccessPattern("pm4.g1.ap1", pm4g1, elements);
        elements = new ArrayList(2);
        Iterator<Column> iter = pm4g2e.iterator();
        elements.add(iter.next());
        elements.add(iter.next());
        RealMetadataFactory.createAccessPattern("pm4.g2.ap1", pm4g2, elements);
        elements = new ArrayList(1);
        elements.add(pm4g2e.get(4));
        RealMetadataFactory.createAccessPattern("pm4.g2.ap2", pm4g2, elements);
        elements = new ArrayList(1);
        elements.add(pm5g1e.iterator().next());
        RealMetadataFactory.createAccessPattern("pm5.g1.ap1", pm5g1, elements);
        elements = new ArrayList(2);
        iter = pm5g2e.iterator();
        elements.add(iter.next());
        elements.add(iter.next());
        RealMetadataFactory.createAccessPattern("pm5.g2.ap1", pm5g2, elements);
        elements = new ArrayList(1);
        elements.add(pm5g2e.get(4));
        RealMetadataFactory.createAccessPattern("pm5.g2.ap2", pm5g2, elements);
        Table tm1g1 = RealMetadataFactory.createXmlStagingTable("doc4.tm1.g1", xmltest, new QueryNode("select null, null, null, null, null"));
        RealMetadataFactory.createElements(tm1g1, new String[]{"e1", "e2", "e3", "e4", "node1"}, new String[]{"string", "integer", "boolean", "double", "string"});
        QueryNode vm1g1n1 = new QueryNode("SELECT * FROM pm1.g1");
        Table vm1g1 = RealMetadataFactory.createUpdatableVirtualGroup("g1", vm1, vm1g1n1);
        QueryNode vm2g1n1 = new QueryNode("SELECT pm1.g1.* FROM pm1.g1, pm1.g2 where pm1.g1.e2 = pm1.g2.e2");
        Table vm2g1 = RealMetadataFactory.createUpdatableVirtualGroup("g1", vm2, vm2g1n1);
        QueryNode vm1g1n1_defect10711 = new QueryNode("SELECT * FROM vm1.g1 as X");
        Table vm1g1_defect10711 = RealMetadataFactory.createVirtualGroup("g1a", vm1, vm1g1n1_defect10711);
        QueryNode vm1g1n1_defect12081 = new QueryNode("SELECT e1, upper(e1) as e1Upper FROM pm1.g1");
        Table vm1g1_defect12081 = RealMetadataFactory.createVirtualGroup("g1b", vm1, vm1g1n1_defect12081);
        QueryNode vm1g1n1c = new QueryNode("SELECT PARSETIMESTAMP(pm1.g1.e1, 'MMM dd yyyy hh:mm:ss') as e5, e2, e3, e4 FROM pm1.g1");
        Table vm1g1c = RealMetadataFactory.createVirtualGroup("g1c", vm1, vm1g1n1c);
        QueryNode vm1g2an1 = new QueryNode("SELECT * FROM pm1.g2");
        Table vm1g2a = RealMetadataFactory.createVirtualGroup("g2a", vm1, vm1g2an1);
        QueryNode vm1g2n1 = new QueryNode("SELECT pm1.g1.e1, pm1.g1.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1=pm1.g2.e1");
        Table vm1g2 = RealMetadataFactory.createVirtualGroup("g2", vm1, vm1g2n1);
        QueryNode vm1g4n1 = new QueryNode("SELECT e1 FROM pm1.g1 UNION ALL SELECT convert(e2, string) as x FROM pm1.g2 ORDER BY e1");
        Table vm1g4 = RealMetadataFactory.createVirtualGroup("g4", vm1, vm1g4n1);
        QueryNode vm1g5n1 = new QueryNode("SELECT concat(e1, 'val'), e2 FROM pm1.g1");
        Table vm1g5 = RealMetadataFactory.createVirtualGroup("g5", vm1, vm1g5n1);
        QueryNode vm1g6n1 = new QueryNode("SELECT concat(e1, 'val') AS e, e2 FROM pm1.g1");
        Table vm1g6 = RealMetadataFactory.createVirtualGroup("g6", vm1, vm1g6n1);
        QueryNode vm1g7n1 = new QueryNode("SELECT concat(e1, e2) AS e, e2 FROM pm1.g1");
        Table vm1g7 = RealMetadataFactory.createVirtualGroup("g7", vm1, vm1g7n1);
        QueryNode vm1g8n1 = new QueryNode("SELECT concat(e1, 'val') AS e, e2 FROM pm1.g1 ORDER BY e");
        Table vm1g8 = RealMetadataFactory.createVirtualGroup("g8", vm1, vm1g8n1);
        QueryNode vm1g9n1 = new QueryNode("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1, pm4.g1 WHERE pm1.g1.e1 = pm4.g1.e1");
        Table vm1g9 = RealMetadataFactory.createVirtualGroup("g9", vm1, vm1g9n1);
        QueryNode vm1g10n1 = new QueryNode("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1, pm4.g2 WHERE pm1.g1.e1 = pm4.g2.e1");
        Table vm1g10 = RealMetadataFactory.createVirtualGroup("g10", vm1, vm1g10n1);
        QueryNode vm1g11n1 = new QueryNode("SELECT * FROM pm4.g2");
        Table vm1g11 = RealMetadataFactory.createVirtualGroup("g11", vm1, vm1g11n1);
        QueryNode vm1g12n1 = new QueryNode("SELECT DISTINCT * FROM pm3.g1");
        Table vm1g12 = RealMetadataFactory.createVirtualGroup("g12", vm1, vm1g12n1);
        QueryNode vm1g13n1 = new QueryNode("SELECT DISTINCT * FROM pm3.g1 ORDER BY e1");
        Table vm1g13 = RealMetadataFactory.createVirtualGroup("g13", vm1, vm1g13n1);
        QueryNode vm1g14n1 = new QueryNode("SELECT * FROM pm3.g1 ORDER BY e1");
        Table vm1g14 = RealMetadataFactory.createVirtualGroup("g14", vm1, vm1g14n1);
        QueryNode vm1g15n1 = new QueryNode("SELECT e1, concat(e1, convert(e2, string)) AS x FROM pm3.g1");
        Table vm1g15 = RealMetadataFactory.createVirtualGroup("g15", vm1, vm1g15n1);
        QueryNode vm1g16n1 = new QueryNode("SELECT concat(e1, 'val') AS e, e2 FROM pm3.g1 ORDER BY e");
        Table vm1g16 = RealMetadataFactory.createVirtualGroup("g16", vm1, vm1g16n1);
        QueryNode vm1g17n1 = new QueryNode("SELECT pm3.g1.e1, pm3.g1.e2 FROM pm3.g1 UNION ALL SELECT pm3.g2.e1, pm3.g2.e2 FROM pm3.g2 ORDER BY e2");
        Table vm1g17 = RealMetadataFactory.createVirtualGroup("g17", vm1, vm1g17n1);
        QueryNode vm1g18n1 = new QueryNode("SELECT (e4 * 100.0) as x FROM pm1.g1");
        Table vm1g18 = RealMetadataFactory.createVirtualGroup("g18", vm1, vm1g18n1);
        QueryNode vm1g19n1 = new QueryNode("Select * from vm1.g4 where not (e1 in (select e1 FROM vm1.g1 WHERE vm1.g4.e1 = e1))");
        Table vm1g19 = RealMetadataFactory.createVirtualGroup("g19", vm1, vm1g19n1);
        QueryNode vm1g20n1 = new QueryNode("Select * from vm1.g1 where exists (select e1 FROM vm1.g2 WHERE vm1.g1.e1 = e1)");
        Table vm1g20 = RealMetadataFactory.createVirtualGroup("g20", vm1, vm1g20n1);
        QueryNode vm1g21n1 = new QueryNode("Select * from pm1.g1 where exists (select e1 FROM pm2.g1 WHERE pm1.g1.e1 = e1)");
        Table vm1g21 = RealMetadataFactory.createVirtualGroup("g21", vm1, vm1g21n1);
        QueryNode vm1g22n1 = new QueryNode("Select e1, e2, e3, e4, (select e4 FROM vm1.g21 WHERE vm1.g20.e4 = e4 and e4 = 7.0) as E5 from vm1.g20");
        Table vm1g22 = RealMetadataFactory.createVirtualGroup("g22", vm1, vm1g22n1);
        QueryNode vm1g23n1 = new QueryNode("Select e1, e2, e3, e4, (select e4 FROM vm1.g21 WHERE vm1.g20.e4 = 7.0 and e4 = 7.0) as E5 from vm1.g20");
        Table vm1g23 = RealMetadataFactory.createVirtualGroup("g23", vm1, vm1g23n1);
        QueryNode vm1g24n1 = new QueryNode("Select * from vm1.g20 where exists (select * FROM vm1.g21 WHERE vm1.g20.e4 = E4)");
        Table vm1g24 = RealMetadataFactory.createVirtualGroup("g24", vm1, vm1g24n1);
        QueryNode vm1g25n1 = new QueryNode("Select e1, e2, e3, e4, (select e4 FROM pm1.g2 WHERE e1 = 'b') as E5 from pm1.g1");
        Table vm1g25 = RealMetadataFactory.createVirtualGroup("g25", vm1, vm1g25n1);
        QueryNode vm1g26n1 = new QueryNode("Select e1, e2, e3, e4, (select e4 FROM pm1.g2 WHERE e4 = pm1.g1.e4 and e1 = 'b') as E5 from pm1.g1");
        Table vm1g26 = RealMetadataFactory.createVirtualGroup("g26", vm1, vm1g26n1);
        QueryNode vm1g27n1 = new QueryNode("SELECT upper(e1) as x, e1 FROM pm1.g1");
        Table vm1g27 = RealMetadataFactory.createVirtualGroup("g27", vm1, vm1g27n1);
        QueryNode vm1g28n1 = new QueryNode("SELECT DISTINCT x as a, lower(e1) as x FROM vm1.g27");
        Table vm1g28 = RealMetadataFactory.createVirtualGroup("g28", vm1, vm1g28n1);
        QueryNode vm1g29n1 = new QueryNode("SELECT DISTINCT x, lower(e1) FROM vm1.g27");
        Table vm1g29 = RealMetadataFactory.createVirtualGroup("g29", vm1, vm1g29n1);
        QueryNode vm1g30n1 = new QueryNode("SELECT DISTINCT e1 as x, e1 as y FROM pm1.g1");
        Table vm1g30 = RealMetadataFactory.createVirtualGroup("g30", vm1, vm1g30n1);
        QueryNode vm1g31n1 = new QueryNode("SELECT e1 as x, e1 as y FROM pm1.g1 ORDER BY x");
        Table vm1g31 = RealMetadataFactory.createVirtualGroup("g31", vm1, vm1g31n1);
        QueryNode vm1g32n1 = new QueryNode("SELECT DISTINCT e1 as x, e1 as y FROM pm1.g1 ORDER BY x");
        Table vm1g32 = RealMetadataFactory.createVirtualGroup("g32", vm1, vm1g32n1);
        QueryNode vm1g33n1 = new QueryNode("SELECT e2 FROM pm1.g1 WHERE 2 = e2");
        Table vm1g33 = RealMetadataFactory.createVirtualGroup("g33", vm1, vm1g33n1);
        QueryNode vm1g34n1 = new QueryNode("SELECT e1 as e1_, e2 as e2_ FROM pm1.g1 UNION ALL SELECT e1 as e1_, e2 as e2_ FROM pm2.g1");
        Table vm1g34 = RealMetadataFactory.createVirtualGroup("g34", vm1, vm1g34n1);
        QueryNode vm1g36n1 = new QueryNode("SELECT pm1.g1.e1 as ve1, pm1.g2.e1 as ve2 FROM pm1.g1 LEFT OUTER JOIN /* optional */ pm1.g2 on pm1.g1.e1 = pm1.g2.e1");
        Table vm1g36 = RealMetadataFactory.createVirtualGroup("g36", vm1, vm1g36n1);
        QueryNode vm1g37n1 = new QueryNode("SELECT * from pm4.g1");
        Table vm1g37 = RealMetadataFactory.createVirtualGroup("g37", vm1, vm1g37n1);
        vm1g37.setSupportsUpdate(true);
        vm1g37.setDeletePlan("for each row begin atomic end");
        QueryNode vm1g38n1 = new QueryNode("SELECT a.e1, b.e2 from pm1.g1 as a, pm6.g1 as b where a.e1=b.e1");
        Table vm1g38 = RealMetadataFactory.createVirtualGroup("g38", vm1, vm1g38n1);
        QueryNode vm1g39n1 = new QueryNode("SELECT * FROM pm1.g1");
        Table vm1g39 = RealMetadataFactory.createUpdatableVirtualGroup("g39", vm1, vm1g39n1, null);
        RealMetadataFactory.createElements(vm1g39, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g1_defect10711, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g1_defect12081, new String[]{"e1", "e1Upper"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g1c, new String[]{"e5", "e2", "e3", "e4"}, new String[]{"timestamp", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g2a, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g4, new String[]{"e1"}, new String[]{"string"});
        RealMetadataFactory.createElements(vm1g5, new String[]{"expr", "e2"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1g6, new String[]{"e", "e2"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1g7, new String[]{"e", "e2"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1g8, new String[]{"e", "e2"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1g9, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1g10, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1g11, new String[]{"e1", "e2", "e3", "e4", "e5", "e6"}, new String[]{"string", "integer", "boolean", "double", "string", "integer"});
        RealMetadataFactory.createElements(vm1g12, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "date", "time", "timestamp"});
        RealMetadataFactory.createElements(vm1g13, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "date", "time", "timestamp"});
        RealMetadataFactory.createElements(vm1g14, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "date", "time", "timestamp"});
        RealMetadataFactory.createElements(vm1g15, new String[]{"e1", "x"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g16, new String[]{"e", "e2"}, new String[]{"string", "date"});
        RealMetadataFactory.createElements(vm1g17, new String[]{"e1", "e2"}, new String[]{"string", "date"});
        RealMetadataFactory.createElements(vm1g18, new String[]{"x"}, new String[]{"double"});
        RealMetadataFactory.createElements(vm1g19, new String[]{"e1"}, new String[]{"string"});
        RealMetadataFactory.createElements(vm1g20, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g21, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g22, new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"string", "integer", "boolean", "double", "double"});
        RealMetadataFactory.createElements(vm1g23, new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"string", "integer", "boolean", "double", "double"});
        RealMetadataFactory.createElements(vm1g24, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g25, new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"string", "integer", "boolean", "double", "double"});
        RealMetadataFactory.createElements(vm1g26, new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"string", "integer", "boolean", "double", "double"});
        RealMetadataFactory.createElements(vm1g27, new String[]{"x", "e1"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g28, new String[]{"a", "x"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g29, new String[]{"x", "expr"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g30, new String[]{"x", "y"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g31, new String[]{"x", "y"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g32, new String[]{"x", "y"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g33, new String[]{"e2"}, new String[]{"integer"});
        RealMetadataFactory.createElements(vm1g34, new String[]{"e1_", "e2_"}, new String[]{"string", "integer"});
        RealMetadataFactory.createElements(vm1g36, new String[]{"ve1", "ve2"}, new String[]{"string", "string"});
        List<Column> vm1g37e = RealMetadataFactory.createElements(vm1g37, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g38, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        elements = new ArrayList(1);
        elements.add(vm1g37e.iterator().next());
        RealMetadataFactory.createAccessPattern("vm1.g37.ap1", vm1g37, elements);
        RealMetadataFactory.createXmlDocument("doc1", xmltest, RealMetadataFactory.exampleDoc1());
        RealMetadataFactory.createXmlDocument("doc2", xmltest, RealMetadataFactory.exampleDoc2());
        RealMetadataFactory.createXmlDocument("doc3", xmltest, RealMetadataFactory.exampleDoc3());
        RealMetadataFactory.createXmlDocument("doc4", xmltest, RealMetadataFactory.exampleDoc4());
        RealMetadataFactory.createXmlDocument("doc5", xmltest, RealMetadataFactory.exampleDoc5());
        RealMetadataFactory.createXmlDocument("doc6", xmltest, RealMetadataFactory.exampleDoc6());
        RealMetadataFactory.createXmlDocument("xmltest2.docA", vm1, RealMetadataFactory.exampleDoc1());
        RealMetadataFactory.createXmlDocument("xmltest3.docA", vm1, RealMetadataFactory.exampleDoc2());
        QueryNode mc1n1 = new QueryNode("SELECT e1 FROM pm1.g1 UNION ALL SELECT e1 FROM pm1.g2");
        Table vm1mc1 = RealMetadataFactory.createVirtualGroup("mc1", xmltest, mc1n1);
        RealMetadataFactory.createElements(vm1mc1, new String[]{"e1"}, new String[]{"string"});
        ColumnSet<Procedure> rs1 = RealMetadataFactory.createResultSet("pm1.rs1", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        QueryNode sq1n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1; END");
        Procedure sq1 = RealMetadataFactory.createVirtualProcedure("sq1", pm1, null, sq1n1);
        sq1.setResultSet(rs1);
        ColumnSet<Procedure> rs2 = RealMetadataFactory.createResultSet("ret", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter rs2p2 = RealMetadataFactory.createParameter("in", 1, "string");
        QueryNode sq2n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq2.in; END");
        Procedure sq2 = RealMetadataFactory.createVirtualProcedure("sq2", pm1, Arrays.asList(rs2p2), sq2n1);
        sq2.setResultSet(rs2);
        ColumnSet<Procedure> rs5 = RealMetadataFactory.createResultSet("pm1.r5", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter rs5p2 = RealMetadataFactory.createParameter("in", 1, "string");
        ProcedureParameter rs5p3 = RealMetadataFactory.createParameter("in2", 1, "integer");
        QueryNode sq3n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq3.in UNION ALL SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sq3.in2; END");
        Procedure sq3 = RealMetadataFactory.createVirtualProcedure("sq3", pm1, Arrays.asList(rs5p2, rs5p3), sq3n1);
        sq3.setResultSet(rs5);
        ColumnSet<Procedure> rs5a = RealMetadataFactory.createResultSet("pm1.r5a", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter rs5p1a = RealMetadataFactory.createParameter("in", 1, "string");
        ProcedureParameter rs5p2a = RealMetadataFactory.createParameter("in2", 1, "integer");
        QueryNode sq3n1a = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq3a.in UNION ALL SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sq3a.in2; END");
        Procedure sq3a = RealMetadataFactory.createVirtualProcedure("sq3a", pm1, Arrays.asList(rs5p1a, rs5p2a), sq3n1a);
        sq3a.setResultSet(rs5a);
        ColumnSet<Procedure> rs5b = RealMetadataFactory.createResultSet("pm1.r5b", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter rs5p2b = RealMetadataFactory.createParameter("in", 1, "string");
        ProcedureParameter rs5p3b = RealMetadataFactory.createParameter("in2", 1, "integer");
        ProcedureParameter rs5p4b = RealMetadataFactory.createParameter("in3", 1, "string");
        rs5p3b.setNullType(BaseColumn.NullType.Nullable);
        rs5p4b.setDefaultValue("YYZ");
        QueryNode sq3n1b = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq3b.in UNION ALL SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sq3b.in2; END");
        Procedure sq3b = RealMetadataFactory.createVirtualProcedure("sq3b", pm1, Arrays.asList(rs5p2b, rs5p3b, rs5p4b), sq3n1b);
        sq3b.setResultSet(rs5b);
        ColumnSet<Procedure> rsDefaults = RealMetadataFactory.createResultSet("pm1.rDefaults", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter rsDefaultsParameterString = RealMetadataFactory.createParameter("inString", 1, "string");
        rsDefaultsParameterString.setDefaultValue(new String("x"));
        ProcedureParameter rsParameterBigDecimal = RealMetadataFactory.createParameter("inBigDecimal", 1, "bigdecimal");
        rsParameterBigDecimal.setNullType(BaseColumn.NullType.Nullable);
        rsParameterBigDecimal.setDefaultValue(new String("13.0"));
        ProcedureParameter rsParameterBigInteger = RealMetadataFactory.createParameter("inBigInteger", 1, "biginteger");
        rsParameterBigInteger.setNullType(BaseColumn.NullType.Nullable);
        rsParameterBigInteger.setDefaultValue(new String("13"));
        ProcedureParameter rsParameterBoolean = RealMetadataFactory.createParameter("inBoolean", 1, "boolean");
        rsParameterBoolean.setNullType(BaseColumn.NullType.Nullable);
        rsParameterBoolean.setDefaultValue(new String("True"));
        ProcedureParameter rsParameterByte = RealMetadataFactory.createParameter("inByte", 1, "byte");
        rsParameterByte.setNullType(BaseColumn.NullType.Nullable);
        rsParameterByte.setDefaultValue(new String("1"));
        ProcedureParameter rsParameterChar = RealMetadataFactory.createParameter("inChar", 1, "char");
        rsParameterChar.setNullType(BaseColumn.NullType.Nullable);
        rsParameterChar.setDefaultValue(new String("q"));
        ProcedureParameter rsParameterDate = RealMetadataFactory.createParameter("inDate", 1, "date");
        rsParameterDate.setNullType(BaseColumn.NullType.Nullable);
        rsParameterDate.setDefaultValue(new String("2003-03-20"));
        ProcedureParameter rsParameterDouble = RealMetadataFactory.createParameter("inDouble", 1, "double");
        rsParameterDouble.setNullType(BaseColumn.NullType.Nullable);
        rsParameterDouble.setDefaultValue(new String("13.0"));
        ProcedureParameter rsParameterFloat = RealMetadataFactory.createParameter("inFloat", 1, "float");
        rsParameterFloat.setNullType(BaseColumn.NullType.Nullable);
        rsParameterFloat.setDefaultValue(new String("13"));
        ProcedureParameter rsParameterInteger = RealMetadataFactory.createParameter("inInteger", 1, "integer");
        rsParameterInteger.setNullType(BaseColumn.NullType.Nullable);
        rsParameterInteger.setDefaultValue(new String("13"));
        ProcedureParameter rsParameterLong = RealMetadataFactory.createParameter("inLong", 1, "long");
        rsParameterLong.setNullType(BaseColumn.NullType.Nullable);
        rsParameterLong.setDefaultValue(new String("13"));
        ProcedureParameter rsParameterShort = RealMetadataFactory.createParameter("inShort", 1, "short");
        rsParameterShort.setNullType(BaseColumn.NullType.Nullable);
        rsParameterShort.setDefaultValue(new String("13"));
        ProcedureParameter rsParameterTimestamp = RealMetadataFactory.createParameter("inTimestamp", 1, "timestamp");
        rsParameterTimestamp.setNullType(BaseColumn.NullType.Nullable);
        rsParameterTimestamp.setDefaultValue(new String("2003-03-20 21:26:00.000000"));
        ProcedureParameter rsParameterTime = RealMetadataFactory.createParameter("inTime", 1, "time");
        rsParameterTime.setNullType(BaseColumn.NullType.Nullable);
        rsParameterTime.setDefaultValue(new String("21:26:00"));
        QueryNode sqDefaultsNode = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sqDefaults.inString UNION ALL SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sqDefaults.inInteger; END");
        Procedure sqDefaults = RealMetadataFactory.createVirtualProcedure("sqDefaults", pm1, Arrays.asList(rsDefaultsParameterString, rsParameterBigDecimal, rsParameterBigInteger, rsParameterBoolean, rsParameterByte, rsParameterChar, rsParameterDate, rsParameterDouble, rsParameterFloat, rsParameterInteger, rsParameterLong, rsParameterShort, rsParameterTimestamp, rsParameterTime), sqDefaultsNode);
        sqDefaults.setResultSet(rsDefaults);
        RealMetadataFactory.createResultSet("pm1.rBadDefault", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter paramBadDefaultIn = RealMetadataFactory.createParameter("in", 1, "integer");
        paramBadDefaultIn.setNullType(BaseColumn.NullType.Nullable);
        paramBadDefaultIn.setDefaultValue("Clearly Not An Integer");
        QueryNode sqnBadDefault = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sqBadDefault.in; END");
        RealMetadataFactory.createVirtualProcedure("sqBadDefault", pm1, Arrays.asList(paramBadDefaultIn), sqnBadDefault);
        ColumnSet<Procedure> rs3 = RealMetadataFactory.createResultSet("pm1.rs3", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        Procedure sp1 = RealMetadataFactory.createStoredProcedure("sp1", pm1, null);
        sp1.setResultSet(rs3);
        ColumnSet<Procedure> rs4 = RealMetadataFactory.createResultSet("pm1.rs4", new String[]{"e1"}, new String[]{"string"});
        QueryNode sqsp1n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sp1()) as x; END");
        Procedure sqsp1 = RealMetadataFactory.createVirtualProcedure("sqsp1", pm1, null, sqsp1n1);
        sqsp1.setResultSet(rs4);
        ColumnSet<Procedure> rs6 = RealMetadataFactory.createResultSet("pm1.rs6", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        QueryNode sq4n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sq1(); END");
        Procedure sq4 = RealMetadataFactory.createVirtualProcedure("sq4", pm1, null, sq4n1);
        sq4.setResultSet(rs6);
        ColumnSet<Procedure> rs7 = RealMetadataFactory.createResultSet("pm1.rs7", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter rs7p2 = RealMetadataFactory.createParameter("in1", 1, "string");
        QueryNode sq5n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sq2(pm1.sq5.in1); END");
        Procedure sq5 = RealMetadataFactory.createVirtualProcedure("sq5", pm1, Arrays.asList(rs7p2), sq5n1);
        sq5.setResultSet(rs7);
        ColumnSet<Procedure> rs8 = RealMetadataFactory.createResultSet("pm1.rs8", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        QueryNode sq6n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sq2('1'); END");
        Procedure sq6 = RealMetadataFactory.createVirtualProcedure("sq6", pm1, null, sq6n1);
        sq6.setResultSet(rs8);
        ColumnSet<Procedure> rs9 = RealMetadataFactory.createResultSet("pm1.rs9", new String[]{"e1"}, new String[]{"string"});
        QueryNode sq7n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sq1()) as x; END");
        Procedure sq7 = RealMetadataFactory.createVirtualProcedure("sq7", pm1, null, sq7n1);
        sq7.setResultSet(rs9);
        ColumnSet<Procedure> rs10 = RealMetadataFactory.createResultSet("pm1.rs10", new String[]{"e1"}, new String[]{"string"});
        ProcedureParameter rs10p2 = RealMetadataFactory.createParameter("in", 1, "string");
        QueryNode sq8n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sq1()) as x WHERE x.e1=pm1.sq8.in; END");
        Procedure sq8 = RealMetadataFactory.createVirtualProcedure("sq8", pm1, Arrays.asList(rs10p2), sq8n1);
        sq8.setResultSet(rs10);
        ColumnSet<Procedure> rs11 = RealMetadataFactory.createResultSet("pm1.rs11", new String[]{"e1"}, new String[]{"string"});
        ProcedureParameter rs11p2 = RealMetadataFactory.createParameter("in", 1, "string");
        QueryNode sq9n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sq2(pm1.sq9.in)) as x; END");
        Procedure sq9 = RealMetadataFactory.createVirtualProcedure("sq9", pm1, Arrays.asList(rs11p2), sq9n1);
        sq9.setResultSet(rs11);
        ColumnSet<Procedure> rs12 = RealMetadataFactory.createResultSet("pm1.rs12", new String[]{"e1"}, new String[]{"string"});
        ProcedureParameter rs12p2 = RealMetadataFactory.createParameter("in", 1, "string");
        ProcedureParameter rs12p3 = RealMetadataFactory.createParameter("in2", 1, "integer");
        QueryNode sq10n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sq2(pm1.sq10.in)) as x where e2=pm1.sq10.in2; END");
        Procedure sq10 = RealMetadataFactory.createVirtualProcedure("sq10", pm1, Arrays.asList(rs12p2, rs12p3), sq10n1);
        sq10.setResultSet(rs12);
        ColumnSet<Procedure> rs13 = RealMetadataFactory.createResultSet("pm1.rs13", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter rs13p2 = RealMetadataFactory.createParameter("in", 1, "integer");
        Procedure sp2 = RealMetadataFactory.createStoredProcedure("sp2", pm1, Arrays.asList(rs13p2));
        sp2.setResultSet(rs13);
        ColumnSet<Procedure> rs14 = RealMetadataFactory.createResultSet("pm1.rs14", new String[]{"e1"}, new String[]{"string"});
        ProcedureParameter rs14p2 = RealMetadataFactory.createParameter("in", 1, "string");
        ProcedureParameter rs14p3 = RealMetadataFactory.createParameter("in2", 1, "integer");
        QueryNode sq11n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sp2(?)) as x where e2=pm1.sq11.in; END");
        Procedure sq11 = RealMetadataFactory.createVirtualProcedure("sq11", pm1, Arrays.asList(rs14p2, rs14p3), sq11n1);
        sq11.setResultSet(rs14);
        ColumnSet<Procedure> rs15 = RealMetadataFactory.createResultSet("pm1.rs15", new String[]{"count"}, new String[]{"integer"});
        ProcedureParameter rs15p2 = RealMetadataFactory.createParameter("in", 1, "string");
        ProcedureParameter rs15p3 = RealMetadataFactory.createParameter("in2", 1, "integer");
        QueryNode sq12n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN INSERT INTO pm1.g1 ( e1, e2 ) VALUES( pm1.sq12.in, pm1.sq12.in2 ); END");
        Procedure sq12 = RealMetadataFactory.createVirtualProcedure("sq12", pm1, Arrays.asList(rs15p2, rs15p3), sq12n1);
        sq12.setResultSet(rs15);
        ColumnSet<Procedure> rs16 = RealMetadataFactory.createResultSet("pm1.rs16", new String[]{"count"}, new String[]{"integer"});
        ProcedureParameter rs16p2 = RealMetadataFactory.createParameter("in", 1, "string");
        QueryNode sq13n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN INSERT INTO pm1.g1 ( e1, e2 ) VALUES( pm1.sq13.in, 2 ); END");
        Procedure sq13 = RealMetadataFactory.createVirtualProcedure("sq13", pm1, Arrays.asList(rs16p2), sq13n1);
        sq13.setResultSet(rs16);
        ColumnSet<Procedure> rs17 = RealMetadataFactory.createResultSet("pm1.rs17", new String[]{"count"}, new String[]{"integer"});
        ProcedureParameter rs17p2 = RealMetadataFactory.createParameter("in", 1, "string");
        ProcedureParameter rs17p3 = RealMetadataFactory.createParameter("in2", 1, "integer");
        QueryNode sq14n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN UPDATE pm1.g1 SET e1 = pm1.sq14.in WHERE e2 = pm1.sq14.in2; END");
        Procedure sq14 = RealMetadataFactory.createVirtualProcedure("sq14", pm1, Arrays.asList(rs17p2, rs17p3), sq14n1);
        sq14.setResultSet(rs17);
        ColumnSet<Procedure> rs18 = RealMetadataFactory.createResultSet("pm1.rs17", new String[]{"count"}, new String[]{"integer"});
        ProcedureParameter rs18p2 = RealMetadataFactory.createParameter("in", 1, "string");
        ProcedureParameter rs18p3 = RealMetadataFactory.createParameter("in2", 1, "integer");
        QueryNode sq15n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DELETE FROM pm1.g1 WHERE e1 = pm1.sq15.in AND e2 = pm1.sq15.in2; END");
        Procedure sq15 = RealMetadataFactory.createVirtualProcedure("sq15", pm1, Arrays.asList(rs18p2, rs18p3), sq15n1);
        sq15.setResultSet(rs18);
        QueryNode sq16n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN INSERT INTO pm1.g1 ( e1, e2 ) VALUES( 1, 2 ); END");
        RealMetadataFactory.createVirtualProcedure("sq16", pm1, null, sq16n1);
        ColumnSet<Procedure> rs19 = RealMetadataFactory.createResultSet("pm1.rs19", new String[]{"xml"}, new String[]{"string"});
        QueryNode sq17n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT * FROM xmltest.doc1; END");
        Procedure sq17 = RealMetadataFactory.createVirtualProcedure("sq17", pm1, null, sq17n1);
        sq17.setResultSet(rs19);
        RealMetadataFactory.createStoredProcedure("sp3", pm1, null);
        ColumnSet<Procedure> rs20 = RealMetadataFactory.createResultSet("pm1.rs20", new String[]{"xml"}, new String[]{"string"});
        QueryNode sq18n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT * FROM xmltest.doc1; END");
        Procedure sq18 = RealMetadataFactory.createVirtualProcedure("sq18", pm1, null, sq18n1);
        sq18.setResultSet(rs20);
        ColumnSet<Procedure> rs21 = RealMetadataFactory.createResultSet("pm1.rs21", new String[]{"xml"}, new String[]{"string"});
        ProcedureParameter sq19p2 = RealMetadataFactory.createParameter("param1", 1, "string");
        QueryNode sq19n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT * FROM xmltest.doc4 WHERE root.node1 = param1; END");
        Procedure sq19 = RealMetadataFactory.createVirtualProcedure("sq19", pm1, Arrays.asList(sq19p2), sq19n1);
        sq19.setResultSet(rs21);
        ColumnSet<Procedure> rs22 = RealMetadataFactory.createResultSet("pm1.rs13", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter rs22p2 = RealMetadataFactory.createParameter("in", 1, "biginteger");
        Procedure sp4 = RealMetadataFactory.createStoredProcedure("sp4", pm1, Arrays.asList(rs22p2));
        sp4.setResultSet(rs22);
        RealMetadataFactory.createStoredProcedure("sp5", pm1, new ArrayList<ProcedureParameter>());
        ColumnSet<Procedure> vsprs1 = RealMetadataFactory.vsprs1();
        QueryNode vspqn1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN x=mycursor.e2; IF(x = 15) BEGIN BREAK; END END SELECT e1 FROM pm1.g1 where pm1.g1.e2 = x; END");
        Procedure vsp1 = RealMetadataFactory.createVirtualProcedure("vsp1", pm1, null, vspqn1);
        vsp1.setResultSet(vsprs1);
        QueryNode vspqn2 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN x=mycursor.e2; END SELECT e1 FROM pm1.g1; END");
        Procedure vsp2 = RealMetadataFactory.createVirtualProcedure("vsp2", pm1, null, vspqn2);
        vsp2.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode vspqn3 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN x=mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        Procedure vsp3 = RealMetadataFactory.createVirtualProcedure("vsp3", pm1, null, vspqn3);
        vsp3.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode vspqn4 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN IF(mycursor.e2 > 10) BEGIN BREAK; END x=mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        Procedure vsp4 = RealMetadataFactory.createVirtualProcedure("vsp4", pm1, null, vspqn4);
        vsp4.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode vspqn5 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN IF(mycursor.e2 > 10) BEGIN CONTINUE; END x=mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        Procedure vsp5 = RealMetadataFactory.createVirtualProcedure("vsp5", pm1, null, vspqn5);
        vsp5.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode vspqn6 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE (x < 15) BEGIN x=x+1; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        Procedure vsp6 = RealMetadataFactory.createVirtualProcedure("vsp6", pm1, null, vspqn6);
        vsp6.setResultSet(RealMetadataFactory.vsprs1());
        ProcedureParameter vspp2 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode vspqn7 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE (x < 12) BEGIN x=x+pm1.vsp7.param1; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        Procedure vsp7 = RealMetadataFactory.createVirtualProcedure("vsp7", pm1, Arrays.asList(vspp2), vspqn7);
        vsp7.setResultSet(RealMetadataFactory.vsprs1());
        ProcedureParameter vspp8 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode vspqn8 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE (x < 12) BEGIN x=x+pm1.vsp8.param1; END SELECT e1 FROM pm1.g1 WHERE e2 >= param1; END");
        Procedure procedure = RealMetadataFactory.createVirtualProcedure("vsp8", pm1, Arrays.asList(vspp8), vspqn8);
        vsp8.setResultSet(RealMetadataFactory.vsprs1());
        ProcedureParameter procedureParameter = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE (x < param1) BEGIN x=x+pm1.vsp9.param1; END SELECT e1 FROM pm1.g1 WHERE e2 >= param1; END");
        Procedure procedure2 = RealMetadataFactory.createVirtualProcedure("vsp9", pm1, Arrays.asList(vspp9), (QueryNode)vspqn9);
        vsp9.setResultSet(RealMetadataFactory.vsprs1());
        ProcedureParameter procedureParameter2 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode2 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1 WHERE e2=param1) AS mycursor BEGIN x=mycursor.e2; END END");
        RealMetadataFactory.createVirtualProcedure("vsp10", pm1, Arrays.asList(vspp3), (QueryNode)vspqn10);
        QueryNode queryNode3 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN LOOP ON (SELECT e1 FROM pm1.g1) AS mycursor BEGIN END END SELECT e1 FROM pm1.g1; END");
        Procedure procedure3 = RealMetadataFactory.createVirtualProcedure("vsp11", pm1, null, (QueryNode)vspqn11);
        vsp11.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode4 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN END x=mycursor.e2; SELECT e1 FROM pm1.g1; END");
        Procedure procedure4 = RealMetadataFactory.createVirtualProcedure("vsp12", pm1, null, (QueryNode)vspqn12);
        vsp12.setResultSet(RealMetadataFactory.vsprs1());
        ColumnSet<Procedure> columnSet = RealMetadataFactory.vspp4();
        QueryNode queryNode5 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; LOOP ON (SELECT e1 FROM pm1.g1) AS mycursor BEGIN x=mycursor.e1; END SELECT x, 5; END");
        Procedure procedure5 = RealMetadataFactory.createVirtualProcedure("vsp13", pm1, null, (QueryNode)vspqn13);
        vsp13.setResultSet((ColumnSet)vsprs2);
        QueryNode queryNode6 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO #temptable FROM pm1.g1; SELECT e1 FROM #temptable; END");
        Procedure procedure6 = RealMetadataFactory.createVirtualProcedure("vsp14", pm1, null, (QueryNode)vspqn14);
        vsp14.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode7 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable, pm1.g2 WHERE #temptable.e2 = pm1.g2.e2; END");
        Procedure procedure7 = RealMetadataFactory.createVirtualProcedure("vsp15", pm1, null, (QueryNode)vspqn15);
        vsp15.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode8 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; SELECT a.e1 FROM (SELECT pm1.g2.e1 FROM #temptable, pm1.g2 WHERE #temptable.e2 = pm1.g2.e2) AS a; END");
        Procedure procedure8 = RealMetadataFactory.createVirtualProcedure("vsp16", pm1, null, (QueryNode)vspqn16);
        vsp16.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode9 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; SELECT e1, e2 INTO #temptable FROM pm1.g1; LOOP ON (SELECT e1, e2 FROM #temptable) AS mycursor BEGIN x=mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        Procedure procedure9 = RealMetadataFactory.createVirtualProcedure("vsp17", pm1, null, (QueryNode)vspqn17);
        vsp17.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode10 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO temptable FROM pm1.g1; END");
        Procedure procedure10 = RealMetadataFactory.createVirtualProcedure("vsp18", pm1, null, (QueryNode)vspqn18);
        vsp18.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode11 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO #temptable FROM pm1.g1; SELECT e1 INTO #temptable FROM pm1.g1; SELECT e1 FROM #temptable; END");
        Procedure procedure11 = RealMetadataFactory.createVirtualProcedure("vsp19", pm1, null, (QueryNode)vspqn19);
        vsp19.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode12 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO #temptable FROM pm1.g1; INSERT INTO #temptable(e1) VALUES( 'Fourth'); SELECT e1 FROM #temptable; END");
        Procedure procedure12 = RealMetadataFactory.createVirtualProcedure("vsp20", pm1, null, (QueryNode)vspqn20);
        vsp20.setResultSet(RealMetadataFactory.vsprs1());
        ProcedureParameter procedureParameter3 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode13 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; INSERT INTO #temptable(#temptable.e1, e2) VALUES( 'Fourth', param1); SELECT e1, e2 FROM #temptable; END");
        Procedure procedure13 = RealMetadataFactory.createVirtualProcedure("vsp21", pm1, Arrays.asList(vspp21), (QueryNode)vspqn21);
        vsp21.setResultSet(RealMetadataFactory.vspp4());
        ProcedureParameter procedureParameter4 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode14 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1 where e2 > param1; SELECT e1, e2 FROM #temptable; END");
        Procedure procedure14 = RealMetadataFactory.createVirtualProcedure("vsp22", pm1, Arrays.asList(vspp22), (QueryNode)vspqn22);
        vsp22.setResultSet(RealMetadataFactory.vspp4());
        ProcedureParameter procedureParameter5 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode15 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; SELECT e1, e2 INTO #temptable FROM pm1.g1 where e2 > param1; x = SELECT e1 FROM #temptable WHERE e2=15; SELECT x, 15; END");
        Procedure procedure15 = RealMetadataFactory.createVirtualProcedure("vsp23", pm1, Arrays.asList(vspp23), (QueryNode)vspqn23);
        vsp23.setResultSet(RealMetadataFactory.vspp4());
        QueryNode queryNode16 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable WHERE #temptable.e2=15; END");
        Procedure procedure16 = RealMetadataFactory.createVirtualProcedure("vsp24", pm1, null, (QueryNode)vspqn24);
        vsp24.setResultSet(RealMetadataFactory.vspp4());
        QueryNode queryNode17 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO #temptable FROM pm1.g1 WHERE e1 ='no match'; SELECT e1 FROM #temptable; END");
        Procedure procedure17 = RealMetadataFactory.createVirtualProcedure("vsp25", pm1, null, (QueryNode)vspqn25);
        vsp25.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode18 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 from (exec pm1.vsp25())as c; END");
        Procedure procedure18 = RealMetadataFactory.createVirtualProcedure("vsp27", pm1, null, (QueryNode)vspqn27);
        vsp27.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode19 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT 0 AS e1 ORDER BY e1; END");
        Procedure procedure19 = RealMetadataFactory.createVirtualProcedure("vsp28", pm1, null, (QueryNode)vspqn28);
        vsp28.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode20 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM pm1.g1 ORDER BY e1; END");
        Procedure procedure20 = RealMetadataFactory.createVirtualProcedure("vsp29", pm1, null, (QueryNode)vspqn29);
        vsp29.setResultSet(RealMetadataFactory.vsprs1());
        ColumnSet<Procedure> columnSet2 = RealMetadataFactory.createResultSet("pm1.vsprs30", new String[]{"e1"}, new String[]{"string"});
        QueryNode queryNode21 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM pm1.g1; END");
        Procedure procedure21 = RealMetadataFactory.createVirtualProcedure("vsp30", pm1, null, (QueryNode)vspqn30);
        vsp30.setResultSet((ColumnSet)vsprs30);
        ColumnSet<Procedure> columnSet3 = RealMetadataFactory.createResultSet("pm1.vsprs31", new String[]{"e1"}, new String[]{"string"});
        ProcedureParameter procedureParameter6 = RealMetadataFactory.createParameter("p1", 1, "integer");
        QueryNode queryNode22 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM pm1.g1 WHERE e2 = pm1.vsp31.p1; END");
        Procedure procedure22 = RealMetadataFactory.createVirtualProcedure("vsp31", pm1, Arrays.asList(RealMetadataFactory.createParameter("p1", 1, "integer")), (QueryNode)vspqn31);
        vsp31.setResultSet((ColumnSet)vsprs31);
        QueryNode queryNode23 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer VARIABLES.y; VARIABLES.y=5; EXEC pm1.vsp7(VARIABLES.y); END");
        Procedure procedure23 = RealMetadataFactory.createVirtualProcedure("vsp38", pm1, null, (QueryNode)vspqn38);
        vsp38.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode24 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer VARIABLES.x; VARIABLES.x=5; EXEC pm1.vsp7(VARIABLES.x); END");
        Procedure procedure24 = RealMetadataFactory.createVirtualProcedure("vsp39", pm1, null, (QueryNode)vspqn39);
        vsp39.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode25 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN EXEC pm1.vsp41(); END END");
        Procedure procedure25 = RealMetadataFactory.createVirtualProcedure("vsp40", pm1, null, (QueryNode)vspqn40);
        vsp40.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode26 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM pm1.g1 where e2=15; END");
        Procedure procedure26 = RealMetadataFactory.createVirtualProcedure("vsp41", pm1, null, (QueryNode)vspqn41);
        vsp41.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode27 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; VARIABLES.x=5; INSERT INTO vm1.g1(e2) values(VARIABLES.x); SELECT ROWCOUNT; END");
        Procedure procedure27 = RealMetadataFactory.createVirtualProcedure("vsp37", pm1, null, (QueryNode)vspqn37);
        vsp37.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode28 = new QueryNode(new StringBuffer("CREATE VIRTUAL PROCEDURE").append(" BEGIN").append(" SELECT 3 AS temp1 INTO #myTempTable;").append(" SELECT 2 AS temp1 INTO #myTempTable;").append(" SELECT 1 AS temp1 INTO #myTempTable;").append(" SELECT temp1 AS e1 FROM #myTempTable ORDER BY e1;").append(" END").toString());
        Procedure procedure28 = RealMetadataFactory.createVirtualProcedure("vsp33", pm1, null, (QueryNode)vspqn33);
        vsp33.setResultSet(RealMetadataFactory.vsprs1());
        ColumnSet<Procedure> columnSet4 = RealMetadataFactory.createResultSet("pm1.vsprs31", new String[]{"e1"}, new String[]{"string"});
        QueryNode queryNode29 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer VARIABLES.ID; VARIABLES.ID = pm1.vsp35.p1; SELECT e1 FROM pm1.g1 WHERE e2 = VARIABLES.ID; END");
        Procedure procedure29 = RealMetadataFactory.createVirtualProcedure("vsp35", pm1, Arrays.asList(vsp31p2), (QueryNode)vspqn35);
        vsp35.setResultSet((ColumnSet)vsprs35);
        QueryNode queryNode30 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, 0 AS const FROM pm1.g1 ORDER BY const; END");
        Procedure procedure30 = RealMetadataFactory.createVirtualProcedure("vsp34", pm1, null, (QueryNode)vspqn34);
        vsp34.setResultSet(RealMetadataFactory.vspp4());
        QueryNode queryNode31 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable where #temptable.e1 in (SELECT pm1.g2.e1 FROM pm1.g2 ); END");
        Procedure procedure31 = RealMetadataFactory.createVirtualProcedure("vsp45", pm1, null, (QueryNode)vspqn45);
        vsp45.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode32 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN IF (pm1.vsp47.param1 IS NOT NULL) BEGIN SELECT 'FOO' as e1, pm1.vsp47.param1 as e2; END ELSE BEGIN SELECT pm1.vsp47.param2 as e1, 2112 as e2; END END");
        ColumnSet<Procedure> columnSet5 = RealMetadataFactory.createResultSet("pm1.vsprs47", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ProcedureParameter procedureParameter7 = RealMetadataFactory.createParameter("param1", 1, "integer");
        vspp47_2.setNullType(BaseColumn.NullType.Nullable);
        ProcedureParameter procedureParameter8 = RealMetadataFactory.createParameter("param2", 1, "string");
        vspp47_3.setNullType(BaseColumn.NullType.Nullable);
        Procedure procedure32 = RealMetadataFactory.createVirtualProcedure("vsp47", pm1, Arrays.asList(vspp47_2, vspp47_3), (QueryNode)vspqn47);
        vsp47.setResultSet((ColumnSet)vsprs47);
        QueryNode queryNode33 = new QueryNode("SELECT P.e2 as ve3, P.e1 as ve4 FROM (EXEC pm1.vsp47(param1=vm1.vgvp7.ve1, param2=vm1.vgvp7.ve2)) as P");
        Table table = RealMetadataFactory.createVirtualGroup("vgvp7", vm1, (QueryNode)vgvpn7);
        Column column = RealMetadataFactory.createElement("ve1", vgvp7, "integer");
        vgvp7e1.setSelectable(false);
        Column column2 = RealMetadataFactory.createElement("ve2", vgvp7, "string");
        vgvp7e2.setSelectable(false);
        RealMetadataFactory.createElement("ve3", vgvp7, "string");
        RealMetadataFactory.createElement("ve4", vgvp7, "string");
        QueryNode queryNode34 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS #mycursor BEGIN IF(#mycursor.e2 > 10) BEGIN CONTINUE; END x=#mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        Procedure procedure33 = RealMetadataFactory.createVirtualProcedure("vsp32", pm1, null, (QueryNode)vspqn32);
        vsp32.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode35 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e2 >= pm1.vsp26.param1 and e1 = pm1.vsp26.param2; END");
        ProcedureParameter procedureParameter9 = RealMetadataFactory.createParameter("param1", 1, "integer");
        ProcedureParameter procedureParameter10 = RealMetadataFactory.createParameter("param2", 1, "string");
        ColumnSet<Procedure> columnSet6 = RealMetadataFactory.createResultSet("pm1.vsprs3", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        Procedure procedure34 = RealMetadataFactory.createVirtualProcedure("vsp26", pm1, Arrays.asList(vspp26_1, vspp26_2), (QueryNode)vspqn26);
        vsp26.setResultSet((ColumnSet)vsprs3);
        QueryNode queryNode36 = new QueryNode("SELECT P.e1 as ve3 FROM (EXEC pm1.vsp26(vm1.vgvp1.ve1, vm1.vgvp1.ve2)) as P");
        Table table2 = RealMetadataFactory.createVirtualGroup("vgvp1", vm1, (QueryNode)vgvpn1);
        Column column3 = RealMetadataFactory.createElement("ve1", vgvp1, "integer");
        vgvp1e1.setSelectable(false);
        Column column4 = RealMetadataFactory.createElement("ve2", vgvp1, "string");
        vgvp1e2.setSelectable(false);
        RealMetadataFactory.createElement("ve3", vgvp1, "string");
        QueryNode queryNode37 = new QueryNode("SELECT P.e1 as ve3 FROM (EXEC pm1.vsp26(vm1.vgvp2.ve1, vm1.vgvp2.ve2)) as P where P.e1='a'");
        Table table3 = RealMetadataFactory.createVirtualGroup("vgvp2", vm1, (QueryNode)vgvpn2);
        Column column5 = RealMetadataFactory.createElement("ve1", vgvp2, "integer");
        vgvp2e1.setSelectable(false);
        Column column6 = RealMetadataFactory.createElement("ve2", vgvp2, "string");
        vgvp2e2.setSelectable(false);
        RealMetadataFactory.createElement("ve3", vgvp2, "string");
        QueryNode queryNode38 = new QueryNode("SELECT P.e1 as ve3 FROM (EXEC pm1.vsp26(vm1.vgvp3.ve1, vm1.vgvp3.ve2)) as P, pm1.g2 where P.e1=g2.e1");
        Table table4 = RealMetadataFactory.createVirtualGroup("vgvp3", vm1, (QueryNode)vgvpn3);
        Column column7 = RealMetadataFactory.createElement("ve1", vgvp3, "integer");
        vgvp3e1.setSelectable(false);
        Column column8 = RealMetadataFactory.createElement("ve2", vgvp3, "string");
        vgvp3e2.setSelectable(false);
        RealMetadataFactory.createElement("ve3", vgvp3, "string");
        QueryNode queryNode39 = new QueryNode("SELECT P.e1 as ve3 FROM (EXEC pm1.vsp26(vm1.vgvp4.ve1, vm1.vgvp4.ve2)) as P, vm1.g1 where P.e1=g1.e1");
        Table table5 = RealMetadataFactory.createVirtualGroup("vgvp4", vm1, (QueryNode)vgvpn4);
        Column column9 = RealMetadataFactory.createElement("ve1", vgvp4, "integer");
        vgvp4e1.setSelectable(false);
        Column column10 = RealMetadataFactory.createElement("ve2", vgvp4, "string");
        vgvp4e2.setSelectable(false);
        RealMetadataFactory.createElement("ve3", vgvp4, "string");
        QueryNode queryNode40 = new QueryNode("SELECT * FROM vm1.vgvp4 where vm1.vgvp4.ve1=vm1.vgvp5.ve1 and  vm1.vgvp4.ve2=vm1.vgvp5.ve2");
        Table table6 = RealMetadataFactory.createVirtualGroup("vgvp5", vm1, (QueryNode)vgvpn5);
        Column column11 = RealMetadataFactory.createElement("ve1", vgvp5, "integer");
        vgvp5e1.setSelectable(false);
        Column column12 = RealMetadataFactory.createElement("ve2", vgvp5, "string");
        vgvp5e2.setSelectable(false);
        RealMetadataFactory.createElement("ve3", vgvp5, "string");
        QueryNode queryNode41 = new QueryNode("SELECT P.e1 as ve3, P.e2 as ve4 FROM (EXEC pm1.vsp26(vm1.vgvp6.ve1, vm1.vgvp6.ve2)) as P");
        Table table7 = RealMetadataFactory.createVirtualGroup("vgvp6", vm1, (QueryNode)vgvpn6);
        Column column13 = RealMetadataFactory.createElement("ve1", vgvp6, "integer");
        vgvp6e1.setSelectable(false);
        Column column14 = RealMetadataFactory.createElement("ve2", vgvp6, "string");
        vgvp6e2.setSelectable(false);
        RealMetadataFactory.createElement("ve3", vgvp6, "string");
        RealMetadataFactory.createElement("ve4", vgvp6, "integer");
        QueryNode queryNode42 = new QueryNode("SELECT e1, e2 FROM pm1.g1");
        Table table8 = RealMetadataFactory.createVirtualGroup("g35", vm1, (QueryNode)vm1g35n1);
        Column column15 = RealMetadataFactory.createElement("e1", vm1g35, "string");
        vm1g35e1.setSelectable(false);
        RealMetadataFactory.createElement("e2", vm1g35, "integer");
        ColumnSet<Procedure> columnSet7 = RealMetadataFactory.createResultSet("pm1.vsprs36", new String[]{"x"}, new String[]{"integer"});
        ProcedureParameter procedureParameter11 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode43 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x = pm1.vsp36.param1 * 2; SELECT x; END");
        Procedure procedure35 = RealMetadataFactory.createVirtualProcedure("vsp36", pm1, Arrays.asList(vsp36p2), (QueryNode)vspqn36);
        vsp36.setResultSet((ColumnSet)vsprs36);
        ColumnSet<Procedure> columnSet8 = RealMetadataFactory.createResultSet("pm1.vsprs42", new String[]{"x"}, new String[]{"integer"});
        ProcedureParameter procedureParameter12 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode44 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN IF (pm1.vsp42.param1 > 0) SELECT 1 AS x; ELSE SELECT 0 AS x; END");
        Procedure procedure36 = RealMetadataFactory.createVirtualProcedure("vsp42", pm1, Arrays.asList(vsp42p2), (QueryNode)vspqn42);
        vsp42.setResultSet((ColumnSet)vsprs42);
        ProcedureParameter procedureParameter13 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode45 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT pm1.vsp44.param1 INTO #temptable; SELECT e1 from pm1.g1; END");
        Procedure procedure37 = RealMetadataFactory.createVirtualProcedure("vsp44", pm1, Arrays.asList(vspp44), (QueryNode)vspqn44);
        vsp44.setResultSet(RealMetadataFactory.vsprs1());
        ProcedureParameter procedureParameter14 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode46 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN exec pm1.vsp44(pm1.vsp43.param1); END");
        Procedure procedure38 = RealMetadataFactory.createVirtualProcedure("vsp43", pm1, Arrays.asList(vspp43), (QueryNode)vspqn43);
        vsp43.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode47 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN create local temporary table #temptable (e1 string, e2 string); LOOP ON (SELECT e1 FROM pm1.g1) AS mycursor BEGIN select mycursor.e1, a.e1 as e2 into #temptable from (SELECT pm1.g1.e1 FROM pm1.g1 where pm1.g1.e1 = mycursor.e1) a; END SELECT e1 FROM #temptable; END");
        Procedure procedure39 = RealMetadataFactory.createVirtualProcedure("vsp46", pm1, null, (QueryNode)vspqn46);
        vsp46.setResultSet(RealMetadataFactory.vsprs1());
        ColumnSet<Procedure> columnSet9 = RealMetadataFactory.createResultSet("pm1vsp48.rs", new String[]{"e1"}, new String[]{"string"});
        ProcedureParameter procedureParameter15 = RealMetadataFactory.createParameter("in", 1, "string");
        QueryNode queryNode48 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; SELECT e1 FROM (EXEC pm1.sq2(pm1.vsp48.in)) as e; END");
        Procedure procedure40 = RealMetadataFactory.createVirtualProcedure("vsp48", pm1, Arrays.asList(vsp48p2), (QueryNode)vspqn48);
        vsp48.setResultSet((ColumnSet)vsp48rs);
        ColumnSet<Procedure> columnSet10 = RealMetadataFactory.createResultSet("pm1vsp49.rs", new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        QueryNode queryNode49 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'b'; EXEC pm1.sq2(x); END");
        Procedure procedure41 = RealMetadataFactory.createVirtualProcedure("vsp49", pm1, null, (QueryNode)vspqn49);
        vsp49.setResultSet((ColumnSet)vsp49rs);
        ColumnSet<Procedure> columnSet11 = RealMetadataFactory.createResultSet("pm1vsp50.rs", new String[]{"e1"}, new String[]{"string"});
        QueryNode queryNode50 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'b'; SELECT e1 FROM (EXEC pm1.sq2(x)) as e; END");
        Procedure procedure42 = RealMetadataFactory.createVirtualProcedure("vsp50", pm1, null, (QueryNode)vspqn50);
        vsp50.setResultSet((ColumnSet)vsp50rs);
        ColumnSet<Procedure> columnSet12 = RealMetadataFactory.createResultSet("pm1vsp51.rs", new String[]{"result"}, new String[]{"string"});
        QueryNode queryNode51 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'b'; LOOP ON (SELECT e1 FROM (EXEC pm1.sq2(x)) as e) AS c BEGIN x = x || 'b'; END SELECT x AS result; END");
        Procedure procedure43 = RealMetadataFactory.createVirtualProcedure("vsp51", pm1, null, (QueryNode)vspqn51);
        vsp51.setResultSet((ColumnSet)vsp51rs);
        ColumnSet<Procedure> columnSet13 = RealMetadataFactory.createResultSet("pm1vsp52.rs", new String[]{"result"}, new String[]{"string"});
        QueryNode queryNode52 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'c'; x = SELECT e1 FROM (EXEC pm1.sq2(x)) as e; SELECT x AS result; END");
        Procedure procedure44 = RealMetadataFactory.createVirtualProcedure("vsp52", pm1, null, (QueryNode)vspqn52);
        vsp52.setResultSet((ColumnSet)vsp52rs);
        ColumnSet<Procedure> columnSet14 = RealMetadataFactory.createResultSet("pm1vsp53.rs", new String[]{"result"}, new String[]{"string"});
        ProcedureParameter procedureParameter16 = RealMetadataFactory.createParameter("in", 1, "string");
        QueryNode queryNode53 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'b'; LOOP ON (SELECT e1 FROM (EXEC pm1.sq2(pm1.vsp53.in)) as e) AS c BEGIN x = x || 'b'; END SELECT x AS result; END");
        Procedure procedure45 = RealMetadataFactory.createVirtualProcedure("vsp53", pm1, Arrays.asList(vsp53p2), (QueryNode)vspqn53);
        vsp53.setResultSet((ColumnSet)vsp53rs);
        ColumnSet<Procedure> columnSet15 = RealMetadataFactory.createResultSet("pm1vsp54.rs", new String[]{"result"}, new String[]{"string"});
        ProcedureParameter procedureParameter17 = RealMetadataFactory.createParameter("in", 1, "string");
        QueryNode queryNode54 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'c'; x = SELECT e1 FROM (EXEC pm1.sq2(pm1.vsp54.in)) as e; SELECT x AS result; END");
        Procedure procedure46 = RealMetadataFactory.createVirtualProcedure("vsp54", pm1, Arrays.asList(vsp54p2), (QueryNode)vspqn54);
        vsp54.setResultSet((ColumnSet)vsp54rs);
        ProcedureParameter procedureParameter18 = RealMetadataFactory.createParameter("param1", 1, "integer");
        QueryNode queryNode55 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN select e1, param1 as a from vm1.g1; END");
        Procedure procedure47 = RealMetadataFactory.createVirtualProcedure("vsp55", pm1, Arrays.asList(vspp55), (QueryNode)vspqn55);
        vsp55.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode56 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT * INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable; END");
        Procedure procedure48 = RealMetadataFactory.createVirtualProcedure("vsp56", pm1, null, (QueryNode)vspqn56);
        vsp56.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode57 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT * INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable order by #temptable.e1; END");
        Procedure procedure49 = RealMetadataFactory.createVirtualProcedure("vsp57", pm1, null, (QueryNode)vspqn57);
        vsp57.setResultSet(RealMetadataFactory.vsprs1());
        ProcedureParameter procedureParameter19 = RealMetadataFactory.createParameter("inp", 1, "integer");
        QueryNode queryNode58 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT vsp58.inp; END");
        Procedure procedure50 = RealMetadataFactory.createVirtualProcedure("vsp58", pm1, Arrays.asList(vspp58), (QueryNode)vspqn58);
        vsp58.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode59 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN SELECT * INTO #temp FROM pm5.g3;INSERT INTO #temp (e1, e2) VALUES('integer',1); END");
        Procedure procedure51 = RealMetadataFactory.createVirtualProcedure("vsp59", pm6, null, (QueryNode)vspqn59);
        vsp59.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode60 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN create local temporary table temp_table (column1 string);insert into temp_table (column1) values ('First');insert into temp_table (column1) values ('Second');insert into temp_table (column1) values ('Third');select * from temp_table; END");
        Procedure procedure52 = RealMetadataFactory.createVirtualProcedure("vsp60", pm1, null, (QueryNode)vspqn60);
        vsp60.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode61 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN create local temporary table temp_table (column1 string);insert into temp_table (column1) values ('First');drop table temp_table;create local temporary table temp_table (column1 string);insert into temp_table (column1) values ('First');insert into temp_table (column1) values ('Second');insert into temp_table (column1) values ('Third');select * from temp_table; END");
        Procedure procedure53 = RealMetadataFactory.createVirtualProcedure("vsp61", pm1, null, (QueryNode)vspqn61);
        vsp61.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode62 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN create local temporary table temp_table (column1 string); select e1 as column1 into temp_table from pm1.g1;select * from temp_table; END");
        Procedure procedure54 = RealMetadataFactory.createVirtualProcedure("vsp62", pm1, null, (QueryNode)vspqn62);
        vsp62.setResultSet(RealMetadataFactory.vsprs1());
        QueryNode queryNode63 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN declare string o; if(1>0) begin declare string a; a='b'; o=a; end if(1>0) begin declare string a; a='c'; o=a; end  select o; END");
        Procedure procedure55 = RealMetadataFactory.createVirtualProcedure("vsp63", pm1, null, (QueryNode)vspqn63);
        vsp63.setResultSet(RealMetadataFactory.vsprs1());
        return metadataStore;
    }

    public static TransformationMetadata example1() {
        return RealMetadataFactory.createTransformationMetadata(RealMetadataFactory.example1Store(), "example1", new FunctionTree[0]);
    }

    private static ColumnSet<Procedure> vspp4() {
        return RealMetadataFactory.createResultSet("pm1.vsprs2", new String[]{"e1", "const"}, new String[]{"string", "integer"});
    }

    private static ColumnSet<Procedure> vsprs1() {
        return RealMetadataFactory.createResultSet("pm1.vsprs1", new String[]{"e1"}, new String[]{"string"});
    }

    public static KeyRecord createKey(KeyRecord.Type type, String name, Table group, List<Column> elements) {
        KeyRecord key = new KeyRecord(type);
        key.setName(name);
        for (Column column : elements) {
            key.addColumn(column);
        }
        switch (type) {
            case Primary: {
                group.setPrimaryKey(key);
                break;
            }
            case Index: {
                group.getIndexes().add(key);
                break;
            }
            case Unique: {
                group.getUniqueKeys().add(key);
                break;
            }
            case AccessPattern: {
                group.getAccessPatterns().add(key);
                break;
            }
            default: {
                throw new AssertionError((Object)"TODO");
            }
        }
        return key;
    }

    public static ForeignKey createForeignKey(String name, Table group, List<Column> elements, KeyRecord primaryKey) {
        ForeignKey key = new ForeignKey();
        key.setName(name);
        for (Column column : elements) {
            key.addColumn(column);
        }
        key.setPrimaryKey(primaryKey);
        group.getForeignKeys().add(key);
        return key;
    }

    public static Schema createPhysicalModel(String name, MetadataStore metadataStore) {
        Schema schema = new Schema();
        schema.setName(name);
        metadataStore.addSchema(schema);
        return schema;
    }

    public static Schema createVirtualModel(String name, MetadataStore metadataStore) {
        Schema schema = new Schema();
        schema.setName(name);
        schema.setPhysical(false);
        metadataStore.addSchema(schema);
        return schema;
    }

    public static Table createPhysicalGroup(String name, Schema model, boolean fullyQualify) {
        Table table = new Table();
        table.setName(name);
        model.addTable(table);
        table.setSupportsUpdate(true);
        table.setNameInSource(fullyQualify || name.lastIndexOf(".") == -1 ? name : name.substring(name.lastIndexOf(".") + 1));
        table.setTableType(Table.Type.Table);
        return table;
    }

    public static Table createPhysicalGroup(String name, Schema model) {
        return RealMetadataFactory.createPhysicalGroup(name, model, false);
    }

    public static Table createVirtualGroup(String name, Schema model, QueryNode plan) {
        Table table = new Table();
        table.setName(name);
        model.addTable(table);
        table.setVirtual(true);
        table.setTableType(Table.Type.View);
        table.setSelectTransformation(plan.getQuery());
        table.setBindings(plan.getBindings());
        return table;
    }

    public static Table createXmlStagingTable(String name, Schema model, QueryNode plan) {
        Table table = RealMetadataFactory.createVirtualGroup(name, model, plan);
        table.setTableType(Table.Type.XmlStagingTable);
        return table;
    }

    public static Table createXmlDocument(String name, Schema model, MappingDocument plan) {
        String doc = RealMetadataFactory.docToString(plan);
        Table table = RealMetadataFactory.createVirtualGroup(name, model, new QueryNode(doc));
        table.setTableType(Table.Type.Document);
        RealMetadataFactory.extractColumns(table, plan);
        return table;
    }

    static void extractColumns(final Table table, MappingDocument plan) {
        MappingVisitor mv = new MappingVisitor(){

            public void visit(MappingElement element) {
                String type = element.getType();
                this.addColumn((MappingNode)element, type);
            }

            private void addColumn(MappingNode element, String type) {
                if (type != null) {
                    Class c = DataTypeManager.getDataTypeClass((String)type);
                    if (c == DataTypeManager.DefaultDataClasses.OBJECT) {
                        type = "string";
                    }
                } else {
                    type = "string";
                }
                RealMetadataFactory.createElement(element.getFullyQualifiedName(), table, type);
            }

            public void visit(MappingAttribute attribute) {
                String type = attribute.getType();
                this.addColumn((MappingNode)attribute, type);
            }
        };
        plan.acceptVisitor((MappingVisitor)new Navigator(true, mv));
    }

    public static String docToString(MappingDocument plan) {
        MappingOutputter out = new MappingOutputter();
        StringWriter stream = new StringWriter();
        try {
            out.write(plan, new PrintWriter(stream));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String doc = stream.toString();
        return doc;
    }

    public static Table createUpdatableVirtualGroup(String name, Schema model, QueryNode plan) {
        return RealMetadataFactory.createUpdatableVirtualGroup(name, model, plan, null);
    }

    public static Table createUpdatableVirtualGroup(String name, Schema model, QueryNode plan, String updatePlan) {
        Table table = RealMetadataFactory.createVirtualGroup(name, model, plan);
        table.setUpdatePlan(updatePlan);
        table.setSupportsUpdate(true);
        return table;
    }

    public static Column createElement(String name, ColumnSet<?> group, String type) {
        Column column = new Column();
        column.setName(name);
        group.addColumn(column);
        column.setRuntimeType(type);
        if (type.equals("string")) {
            column.setSearchType(Column.SearchType.Searchable);
        } else if (DataTypeManager.isNonComparable((String)type)) {
            column.setSearchType(Column.SearchType.Unsearchable);
        } else {
            column.setSearchType(Column.SearchType.All_Except_Like);
        }
        column.setNullType(BaseColumn.NullType.Nullable);
        column.setPosition(group.getColumns().size());
        column.setUpdatable(true);
        column.setLength(100);
        column.setNameInSource(name);
        return column;
    }

    public static List<Column> createElements(ColumnSet<?> group, String[] names, String[] types) {
        return RealMetadataFactory.createElementsWithDefaults(group, names, types, new String[names.length]);
    }

    public static List<Column> createElementsWithDefaults(ColumnSet<?> group, String[] names, String[] types, String[] defaults) {
        ArrayList<Column> elements = new ArrayList<Column>();
        for (int i = 0; i < names.length; ++i) {
            Column element = RealMetadataFactory.createElement(names[i], group, types[i]);
            element.setDefaultValue(defaults[i]);
            elements.add(element);
        }
        return elements;
    }

    public static ProcedureParameter createParameter(String name, int direction, String type) {
        ProcedureParameter param = new ProcedureParameter();
        param.setName(name);
        switch (direction) {
            case 1: {
                param.setType(ProcedureParameter.Type.In);
                break;
            }
            case 3: {
                param.setType(ProcedureParameter.Type.InOut);
                break;
            }
            case 2: {
                param.setType(ProcedureParameter.Type.Out);
                break;
            }
            case 5: {
                throw new AssertionError((Object)"should not directly create a resultset param");
            }
            case 4: {
                param.setType(ProcedureParameter.Type.ReturnValue);
            }
        }
        param.setRuntimeType(type);
        return param;
    }

    public static Procedure createStoredProcedure(String name, Schema model, List<ProcedureParameter> params) {
        Procedure proc = new Procedure();
        proc.setName(name);
        proc.setNameInSource(name);
        if (params != null) {
            int index = 1;
            for (ProcedureParameter procedureParameter : params) {
                procedureParameter.setProcedure(proc);
                procedureParameter.setPosition(index++);
            }
            proc.setParameters(params);
        }
        model.addProcedure(proc);
        return proc;
    }

    public static Procedure createVirtualProcedure(String name, Schema model, List<ProcedureParameter> params, QueryNode queryPlan) {
        Procedure proc = RealMetadataFactory.createStoredProcedure(name, model, params);
        proc.setVirtual(true);
        proc.setQueryPlan(queryPlan.getQuery());
        return proc;
    }

    public static ColumnSet<Procedure> createResultSet(String name, String[] colNames, String[] colTypes) {
        ColumnSet rs = new ColumnSet();
        rs.setName(name);
        for (Column column : RealMetadataFactory.createElements(rs, colNames, colTypes)) {
            column.setParent(rs);
        }
        return rs;
    }

    public static KeyRecord createAccessPattern(String name, Table group, List<Column> elements) {
        return RealMetadataFactory.createKey(KeyRecord.Type.AccessPattern, name, group, elements);
    }

    private static MappingDocument exampleDoc1() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement node1 = root.addChildElement(new MappingElement("node1"));
        MappingElement node2 = node1.addChildElement(new MappingElement("node2"));
        node2.addChildElement(new MappingElement("node3"));
        return doc;
    }

    private static MappingDocument exampleDoc2() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement node1 = root.addChildElement(new MappingElement("node1"));
        MappingSequenceNode node2 = node1.addSequenceNode(new MappingSequenceNode());
        node2.addChildElement(new MappingElement("node3"));
        root.addChildElement(new MappingElement("node2"));
        return doc;
    }

    private static MappingDocument exampleDoc3() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement node1 = root.addChildElement(new MappingElement("node1"));
        node1.addChildElement(new MappingElement("node2"));
        root.addChildElement(new MappingElement("node2"));
        return doc;
    }

    private static MappingDocument exampleDoc4() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.addAttribute(new MappingAttribute("node6"));
        root.addStagingTable("xmltest.doc4.tm1.g1");
        MappingElement node1 = root.addChildElement(new MappingElement("node1"));
        node1.addAttribute(new MappingAttribute("node2"));
        MappingElement node3 = root.addChildElement(new MappingElement("node3"));
        node3.addAttribute(new MappingAttribute("node4"));
        MappingElement node5 = node3.addChildElement(new MappingElement("node4"));
        MappingElement duplicateRoot = node5.addChildElement(new MappingElement("root"));
        duplicateRoot.addChildElement(new MappingElement("node6"));
        return doc;
    }

    private static MappingDocument exampleDoc5() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement node1 = root.addChildElement(new MappingElement("node1"));
        node1.addChildElement(new MappingElement("node2", "xmltest.mc1.e1"));
        node1.setSource("xmltest.mc1");
        node1.setMaxOccurrs(-1);
        return doc;
    }

    private static MappingDocument exampleDoc6() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.addChildElement(new MappingElement("node"));
        root.addChildElement(new MappingElement("thenode"));
        return doc;
    }

    public static VDBMetaData example1VDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("example1");
        vdb.setVersion(1);
        vdb.addModel(RealMetadataFactory.createModel("pm1", true));
        vdb.addModel(RealMetadataFactory.createModel("pm2", true));
        vdb.addModel(RealMetadataFactory.createModel("pm3", true));
        vdb.addModel(RealMetadataFactory.createModel("pm4", true));
        vdb.addModel(RealMetadataFactory.createModel("pm5", true));
        vdb.addModel(RealMetadataFactory.createModel("pm6", true));
        vdb.addModel(RealMetadataFactory.createModel("vm1", false));
        vdb.addModel(RealMetadataFactory.createModel("vm2", false));
        vdb.addModel(RealMetadataFactory.createModel("tm1", false));
        return vdb;
    }

    public static VDBMetaData exampleBQTVDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("example1");
        vdb.setVersion(1);
        vdb.addModel(RealMetadataFactory.createModel("BQT1", true));
        vdb.addModel(RealMetadataFactory.createModel("BQT2", true));
        vdb.addModel(RealMetadataFactory.createModel("BQT3", true));
        vdb.addModel(RealMetadataFactory.createModel("LOB", true));
        vdb.addModel(RealMetadataFactory.createModel("VQT", false));
        vdb.addModel(RealMetadataFactory.createModel("pm1", true));
        vdb.addModel(RealMetadataFactory.createModel("pm2", true));
        vdb.addModel(RealMetadataFactory.createModel("pm3", true));
        vdb.addModel(RealMetadataFactory.createModel("pm4", true));
        return vdb;
    }

    public static VDBMetaData exampleMultiBindingVDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("exampleMultiBinding");
        vdb.setVersion(1);
        ModelMetaData model = new ModelMetaData();
        model.setName("MultiModel");
        model.setModelType(Model.Type.PHYSICAL);
        model.setVisible(Boolean.valueOf(true));
        model.setSupportsMultiSourceBindings(true);
        vdb.addModel(model);
        vdb.addModel(RealMetadataFactory.createModel("Virt", false));
        return vdb;
    }

    public static DQPWorkContext buildWorkContext(TransformationMetadata metadata) {
        return RealMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, metadata.getVdbMetaData());
    }

    public static DQPWorkContext buildWorkContext(QueryMetadataInterface metadata, VDBMetaData vdb) {
        DQPWorkContext workContext = new DQPWorkContext();
        SessionMetadata session = new SessionMetadata();
        workContext.setSession(session);
        session.setVDBName(vdb.getName());
        session.setVDBVersion(vdb.getVersion());
        session.setSessionId(String.valueOf(1));
        session.setUserName("foo");
        session.setVdb(vdb);
        workContext.getVDB().addAttchment(QueryMetadataInterface.class, (Object)metadata);
        if (metadata instanceof TransformationMetadata) {
            workContext.getVDB().addAttchment(TransformationMetadata.class, (Object)((TransformationMetadata)metadata));
        }
        DQPWorkContext.setWorkContext((DQPWorkContext)workContext);
        return workContext;
    }

    public static ModelMetaData createModel(String name, boolean source) {
        ModelMetaData model = new ModelMetaData();
        model.setName(name);
        if (source) {
            model.setModelType(Model.Type.PHYSICAL);
        } else {
            model.setModelType(Model.Type.VIRTUAL);
        }
        model.setVisible(Boolean.valueOf(true));
        model.setSupportsMultiSourceBindings(false);
        model.addSourceMapping(name, name, null);
        return model;
    }

    public static TransformationMetadata exampleBitwise() {
        MetadataStore store = new MetadataStore();
        Schema phys = RealMetadataFactory.createPhysicalModel("phys", store);
        Table t = RealMetadataFactory.createPhysicalGroup("t", phys);
        RealMetadataFactory.createElements(t, new String[]{"ID", "Name", "source_bits"}, new String[]{"integer", "string", "integer"});
        Schema virt = RealMetadataFactory.createVirtualModel("virt", store);
        ColumnSet<Procedure> rs = RealMetadataFactory.createResultSet("rs", new String[]{"ID", "Name", "source_bits"}, new String[]{"integer", "string", "integer"});
        QueryNode qn = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN         DECLARE integer VARIABLES.BITS;        create local temporary table #temp (id integer, name string, bits integer);        LOOP ON (SELECT DISTINCT phys.t.ID, phys.t.Name FROM phys.t) AS idCursor        BEGIN                VARIABLES.BITS = 0;                LOOP ON (SELECT phys.t.source_bits FROM phys.t WHERE phys.t.ID = idCursor.id) AS bitsCursor                BEGIN                        VARIABLES.BITS = bitor(VARIABLES.BITS, bitsCursor.source_bits);                END                SELECT idCursor.id, idCursor.name, VARIABLES.BITS INTO #temp;        END        SELECT ID, Name, #temp.BITS AS source_bits FROM #temp;END");
        Procedure proc = RealMetadataFactory.createVirtualProcedure("agg", virt, null, qn);
        proc.setResultSet(rs);
        return RealMetadataFactory.createTransformationMetadata(store, "bitwise", new FunctionTree[0]);
    }

    public static void setCardinality(String group, int cardinality, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        if (!(metadata instanceof TransformationMetadata)) {
            throw new RuntimeException("unknown metadata");
        }
        Table t = (Table)metadata.getGroupID(group);
        t.setCardinality(cardinality);
    }

    public static TransformationMetadata exampleAggregatesCached() {
        return CACHED_AGGREGATES;
    }

    public static TransformationMetadata example3() {
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        Schema pm2 = RealMetadataFactory.createPhysicalModel("pm2", metadataStore);
        Schema pm3 = RealMetadataFactory.createPhysicalModel("pm3", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("cat1.cat2.cat3.g1", pm1);
        Table pm1g2 = RealMetadataFactory.createPhysicalGroup("cat1.g2", pm1);
        Table pm1g3 = RealMetadataFactory.createPhysicalGroup("cat2.g3", pm1);
        Table pm2g1 = RealMetadataFactory.createPhysicalGroup("cat1.g1", pm2);
        Table pm2g2 = RealMetadataFactory.createPhysicalGroup("cat2.g2", pm2);
        Table pm2g3 = RealMetadataFactory.createPhysicalGroup("g3", pm2);
        Table pm2g4 = RealMetadataFactory.createPhysicalGroup("g4", pm3);
        Table pm2g5 = RealMetadataFactory.createPhysicalGroup("cat3.g1", pm2);
        RealMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g5, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example3", new FunctionTree[0]);
    }

    public static TransformationMetadata exampleUpdateProc(Table.TriggerEvent event, String procedure) {
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        Schema pm2 = RealMetadataFactory.createPhysicalModel("pm2", metadataStore);
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("g1", pm1);
        Table pm1g2 = RealMetadataFactory.createPhysicalGroup("g2", pm1);
        Table pm2g1 = RealMetadataFactory.createPhysicalGroup("g1", pm2);
        Table pm2g2 = RealMetadataFactory.createPhysicalGroup("g2", pm2);
        RealMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode vm1g1n1 = new QueryNode("SELECT * FROM pm1.g1");
        Table vm1g1 = RealMetadataFactory.createUpdatableVirtualGroup("g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3 FROM pm1.g2");
        Table vm1g2 = RealMetadataFactory.createUpdatableVirtualGroup("g2", vm1, vm1g2n1);
        QueryNode vm1g3n1 = new QueryNode("SELECT CONCAT(e1, 'm') as x, (e2 +1) as y, 1 as e3, e4*50 as e4 FROM pm1.g1");
        Table vm1g3 = RealMetadataFactory.createUpdatableVirtualGroup("g3", vm1, vm1g3n1);
        QueryNode vm1g4n1 = new QueryNode("SELECT * FROM pm1.g1");
        Table vm1g4 = RealMetadataFactory.createUpdatableVirtualGroup("g4", vm1, vm1g4n1);
        RealMetadataFactory.createElementsWithDefaults(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"}, new String[]{"xyz", "123", "true", "123.456"});
        RealMetadataFactory.createElementsWithDefaults(vm1g2, new String[]{"e1", "e2", "e3"}, new String[]{"string", "integer", "boolean"}, new String[]{"abc", "456", "false"});
        RealMetadataFactory.createElementsWithDefaults(vm1g3, new String[]{"x", "y", "e3", "e4"}, new String[]{"string", "integer", "integer", "double"}, new String[]{"mno", "789", "true", "789.012"});
        RealMetadataFactory.createElementsWithDefaults(vm1g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"}, new String[]{"xyz", "123", "true", "123.456"});
        RealMetadataFactory.setInsteadOfTriggerDefinition(vm1g1, event, procedure);
        RealMetadataFactory.setInsteadOfTriggerDefinition(vm1g2, event, procedure);
        RealMetadataFactory.setInsteadOfTriggerDefinition(vm1g3, event, procedure);
        RealMetadataFactory.setInsteadOfTriggerDefinition(vm1g4, event, procedure);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "proc", new FunctionTree[0]);
    }

    public static void setInsteadOfTriggerDefinition(Table view, Table.TriggerEvent event, String proc) {
        switch (event) {
            case DELETE: {
                view.setDeletePlan(proc);
                break;
            }
            case INSERT: {
                view.setInsertPlan(proc);
                break;
            }
            case UPDATE: {
                view.setUpdatePlan(proc);
            }
        }
    }

    public static TransformationMetadata exampleUpdateProc(Table.TriggerEvent procedureType, String procedure1, String procedure2) {
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        Schema pm2 = RealMetadataFactory.createPhysicalModel("pm2", metadataStore);
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("g1", pm1);
        Table pm1g2 = RealMetadataFactory.createPhysicalGroup("g2", pm1);
        Table pm2g1 = RealMetadataFactory.createPhysicalGroup("g1", pm2);
        Table pm2g2 = RealMetadataFactory.createPhysicalGroup("g2", pm2);
        RealMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode vm1g1n1 = new QueryNode("SELECT * FROM vm1.g2");
        Table vm1g1 = RealMetadataFactory.createUpdatableVirtualGroup("g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2");
        Table vm1g2 = RealMetadataFactory.createUpdatableVirtualGroup("g2", vm1, vm1g2n1);
        RealMetadataFactory.createElementsWithDefaults(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"}, new String[]{"xyz", "123", "true", "123.456"});
        RealMetadataFactory.createElementsWithDefaults(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"}, new String[]{"abc", "456", "false", null});
        RealMetadataFactory.setInsteadOfTriggerDefinition(vm1g1, procedureType, procedure1);
        RealMetadataFactory.setInsteadOfTriggerDefinition(vm1g2, procedureType, procedure2);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "proc", new FunctionTree[0]);
    }

    public static TransformationMetadata exampleBusObj() {
        return RealMetadataFactory.createTransformationMetadata(RealMetadataFactory.exampleBusObjStore(), "busObj", new FunctionTree[0]);
    }

    public static MetadataStore exampleBusObjStore() {
        MetadataStore metadataStore = new MetadataStore();
        Schema db2Model = RealMetadataFactory.createPhysicalModel("db2model", metadataStore);
        Table db2Table = RealMetadataFactory.createPhysicalGroup("DB2_TABLE", db2Model);
        RealMetadataFactory.createElements(db2Table, new String[]{"PRODUCT", "REGION", "SALES"}, new String[]{"string", "string", "double"});
        Table salesTable = RealMetadataFactory.createPhysicalGroup("SALES", db2Model);
        salesTable.setCardinality(1000000);
        RealMetadataFactory.createElements(salesTable, new String[]{"CITY", "MONTH", "SALES"}, new String[]{"string", "string", "double"});
        Table geographyTable2 = RealMetadataFactory.createPhysicalGroup("GEOGRAPHY2", db2Model);
        geographyTable2.setCardinality(1000);
        List<Column> geographyElem2 = RealMetadataFactory.createElements(geographyTable2, new String[]{"CITY", "REGION"}, new String[]{"string", "string"});
        ArrayList<Column> geoPkElem2 = new ArrayList<Column>();
        geoPkElem2.add(geographyElem2.get(0));
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "db2model.GEOGRAPHY2.GEOGRAPHY_PK", geographyTable2, geoPkElem2);
        Table db2Table2 = RealMetadataFactory.createPhysicalGroup("DB2TABLE", db2Model);
        RealMetadataFactory.createElements(db2Table2, new String[]{"c0", "c1", "c2"}, new String[]{"integer", "integer", "integer"});
        Schema oraModel = RealMetadataFactory.createPhysicalModel("oraclemodel", metadataStore);
        Table oraTable = RealMetadataFactory.createPhysicalGroup("Oracle_table", oraModel);
        RealMetadataFactory.createElements(oraTable, new String[]{"COSTS", "REGION", "YEAR"}, new String[]{"double", "string", "string"});
        Table geographyTable = RealMetadataFactory.createPhysicalGroup("GEOGRAPHY", oraModel);
        geographyTable.setCardinality(1000);
        List<Column> geographyElem = RealMetadataFactory.createElements(geographyTable, new String[]{"CITY", "REGION"}, new String[]{"string", "string"});
        ArrayList<Column> geoPkElem = new ArrayList<Column>();
        geoPkElem.add(geographyElem.get(0));
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "oraclemodel.GEOGRAPHY.GEOGRAPHY_PK", geographyTable, geoPkElem);
        Table oraTable2 = RealMetadataFactory.createPhysicalGroup("OraTable", oraModel);
        RealMetadataFactory.createElements(oraTable2, new String[]{"b0", "b1", "b2"}, new String[]{"double", "string", "string"});
        Schema msModel = RealMetadataFactory.createPhysicalModel("msmodel", metadataStore);
        Table timeTable = RealMetadataFactory.createPhysicalGroup("TIME", msModel);
        timeTable.setCardinality(120);
        List<Column> timeElem = RealMetadataFactory.createElements(timeTable, new String[]{"MONTH", "YEAR"}, new String[]{"string", "string"});
        ArrayList<Column> timePkElem = new ArrayList<Column>();
        timePkElem.add(timeElem.get(0));
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "msmodel.TIME.TIME_PK", timeTable, timePkElem);
        Schema virtModel = RealMetadataFactory.createVirtualModel("logical", metadataStore);
        QueryNode n1 = new QueryNode("select sum(c0) as c0, c1, c2 from db2Table group by c1, c2");
        Table logicalTable1 = RealMetadataFactory.createVirtualGroup("logicalTable1", virtModel, n1);
        RealMetadataFactory.createElements(logicalTable1, new String[]{"c0", "c1", "c2"}, new String[]{"long", "integer", "integer"});
        QueryNode n2 = new QueryNode("select sum(c0) as c0, c1, c2 from db2Table group by c1, c2");
        Table logicalTable2 = RealMetadataFactory.createVirtualGroup("logicalTable2", virtModel, n2);
        RealMetadataFactory.createElements(logicalTable2, new String[]{"b0", "b1", "b2"}, new String[]{"long", "integer", "integer"});
        return metadataStore;
    }

    public static TransformationMetadata exampleAggregates() {
        MetadataStore store = new MetadataStore();
        RealMetadataFactory.addAggregateTablesToModel("m1", store);
        RealMetadataFactory.addAggregateTablesToModel("m2", store);
        return RealMetadataFactory.createTransformationMetadata(store, "exampleAggregates", new FunctionTree[0]);
    }

    public static void addAggregateTablesToModel(String modelName, MetadataStore metadataStore) {
        Schema model = RealMetadataFactory.createPhysicalModel(modelName, metadataStore);
        Table orders = RealMetadataFactory.createPhysicalGroup("order", model);
        orders.setCardinality(1000000);
        RealMetadataFactory.createElements(orders, new String[]{"O_OrderID", "O_ProductID", "O_DealerID", "O_Amount", "O_Date"}, new String[]{"integer", "integer", "integer", "bigdecimal", "date"});
        Table products = RealMetadataFactory.createPhysicalGroup("product", model);
        products.setCardinality(1000);
        RealMetadataFactory.createElements(products, new String[]{"P_ProductID", "P_Overhead", "P_DivID"}, new String[]{"integer", "bigdecimal", "integer"});
        Table divisions = RealMetadataFactory.createPhysicalGroup("division", model);
        divisions.setCardinality(100);
        RealMetadataFactory.createElements(divisions, new String[]{"V_DIVID", "V_SectorID"}, new String[]{"integer", "integer"});
        Table dealers = RealMetadataFactory.createPhysicalGroup("dealer", model);
        dealers.setCardinality(1000);
        RealMetadataFactory.createElements(dealers, new String[]{"D_DealerID", "D_State", "D_Address"}, new String[]{"integer", "string", "string"});
    }

    public static TransformationMetadata exampleMultiBinding() {
        MetadataStore metadataStore = new MetadataStore();
        Schema virtModel = RealMetadataFactory.createVirtualModel("Virt", metadataStore);
        Schema physModel = RealMetadataFactory.createPhysicalModel("MultiModel", metadataStore);
        Table physGroup = RealMetadataFactory.createPhysicalGroup("Phys", physModel);
        RealMetadataFactory.createElements(physGroup, new String[]{"a", "b"}, new String[]{"string", "string"});
        QueryNode virtTrans = new QueryNode("SELECT * FROM MultiModel.Phys");
        Table virtGroup = RealMetadataFactory.createVirtualGroup("view", virtModel, virtTrans);
        RealMetadataFactory.createElements(virtGroup, new String[]{"a", "b"}, new String[]{"string", "string"});
        ColumnSet<Procedure> rs2 = RealMetadataFactory.createResultSet("Virt.rs1", new String[]{"a", "b"}, new String[]{"string", "string"});
        ProcedureParameter rs2p2 = RealMetadataFactory.createParameter("in", 1, "string");
        rs2p2.setNullType(BaseColumn.NullType.Nullable);
        QueryNode sq2n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT a, b FROM MultiModel.Phys where SOURCE_NAME = Virt.sq1.in'; END");
        Procedure sq1 = RealMetadataFactory.createVirtualProcedure("sq1", virtModel, Arrays.asList(rs2p2), sq2n1);
        sq1.setResultSet(rs2);
        ColumnSet<Procedure> rs3 = RealMetadataFactory.createResultSet("MultiModel.rs1", new String[]{"a", "b"}, new String[]{"string", "string"});
        ProcedureParameter rs3p2 = RealMetadataFactory.createParameter("in", 1, "string");
        ProcedureParameter rs3p3 = RealMetadataFactory.createParameter("source_name", 1, "string");
        rs3p3.setNullType(BaseColumn.NullType.Nullable);
        Procedure sq2 = RealMetadataFactory.createStoredProcedure("proc", physModel, Arrays.asList(rs3p2, rs3p3));
        sq2.setResultSet(rs3);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "multiBinding", new FunctionTree[0]);
    }

    public static TransformationMetadata exampleCase3225() {
        MetadataStore metadataStore = new MetadataStore();
        Schema stock = RealMetadataFactory.createPhysicalModel("stock", metadataStore);
        Schema xmltest = RealMetadataFactory.createVirtualModel("xmltest", metadataStore);
        Table items = RealMetadataFactory.createPhysicalGroup("items", stock);
        Table item_supplier = RealMetadataFactory.createPhysicalGroup("item_supplier", stock);
        Table suppliers = RealMetadataFactory.createPhysicalGroup("suppliers", stock);
        Table orders = RealMetadataFactory.createPhysicalGroup("orders", stock);
        Table employees = RealMetadataFactory.createPhysicalGroup("employees", stock);
        RealMetadataFactory.createElements(items, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        RealMetadataFactory.createElements(item_supplier, new String[]{"itemNum", "supplierNum"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(suppliers, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        RealMetadataFactory.createElements(orders, new String[]{"orderNum", "itemFK", "supplierFK", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "string", "string", "integer", "string"});
        RealMetadataFactory.createElements(employees, new String[]{"employeeNum", "supplierNumFK", "specializesInItemNum", "supervisorNum", "firstName", "lastName"}, new String[]{"string", "string", "string", "string", "string", "string"});
        QueryNode rsQuery = new QueryNode("SELECT itemNum, itemName, itemQuantity, itemStatus FROM stock.items");
        Table rsItems = RealMetadataFactory.createVirtualGroup("items", xmltest, rsQuery);
        QueryNode rsQuery2 = new QueryNode("SELECT stock.suppliers.supplierNum, supplierName, supplierZipCode, stock.item_supplier.itemNum FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum = ?");
        rsQuery2.addBinding("xmltest.items.itemNum");
        Table rsSuppliers = RealMetadataFactory.createVirtualGroup("suppliers", xmltest, rsQuery2);
        QueryNode rsQuery3 = new QueryNode("SELECT orderNum, orderDate, orderQty, orderStatus, itemFK, supplierFK FROM stock.orders WHERE itemFK = ? AND supplierFK = ?");
        rsQuery3.addBinding("xmltest.suppliers.itemNum");
        rsQuery3.addBinding("xmltest.suppliers.supplierNum");
        Table rsOrders = RealMetadataFactory.createVirtualGroup("orders", xmltest, rsQuery3);
        QueryNode rsQuery4 = new QueryNode("SELECT employeeNum, firstName, lastName, supervisorNum, specializesInItemNum, supplierNumFK FROM stock.employees WHERE specializesInItemNum = ? AND supplierNumFK = ?");
        rsQuery4.addBinding("xmltest.suppliers.itemNum");
        rsQuery4.addBinding("xmltest.suppliers.supplierNum");
        Table rsEmployees = RealMetadataFactory.createVirtualGroup("employees", xmltest, rsQuery4);
        RealMetadataFactory.createElements(rsItems, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        RealMetadataFactory.createElements(rsSuppliers, new String[]{"supplierNum", "supplierName", "supplierZipCode", "itemNum"}, new String[]{"string", "string", "string", "string"});
        RealMetadataFactory.createElements(rsOrders, new String[]{"orderNum", "orderDate", "orderQty", "orderStatus", "itemFK", "supplierFK"}, new String[]{"string", "string", "integer", "string", "string", "string"});
        RealMetadataFactory.createElements(rsEmployees, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum", "specializesInItemNum", "supplierNumFK"}, new String[]{"string", "string", "string", "string", "string", "string"});
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement itemsA = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = itemsA.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.items.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.items.itemQuantity"));
        MappingElement nestedWrapper = item.addChildElement(new MappingElement("Suppliers"));
        MappingElement supplier = nestedWrapper.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        supplier.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        supplier.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        MappingElement ordersWrapper = supplier.addChildElement(new MappingElement("Orders"));
        MappingElement order = ordersWrapper.addChildElement(new MappingElement("Order"));
        order.setSource("xmltest.orders");
        order.setMaxOccurrs(-1);
        order.addAttribute(new MappingAttribute("OrderID", "xmltest.orders.orderNum"));
        order.addChildElement(new MappingElement("OrderDate", "xmltest.orders.orderDate"));
        order.addChildElement(new MappingElement("OrderQuantity", "xmltest.orders.orderQty"));
        order.addChildElement(new MappingElement("OrderStatus", "xmltest.orders.orderStatus")).setMinOccurrs(0);
        MappingElement employeesWrapper = supplier.addChildElement(new MappingElement("Employees"));
        MappingElement employee = employeesWrapper.addChildElement(new MappingElement("Employee"));
        employee.setSource("xmltest.employees");
        employee.setMaxOccurrs(-1);
        employee.addAttribute(new MappingAttribute("EmployeeID", "xmltest.employees.employeeNum"));
        employee.addChildElement(new MappingElement("FirstName", "xmltest.employees.firstName"));
        employee.addChildElement(new MappingElement("LastName", "xmltest.employees.lastName"));
        employee.addAttribute(new MappingAttribute("SupervisorID", "xmltest.employees.supervisorNum"));
        RealMetadataFactory.createXmlDocument("itemsDoc", xmltest, doc);
        QueryNode playersNode = new QueryNode("SELECT stock.employees.employeeNum, firstName, lastName, supervisorNum FROM stock.employees WHERE specializesInItemNum is not null");
        Table rsPlayers = RealMetadataFactory.createVirtualGroup("player", xmltest, playersNode);
        QueryNode managersNode = new QueryNode("SELECT stock.employees.employeeNum, firstName, lastName, supervisorNum FROM stock.employees WHERE stock.employees.employeeNum = ?");
        managersNode.addBinding("xmltest.player.supervisorNum");
        Table rsManagers = RealMetadataFactory.createVirtualGroup("managers", xmltest, managersNode);
        QueryNode ownersNode = new QueryNode("SELECT stock.employees.employeeNum, firstName, lastName, supervisorNum FROM stock.employees WHERE stock.employees.employeeNum = ?");
        ownersNode.addBinding("xmltest.managers.supervisorNum");
        Table rsOwners = RealMetadataFactory.createVirtualGroup("owners", xmltest, ownersNode);
        RealMetadataFactory.createElements(rsPlayers, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum"}, new String[]{"string", "string", "string", "string"});
        RealMetadataFactory.createElements(rsManagers, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum"}, new String[]{"string", "string", "string", "string"});
        RealMetadataFactory.createElements(rsOwners, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum"}, new String[]{"string", "string", "string", "string"});
        MappingDocument doc2 = new MappingDocument(true);
        MappingElement root2 = doc2.addChildElement(new MappingElement("BaseballPlayers"));
        MappingElement player = root2.addChildElement(new MappingElement("Player"));
        player.setSource("xmltest.player");
        player.setMaxOccurrs(-1);
        player.addAttribute(new MappingAttribute("PlayerID", "xmltest.player.employeeNum"));
        player.addChildElement(new MappingElement("FirstName", "xmltest.player.firstName"));
        player.addChildElement(new MappingElement("LastName", "xmltest.player.lastName"));
        MappingElement manager = player.addChildElement(new MappingElement("Manager"));
        manager.setSource("xmltest.managers");
        manager.setMaxOccurrs(-1);
        manager.addAttribute(new MappingAttribute("ManagerID", "xmltest.managers.employeeNum"));
        manager.addChildElement(new MappingElement("FirstName", "xmltest.managers.firstName"));
        manager.addChildElement(new MappingElement("LastName", "xmltest.managers.lastName"));
        MappingElement owner = manager.addChildElement(new MappingElement("Owner"));
        owner.setSource("xmltest.owners");
        owner.setMaxOccurrs(-1);
        owner.addAttribute(new MappingAttribute("OwnerID", "xmltest.owners.employeeNum"));
        owner.addChildElement(new MappingElement("FirstName", "xmltest.owners.firstName"));
        owner.addChildElement(new MappingElement("LastName", "xmltest.owners.lastName"));
        RealMetadataFactory.createXmlDocument("playersDoc", xmltest, doc2);
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "case3225", new FunctionTree[0]);
    }

    public static TransformationMetadata example4() {
        MetadataStore metadataStore = new MetadataStore();
        Schema pm1 = RealMetadataFactory.createPhysicalModel("pm1", metadataStore);
        Schema pm2 = RealMetadataFactory.createPhysicalModel("pm2", metadataStore);
        Schema pm3 = RealMetadataFactory.createPhysicalModel("pm3", metadataStore);
        Schema pm4 = RealMetadataFactory.createPhysicalModel("pm4", metadataStore);
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        Table pm1g1 = RealMetadataFactory.createPhysicalGroup("g1", pm1);
        Table pm1g2 = RealMetadataFactory.createPhysicalGroup("g2", pm1);
        Table pm1g3 = RealMetadataFactory.createPhysicalGroup("g3", pm1);
        Table pm2g1 = RealMetadataFactory.createPhysicalGroup("g1", pm2);
        Table pm2g2 = RealMetadataFactory.createPhysicalGroup("g2", pm2);
        Table pm2g3 = RealMetadataFactory.createPhysicalGroup("g3", pm2);
        Table pm3g1 = RealMetadataFactory.createPhysicalGroup("g1", pm3);
        Table pm3g2 = RealMetadataFactory.createPhysicalGroup("g2", pm3);
        Table pm3g3 = RealMetadataFactory.createPhysicalGroup("g3", pm3);
        Table pm4g1 = RealMetadataFactory.createPhysicalGroup("g1", pm4);
        Table pm4g2 = RealMetadataFactory.createPhysicalGroup("g2", pm4);
        pm1g1.setCardinality(10);
        pm1g2.setCardinality(10);
        pm1g3.setCardinality(10);
        pm2g1.setCardinality(1000);
        pm2g2.setCardinality(1000);
        pm3g1.setCardinality(100000);
        pm3g2.setCardinality(100000);
        pm3g3.setCardinality(100000);
        List<Column> pm1g1e = RealMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<Column> pm1g3e = RealMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<Column> pm2g1e = RealMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm2g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<Column> pm3g1e = RealMetadataFactory.createElements(pm3g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(pm3g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<Column> pm3g3e = RealMetadataFactory.createElements(pm3g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<Column> pm4g1e = RealMetadataFactory.createElements(pm4g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<Column> pm4g2e = RealMetadataFactory.createElements(pm4g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "pm1.g1.key1", pm1g1, pm1g1e.subList(0, 1));
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "pm3.g1.key1", pm3g1, pm3g1e.subList(0, 1));
        RealMetadataFactory.createKey(KeyRecord.Type.Primary, "pm3.g3.key1", pm3g3, pm3g3e.subList(0, 1));
        KeyRecord pm4g1key1 = RealMetadataFactory.createKey(KeyRecord.Type.Primary, "pm4.g1.key1", pm4g1, pm4g1e.subList(0, 2));
        RealMetadataFactory.createForeignKey("pm4.g2.fk", pm4g2, pm4g2e.subList(0, 2), pm4g1key1);
        ArrayList<Object> elements = new ArrayList<Column>(1);
        elements.add(pm1g1e.iterator().next());
        RealMetadataFactory.createAccessPattern("pm1.g1.ap1", pm1g1, elements);
        elements = new ArrayList(2);
        Iterator<Column> iter = pm1g3e.iterator();
        elements.add(iter.next());
        elements.add(iter.next());
        RealMetadataFactory.createAccessPattern("pm1.g3.ap1", pm1g3, elements);
        elements = new ArrayList(1);
        elements.add(pm2g1e.iterator().next());
        RealMetadataFactory.createAccessPattern("pm2.g1.ap1", pm2g1, elements);
        QueryNode vm1g1n1 = new QueryNode("SELECT * FROM pm1.g1");
        Table vm1g1 = RealMetadataFactory.createUpdatableVirtualGroup("g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3 FROM pm1.g2");
        Table vm1g2 = RealMetadataFactory.createUpdatableVirtualGroup("g2", vm1, vm1g2n1);
        QueryNode vm1g3n1 = new QueryNode("SELECT pm1.g3.e1 AS x, pm1.g3.e2 AS y from pm1.g3");
        Table vm1g3 = RealMetadataFactory.createUpdatableVirtualGroup("g3", vm1, vm1g3n1);
        QueryNode vm1g4n1 = new QueryNode("SELECT distinct pm1.g2.e1 as ve1, pm1.g1.e1 as ve2 FROM pm1.g2 LEFT OUTER JOIN /* optional */ pm1.g1 on pm1.g1.e1 = pm1.g2.e1");
        Table vm1g4 = RealMetadataFactory.createVirtualGroup("g4", vm1, vm1g4n1);
        RealMetadataFactory.createElements(vm1g4, new String[]{"ve1", "ve2"}, new String[]{"string", "string"});
        RealMetadataFactory.createElements(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        RealMetadataFactory.createElements(vm1g3, new String[]{"e1", "e2", "x", "y"}, new String[]{"string", "integer", "string", "integer"});
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "example4", new FunctionTree[0]);
    }

    public static TransformationMetadata fromDDL(File ddlFile, String vdbName, String modelName) throws Exception {
        MetadataFactory mf = new TestDDLParser().buildMetadataFactory(ddlFile, modelName);
        return RealMetadataFactory.createTransformationMetadata(mf.asMetadataStore(), vdbName, new FunctionTree[0]);
    }
}

