/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.PasswordMaskUtil;
import org.teiid.core.util.StringUtil;

public final class PropertiesUtils {
    private static final String NEWLINE = "\n";
    private static final String APREFIX = "Property '";
    private static final String AEQUAL = "'='";
    private static final String ASUFFIX = "'";
    private static final String TAB = "\t";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Properties clone(Properties props) {
        return PropertiesUtils.clone(props, null, false);
    }

    public static Properties clone(Properties props, Properties defaults, boolean deepClone) {
        Properties result = null;
        if (defaults != null) {
            if (deepClone) {
                defaults = PropertiesUtils.clone(defaults);
            }
            result = new Properties(defaults);
        } else {
            result = new Properties();
        }
        PropertiesUtils.putAll(result, props);
        return result;
    }

    public static int compare(Properties p1, Properties p2) {
        if (p1 != null) {
            if (p2 == null) {
                return 1;
            }
        } else {
            if (p2 != null) {
                return -1;
            }
            return 0;
        }
        int diff = p1.size() - p2.size();
        if (diff != 0) {
            return diff;
        }
        Map.Entry<Object, Object> entry2 = null;
        Object p1Value = null;
        Object p2Value = null;
        for (Map.Entry<Object, Object> entry2 : p1.entrySet()) {
            p1Value = entry2.getValue();
            p2Value = p2.get(entry2.getKey());
            if (p1Value != null) {
                if (p2Value == null) {
                    return 1;
                }
                diff = p1Value instanceof Comparable ? ((Comparable)p1Value).compareTo(p2Value) : p1Value.toString().compareTo(p2Value.toString());
                if (diff == 0) continue;
                return diff;
            }
            if (p2Value == null) continue;
            return -1;
        }
        return 0;
    }

    public static void putAll(Properties addToThis, Properties withThese) {
        if (withThese != null && addToThis != null) {
            Enumeration<?> enumeration = withThese.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propName = (String)enumeration.nextElement();
                Object propValue = withThese.get(propName);
                if (propValue == null) {
                    propValue = withThese.getProperty(propName);
                }
                if (propValue == null) continue;
                addToThis.put(propName, propValue);
            }
        }
    }

    public static void setOverrideProperies(Properties base, Properties override) {
        Enumeration<?> overrideEnum = override.propertyNames();
        while (overrideEnum.hasMoreElements()) {
            String key = (String)overrideEnum.nextElement();
            String value = base.getProperty(key);
            String overRideValue = override.getProperty(key);
            if (value == null || value.equals(overRideValue)) continue;
            base.setProperty(key, overRideValue);
        }
    }

    public static int getIntProperty(Properties props, String propName, int defaultValue) throws InvalidPropertyException {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10037, propName, stringVal, Integer.class, e);
        }
    }

    public static long getLongProperty(Properties props, String propName, long defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Long.parseLong(stringVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10038, propName, stringVal, Long.class, e);
        }
    }

    public static float getFloatProperty(Properties props, String propName, float defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(stringVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10039, propName, stringVal, Float.class, e);
        }
    }

    public static double getDoubleProperty(Properties props, String propName, double defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(stringVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10040, propName, stringVal, Double.class, e);
        }
    }

    public static boolean getBooleanProperty(Properties props, String propName, boolean defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(stringVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10041, propName, stringVal, Float.class, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadHeader(String fileName) throws IOException {
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(fileName);
            br = new BufferedReader(fr);
            String header = br.readLine();
            if (header != null && header.indexOf(35) == 0) {
                header = header.substring(1);
            }
            String string = header;
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String fileName) throws IOException {
        InputStream is = null;
        try {
            Properties props = new Properties();
            is = new FileInputStream(fileName);
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadFromURL(URL url) throws MalformedURLException, IOException {
        Properties result = new Properties();
        InputStream is = null;
        try {
            is = url.openStream();
            result.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadAsResource(Class clazz, String resourceName) throws IOException {
        InputStream is = null;
        Properties configProps = new Properties();
        try {
            is = clazz.getResourceAsStream(resourceName);
            ArgCheck.isNotNull(is);
            if (is != null) {
                configProps.load(is);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ce) {}
            }
        }
        return configProps;
    }

    public static Properties sort(Properties props) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            names.add(name);
        }
        Collections.sort(names);
        Properties newProps = new Properties();
        for (String name : names) {
            String propValue = props.getProperty(name);
            if (propValue == null) continue;
            newProps.setProperty(name, propValue);
        }
        return newProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String fileName, Properties props, String header) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(fileName);
            props.store(stream, header);
            stream.flush();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String fileName, Properties props) throws IOException {
        FileOutputStream stream = null;
        PrintStream writer = null;
        try {
            stream = new FileOutputStream(fileName);
            writer = new PrintStream(stream);
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                names.add(name);
            }
            Collections.sort(names);
            for (String name : names) {
                String value = props.getProperty(name);
                StringBuffer sb = new StringBuffer();
                sb.append(name);
                sb.append("=");
                sb.append(value);
                writer.println(sb.toString());
            }
            writer.flush();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void print(PrintStream stream, Properties props) {
        if (props != null) {
            Collection sorted = PropertiesUtils.sortPropertiesForPrinting(props);
            for (String value : sorted) {
                stream.println(value);
            }
        }
    }

    public static String prettyPrint(Properties props) {
        if (props != null) {
            Collection sorted = PropertiesUtils.sortPropertiesForPrinting(props);
            StringBuffer outBuf = new StringBuffer();
            for (String value : sorted) {
                outBuf.append(value);
                outBuf.append(NEWLINE);
            }
            return outBuf.toString();
        }
        return "";
    }

    public static Collection sortPropertiesForPrinting(Properties props) {
        ArrayList<String> sortedProps = new ArrayList<String>(props.size());
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            names.add(name);
        }
        Collections.sort(names);
        for (String name : names) {
            String value = null;
            if (PasswordMaskUtil.doesNameEndWithPasswordSuffix(name)) {
                value = "*****";
            } else {
                value = props.getProperty(name);
                value = PropertiesUtils.saveConvert(value, false);
            }
            name = PropertiesUtils.saveConvert(name, true);
            StringBuffer sb = new StringBuffer(APREFIX);
            sb.append(name);
            sb.append(TAB);
            sb.append(AEQUAL);
            sb.append(value);
            sb.append(ASUFFIX);
            sortedProps.add(sb.toString());
        }
        return sortedProps;
    }

    public static String saveConvert(String theString, boolean escapeSpace) {
        if (theString == null) {
            return "";
        }
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertiesUtils.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertiesUtils.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertiesUtils.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertiesUtils.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(PropertiesUtils.toHex(b >>> 4));
            sb.append(PropertiesUtils.toHex(b));
        }
        return sb.toString();
    }

    public static final void copyProperty(Properties srcProperties, String srcPropName, Properties tgtProperties, String tgtPropName) {
        if (srcProperties == null || srcPropName == null || tgtProperties == null || tgtPropName == null) {
            return;
        }
        String value = srcProperties.getProperty(srcPropName);
        if (value != null) {
            tgtProperties.setProperty(tgtPropName, value);
        }
    }

    public static Properties resolveNestedProperties(Properties original) {
        Enumeration<?> e = original.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = original.getProperty(key);
            if (value == null) continue;
            boolean matched = true;
            boolean modified = false;
            while (matched) {
                int start;
                int end = start = value.indexOf("${");
                if (start != -1) {
                    end = value.indexOf(125, start);
                }
                if (!(matched = start != -1 && end != -1)) continue;
                String nestedkey = value.substring(start + 2, end);
                String nestedvalue = original.getProperty(nestedkey);
                if (key.equals(nestedkey)) {
                    matched = false;
                    continue;
                }
                if (nestedvalue == null) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10042, CorePlugin.Util.gs(CorePlugin.Event.TEIID10042, nestedkey));
                }
                value = value.substring(0, start) + nestedvalue + value.substring(end + 1);
                modified = true;
            }
            if (!modified) continue;
            original.setProperty(key, value);
        }
        return original;
    }

    public static void setBeanProperties(Object bean, Properties props, String prefix) {
        Properties connProps = PropertiesUtils.lowerCaseAllPropNames(props);
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String propertyName = methodName.substring(3);
            String shortName = propertyName.toLowerCase();
            String propertyValue = null;
            propertyValue = prefix != null ? connProps.getProperty(prefix + "." + shortName) : connProps.getProperty(shortName);
            if (propertyValue == null) continue;
            Class<?> argType = method.getParameterTypes()[0];
            try {
                Object[] params = new Object[]{StringUtil.valueOf(propertyValue, argType)};
                method.invoke(bean, params);
                continue;
            }
            catch (Throwable e) {
                throw new InvalidPropertyException(CorePlugin.Event.TEIID10043, propertyName, propertyValue, argType, e);
            }
        }
    }

    public static void setBeanProperty(Object bean, String name, Object value) {
        if (value == null) {
            return;
        }
        name = name.toLowerCase();
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            String shortName;
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || !(shortName = (propertyName = methodName.substring(3)).toLowerCase()).equals(name)) continue;
            Class<?> argType = method.getParameterTypes()[0];
            try {
                Object[] params = new Object[]{value};
                if (!argType.isAssignableFrom(value.getClass())) {
                    params = new Object[]{StringUtil.valueOf(value.toString(), argType)};
                }
                method.invoke(bean, params);
                continue;
            }
            catch (Throwable e) {
                throw new InvalidPropertyException(CorePlugin.Event.TEIID10044, propertyName, value.toString(), argType, e);
            }
        }
    }

    private static Properties lowerCaseAllPropNames(Properties connectionProps) {
        Properties lcProps = new Properties();
        Enumeration<?> itr = connectionProps.propertyNames();
        while (itr.hasMoreElements()) {
            String name = (String)itr.nextElement();
            String propValue = connectionProps.getProperty(name);
            if (propValue == null) continue;
            lcProps.setProperty(name.toLowerCase(), propValue);
        }
        return lcProps;
    }

    public static class InvalidPropertyException
    extends TeiidRuntimeException {
        private static final long serialVersionUID = 1586068295007497776L;

        public InvalidPropertyException(BundleUtil.Event event, String propertyName, String value, Class<?> expectedType, Throwable cause) {
            super(event, cause, CorePlugin.Util.getString("InvalidPropertyException.message", propertyName, value, expectedType.getSimpleName()));
        }
    }
}

