/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client.ctc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.internal.core.xml.SAXBuilderHelper;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.test.client.QuerySQL;
import org.teiid.test.client.QueryTest;
import org.teiid.test.client.ctc.QueryResults;
import org.teiid.test.client.ctc.ResultsHolder;
import org.teiid.test.client.ctc.TagNames;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.exception.TransactionRuntimeException;
import org.teiid.test.util.StringUtil;

public class XMLQueryVisitationStrategy {
    private static final int START_ROW = 1;

    public List parseXMLQueryFile(String queryScenarioID, File queryFile, String querySetID) throws IOException, JDOMException {
        LinkedList<QueryTest> queries = new LinkedList<QueryTest>();
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(false);
        Document queryDocument = builder.build(queryFile);
        List queryElements = queryDocument.getRootElement().getChildren("query");
        for (Element queryElement : queryElements) {
            String queryName = queryElement.getAttributeValue("name");
            if (queryElement.getChild("exception") == null) {
                String uniqueID = querySetID + "_" + queryName;
                List parmChildren = queryElement.getChildren("sql");
                if (parmChildren == null || parmChildren.isEmpty()) {
                    TestLogger.logDebug("=======  Single QueryTest ");
                    QuerySQL sql = this.createQuerySQL(queryElement);
                    QueryTest q = new QueryTest(queryScenarioID, uniqueID, querySetID, new QuerySQL[]{sql}, false);
                    queries.add(q);
                    continue;
                }
                TestLogger.logDebug("=======  QueryTest has multiple sql statements");
                QuerySQL[] querysql = new QuerySQL[parmChildren.size()];
                int c = 0;
                for (Element sqlElement : parmChildren) {
                    QuerySQL sql;
                    querysql[c] = sql = this.createQuerySQL(sqlElement);
                    ++c;
                }
                QueryTest q = new QueryTest(queryScenarioID, uniqueID, querySetID, querysql, false);
                queries.add(q);
                continue;
            }
            Element exceptionElement = queryElement.getChild("exception");
            String exceptionType = exceptionElement.getChild("class").getTextTrim();
            String uniqueID = querySetID + "_" + queryName;
            QuerySQL sql = new QuerySQL(exceptionType, null);
            QueryTest q = new QueryTest(queryScenarioID, uniqueID, querySetID, new QuerySQL[]{sql}, true);
            queries.add(q);
        }
        return queries;
    }

    private QuerySQL createQuerySQL(Element queryElement) {
        String rowCnt;
        String query = queryElement.getTextTrim();
        Object[] parms = this.getParms(queryElement);
        QuerySQL sql = new QuerySQL(query, parms);
        String updateCnt = queryElement.getAttributeValue("updatecnt");
        if (updateCnt != null && updateCnt.trim().length() > 0) {
            int cnt = Integer.parseInt(updateCnt);
            sql.setUpdateCnt(cnt);
        }
        if ((rowCnt = queryElement.getAttributeValue("rowCount")) != null && rowCnt.trim().length() > 0) {
            int cnt = Integer.parseInt(rowCnt);
            sql.setRowCnt(cnt);
        }
        return sql;
    }

    private Object[] getParms(Element parent) {
        List parmChildren = parent.getChildren("parm");
        if (parmChildren == null) {
            return null;
        }
        Object[] parms = new Object[parmChildren.size()];
        int i = 0;
        for (Element parmElement : parmChildren) {
            try {
                Object parm;
                parms[i] = parm = this.createParmType(parmElement);
                ++i;
            }
            catch (JDOMException e) {
                throw new TransactionRuntimeException((Exception)((Object)e));
            }
        }
        return parms;
    }

    private Object createParmType(Element cellElement) throws JDOMException {
        Object cellObject = null;
        String typeName = cellElement.getAttributeValue("type");
        if (typeName.equalsIgnoreCase("boolean")) {
            cellObject = this.consumeMsg((Boolean)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("string")) {
            cellObject = this.consumeMsg((String)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("char")) {
            cellObject = this.consumeMsg((Character)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("byte")) {
            cellObject = this.consumeMsg((Byte)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("double")) {
            cellObject = this.consumeMsg((Double)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("date")) {
            cellObject = this.consumeMsg((Date)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("time")) {
            cellObject = this.consumeMsg((Time)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("timestamp")) {
            cellObject = this.consumeMsg((Timestamp)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("float")) {
            cellObject = this.consumeMsg((Float)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("bigdecimal")) {
            cellObject = this.consumeMsg((BigDecimal)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("biginteger")) {
            cellObject = this.consumeMsg((BigInteger)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("integer")) {
            cellObject = this.consumeMsg((Integer)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("long")) {
            cellObject = this.consumeMsg((Long)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("short")) {
            cellObject = this.consumeMsg((Short)cellObject, cellElement);
        } else if (typeName.equalsIgnoreCase("object")) {
            cellObject = this.consumeMsg((String)cellObject, cellElement);
        }
        return cellObject;
    }

    public ResultsHolder parseXMLResultsFile(File resultsFile) throws IOException, JDOMException {
        ResultsHolder expectedResults = null;
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(false);
        Document resultsDocument = builder.build(resultsFile);
        String query = resultsDocument.getRootElement().getChildText("query");
        List resultElements = resultsDocument.getRootElement().getChildren("queryResults");
        for (Element resultElement : resultElements) {
            String resultName = resultElement.getAttributeValue("name");
            QueryResults queryResults = this.consumeMsg(new QueryResults(), resultElement);
            if (queryResults.getFieldCount() != 0) {
                expectedResults = new ResultsHolder("queryResults");
                expectedResults.setQueryID(resultName);
                expectedResults.setQuery(query);
                expectedResults.setIdentifiers(queryResults.getFieldIdents());
                expectedResults.setTypes(queryResults.getTypes());
                if (queryResults.getRecordCount() <= 0) continue;
                expectedResults.setRows(queryResults.getRecords());
                continue;
            }
            expectedResults = new ResultsHolder("exception");
            expectedResults.setQueryID(resultName);
            expectedResults.setQuery(query);
            Element exceptionElement = resultElement.getChild("exception");
            if (exceptionElement == null) continue;
            expectedResults.setExceptionClassName(exceptionElement.getChild("class").getTextTrim());
            String msg = exceptionElement.getChild("message").getTextTrim();
            expectedResults.setExceptionMsg(StringUtil.removeChars(msg, new char[]{'\r'}));
        }
        return expectedResults;
    }

    public Element parseXMLResultsFile(File resultsFile, Element parent) throws IOException, JDOMException {
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(false);
        Document resultsDocument = builder.build(resultsFile);
        List resultElements = resultsDocument.getRootElement().getChildren("queryResults");
        for (Element resultElement : resultElements) {
            if (resultElement.getChild("select") == null) {
                Element exceptionElement = resultElement.getChild("exception");
                if (exceptionElement == null) continue;
                Element typeElement = new Element("exceptionType");
                typeElement.setText(exceptionElement.getChild("exceptionType").getTextTrim());
                parent.addContent((Content)typeElement);
                Element messageElement = new Element("message");
                String msg = exceptionElement.getChild("message").getTextTrim();
                messageElement.setText(StringUtil.removeChars(msg, new char[]{'\r'}));
                parent.addContent((Content)messageElement);
                Element classElement = new Element("class");
                classElement.setText(exceptionElement.getChild("class").getTextTrim());
                parent.addContent((Content)classElement);
                continue;
            }
            Element selectElement = resultElement.getChild("select");
            resultElement.removeChild("select");
            parent.addContent((Content)selectElement);
            Element tableElement = resultElement.getChild("table");
            resultElement.removeChild("table");
            parent.addContent((Content)tableElement);
        }
        return parent;
    }

    public static Element jdomException(Throwable ex, Element exceptionElement) {
        String className = ex.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index != -1 && ++index < className.length()) {
            className = className.substring(index);
        }
        Element typeElement = new Element("exceptionType");
        typeElement.setText(className);
        exceptionElement.addContent((Content)typeElement);
        Element messageElement = new Element("message");
        messageElement.setText(StringUtil.removeChars(ex.getMessage(), new char[]{'\r'}));
        exceptionElement.addContent((Content)messageElement);
        Element classElement = new Element("class");
        classElement.setText(ex.getClass().getName());
        exceptionElement.addContent((Content)classElement);
        return exceptionElement;
    }

    private QueryResults consumeMsg(QueryResults object, Element resultsElement) throws JDOMException {
        QueryResults results = object;
        if (results == null) {
            results = new QueryResults();
        }
        if (resultsElement.getChild("select") == null) {
            return results;
        }
        Element selectElement = resultsElement.getChild("select");
        Select select = new Select();
        select = this.consumeMsg(select, selectElement);
        List listOfElementSymbols = select.getSymbols();
        Iterator elementSymbolItr = listOfElementSymbols.iterator();
        ArrayList<QueryResults.ColumnInfo> collectionOfColumnInfos = new ArrayList<QueryResults.ColumnInfo>();
        while (elementSymbolItr.hasNext()) {
            ElementSymbol elementSymbol = (ElementSymbol)elementSymbolItr.next();
            Class elementType = elementSymbol.getType();
            String dataType = DataTypeManager.getDataTypeName((Class)elementType);
            QueryResults.ColumnInfo columnInfo = new QueryResults.ColumnInfo(elementSymbol.getName(), dataType, elementType);
            collectionOfColumnInfos.add(columnInfo);
        }
        results.addFields(collectionOfColumnInfos);
        Element tableElement = resultsElement.getChild("table");
        List tableRows = tableElement.getChildren("tableRow");
        if (tableRows.size() > 0) {
            for (Element rowElement : tableRows) {
                List cellElements = rowElement.getChildren("tableCell");
                Iterator cellIter = cellElements.iterator();
                ArrayList<Object> row = new ArrayList<Object>();
                Object evalue = null;
                while (cellIter.hasNext()) {
                    Element cellElement = (Element)cellIter.next();
                    if (cellElement.getTextTrim().equalsIgnoreCase("null")) {
                        row.add(null);
                        continue;
                    }
                    Element cellChildElement = (Element)cellElement.getChildren().get(0);
                    evalue = this.consumeMsg(cellChildElement);
                    row.add(evalue);
                }
                results.addRecord(row);
            }
        }
        return results;
    }

    private Select consumeMsg(Select object, Element selectElement) throws JDOMException {
        String star;
        Select select = object != null ? object : new Select();
        String distinct = selectElement.getAttributeValue("distinct");
        if (distinct != null && distinct.equalsIgnoreCase("true")) {
            select.setDistinct(true);
        }
        if ((star = selectElement.getAttributeValue("star")) != null && star.equalsIgnoreCase("true")) {
            if (selectElement.getChildren() != null) {
                throw new JDOMException("No children expected when star is chosen.");
            }
            return select;
        }
        List idents = selectElement.getChildren();
        for (Element dataElement : idents) {
            Attribute dataType = dataElement.getAttribute("type");
            ElementSymbol nodeID = new ElementSymbol(dataElement.getText());
            Class nodeType = (Class)TagNames.TYPE_MAP.get(dataType.getValue());
            if (nodeType == null) {
                throw new JDOMException("Unknown class for type \"" + dataType.getValue() + "\".");
            }
            nodeID.setType(nodeType);
            select.addSymbol((Expression)nodeID);
        }
        return select;
    }

    private Object consumeMsg(Element cellElement) throws JDOMException {
        Object cellObject = null;
        String cellName = cellElement.getName();
        cellObject = cellName.equalsIgnoreCase("boolean") ? this.consumeMsg((Boolean)cellObject, cellElement) : (cellName.equalsIgnoreCase("string") ? this.consumeMsg((String)cellObject, cellElement) : (cellName.equalsIgnoreCase("char") ? this.consumeMsg((Character)cellObject, cellElement) : (cellName.equalsIgnoreCase("byte") ? this.consumeMsg((Byte)cellObject, cellElement) : (cellName.equalsIgnoreCase("double") ? this.consumeMsg((Double)cellObject, cellElement) : (cellName.equalsIgnoreCase("date") ? this.consumeMsg((Date)cellObject, cellElement) : (cellName.equalsIgnoreCase("time") ? this.consumeMsg((Time)cellObject, cellElement) : (cellName.equalsIgnoreCase("timestamp") ? this.consumeMsg((Timestamp)cellObject, cellElement) : (cellName.equalsIgnoreCase("float") ? this.consumeMsg((Float)cellObject, cellElement) : (cellName.equalsIgnoreCase("bigdecimal") ? this.consumeMsg((BigDecimal)cellObject, cellElement) : (cellName.equalsIgnoreCase("biginteger") ? this.consumeMsg((BigInteger)cellObject, cellElement) : (cellName.equalsIgnoreCase("integer") ? this.consumeMsg((Integer)cellObject, cellElement) : (cellName.equalsIgnoreCase("long") ? this.consumeMsg((Long)cellObject, cellElement) : (cellName.equalsIgnoreCase("short") ? this.consumeMsg((Short)cellObject, cellElement) : (cellName.equalsIgnoreCase("object") ? this.consumeMsg((String)cellObject, cellElement) : this.consumeMsg(cellObject, cellElement)))))))))))))));
        return cellObject;
    }

    private Object consumeMsg(Boolean object, Element cellElement) throws JDOMException {
        boolean result = false;
        String value = cellElement.getTextTrim();
        if (value.equalsIgnoreCase("true")) {
            result = true;
        } else if (value.equalsIgnoreCase("false")) {
            result = false;
        } else {
            throw new JDOMException("Invalid value for " + cellElement.getName() + " element: \"" + value + "\" must be either \"" + "true" + "\" or \"" + "false" + "\"");
        }
        return new Boolean(result);
    }

    private Object consumeMsg(Date object, Element cellElement) throws JDOMException {
        Date result;
        try {
            result = Date.valueOf(cellElement.getTextTrim());
        }
        catch (Exception e) {
            throw new JDOMException("Invalid input format ", (Throwable)e);
        }
        return result;
    }

    private Object consumeMsg(Time object, Element cellElement) throws JDOMException {
        Time result;
        try {
            result = Time.valueOf(cellElement.getTextTrim());
        }
        catch (Exception e) {
            throw new JDOMException("Invalid input format ", (Throwable)e);
        }
        return result;
    }

    private Object consumeMsg(Timestamp object, Element cellElement) throws JDOMException {
        Timestamp result;
        try {
            result = Timestamp.valueOf(cellElement.getTextTrim());
        }
        catch (Exception e) {
            throw new JDOMException("Invalid input format ", (Throwable)e);
        }
        return result;
    }

    private Object consumeMsg(Double object, Element cellElement) throws JDOMException {
        Double result;
        String strElement = cellElement.getTextTrim();
        if (strElement.equals("NaN")) {
            result = new Double(Double.NaN);
        } else if (strElement.equals("-Infinity")) {
            result = new Double(Double.NEGATIVE_INFINITY);
        } else if (strElement.equals("Infinity")) {
            result = new Double(Double.POSITIVE_INFINITY);
        } else {
            try {
                result = Double.valueOf(strElement);
            }
            catch (NumberFormatException e) {
                throw new JDOMException("Unable to parse the value for " + cellElement.getName() + " element: " + strElement, (Throwable)e);
            }
        }
        return result;
    }

    private Object consumeMsg(Float object, Element cellElement) throws JDOMException {
        Float result;
        String strElement = cellElement.getTextTrim();
        if (strElement.equals("NaN")) {
            result = new Float(Float.NaN);
        } else if (strElement.equals("-Infinity")) {
            result = new Float(Float.NEGATIVE_INFINITY);
        } else if (strElement.equals("Infinity")) {
            result = new Float(Float.POSITIVE_INFINITY);
        } else {
            try {
                result = Float.valueOf(strElement);
            }
            catch (NumberFormatException e) {
                throw new JDOMException("Unable to parse the value for " + cellElement.getName() + " element: " + strElement, (Throwable)e);
            }
        }
        return result;
    }

    private Object consumeMsg(BigDecimal object, Element cellElement) throws JDOMException {
        BigDecimal result;
        try {
            result = new BigDecimal(cellElement.getTextTrim());
        }
        catch (NumberFormatException e) {
            throw new JDOMException("Unable to parse the value for " + cellElement.getName() + " element: " + cellElement.getTextTrim(), (Throwable)e);
        }
        return result;
    }

    private Object consumeMsg(BigInteger object, Element cellElement) throws JDOMException {
        BigInteger result;
        try {
            result = new BigInteger(cellElement.getTextTrim());
        }
        catch (NumberFormatException e) {
            throw new JDOMException("Unable to parse the value for " + cellElement.getName() + " element: " + cellElement.getTextTrim(), (Throwable)e);
        }
        return result;
    }

    private Object consumeMsg(String object, Element cellElement) throws JDOMException {
        return cellElement.getText();
    }

    private Object consumeMsg(Character object, Element cellElement) throws JDOMException {
        Character result;
        try {
            if (cellElement.getTextTrim().length() == 0) {
                return null;
            }
            result = new Character(cellElement.getTextTrim().charAt(0));
        }
        catch (NumberFormatException e) {
            throw new JDOMException("Unable to parse the value for " + cellElement.getName() + " element: " + cellElement.getTextTrim(), (Throwable)e);
        }
        return result;
    }

    private Object consumeMsg(Byte object, Element cellElement) throws JDOMException {
        Byte result;
        try {
            result = new Byte(cellElement.getTextTrim());
        }
        catch (NumberFormatException e) {
            throw new JDOMException("Unable to parse the value for " + cellElement.getName() + " element: " + cellElement.getTextTrim(), (Throwable)e);
        }
        return result;
    }

    private Object consumeMsg(Integer object, Element cellElement) throws JDOMException {
        Integer result;
        try {
            result = Integer.valueOf(cellElement.getTextTrim());
        }
        catch (NumberFormatException e) {
            throw new JDOMException("Unable to parse the value for " + cellElement.getName() + " element: " + cellElement.getTextTrim(), (Throwable)e);
        }
        return result;
    }

    private Object consumeMsg(Long object, Element cellElement) throws JDOMException {
        Long result;
        try {
            result = Long.valueOf(cellElement.getTextTrim());
        }
        catch (NumberFormatException e) {
            throw new JDOMException("Unable to parse the value for " + cellElement.getName() + " element: " + cellElement.getTextTrim(), (Throwable)e);
        }
        return result;
    }

    private Object consumeMsg(Object object, Element cellElement) throws JDOMException {
        return cellElement.getText();
    }

    private Object consumeMsg(Short object, Element cellElement) throws JDOMException {
        Short result;
        try {
            result = Short.valueOf(cellElement.getTextTrim());
        }
        catch (NumberFormatException e) {
            throw new JDOMException("Unable to parse the value for " + cellElement.getName() + " element: " + cellElement.getTextTrim(), (Throwable)e);
        }
        return result;
    }

    public Element produceResults(ResultSet object) throws JDOMException, SQLException {
        return this.produceResults(object, 1, Integer.MAX_VALUE);
    }

    private Element produceResults(ResultSet object, int beginRow, int endRow) throws JDOMException, SQLException {
        block6: {
            int currentRow;
            block5: {
                if (object.isClosed()) {
                    throw new SQLException("ResultSet is closed at this point, unable to product results");
                }
                if (beginRow < 1) {
                    throw new IllegalArgumentException("The starting row cannot be less than 1.");
                }
                if (beginRow > endRow) {
                    throw new IllegalArgumentException("The starting row cannot be less than the ending row.");
                }
                currentRow = object.getRow() + 1;
                if (beginRow <= currentRow) break block5;
                while (!object.isLast() && currentRow != beginRow) {
                    object.next();
                    ++currentRow;
                }
                break block6;
            }
            if (beginRow >= currentRow) break block6;
            while (!object.isFirst() && currentRow != beginRow) {
                object.previous();
                --currentRow;
            }
        }
        return this.produceMsg(object, endRow);
    }

    private Element produceMsg(ResultSet object, int endRow) throws JDOMException, SQLException {
        Element resultsElement = new Element("queryResults");
        ResultSetMetaData rmdata = object.getMetaData();
        ArrayList<ElementSymbol> identList = new ArrayList<ElementSymbol>(rmdata.getColumnCount());
        for (int i = 1; i <= rmdata.getColumnCount(); ++i) {
            identList.add(new ElementSymbol(rmdata.getColumnName(i)));
        }
        Select select = new Select(identList);
        resultsElement = this.produceMsg(select, rmdata, resultsElement);
        resultsElement.addContent((Content)new Element("table"));
        Element tableElement = resultsElement.getChild("table");
        int rowCount = 0;
        int colCount = rmdata.getColumnCount();
        while (object.next() && object.getRow() <= endRow) {
            Element rowElement = new Element("tableRow");
            for (int i = 1; i <= colCount; ++i) {
                Element cellElement = new Element("tableCell");
                Object cellValue = object.getObject(i);
                cellElement = cellValue != null ? this.produceMsg(cellValue, cellElement) : cellElement.addContent("null");
                rowElement.addContent((Content)cellElement);
            }
            tableElement.addContent((Content)rowElement);
            ++rowCount;
        }
        Attribute rowCountAttribute = new Attribute("rowCount", Integer.toString(rowCount));
        Attribute columnCountAttribute = new Attribute("columnCount", Integer.toString(colCount));
        tableElement.setAttribute(rowCountAttribute);
        tableElement.setAttribute(columnCountAttribute);
        return resultsElement;
    }

    public Element produceMsg(ResultSet object, Element resultsElement) throws JDOMException, SQLException {
        ResultSetMetaData rmdata = object.getMetaData();
        ArrayList<ElementSymbol> identList = new ArrayList<ElementSymbol>(rmdata.getColumnCount());
        for (int i = 1; i <= rmdata.getColumnCount(); ++i) {
            identList.add(new ElementSymbol(rmdata.getColumnName(i)));
        }
        Select select = new Select(identList);
        resultsElement = this.produceMsg(select, rmdata, resultsElement);
        resultsElement.addContent((Content)new Element("table"));
        Element tableElement = resultsElement.getChild("table");
        int rowCount = 0;
        int colCount = rmdata.getColumnCount();
        while (object.next()) {
            Element rowElement = new Element("tableRow");
            for (int i = 1; i <= colCount; ++i) {
                Element cellElement = new Element("tableCell");
                Object cellValue = object.getObject(i);
                cellElement = cellValue != null ? this.produceMsg(cellValue, cellElement) : cellElement.addContent("null");
                rowElement.addContent((Content)cellElement);
            }
            tableElement.addContent((Content)rowElement);
            ++rowCount;
        }
        Attribute rowCountAttribute = new Attribute("rowCount", Integer.toString(rowCount));
        Attribute columnCountAttribute = new Attribute("columnCount", Integer.toString(colCount));
        tableElement.setAttribute(rowCountAttribute);
        tableElement.setAttribute(columnCountAttribute);
        return resultsElement;
    }

    public Element produceMsg(Object object, Element parent) throws JDOMException, SQLException {
        if (object == null) {
            throw new IllegalArgumentException("Null object reference.");
        }
        Element element = null;
        element = object instanceof Boolean ? this.produceMsg((Boolean)object, parent) : (object instanceof String ? this.produceMsg((String)object, parent) : (object instanceof Character ? this.produceMsg((Character)object, parent) : (object instanceof Byte ? this.produceMsg((Byte)object, parent) : (object instanceof Double ? this.produceMsg((Double)object, parent) : (object instanceof Date ? this.produceMsg((Date)object, parent) : (object instanceof Time ? this.produceMsg((Time)object, parent) : (object instanceof Timestamp ? this.produceMsg((Timestamp)object, parent) : (object instanceof Float ? this.produceMsg((Float)object, parent) : (object instanceof BigDecimal ? this.produceMsg((BigDecimal)object, parent) : (object instanceof BigInteger ? this.produceMsg((BigInteger)object, parent) : (object instanceof Integer ? this.produceMsg((Integer)object, parent) : (object instanceof Long ? this.produceMsg((Long)object, parent) : (object instanceof Short ? this.produceMsg((Short)object, parent) : (object instanceof Throwable ? this.produceMsg((Throwable)object, parent) : this.produceObject(object, parent)))))))))))))));
        return element;
    }

    private Element produceMsg(Select select, ResultSetMetaData rmdata, Element parent) throws JDOMException {
        Element selectElement = new Element("select");
        boolean distinct = select.isDistinct();
        if (distinct) {
            Attribute distinctAttribute = new Attribute("distinct", "true");
            selectElement.setAttribute(distinctAttribute);
        }
        if (select.isStar()) {
            Attribute starAttribute = new Attribute("star", "true");
            selectElement.setAttribute(starAttribute);
        }
        int col = 0;
        Iterator iter = select.getSymbols().iterator();
        while (iter.hasNext()) {
            Element dataElement = new Element("dataElement");
            ElementSymbol symbol = (ElementSymbol)iter.next();
            String elementName = symbol.getName();
            Attribute dataType = null;
            try {
                dataType = new Attribute("type", rmdata.getColumnTypeName(++col));
            }
            catch (SQLException e) {
                // empty catch block
            }
            dataElement.setAttribute(dataType);
            dataElement.setText(elementName);
            selectElement.addContent((Content)dataElement);
        }
        if (parent != null) {
            selectElement = parent.addContent((Content)selectElement);
        }
        return selectElement;
    }

    private Element produceObject(Object object, Element parent) throws JDOMException, SQLException {
        Element objectElement = new Element("object");
        String result = null;
        if (object instanceof Blob || object instanceof Clob || object instanceof SQLXML) {
            if (object instanceof Clob) {
                Clob c = (Clob)object;
                try {
                    result = ObjectConverterUtil.convertToString((InputStream)c.getAsciiStream());
                }
                catch (Throwable e) {
                    throw new SQLException(e);
                }
            } else if (object instanceof Blob) {
                Blob b = (Blob)object;
                try {
                    result = ObjectConverterUtil.convertToString((InputStream)b.getBinaryStream());
                }
                catch (Throwable e) {
                    throw new SQLException(e);
                }
            } else if (object instanceof SQLXML) {
                SQLXML s = (SQLXML)object;
                try {
                    result = ObjectConverterUtil.convertToString((InputStream)s.getBinaryStream());
                }
                catch (Throwable e) {
                    throw new SQLException(e);
                }
            }
        } else {
            result = object.toString();
        }
        objectElement.setText(result);
        if (parent != null) {
            objectElement = parent.addContent((Content)objectElement);
        }
        return objectElement;
    }

    private Element produceMsg(String object, Element parent) throws JDOMException {
        Element stringElement = new Element("string");
        stringElement.setText(object);
        if (parent != null) {
            stringElement = parent.addContent((Content)stringElement);
        }
        return stringElement;
    }

    private Element produceMsg(Character object, Element parent) throws JDOMException {
        Element charElement = new Element("char");
        String v = object.toString();
        if (v != null && v.length() != 0) {
            String toReplace = new String(new Character('\u0000').toString());
            v.replaceAll(toReplace, " ");
            charElement.setText(v.trim());
        }
        if (parent != null) {
            charElement = parent.addContent((Content)charElement);
        }
        return charElement;
    }

    private Element produceMsg(Byte object, Element parent) throws JDOMException {
        Element byteElement = new Element("byte");
        byteElement.setText(object.toString());
        if (parent != null) {
            byteElement = parent.addContent((Content)byteElement);
        }
        return byteElement;
    }

    private Element produceMsg(Boolean object, Element parent) throws JDOMException {
        Element booleanElement = new Element("boolean");
        if (object.booleanValue()) {
            booleanElement.setText("true");
        } else {
            booleanElement.setText("false");
        }
        if (parent != null) {
            booleanElement = parent.addContent((Content)booleanElement);
        }
        return booleanElement;
    }

    private Element produceMsg(Float object, Element parent) throws JDOMException {
        Element floatElement = new Element("float");
        floatElement.setText(object.toString());
        if (parent != null) {
            floatElement = parent.addContent((Content)floatElement);
        }
        return floatElement;
    }

    private Element produceMsg(Double object, Element parent) throws JDOMException {
        Element doubleElement = new Element("double");
        doubleElement.setText(object.toString());
        if (parent != null) {
            doubleElement = parent.addContent((Content)doubleElement);
        }
        return doubleElement;
    }

    private Element produceMsg(BigDecimal object, Element parent) throws JDOMException {
        Element bigDecimalElement = new Element("bigdecimal");
        bigDecimalElement.setText(object.toString());
        if (parent != null) {
            bigDecimalElement = parent.addContent((Content)bigDecimalElement);
        }
        return bigDecimalElement;
    }

    private Element produceMsg(BigInteger object, Element parent) throws JDOMException {
        Element bigIntegerElement = new Element("biginteger");
        bigIntegerElement.setText(object.toString());
        if (parent != null) {
            bigIntegerElement = parent.addContent((Content)bigIntegerElement);
        }
        return bigIntegerElement;
    }

    private Element produceMsg(Date object, Element parent) throws JDOMException {
        Element sqldateElement = new Element("date");
        sqldateElement.setText(object.toString());
        if (parent != null) {
            sqldateElement = parent.addContent((Content)sqldateElement);
        }
        return sqldateElement;
    }

    private Element produceMsg(Time object, Element parent) throws JDOMException {
        Element timeElement = new Element("time");
        timeElement.setText(object.toString());
        if (parent != null) {
            timeElement = parent.addContent((Content)timeElement);
        }
        return timeElement;
    }

    private Element produceMsg(Timestamp object, Element parent) throws JDOMException {
        Element timestampElement = new Element("timestamp");
        timestampElement.setText(object.toString());
        if (parent != null) {
            timestampElement = parent.addContent((Content)timestampElement);
        }
        return timestampElement;
    }

    private Element produceMsg(Integer object, Element parent) throws JDOMException {
        Element integerElement = new Element("integer");
        integerElement.setText(object.toString());
        if (parent != null) {
            integerElement = parent.addContent((Content)integerElement);
        }
        return integerElement;
    }

    private Element produceMsg(Long object, Element parent) throws JDOMException {
        Element longElement = new Element("long");
        longElement.setText(object.toString());
        if (parent != null) {
            longElement = parent.addContent((Content)longElement);
        }
        return longElement;
    }

    private Element produceMsg(Short object, Element parent) throws JDOMException {
        Element shortElement = new Element("short");
        shortElement.setText(object.toString());
        if (parent != null) {
            shortElement = parent.addContent((Content)shortElement);
        }
        return shortElement;
    }

    private Element produceMsg(Throwable object, Element parent) throws JDOMException {
        Throwable exception = object;
        Element exceptionElement = null;
        exceptionElement = new Element("exception");
        String className = exception.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index != -1 && ++index < className.length()) {
            className = className.substring(index);
        }
        Element typeElement = new Element("exceptionType");
        typeElement.setText(className);
        exceptionElement.addContent((Content)typeElement);
        Element messageElement = new Element("message");
        messageElement.setText(StringUtil.removeChars(exception.getMessage(), new char[]{'\r'}));
        exceptionElement.addContent((Content)messageElement);
        Element classElement = new Element("class");
        classElement.setText(exception.getClass().getName());
        exceptionElement.addContent((Content)classElement);
        if (parent != null) {
            exceptionElement = parent.addContent((Content)exceptionElement);
        }
        return exceptionElement;
    }
}

