/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.core.TeiidException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.query.util.Options;
import org.teiid.translator.ExecutionFactory;

public class TestOrderByProcessing {
    @Test
    public void testOrderByDescAll() {
        String sql = "SELECT distinct e1 from pm1.g2 order by e1 desc limit 1";
        List[] expected = new List[]{Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOrderByOutsideOfSelect() {
        String sql = "SELECT e1 FROM (select e1, e2 || e3 as e2 from pm1.g2) x order by e2";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList(new String[]{null}), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOrderByUnrelatedExpression() {
        String sql = "SELECT e1, e2 + 1 from pm1.g2 order by e3 || e2 limit 1";
        List[] expected = new List[]{Arrays.asList("a", 1)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testOrderByWithDuplicateExpressions() throws Exception {
        String sql = "select e1 as x, e1 as y from pm1.g1 order by y ASC";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c")};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testExplicitNullOrdering() throws Exception {
        String sql = "select e1, case when e4 = 2.0 then null else e4 end as x from pm1.g1 order by e1 ASC NULLS LAST, x DESC NULLS FIRST";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList("a", null), Arrays.asList("a", null), Arrays.asList("a", 7.0), Arrays.asList("b", 0.0), Arrays.asList("c", null), Arrays.asList(null, 1.0)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testNullOrdering() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_NULL_ORDERING, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select e1 from pm1.g1 order by e1 desc, e2 asc", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0 DESC, g_0.e2"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testNullOrdering2() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_NULL_ORDERING, true);
        caps.setSourceProperty(SourceCapabilities.Capability.QUERY_ORDERBY_DEFAULT_NULL_ORDER, (Object)ExecutionFactory.NullOrder.FIRST);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        CommandContext cc = new CommandContext();
        cc.setOptions(new Options().pushdownDefaultNullOrder(true));
        ProcessorPlan plan = TestOptimizer.getPlan(TestOptimizer.helpGetCommand("select e1 from pm1.g1 order by e1 desc, e2 asc NULLS LAST", (QueryMetadataInterface)metadata, null), (QueryMetadataInterface)metadata, capFinder, null, true, cc);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0 DESC NULLS LAST, g_0.e2 NULLS LAST"}, plan);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testNullOrdering3() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setSourceProperty(SourceCapabilities.Capability.QUERY_ORDERBY_DEFAULT_NULL_ORDER, (Object)ExecutionFactory.NullOrder.HIGH);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        CommandContext cc = new CommandContext();
        cc.setOptions(new Options().pushdownDefaultNullOrder(true));
        ProcessorPlan plan = TestOptimizer.getPlan(TestOptimizer.helpGetCommand("select e1 from pm1.g1 order by e1 desc, e2 asc NULLS LAST", (QueryMetadataInterface)metadata, null), (QueryMetadataInterface)metadata, capFinder, null, true, cc);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0 DESC, g_0.e2"}, plan);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testNullOrdering4() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_NULL_ORDERING, true);
        caps.setSourceProperty(SourceCapabilities.Capability.QUERY_ORDERBY_DEFAULT_NULL_ORDER, (Object)ExecutionFactory.NullOrder.UNKNOWN);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        CommandContext cc = new CommandContext();
        cc.setOptions(new Options().pushdownDefaultNullOrder(true));
        ProcessorPlan plan = TestOptimizer.getPlan(TestOptimizer.helpGetCommand("select e1 from pm1.g1 order by e1 desc, e2 asc", (QueryMetadataInterface)metadata, null), (QueryMetadataInterface)metadata, capFinder, null, true, cc);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0 DESC NULLS LAST, g_0.e2 NULLS FIRST"}, plan);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testSortFunctionOverView() {
        String sql = "select * from (select * from pm1.g1) as x order by cast(e2 as string) limit 1";
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        FakeDataManager fdm = new FakeDataManager();
        TestProcessor.sampleData1(fdm);
        TestProcessor.helpProcess(plan, fdm, new List[]{Arrays.asList("a", 0, false, 2.0)});
    }

    @Test
    public void testSortFunctionOverView1() {
        String sql = "select e1 from (select * from pm1.g1) as x order by cast(e3 as string) desc, cast(e2 as string) limit 1";
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        FakeDataManager fdm = new FakeDataManager();
        TestProcessor.sampleData1(fdm);
        TestProcessor.helpProcess(plan, fdm, new List[]{Arrays.asList("c")});
    }

    @Test
    public void testOrderByAggWithoutSelectExpression() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        TestOptimizer.helpPlan("select sum (e2) as \"sum\" from pm1.g1 group by e1 order by \"sum\"", (QueryMetadataInterface)metadata, new String[]{"SELECT SUM(g_0.e2) FROM pm1.g1 AS g_0 GROUP BY g_0.e1 ORDER BY SUM(g_0.e2)"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testNestedLimit() throws Exception {
        String sql = "SELECT count(*) FROM (select intkey, stringkey as x from BQT1.SmallA ORDER BY x limit 10) x where intkey = 1";
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)TestOptimizer.getTypicalCapabilities()));
        List[] expected = new List[]{Arrays.asList(1)};
        HardcodedDataManager manager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        manager.addData("SELECT g_0.IntKey AS c_0 FROM SmallA AS g_0 ORDER BY g_0.StringKey", Arrays.asList(1));
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testSubqueryOrderNotPushdown() throws Exception {
        String sql = "SELECT (SELECT SUM(pm1.g1.e2) AS subField FROM pm1.g1 WHERE (pm1.g2.e1 = pm1.g1.e1)) AS sumField FROM pm1.g2 ORDER BY sumField DESC";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc));
        List[] expected = new List[]{Arrays.asList(2L)};
        HardcodedDataManager manager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        manager.addData("SELECT g_0.e1 FROM g2 AS g_0", Arrays.asList("1"));
        manager.addData("SELECT g_0.e2 FROM g1 AS g_0 WHERE g_0.e1 = '1'", Arrays.asList(2));
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testSubqueryOrderPushdown() throws Exception {
        String sql = "SELECT (SELECT SUM(pm1.g1.e2) AS subField FROM pm1.g1 WHERE (pm1.g2.e1 = pm1.g1.e1)) AS sumField FROM pm1.g2 ORDER BY sumField DESC";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc));
        List[] expected = new List[]{Arrays.asList(1)};
        HardcodedDataManager manager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        manager.addData("SELECT (SELECT SUM(g_1.e2) FROM g1 AS g_1 WHERE g_1.e1 = g_0.e1) AS c_0 FROM g2 AS g_0 ORDER BY c_0 DESC", Arrays.asList(1));
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test(expected=QueryValidatorException.class)
    public void testSubqueryOrderByUnrelated() throws Exception {
        String sql = "SELECT * FROM pm1.g1 ORDER BY (select count(*) from pm1.g2 where e1 = pm1.g1.e1)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc), TestProcessor.createCommandContext());
    }

    @Test
    public void testSubqueryOrderByRelated() throws Exception {
        String sql = "SELECT pm1.g1.*, (select count(*) from pm1.g2 where e1 = pm1.g1.e1) FROM pm1.g1 ORDER BY (select count(*) from pm1.g2 where e1 = pm1.g1.e1)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities bsc = TestOptimizer.getTypicalCapabilities();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)bsc), TestProcessor.createCommandContext());
        List[] expected = new List[]{Arrays.asList("a", 1, true, 1.0, 1)};
        HardcodedDataManager manager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        manager.addData("SELECT g_0.e1, g_0.e2, g_0.e3, g_0.e4 FROM g1 AS g_0", Arrays.asList("a", 1, true, 1.0));
        manager.addData("SELECT 1 FROM g2 AS g_0 WHERE g_0.e1 = 'a'", Arrays.asList(1));
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testSortCollationInhibitsPush() throws TeiidException {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setSourceProperty(SourceCapabilities.Capability.COLLATION_LOCALE, (Object)"foo");
        String sql = "select e1, e2 from pm1.g1 order by e2";
        CommandContext cc = new CommandContext();
        cc.setOptions(new Options().requireTeiidCollation(true));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), cc);
        List[] expected = new List[]{Arrays.asList("a", 0), Arrays.asList("a", 1)};
        HardcodedDataManager manager = new HardcodedDataManager();
        manager.addData("SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_1", Arrays.asList("a", 0), Arrays.asList("a", 1));
        TestProcessor.helpProcess(plan, manager, expected);
        sql = "select e1, e2 from pm1.g1 order by e1";
        plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), cc);
        expected = new List[]{Arrays.asList("a", 0), Arrays.asList("b", 1)};
        manager = new HardcodedDataManager();
        manager.addData("SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0", Arrays.asList("b", 1), Arrays.asList("a", 0));
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testDefaultNullOrdering() throws Exception {
        String sql = "select e1 from pm1.g1 order by e1";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        CommandContext cc = TestProcessor.createCommandContext();
        BufferManagerImpl bm = BufferManagerFactory.createBufferManager();
        bm.setOptions(new Options().defaultNullOrder(ExecutionFactory.NullOrder.FIRST));
        cc.setBufferManager((BufferManager)bm);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), cc);
        HardcodedDataManager manager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        manager.addData("SELECT g1.e1 FROM g1", Arrays.asList("a"), Arrays.asList("b"), Arrays.asList(new String[]{null}));
        TestProcessor.helpProcess(plan, cc, manager, new List[]{Arrays.asList(new String[]{null}), Arrays.asList("a"), Arrays.asList("b")});
        plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e1 from pm1.g1 order by e1 desc"), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), cc);
        TestProcessor.helpProcess(plan, cc, manager, new List[]{Arrays.asList(new String[]{null}), Arrays.asList("b"), Arrays.asList("a")});
        bm.getOptions().setDefaultNullOrder(ExecutionFactory.NullOrder.LAST);
        plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e1 from pm1.g1 order by e1 desc"), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), cc);
        TestProcessor.helpProcess(plan, cc, manager, new List[]{Arrays.asList("b"), Arrays.asList("a"), Arrays.asList(new String[]{null})});
        bm.getOptions().setDefaultNullOrder(ExecutionFactory.NullOrder.HIGH);
        plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e1 from pm1.g1 order by e1"), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), cc);
        TestProcessor.helpProcess(plan, cc, manager, new List[]{Arrays.asList("a"), Arrays.asList("b"), Arrays.asList(new String[]{null})});
    }
}

