/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.multisource.MultiSourceElementReplacementVisitor;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.RowBasedSecurityHelper;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.relational.GroupingNode;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.NullNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.processor.relational.SubqueryAwareEvaluator;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.processor.relational.UnionAllNode;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class AccessNode
extends SubqueryAwareRelationalNode {
    private static final Object[] NO_PROJECTION = new Object[0];
    private static final int MAX_CONCURRENT = 10;
    private Command command;
    private String modelName;
    private String connectorBindingId;
    private Expression connectorBindingExpression;
    private boolean shouldEvaluate = false;
    private boolean multiSource;
    private Object modelId;
    private Set<Object> conformedTo;
    private ArrayList<TupleSource> tupleSources = new ArrayList();
    private boolean isUpdate = false;
    private boolean returnedRows = false;
    protected Command nextCommand;
    private int reserved;
    private int schemaSize;
    private Command processingCommand;
    private boolean shouldExecute = true;
    private Object[] projection;
    private List<Expression> originalSelect;
    private List<String> sourceNames;
    public RegisterRequestParameter.SharedAccessInfo info;
    private Map<GroupSymbol, RelationalPlan> subPlans;
    private Map<GroupSymbol, SubqueryAwareEvaluator.SubqueryState> evaluatedPlans;

    protected AccessNode() {
    }

    public AccessNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        this.schemaSize = this.getBufferManager().getSchemaSize(this.getOutputElements());
    }

    @Override
    public void reset() {
        super.reset();
        this.tupleSources.clear();
        this.isUpdate = false;
        this.returnedRows = false;
        this.nextCommand = null;
        if (this.connectorBindingExpression != null) {
            this.connectorBindingId = null;
        }
        this.processingCommand = null;
        this.shouldExecute = true;
        this.evaluatedPlans = null;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setModelId(Object id) {
        this.modelId = id;
    }

    public Object getModelId() {
        return this.modelId;
    }

    public void setModelName(String name) {
        this.modelName = name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setShouldEvaluateExpressions(boolean shouldEvaluate) {
        this.shouldEvaluate = shouldEvaluate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        ModelMetaData model;
        VDBMetaData vdb;
        Object be;
        if (this.subPlans != null) {
            if (this.evaluatedPlans == null) {
                this.evaluatedPlans = new HashMap<GroupSymbol, SubqueryAwareEvaluator.SubqueryState>();
                for (Map.Entry<GroupSymbol, RelationalPlan> entry : this.subPlans.entrySet()) {
                    SubqueryAwareEvaluator.SubqueryState state = new SubqueryAwareEvaluator.SubqueryState();
                    state.processor = new QueryProcessor(entry.getValue(), this.getContext().clone(), this.getBufferManager(), this.getDataManager());
                    state.collector = state.processor.createBatchCollector();
                    this.evaluatedPlans.put(entry.getKey(), state);
                }
            }
            be = null;
            for (SubqueryAwareEvaluator.SubqueryState state : this.evaluatedPlans.values()) {
                try {
                    state.collector.collectTuples();
                }
                catch (BlockedException e) {
                    be = e;
                }
            }
            if (be != null) {
                throw be;
            }
        }
        if (this.multiSource && this.connectorBindingExpression == null) {
            be = this;
            synchronized (be) {
                vdb = this.getContext().getVdb();
                model = vdb.getModel(this.getModelName());
                List sources = model.getSourceNames();
                if (!(this.getChildCount() == 0 || this.sourceNames != null && this.sourceNames.equals(sources))) {
                    --this.childCount;
                    this.getChildren()[0] = null;
                }
                if (this.getChildCount() == 0) {
                    this.sourceNames = sources;
                    RelationalNode node = AccessNode.multiSourceModify(this, this.connectorBindingExpression, this.getContext().getMetadata(), this.sourceNames);
                    RelationalPlan.connectExternal(node, this.getContext(), this.getDataManager(), this.getBufferManager());
                    this.addChild(node);
                }
            }
            this.getChildren()[0].open();
            return;
        }
        if (this.processingCommand == null) {
            this.processingCommand = this.command;
            this.isUpdate = RelationalNodeUtil.isUpdate(this.command);
        }
        boolean needProcessing = true;
        if (this.connectorBindingExpression != null && this.connectorBindingId == null) {
            this.connectorBindingId = (String)this.getEvaluator(Collections.emptyMap()).evaluate(this.connectorBindingExpression, null);
            vdb = this.getContext().getVdb();
            model = vdb.getModel(this.getModelName());
            List sources = model.getSourceNames();
            String replacement = this.connectorBindingId;
            if (!sources.contains(this.connectorBindingId)) {
                StoredProcedure sp;
                this.shouldExecute = false;
                if (this.command instanceof StoredProcedure && (sp = (StoredProcedure)this.command).returnParameters() && sp.getProjectedSymbols().size() > sp.getResultSetColumns().size()) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30561, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30561, new Object[]{this.command}));
                }
                return;
            }
            if (!(this.command instanceof StoredProcedure) && !(this.command instanceof Insert)) {
                this.processingCommand = (Command)this.command.clone();
                PreOrPostOrderNavigator.doVisit(this.processingCommand, new MultiSourceElementReplacementVisitor(replacement, this.getContext().getMetadata()), true, false);
            }
        }
        do {
            Command atomicCommand = this.nextCommand();
            if (this.shouldEvaluate) {
                needProcessing = this.prepareNextCommand(atomicCommand);
                this.nextCommand = null;
            } else {
                needProcessing = RelationalNodeUtil.shouldExecute(atomicCommand, true);
            }
            if (!needProcessing) continue;
            this.registerRequest(atomicCommand);
        } while (!this.processCommandsIndividually() && this.hasNextCommand() && this.tupleSources.size() < Math.min(10, this.getContext().getUserRequestSourceConcurrency()));
    }

    public boolean isShouldEvaluate() {
        return this.shouldEvaluate;
    }

    public void minimizeProject(Command atomicCommand) {
        if (!(atomicCommand instanceof Query)) {
            return;
        }
        Query query = (Query)atomicCommand;
        Select select = query.getSelect();
        List<Expression> symbols = select.getSymbols();
        if (symbols.size() == 1) {
            return;
        }
        boolean shouldProject = false;
        LinkedHashMap<Expression, Integer> uniqueSymbols = new LinkedHashMap<Expression, Integer>();
        this.projection = new Object[symbols.size()];
        this.originalSelect = new ArrayList<Expression>(query.getSelect().getSymbols());
        int i = 0;
        int j = 0;
        Iterator<Expression> iter = symbols.iterator();
        while (iter.hasNext()) {
            Expression ss = iter.next();
            Expression ex = SymbolMap.getExpression(ss);
            if (ex instanceof Constant) {
                this.projection[i] = ex;
                if (iter.hasNext() || j != 0) {
                    iter.remove();
                    shouldProject = true;
                } else {
                    this.projection[i] = j++;
                }
            } else {
                Integer index = (Integer)uniqueSymbols.get(ex);
                if (index == null) {
                    uniqueSymbols.put(ex, j);
                    index = j++;
                } else {
                    iter.remove();
                    shouldProject = true;
                }
                this.projection[i] = index;
            }
            ++i;
        }
        if (!shouldProject) {
            this.projection = NO_PROJECTION;
        } else if (query.getOrderBy() != null) {
            for (OrderByItem item : query.getOrderBy().getOrderByItems()) {
                Integer index = (Integer)uniqueSymbols.get(SymbolMap.getExpression(item.getSymbol()));
                if (index == null) continue;
                item.setExpressionPosition(index);
                item.setSymbol(select.getSymbols().get(index));
            }
        }
    }

    public List<Expression> getOriginalSelect() {
        return this.originalSelect;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    static void rewriteAndEvaluate(Command atomicCommand, Evaluator eval, CommandContext context, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
        try {
            QueryRewriter.evaluateAndRewrite(atomicCommand, eval, context, metadata);
        }
        catch (QueryValidatorException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30174, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30174, new Object[]{atomicCommand}));
        }
    }

    protected Command nextCommand() throws TeiidProcessingException, TeiidComponentException {
        if (this.nextCommand == null) {
            this.nextCommand = (Command)this.processingCommand.clone();
            if (this.evaluatedPlans != null) {
                for (WithQueryCommand with : ((QueryCommand)this.nextCommand).getWith()) {
                    TupleBuffer tb = this.evaluatedPlans.get((Object)with.getGroupSymbol()).collector.getTupleBuffer();
                    with.setTupleBuffer(tb);
                }
            }
        }
        return this.nextCommand;
    }

    protected boolean prepareNextCommand(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        AccessNode.rewriteAndEvaluate(atomicCommand, this.getEvaluator(Collections.emptyMap()), this.getContext(), this.getContext().getMetadata());
        return RelationalNodeUtil.shouldExecute(atomicCommand, true);
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.multiSource && this.connectorBindingExpression == null) {
            return this.getChildren()[0].nextBatch();
        }
        while (this.shouldExecute && (!this.tupleSources.isEmpty() || this.hasNextCommand())) {
            if (this.tupleSources.isEmpty() && this.processCommandsIndividually()) {
                this.registerNext();
            }
            for (int i = 0; i < this.tupleSources.size(); ++i) {
                TupleSource tupleSource = this.tupleSources.get(i);
                try {
                    List<?> tuple = null;
                    while ((tuple = tupleSource.nextTuple()) != null) {
                        this.returnedRows = true;
                        if (this.projection != null && this.projection.length > 0) {
                            ArrayList newTuple = new ArrayList(this.projection.length);
                            for (Object object : this.projection) {
                                if (object instanceof Integer) {
                                    newTuple.add(tuple.get((Integer)object));
                                    continue;
                                }
                                newTuple.add(((Constant)object).getValue());
                            }
                            tuple = newTuple;
                        }
                        this.addBatchRow(tuple);
                        if (!this.isBatchFull()) continue;
                        return this.pullBatch();
                    }
                    tupleSource.closeSource();
                    this.tupleSources.remove(i--);
                    if (this.reserved > 0) {
                        this.reserved -= this.schemaSize;
                        this.getBufferManager().releaseBuffers(this.schemaSize);
                    }
                    if (this.processCommandsIndividually()) continue;
                    this.registerNext();
                    continue;
                }
                catch (BlockedException e) {
                    if (!this.processCommandsIndividually()) continue;
                    if (this.hasPendingRows()) {
                        return this.pullBatch();
                    }
                    throw e;
                }
            }
            if (this.processCommandsIndividually()) {
                if (!this.hasPendingRows()) continue;
                return this.pullBatch();
            }
            if (this.tupleSources.isEmpty()) continue;
            if (this.hasPendingRows()) {
                return this.pullBatch();
            }
            throw BlockedException.block(this.getContext().getRequestId(), "Blocking on source request(s).");
        }
        if (this.isUpdate && !this.returnedRows) {
            ArrayList<Integer> tuple = new ArrayList<Integer>(1);
            tuple.add(0);
            this.addBatchRow(tuple);
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    @Override
    protected void addBatchRow(List<?> row) {
        if (this.getOutputElements().isEmpty()) {
            row = Collections.emptyList();
        }
        super.addBatchRow(row);
    }

    private void registerNext() throws TeiidComponentException, TeiidProcessingException {
        while (this.hasNextCommand()) {
            Command atomicCommand = this.nextCommand();
            if (this.prepareNextCommand(atomicCommand)) {
                this.nextCommand = null;
                this.registerRequest(atomicCommand);
                break;
            }
            this.nextCommand = null;
        }
    }

    private void registerRequest(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        LimitNode parent;
        if (this.shouldEvaluate) {
            this.projection = null;
            this.minimizeProject(atomicCommand);
        }
        int limit = -1;
        if (this.getParent() instanceof LimitNode && (parent = (LimitNode)this.getParent()).getLimit() > 0) {
            limit = parent.getLimit() + parent.getOffset();
        }
        RegisterRequestParameter param = new RegisterRequestParameter(this.connectorBindingId, this.getID(), limit);
        param.info = this.info;
        param.fetchSize = this.getBatchSize();
        RowBasedSecurityHelper.checkConstraints(atomicCommand, this.getEvaluator(Collections.emptyMap()));
        this.tupleSources.add(this.getDataManager().registerRequest(this.getContext(), atomicCommand, this.modelName, param));
        if (this.tupleSources.size() > 1) {
            this.reserved += this.getBufferManager().reserveBuffers(this.schemaSize, BufferManager.BufferReserveMode.FORCE);
        }
    }

    protected boolean processCommandsIndividually() {
        return false;
    }

    protected boolean hasNextCommand() {
        return false;
    }

    @Override
    public void closeDirect() {
        if (this.reserved > 0) {
            this.getBufferManager().releaseBuffers(this.reserved);
            this.reserved = 0;
        }
        if (this.evaluatedPlans != null) {
            for (SubqueryAwareEvaluator.SubqueryState state : this.evaluatedPlans.values()) {
                state.close(true);
            }
            this.evaluatedPlans = null;
        }
        super.closeDirect();
        this.closeSources();
    }

    private void closeSources() {
        for (TupleSource ts : this.tupleSources) {
            ts.closeSource();
        }
        this.tupleSources.clear();
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.command);
        if (this.info != null) {
            str.append(" [SHARED ").append(this.info.id).append("]");
        }
    }

    @Override
    public Object clone() {
        AccessNode clonedNode = new AccessNode();
        this.copyTo(clonedNode);
        return clonedNode;
    }

    protected void copyTo(AccessNode target) {
        super.copyTo(target);
        target.modelName = this.modelName;
        target.modelId = this.modelId;
        if (this.connectorBindingExpression == null) {
            target.connectorBindingId = this.connectorBindingId;
        }
        target.shouldEvaluate = this.shouldEvaluate;
        if (!this.shouldEvaluate) {
            target.projection = this.projection;
            target.originalSelect = this.originalSelect;
        }
        target.command = this.command;
        target.info = this.info;
        target.connectorBindingExpression = this.connectorBindingExpression;
        target.multiSource = this.multiSource;
        target.sourceNames = this.sourceNames;
        target.conformedTo = this.conformedTo;
        if (this.subPlans != null) {
            target.subPlans = new HashMap<GroupSymbol, RelationalPlan>();
            for (Map.Entry<GroupSymbol, RelationalPlan> entry : this.subPlans.entrySet()) {
                target.subPlans.put(entry.getKey(), entry.getValue().clone());
            }
        }
    }

    @Override
    public synchronized PlanNode getDescriptionProperties() {
        if (this.getChildCount() > 0) {
            return this.getChildren()[0].getDescriptionProperties();
        }
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Query", this.command.toString());
        props.addProperty("Model Name", this.modelName);
        if (this.projection != null && this.projection.length > 0 && this.originalSelect != null) {
            props.addProperty("Select Columns", this.originalSelect.toString());
        }
        if (this.info != null) {
            props.addProperty("Sharing ID", String.valueOf(this.info.id));
        }
        if (this.subPlans != null) {
            for (Map.Entry<GroupSymbol, RelationalPlan> entry : this.subPlans.entrySet()) {
                props.addProperty(entry.getKey() + " Dependent Subplan", entry.getValue().getDescriptionProperties());
            }
        }
        return props;
    }

    public String getConnectorBindingId() {
        return this.connectorBindingId;
    }

    public void setConnectorBindingId(String connectorBindingId) {
        this.connectorBindingId = connectorBindingId;
    }

    public Expression getConnectorBindingExpression() {
        return this.connectorBindingExpression;
    }

    public void setConnectorBindingExpression(Expression connectorBindingExpression) {
        this.connectorBindingExpression = connectorBindingExpression;
    }

    @Override
    protected Collection<? extends LanguageObject> getObjects() {
        ArrayList list = new ArrayList();
        if (this.shouldEvaluate) {
            for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(this.command)) {
                if (container instanceof ExistsCriteria && ((ExistsCriteria)container).shouldEvaluate()) {
                    list.add(container);
                }
                if (!(container instanceof ScalarSubquery) || !((ScalarSubquery)container).shouldEvaluate()) continue;
                list.add(container);
            }
        }
        return list;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        Boolean required = super.requiresTransaction(transactionalReads);
        if (Boolean.TRUE.equals(required) || this.command instanceof StoredProcedure && ((StoredProcedure)this.command).getUpdateCount() > 1) {
            return true;
        }
        if (this.multiSource && this.connectorBindingExpression == null && (transactionalReads || RelationalNodeUtil.isUpdate(this.command))) {
            return true;
        }
        return null;
    }

    private static RelationalNode multiSourceModify(AccessNode accessNode, Expression ex, QueryMetadataInterface metadata, List<String> sourceNames) throws TeiidComponentException, TeiidProcessingException {
        ArrayList<AccessNode> accessNodes = new ArrayList<AccessNode>();
        boolean hasOutParams = RelationalNodeUtil.hasOutputParams(accessNode.getCommand());
        if (!Constant.NULL_CONSTANT.equals(ex)) {
            for (String sourceName : sourceNames) {
                Command command = accessNode.getCommand();
                if (!(command instanceof Insert) && !(command instanceof StoredProcedure)) {
                    command = (Command)command.clone();
                    PreOrPostOrderNavigator.doVisit(command, new MultiSourceElementReplacementVisitor(sourceName, metadata), true, false);
                    if (!RelationalNodeUtil.shouldExecute(command, false, true)) continue;
                }
                AccessNode instanceNode = (AccessNode)accessNode.clone();
                instanceNode.setMultiSource(false);
                instanceNode.setCommand(command);
                accessNodes.add(instanceNode);
                if (accessNodes.size() > 1 && command instanceof Insert) {
                    throw new AssertionError((Object)"Multi-source insert must target a single source.  Should have been caught in validation");
                }
                instanceNode.setConnectorBindingId(sourceName);
            }
        }
        if (hasOutParams && accessNodes.size() != 1) {
            throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30561, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30561, new Object[]{accessNode.getCommand()}));
        }
        switch (accessNodes.size()) {
            case 0: {
                if (RelationalNodeUtil.isUpdate(accessNode.getCommand())) {
                    ProjectNode pnode = new ProjectNode(accessNode.getID());
                    pnode.setSelectSymbols(Arrays.asList(new Constant(0)));
                    return pnode;
                }
                NullNode nullNode = new NullNode(accessNode.getID());
                return nullNode;
            }
            case 1: {
                return (RelationalNode)accessNodes.get(0);
            }
        }
        UnionAllNode unionNode = new UnionAllNode(accessNode.getID());
        unionNode.setElements(accessNode.getElements());
        for (AccessNode newNode : accessNodes) {
            unionNode.addChild(newNode);
        }
        RelationalNode parent = unionNode;
        if (RelationalNodeUtil.isUpdate(accessNode.getCommand())) {
            GroupingNode groupNode = new GroupingNode(accessNode.getID());
            AggregateSymbol sumCount = new AggregateSymbol("SUM", false, accessNode.getElements().get(0));
            groupNode.setElements(Arrays.asList(sumCount));
            groupNode.addChild(unionNode);
            ProjectNode projectNode = new ProjectNode(accessNode.getID());
            Function intSum = ResolverUtil.getConversion(sumCount, DataTypeManager.getDataTypeName(sumCount.getType()), "integer", false, metadata.getFunctionLibrary());
            List<Expression> outputElements = Arrays.asList(intSum);
            projectNode.setElements(outputElements);
            projectNode.setSelectSymbols(outputElements);
            projectNode.addChild(groupNode);
            parent = projectNode;
        }
        return parent;
    }

    public void setMultiSource(boolean ex) {
        this.multiSource = ex;
    }

    public void setSubPlans(Map<GroupSymbol, RelationalPlan> plans) {
        this.subPlans = plans;
    }

    public Map<GroupSymbol, RelationalPlan> getSubPlans() {
        return this.subPlans;
    }

    public Set<Object> getConformedTo() {
        return this.conformedTo;
    }

    public void setConformedTo(Set<Object> conformedTo) {
        this.conformedTo = conformedTo;
    }
}

