/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core;

import java.sql.SQLException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;

public class TeiidException
extends Exception {
    private static final long serialVersionUID = -3033427629587497938L;
    protected String code;
    private transient String originalType;

    public TeiidException() {
    }

    public TeiidException(String message) {
        super(message);
    }

    public TeiidException(BundleUtil.Event code, String message) {
        super(message);
        this.setCode(code.toString());
    }

    public TeiidException(BundleUtil.Event code, Throwable t, String message) {
        super(message, t);
        if (message != null && t != null && message.equals(t.getMessage())) {
            this.setCode(code, t);
        } else {
            this.setCode(code.toString());
        }
    }

    public TeiidException(BundleUtil.Event code, Throwable t) {
        super(t);
        this.setCode(code, t);
    }

    private void setCode(BundleUtil.Event code, Throwable t) {
        TeiidException te;
        String codeStr = code.toString();
        if (t instanceof TeiidException && (te = (TeiidException)t).getCode() != null) {
            codeStr = te.getCode();
        }
        this.setCode(codeStr);
    }

    public TeiidException(Throwable e) {
        this(e, e != null ? e.getMessage() : null);
    }

    public TeiidException(Throwable e, String message) {
        super(message, e);
        this.setCode(TeiidException.getCode(e));
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(String originalType) {
        this.originalType = originalType;
    }

    static String getCode(Throwable e) {
        if (e instanceof TeiidException) {
            return ((TeiidException)e).getCode();
        }
        if (e instanceof TeiidRuntimeException) {
            return ((TeiidRuntimeException)e).getCode();
        }
        if (e instanceof SQLException) {
            return ((SQLException)e).getSQLState();
        }
        return null;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            return this.code;
        }
        if (this.code == null || this.code.length() == 0 || message.startsWith(this.code)) {
            return message;
        }
        return this.code + " " + message;
    }
}

