/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.sql.Blob;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.function.TeiidFunction;

public class GeometryFunctionMethods {
    @TeiidFunction(name="st_astext", category="Geometry")
    public static ClobType asText(GeometryType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToClob(geometry);
    }

    @TeiidFunction(name="st_asbinary", category="Geometry")
    public static BlobType asBlob(GeometryType geometry) {
        Blob b = (Blob)geometry.getReference();
        return new BlobType(b);
    }

    @TeiidFunction(name="st_geomfrombinary", category="Geometry")
    public static GeometryType geoFromBlob(BlobType wkb) throws FunctionExecutionException {
        return GeometryUtils.geometryFromBlob(wkb);
    }

    @TeiidFunction(name="st_geomfromtext", category="Geometry")
    public static GeometryType geomFromText(ClobType wkt) throws FunctionExecutionException {
        return GeometryUtils.geometryFromClob(wkt);
    }

    @TeiidFunction(name="st_intersects", category="Geometry")
    public static Boolean intersects(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.intersects(geom1, geom2);
    }

    @TeiidFunction(name="st_contains", category="Geometry")
    public static Boolean contains(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.contains(geom1, geom2);
    }
}

