/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidException;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;

public final class TestFileUtils
extends TestCase {
    private static final String FILE_NAME = UnitTestUtil.getTestDataPath() + File.separator + "fakeScript.txt";
    private static final String TEMP_FILE_PREFFIX = "mmtmp";
    private static final String TEMP_DIR_NAME = "tempdir";
    File tempDir;
    public static final String TEMP_FILE = "delete.me";
    public static final String TEMP_FILE_RENAMED = "delete.me.old";
    private static final String TEMP_FILE_NAME = "tempfile.txt";
    private static final String TEMP_FILE_NAME2 = "tempfile2.txt";

    public TestFileUtils(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.tempDir = new File(TEMP_DIR_NAME);
        this.tempDir.mkdir();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        try {
            this.tempDir.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            new File(TEMP_FILE_NAME).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            new File(TEMP_FILE_NAME2).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWrite() throws Exception {
        File tmp = null;
        try {
            tmp = File.createTempFile(TEMP_FILE_PREFFIX, null);
            FileInputStream is = new FileInputStream(FILE_NAME);
            FileUtils.write((InputStream)is, (File)tmp);
            if (tmp == null || tmp.length() == 0L) {
                TestFileUtils.fail((String)"Content not written to new file");
            }
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteEmptyFile() throws Exception {
        File tmp = null;
        File emptyFile = null;
        try {
            tmp = File.createTempFile(TEMP_FILE_PREFFIX, null);
            emptyFile = File.createTempFile("EMPTY", null);
            FileInputStream is = new FileInputStream(emptyFile);
            FileUtils.write((InputStream)is, (File)tmp);
            if (tmp == null || tmp.length() > 0L) {
                TestFileUtils.fail((String)"content available; must be empty");
            }
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
            if (emptyFile != null) {
                emptyFile.delete();
            }
        }
    }

    public void testTestDirectoryPermissions() throws Exception {
        TestFileUtils.testDirectoryPermissions(TEMP_DIR_NAME);
        try {
            TestFileUtils.testDirectoryPermissions("fakeDir");
            TestFileUtils.fail((String)"Expected a MetaMatrixCoreException");
        }
        catch (TeiidException teiidException) {
            // empty catch block
        }
    }

    public void testCopy() throws Exception {
        String contents1 = ObjectConverterUtil.convertFileToString((File)new File(FILE_NAME));
        FileUtils.copy((String)FILE_NAME, (String)TEMP_FILE_NAME, (boolean)false);
        String contents2 = ObjectConverterUtil.convertFileToString((File)new File(TEMP_FILE_NAME));
        TestFileUtils.assertEquals((String)"Expected file contents to be the same", (String)contents1, (String)contents2);
        TestFileUtils.assertTrue((String)"Expected original file to still exist", (boolean)new File(FILE_NAME).exists());
        try {
            FileUtils.copy((String)FILE_NAME, (String)TEMP_FILE_NAME, (boolean)false);
            TestFileUtils.fail((String)"Expected MetaMatrixException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileUtils.copy((String)FILE_NAME, (String)TEMP_FILE_NAME, (boolean)true);
        contents2 = ObjectConverterUtil.convertFileToString((File)new File(TEMP_FILE_NAME));
        TestFileUtils.assertEquals((String)"Expected file contents to be the same", (String)contents1, (String)contents2);
        TestFileUtils.assertTrue((String)"Expected original file to still exist", (boolean)new File(FILE_NAME).exists());
    }

    public void testRename() throws Exception {
        String contents1 = ObjectConverterUtil.convertFileToString((File)new File(FILE_NAME));
        FileUtils.copy((String)FILE_NAME, (String)TEMP_FILE_NAME, (boolean)true);
        FileUtils.rename((String)TEMP_FILE_NAME, (String)TEMP_FILE_NAME2, (boolean)false);
        String contents2 = ObjectConverterUtil.convertFileToString((File)new File(TEMP_FILE_NAME2));
        TestFileUtils.assertEquals((String)"Expected file contents to be the same", (String)contents1, (String)contents2);
        TestFileUtils.assertFalse((String)"Expected original file to not exist", (boolean)new File(TEMP_FILE_NAME).exists());
        FileUtils.copy((String)FILE_NAME, (String)TEMP_FILE_NAME, (boolean)true);
        FileUtils.copy((String)FILE_NAME, (String)TEMP_FILE_NAME2, (boolean)true);
        try {
            FileUtils.rename((String)FILE_NAME, (String)TEMP_FILE_NAME2, (boolean)false);
            TestFileUtils.fail((String)"Expected MetaMatrixException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileUtils.copy((String)FILE_NAME, (String)TEMP_FILE_NAME, (boolean)true);
        FileUtils.copy((String)FILE_NAME, (String)TEMP_FILE_NAME2, (boolean)true);
        FileUtils.rename((String)TEMP_FILE_NAME, (String)TEMP_FILE_NAME2, (boolean)true);
        contents2 = ObjectConverterUtil.convertFileToString((File)new File(TEMP_FILE_NAME2));
        TestFileUtils.assertEquals((String)"Expected file contents to be the same", (String)contents1, (String)contents2);
        TestFileUtils.assertFalse((String)"Expected original file to not exist", (boolean)new File(TEMP_FILE_NAME).exists());
    }

    public void testRemove() throws Exception {
        FileUtils.copy((String)FILE_NAME, (String)TEMP_FILE_NAME, (boolean)true);
        FileUtils.remove((String)TEMP_FILE_NAME);
        TestFileUtils.assertFalse((String)"Expected File to not exist", (boolean)new File(TEMP_FILE_NAME).exists());
        FileUtils.remove((String)TEMP_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyRecursivelyNull() throws Exception {
        File fileSource = new File(TEMP_FILE_NAME);
        fileSource.delete();
        fileSource.createNewFile();
        try {
            FileUtils.copyDirectoriesRecursively((File)fileSource, (File)fileSource);
            TestFileUtils.fail((String)"File arg should have been illegal.");
        }
        catch (Exception exception) {
        }
        finally {
            fileSource.delete();
        }
    }

    public static void testDirectoryPermissions(String dirPath) throws TeiidException {
        File tmpFile = new File(dirPath + File.separatorChar + TEMP_FILE);
        boolean success = false;
        try {
            success = tmpFile.createNewFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!success) {
            throw new TeiidException("cannot create file in " + dirPath);
        }
        if (!tmpFile.canWrite()) {
            throw new TeiidException("cannot write " + dirPath);
        }
        if (!tmpFile.canRead()) {
            throw new TeiidException("cannot read " + dirPath);
        }
        File newFile = new File(dirPath + File.separatorChar + TEMP_FILE_RENAMED);
        success = false;
        try {
            success = tmpFile.renameTo(newFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!success) {
            throw new TeiidException("failed to rename " + dirPath);
        }
        success = false;
        try {
            success = newFile.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!success) {
            String msg = CorePlugin.Util.getString("FileUtils.Unable_to_delete_file_in", new Object[]{dirPath});
            throw new TeiidException(msg);
        }
    }
}

