/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.sql.Blob;
import java.sql.Clob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.XMLType;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.resolver.TestFunctionResolving;
import org.teiid.query.sql.symbol.Expression;

public class TestGeometry {
    @Test
    public void testRoundTrip() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))')");
        GeometryType geom = (GeometryType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((long)0L, (long)geom.getSrid());
        byte[] bytes = geom.getBytes(1L, (int)geom.length());
        Expression ex1 = TestFunctionResolving.getExpression("ST_GeomFromBinary(X'" + new BinaryType(bytes) + "', 8307)");
        GeometryType geom1 = (GeometryType)Evaluator.evaluate((Expression)ex1);
        Assert.assertEquals((long)8307L, (long)geom1.getSrid());
        Assert.assertEquals((Object)geom, (Object)geom1);
    }

    @Test
    public void testAsText() throws Exception {
        Expression ex2 = TestFunctionResolving.getExpression("st_astext(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Clob val = (Clob)Evaluator.evaluate((Expression)ex2);
        Assert.assertEquals((Object)"POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))", (Object)ClobType.getString((Clob)val));
    }

    @Test
    public void testAsBinary() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_asbinary(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Assert.assertTrue((boolean)(Evaluator.evaluate((Expression)ex) instanceof Blob));
    }

    @Test
    public void testContains() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("st_contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((43 0, 50 50, 0 50, 0 0, 43 0))'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void testIntersects() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_intersects(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("st_intersects(ST_GeomFromText('POLYGON ((100 100, 200 200, 75 75, 100 100))'), ST_GeomFromText('POLYGON ((43 0, 50 50, 0 50, 0 0, 43 0))'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void testAsGeoJson() throws Exception {
        this.assertEval("ST_AsGeoJson(ST_GeomFromText('POINT (-48.23456 20.12345)'))", "{\"coordinates\":[-48.23456,20.12345],\"type\":\"Point\"}");
        this.assertEval("ST_AsGeoJson(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))", "{\"coordinates\":[[[40.0,0.0],[50.0,50.0],[0.0,50.0],[0.0,0.0],[40.0,0.0]]],\"type\":\"Polygon\"}");
    }

    @Test
    public void testFromGeoJson() throws Exception {
        this.assertEval("ST_AsText(ST_GeomFromGeoJSON('{\"coordinates\":[-48.23456,20.12345],\"type\":\"Point\"}'))", "POINT (-48.23456 20.12345)");
        this.assertEval("ST_AsText(ST_GeomFromGeoJSON('{\"coordinates\":[[[40.0,0.0],[50.0,50.0],[0.0,50.0],[0.0,0.0],[40.0,0.0]]],\"type\":\"Polygon\"}'))", "POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))");
    }

    @Test
    public void testAsGml() throws Exception {
        this.assertEval("ST_AsGML(ST_GeomFromText('POINT (-48.23456 20.12345)'))", "<gml:Point>\n  <gml:coordinates>\n    -48.23456,20.12345 \n  </gml:coordinates>\n</gml:Point>\n");
        this.assertEval("ST_AsGML(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))", "<gml:Polygon>\n  <gml:outerBoundaryIs>\n    <gml:LinearRing>\n      <gml:coordinates>\n        40.0,0.0 50.0,50.0 0.0,50.0 0.0,0.0 40.0,0.0 \n      </gml:coordinates>\n    </gml:LinearRing>\n  </gml:outerBoundaryIs>\n</gml:Polygon>\n");
    }

    @Test
    public void testFromGml() throws Exception {
        this.assertEval("ST_AsText(ST_GeomFromGML('<gml:Point>\n  <gml:coordinates>\n    -48.23456,20.12345 \n  </gml:coordinates>\n</gml:Point>'))", "POINT (-48.23456 20.12345)");
        this.assertEval("ST_AsText(ST_GeomFromGML('<gml:Polygon>\n  <gml:outerBoundaryIs>\n    <gml:LinearRing>\n      <gml:coordinates>\n        40.0,0.0 50.0,50.0 0.0,50.0 0.0,0.0 40.0,0.0 \n      </gml:coordinates>\n    </gml:LinearRing>\n  </gml:outerBoundaryIs>\n</gml:Polygon>'))", "POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))");
    }

    private void assertEval(String expr, String result) throws Exception {
        Expression ex = TestFunctionResolving.getExpression(expr);
        Object val = Evaluator.evaluate((Expression)ex);
        String valStr = null;
        if (val instanceof Clob) {
            valStr = ClobType.getString((Clob)((Clob)val));
        } else if (val instanceof XMLType) {
            valStr = ((XMLType)val).getString();
        }
        Assert.assertEquals((Object)result, (Object)valStr);
    }
}

