/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.sql.Clob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.rowset.serial.SerialClob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.NestedTableJoinStrategy;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.TestValidator;

public class TestTextTable {
    @Test
    public void testCorrelatedTextTable() throws Exception {
        String sql = "select x.* from pm1.g1, texttable(e1 || ',' || e2 COLUMNS x string, y integer) x";
        List[] expected = new List[]{Arrays.asList("a", 0), Arrays.asList("a", 3), Arrays.asList("c", 1), Arrays.asList("b", 2), Arrays.asList("a", 0)};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableFixed() throws Exception {
        String sql = "select max(compkey), max(cdm_id), max(currency), max(\"start\"), max(maturity), max(amount), count(*) from texttable(? COLUMNS compkey string width 76, CDM_ID string width 14, CURRENCY string width 9, \"START\" string width 31, MATURITY string width 31, AMOUNT double width 21, RECORDSOURCE string width 13, SUMMIT_ID string width 15, RATE double width 20, SPREAD double width 20, DESK string width 14) x";
        List[] expected = new List[]{Arrays.asList("000369USD05/20/200405/20/2007", "000369", "USD", "12/18/2000", "12/19/2005", 6.7209685146E8, 52)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/cdm_dos.txt")));
    }

    @Test
    public void testTextTableFixedWin() throws Exception {
        String sql = "select max(compkey), max(cdm_id), max(currency), max(\"start\"), max(maturity), max(amount), count(*) from texttable(? COLUMNS compkey string width 76, CDM_ID string width 14, CURRENCY string width 9, \"START\" string width 31, MATURITY string width 31, AMOUNT double width 21, RECORDSOURCE string width 13, SUMMIT_ID string width 15, RATE double width 20, SPREAD double width 20, DESK string width 14) x";
        List[] expected = new List[]{Arrays.asList("000369USD05/20/200405/20/2007", "000369", "USD", "12/18/2000", "12/19/2005", 6.7209685146E8, 52)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/cdm_dos_win.txt")));
    }

    @Test
    public void testTextTableFixedPartial() throws Exception {
        String sql = "select max(length(compkey)) from texttable(? COLUMNS compkey string width 76) x";
        List[] expected = new List[]{Arrays.asList(30)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/cdm_dos.txt")));
    }

    @Test
    public void testNamedMultilineHeader() throws Exception {
        String sql = "SELECT * from texttable(? COLUMNS Col3Head string HEADER) x";
        List[] expected = new List[]{Arrays.asList("VAL2"), Arrays.asList("VAL4"), Arrays.asList("abc"), Arrays.asList("VAL9")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/test-file.txt.csv")));
    }

    @Test
    public void testNamedMultilineHeaderWithOrdinality() throws Exception {
        String sql = "SELECT * from texttable(? COLUMNS Col3Head string, y for ordinality HEADER) x";
        List[] expected = new List[]{Arrays.asList("VAL2", 1), Arrays.asList("VAL4", 2), Arrays.asList("abc", 3), Arrays.asList("VAL9", 4)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/test-file.txt.csv")));
    }

    @Test
    public void testHeaderWithSkip() throws Exception {
        String sql = "select count(*) from texttable(? COLUMNS PARTNAME string HEADER 3 SKIP 5) x";
        List[] expected = new List[]{Arrays.asList(21)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("text/TextParts_HeaderRow2.csv")));
    }

    @Test
    public void testEscape() throws Exception {
        String sql = "select * from texttable('a\\,b,c\\\na\na,b\\\\' COLUMNS c1 string, c2 string ESCAPE '\\') x";
        List[] expected = new List[]{Arrays.asList("a,b", "c\na"), Arrays.asList("a", "b\\")};
        TestTextTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testEscapeError() throws Exception {
        String sql = "select * from texttable('axq' COLUMNS c1 string ESCAPE 'x') x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testDelimiter() throws Exception {
        String sql = "select * from texttable('\na\\,b,c' COLUMNS c1 string, c2 string DELIMITER 'b') x";
        List[] expected = new List[]{Arrays.asList("a\\,", ",c")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testNoRowDelimiter() throws Exception {
        String sql = "select * from texttable('abcdef' COLUMNS c1 string width 1, c2 string width 1 no row delimiter) x";
        List[] expected = new List[]{Arrays.asList("a", "b"), Arrays.asList("c", "d"), Arrays.asList("e", "f")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testNoTrim() throws Exception {
        String sql = "select * from texttable('a b \nc  d' COLUMNS c1 string width 2, c2 string width 2 no trim) x";
        List[] expected = new List[]{Arrays.asList("a", "b "), Arrays.asList("c", " d")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testNoRows() throws Exception {
        String sql = "select * from texttable('' COLUMNS c1 string, c2 string SKIP 3) x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testMissingValues() throws Exception {
        String sql = "select * from texttable('a,b\nc' COLUMNS c1 string, c2 string) x";
        List[] expected = new List[]{Arrays.asList("a", "b"), Arrays.asList("c", null)};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testCarraigeReturn() throws Exception {
        String sql = "select * from texttable('a,b\r\nc,d\r\ne,f' COLUMNS c1 string, c2 string) x";
        List[] expected = new List[]{Arrays.asList("a", "b"), Arrays.asList("c", "d"), Arrays.asList("e", "f")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testQuote() throws Exception {
        String sql = "select * from texttable('  \" a\", \" \"\" \"' COLUMNS c1 string, c2 string) x";
        List[] expected = new List[]{Arrays.asList(" a", " \" ")};
        TestTextTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testUnclosedQuoteError() throws Exception {
        String sql = "select * from texttable('  \" a\", \" \"\"' COLUMNS c1 string, c2 string) x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testQuoteError() throws Exception {
        String sql = "select * from texttable('  \" a\", x\" \"\" \"' COLUMNS c1 string, c2 string) x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testHeaderError() throws Exception {
        String sql = "select * from texttable('notc1,notc2' COLUMNS c1 string, c2 string HEADER) x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableCriteria() throws Exception {
        String sql = "select x.* from texttable('a' || ',' || '1' COLUMNS x string, y integer) x where x.y = 1";
        List[] expected = new List[]{Arrays.asList("a", 1)};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableGroupBy() throws Exception {
        String sql = "select max(x) from texttable('a' || ',' || '1' COLUMNS x string, y integer) x group by y";
        List[] expected = new List[]{Arrays.asList("a")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableSubquery() throws Exception {
        String sql = "select x.* from pm1.g1, texttable(e1 || ',' || e2 COLUMNS x string, y integer) x where y < (select avg(e2) from pm1.g1 as x)";
        List[] expected = new List[]{Arrays.asList("a", 0), Arrays.asList("c", 1), Arrays.asList("a", 0)};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableMultiBatch() throws Exception {
        String sql = "select x.* from (select * from pm1.g1 where e1 = 'c') y, texttable(e1 || '\n' || e2 || '\n' || e3 COLUMNS x string) x";
        List[] expected = new List[]{Arrays.asList("c"), Arrays.asList("1"), Arrays.asList("true")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableJoin() throws Exception {
        String sql = "select z.* from (select x.* from (select * from pm1.g1 where e1 = 'c') y, texttable(e1 || '\n' || e2 || '\n' || e3 COLUMNS x string) x) as z, (select x.* from (select * from pm1.g1 where e1 = 'c') y, texttable(e1 || '\n' || e2 || '\n' || e3 COLUMNS x string) x) as z1 where z.x = z1.x";
        List[] expected = new List[]{Arrays.asList("c"), Arrays.asList("1"), Arrays.asList("true")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        RelationalPlan plan = (RelationalPlan)TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        JoinNode join = (JoinNode)plan.getRootNode().getChildren()[0];
        Assert.assertTrue((!(join.getJoinStrategy() instanceof NestedTableJoinStrategy) ? 1 : 0) != 0);
        TestProcessor.helpProcess((ProcessorPlan)plan, TestProcessor.createCommandContext(), dataManager, expected);
    }

    @Test
    public void testTextTableJoinPrefetch() throws Exception {
        String sql = "select z.* from (select x.* from (select * from pm1.g1 where e1 = 'c') y, texttable(e1 || '\n' || e2 || '\n' || e3 COLUMNS x string) x) as z";
        List[] expected = new List[]{Arrays.asList("c"), Arrays.asList("1"), Arrays.asList("true")};
        FakeDataManager dataManager = new FakeDataManager();
        dataManager.setBlockOnce();
        TestProcessor.sampleData1(dataManager);
        RelationalPlan plan = (RelationalPlan)TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess((ProcessorPlan)plan, TestProcessor.createCommandContext(), dataManager, expected);
    }

    @Test
    public void testTextTableJoin1() throws Exception {
        String sql = "select e1, e2 from texttable('a' COLUMNS col string) x, pm1.g1 where col = e1";
        List[] expected = new List[]{Arrays.asList("a", 0), Arrays.asList("a", 3), Arrays.asList("a", 0)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        RelationalPlan plan = (RelationalPlan)TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess((ProcessorPlan)plan, TestProcessor.createCommandContext(), dataManager, expected);
    }

    @Test
    public void testTextTableSelector() throws Exception {
        String sql = "select x.* from (select * from pm1.g1) y, texttable(e1 || '\n' || e2 || '\n' || e3 SELECTOR 'c' COLUMNS x string) x";
        List[] expected = new List[]{Arrays.asList("c")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableSelector1() throws Exception {
        String sql = "select x.* from texttable('cc,bb' SELECTOR 'c' COLUMNS x string) x";
        List[] expected = new List[]{};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableSelector2() throws Exception {
        String sql = "select x.* from texttable('A,10-dec-2011,12345,3322,3000,222\nB,1,123,Sprockets Black,30,50,1500\nB,2,333,Sprockets Blue,300,5,1500' SELECTOR 'B' COLUMNS x string, y integer, z string SELECTOR 'A' 2) x";
        List[] expected = new List[]{Arrays.asList("B", 1, "10-dec-2011"), Arrays.asList("B", 2, "10-dec-2011")};
        TestTextTable.process(sql, expected);
    }

    @Test
    public void testTextTableSelectorFixedWidth() throws Exception {
        String sql = "select x.* from texttable('A10-dec-20111234533223000222\nB112330501500\nB233330051500\nCX' SELECTOR 'B' COLUMNS x string width 1, y integer width 6, z integer width 6) x";
        List[] expected = new List[]{Arrays.asList("B", 112330, 501500), Arrays.asList("B", 233330, 51500)};
        TestTextTable.process(sql, expected);
    }

    public static void process(String sql, List<?>[] expectedResults) throws Exception {
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, TestProcessor.createCommandContext(), dataManager, expectedResults);
    }

    public static ClobType clobFromFile(String file) {
        return new ClobType((Clob)new ClobImpl((InputStreamFactory)new InputStreamFactory.FileInputStreamFactory(UnitTestUtil.getTestDataFile((String)file)), -1L));
    }

    @Test
    public void testTextAgg() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select convert(to_chars(textagg(for pm1.g1.e1, pm1.g1.e2 header order by e2), 'UTF-8'), string) as x from pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0", Arrays.asList("z", 2), Arrays.asList("b", 1));
        hdm.setBlockOnce(true);
        String nl = System.getProperty("line.separator");
        ArrayList<String> list = new ArrayList<String>();
        list.add("\"e1\",\"e2\"" + nl + "\"b\",\"1\"" + nl + "\"z\",\"2\"" + nl);
        List[] expected = new List[]{list};
        TestProcessor.helpProcess(plan, hdm, expected);
    }

    @Test
    public void testTextAggOrderByUnrelated() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select convert(to_chars(textagg(for pm1.g1.e1 header order by e2), 'UTF-8'), string) as x from pm1.g1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0", Arrays.asList("z", 2), Arrays.asList("b", 1));
        hdm.setBlockOnce(true);
        String nl = System.getProperty("line.separator");
        ArrayList<String> list = new ArrayList<String>();
        list.add("\"e1\"" + nl + "\"b\"" + nl + "\"z\"" + nl);
        List[] expected = new List[]{list};
        TestProcessor.helpProcess(plan, hdm, expected);
    }

    @Test
    public void testTextAggGroupBy() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select convert(to_chars(textagg(pm1.g1.e1), 'UTF-8'), string) as x from pm1.g1 group by e2", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e2, g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT g_0.e2, g_0.e1 FROM pm1.g1 AS g_0", Arrays.asList(2, "z"), Arrays.asList(1, "b"), Arrays.asList(2, "z"), Arrays.asList(1, "b"), Arrays.asList(2, "c"), Arrays.asList(2, "a"));
        hdm.setBlockOnce(true);
        String nl = System.getProperty("line.separator");
        ArrayList<String> list = new ArrayList<String>();
        list.add("\"b\"" + nl + "\"b\"" + nl);
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("\"a\"" + nl + "\"z\"" + nl + "\"c\"" + nl + "\"z\"" + nl);
        List[] expected = new List[]{list, list1};
        CommandContext context = TestProcessor.createCommandContext();
        context.setBufferManager((BufferManager)BufferManagerFactory.getTestBufferManager(0L, 2));
        TestProcessor.helpProcess(plan, context, hdm, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testTextTableInvalidData() throws Exception {
        String sql = "select count(*) from texttable(? COLUMNS PARTNAME string) x";
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        char[] data = new char[5000];
        TestProcessor.processPreparedStatement(sql, null, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(new ClobType((Clob)new SerialClob(data))));
    }

    @Test
    public void testTextTableInvalidData1() throws Exception {
        String sql = "select * from texttable(to_chars(X'610D810D', 'ascii') COLUMNS PARTNAME string) x";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[0]);
        try {
            TestProcessor.helpProcess(plan, TestProcessor.createCommandContext(), new HardcodedDataManager(), new List[]{Arrays.asList("a")});
            Assert.fail();
        }
        catch (TeiidProcessingException e) {
            Assert.assertEquals((Object)"TEIID10082 Error converting byte stream to characters using the US-ASCII charset at byte 3.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testTextTableFixedBestEffort() throws Exception {
        String sql = "select x.* from texttable('abc\nde\nfghi\n' COLUMNS x string width 1, y string width 1, z string width 1) x";
        List[] expected = new List[]{Arrays.asList("a", "b", "c"), Arrays.asList("d", "e", null), Arrays.asList("f", "g", "h")};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNoTrimDelimited() throws Exception {
        String sql = "select x.* from texttable('x, y\n a , \"b\"' COLUMNS x string, \" y\" string HEADER NO TRIM) x";
        List[] expected = new List[]{Arrays.asList(" a ", "b")};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        Command cmd = TestProcessor.helpParse(sql);
        Assert.assertEquals((Object)"SELECT x.* FROM TEXTTABLE('x, y\n a , \"b\"' COLUMNS x string, \" y\" string HEADER NO TRIM) AS x", (Object)cmd.toString());
        ProcessorPlan plan = TestProcessor.helpGetPlan(cmd, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testRowDelimiter() throws Exception {
        String sql = "select x.* from texttable('x-1, y\n a -2, \"b\"-3' COLUMNS x string, \"1\" string ROW DELIMITER ',' DELIMITER '-' HEADER) x";
        List[] expected = new List[]{Arrays.asList("y\n a", "2"), Arrays.asList("b", "3")};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        Command cmd = TestProcessor.helpParse(sql);
        Assert.assertEquals((Object)"SELECT x.* FROM TEXTTABLE('x-1, y\n a -2, \"b\"-3' COLUMNS x string, \"1\" string ROW DELIMITER ',' DELIMITER '-' HEADER) AS x", (Object)cmd.toString());
        ProcessorPlan plan = TestProcessor.helpGetPlan(cmd, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testRowDelimiterValidation() throws Exception {
        String sql = "select x.* from texttable('x' COLUMNS x string ROW DELIMITER '-' DELIMITER '-' HEADER) x";
        TestValidator.helpValidate(sql, new String[]{"TEXTTABLE('x' COLUMNS x string ROW DELIMITER '-' DELIMITER '-' HEADER) AS x"}, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }
}

