/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.util.Arrays;
import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.function.aggregate.SingleArgumentAggregateFunction;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.util.CommandContext;

public class StatsFunction
extends SingleArgumentAggregateFunction {
    private double sum = 0.0;
    private double sumSq = 0.0;
    private int count = 0;
    private AggregateSymbol.Type type;

    public StatsFunction(AggregateSymbol.Type function) {
        this.type = function;
    }

    @Override
    public void reset() {
        this.sum = 0.0;
        this.sumSq = 0.0;
        this.count = 0;
    }

    @Override
    public void addInputDirect(Object input, List<?> tuple, CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        this.sum += ((Number)input).doubleValue();
        this.sumSq += Math.pow(((Number)input).doubleValue(), 2.0);
        ++this.count;
    }

    @Override
    public Object getResult(CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        double result = 0.0;
        switch (this.type) {
            case STDDEV_POP: 
            case VAR_POP: {
                if (this.count == 0) {
                    return null;
                }
                result = (this.sumSq - this.sum * this.sum / (double)this.count) / (double)this.count;
                if (this.type != AggregateSymbol.Type.STDDEV_POP) break;
                result = Math.sqrt(result);
                break;
            }
            case STDDEV_SAMP: 
            case VAR_SAMP: {
                if (this.count < 2) {
                    return null;
                }
                result = (this.sumSq - this.sum * this.sum / (double)this.count) / (double)(this.count - 1);
                if (this.type != AggregateSymbol.Type.STDDEV_SAMP) break;
                result = Math.sqrt(result);
            }
        }
        return result;
    }

    @Override
    public void getState(List<Object> state) {
        state.add(this.count);
        state.add(this.sum);
        state.add(this.sumSq);
    }

    @Override
    public List<? extends Class<?>> getStateTypes() {
        return Arrays.asList(Integer.class, Double.class, Double.class);
    }

    @Override
    public int setState(List<?> state, int index) {
        this.count = (Integer)state.get(index++);
        this.sum = (Double)state.get(index++);
        this.sumSq = (Double)state.get(index++);
        return index;
    }
}

