/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.NullType;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.AnyToObjectTransform;
import org.teiid.core.types.basic.AnyToStringTransform;
import org.teiid.core.types.basic.BigDecimalToBigIntegerTransform;
import org.teiid.core.types.basic.BigIntegerToBigDecimalTransform;
import org.teiid.core.types.basic.BinaryToBlobTransform;
import org.teiid.core.types.basic.BlobToBinaryTransform;
import org.teiid.core.types.basic.BooleanToNumberTransform;
import org.teiid.core.types.basic.ClobToStringTransform;
import org.teiid.core.types.basic.DateToTimestampTransform;
import org.teiid.core.types.basic.FixedNumberToBigDecimalTransform;
import org.teiid.core.types.basic.FixedNumberToBigIntegerTransform;
import org.teiid.core.types.basic.FloatingNumberToBigDecimalTransform;
import org.teiid.core.types.basic.FloatingNumberToBigIntegerTransform;
import org.teiid.core.types.basic.NullToAnyTransform;
import org.teiid.core.types.basic.NumberToBooleanTransform;
import org.teiid.core.types.basic.NumberToByteTransform;
import org.teiid.core.types.basic.NumberToDoubleTransform;
import org.teiid.core.types.basic.NumberToFloatTransform;
import org.teiid.core.types.basic.NumberToIntegerTransform;
import org.teiid.core.types.basic.NumberToLongTransform;
import org.teiid.core.types.basic.NumberToShortTransform;
import org.teiid.core.types.basic.ObjectToAnyTransform;
import org.teiid.core.types.basic.SQLXMLToStringTransform;
import org.teiid.core.types.basic.StringToBigDecimalTransform;
import org.teiid.core.types.basic.StringToBigIntegerTransform;
import org.teiid.core.types.basic.StringToBooleanTransform;
import org.teiid.core.types.basic.StringToByteTransform;
import org.teiid.core.types.basic.StringToCharacterTransform;
import org.teiid.core.types.basic.StringToClobTransform;
import org.teiid.core.types.basic.StringToDateTransform;
import org.teiid.core.types.basic.StringToDoubleTransform;
import org.teiid.core.types.basic.StringToFloatTransform;
import org.teiid.core.types.basic.StringToIntegerTransform;
import org.teiid.core.types.basic.StringToLongTransform;
import org.teiid.core.types.basic.StringToSQLXMLTransform;
import org.teiid.core.types.basic.StringToShortTransform;
import org.teiid.core.types.basic.StringToTimeTransform;
import org.teiid.core.types.basic.StringToTimestampTransform;
import org.teiid.core.types.basic.TimeToTimestampTransform;
import org.teiid.core.types.basic.TimestampToDateTransform;
import org.teiid.core.types.basic.TimestampToTimeTransform;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.PropertiesUtils;

public class DataTypeManager {
    static final String ARRAY_SUFFIX = "[]";
    public static final boolean USE_VALUE_CACHE = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.useValueCache", false);
    private static final boolean COMPARABLE_LOBS = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.comparableLobs", false);
    private static final boolean COMPARABLE_OBJECT = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.comparableObject", false);
    public static final boolean PAD_SPACE = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.padSpace", false);
    public static final String COLLATION_LOCALE = System.getProperties().getProperty("org.teiid.collationLocale");
    private static boolean valueCacheEnabled = USE_VALUE_CACHE;
    private static Map<Class<?>, ValueCache<?>> valueMaps = new HashMap(128);
    private static HashedValueCache<String> stringCache = new WeakReferenceHashedValueCache<String>(17){

        @Override
        protected int primaryHash(String value) {
            if (value.length() < 14) {
                return value.hashCode();
            }
            return HashCodeUtil.expHashCode(value);
        }
    };
    public static final int MAX_STRING_LENGTH = PropertiesUtils.getIntProperty(System.getProperties(), "org.teiid.maxStringLength", 4000);
    public static final int MAX_LOB_MEMORY_BYTES = Math.max(DataTypeManager.nextPowOf2(2 * MAX_STRING_LENGTH), 8192);
    public static int MAX_TYPE_CODE = 20;
    private static final Map<Class<?>, Integer> typeMap = new LinkedHashMap(64);
    private static final List<Class<?>> typeList;
    private static Map<String, Map<String, Transform>> transforms;
    private static Map<String, Class<?>> dataTypeNames;
    private static Map<Class<?>, String> dataTypeClasses;
    private static Map<Class<?>, Class<?>> arrayTypes;
    private static Map<Class<?>, String> arrayTypeNames;
    private static Set<String> DATA_TYPE_NAMES;
    private static Set<Class<?>> DATA_TYPE_CLASSES;

    public static int nextPowOf2(int val) {
        int result;
        for (result = 1; result < val; result <<= 1) {
        }
        return result;
    }

    public static int getTypeCode(Class<?> source) {
        Integer result = typeMap.get(source);
        if (result == null) {
            return 14;
        }
        return result;
    }

    public static Class<?> getClass(int code) {
        Class<?> result = typeList.get(code);
        if (result == null) {
            return DefaultDataClasses.OBJECT;
        }
        return result;
    }

    private static Transform getTransformFromMaps(String srcType, String targetType) {
        Map<String, Transform> innerMap = transforms.get(srcType);
        boolean found = false;
        if (innerMap != null) {
            Transform result = innerMap.get(targetType);
            if (result != null) {
                return result;
            }
            found = true;
        }
        if (srcType.equals(targetType)) {
            return null;
        }
        if ("object".equals(targetType)) {
            return AnyToObjectTransform.INSTANCE;
        }
        if (srcType.equals("null")) {
            return NullToAnyTransform.INSTANCE;
        }
        if (srcType.equals("object")) {
            return ObjectToAnyTransform.INSTANCE;
        }
        if (found) {
            return null;
        }
        int sourceDims = 0;
        while (DataTypeManager.isArrayType(srcType)) {
            srcType = srcType.substring(0, srcType.length() - 2);
            ++sourceDims;
        }
        int targetDims = 0;
        while (DataTypeManager.isArrayType(targetType)) {
            targetType = targetType.substring(0, targetType.length() - 2);
            ++targetDims;
        }
        if ("object".equals(targetType) && targetDims <= sourceDims) {
            return AnyToObjectTransform.INSTANCE;
        }
        if ("object".equals(srcType) && targetDims >= sourceDims) {
            return ObjectToAnyTransform.INSTANCE;
        }
        return null;
    }

    private DataTypeManager() {
    }

    static void addDataType(String typeName, Class<?> dataType) {
        dataTypeNames.put(typeName, dataType);
        dataTypeClasses.put(dataType, typeName);
    }

    public static Set<String> getAllDataTypeNames() {
        return DATA_TYPE_NAMES;
    }

    public static Set<Class<?>> getAllDataTypeClasses() {
        return DATA_TYPE_CLASSES;
    }

    public static Class<?> getDataTypeClass(String name) {
        if (name == null) {
            return DefaultDataClasses.NULL;
        }
        Class<Object> dataTypeClass = dataTypeNames.get(name);
        if (dataTypeClass == null) {
            dataTypeClass = dataTypeNames.get(name.toLowerCase());
        }
        if (dataTypeClass == null) {
            if (DataTypeManager.isArrayType(name)) {
                return DataTypeManager.getArrayType(DataTypeManager.getDataTypeClass(name.substring(0, name.length() - 2)));
            }
            dataTypeClass = DefaultDataClasses.OBJECT;
        }
        return dataTypeClass;
    }

    public static boolean isArrayType(String name) {
        return name.endsWith(ARRAY_SUFFIX);
    }

    public static String getDataTypeName(Class<?> typeClass) {
        if (typeClass == null) {
            return "null";
        }
        String result = dataTypeClasses.get(typeClass);
        if (result == null) {
            if (typeClass.isArray() && !typeClass.getComponentType().isPrimitive()) {
                result = arrayTypeNames.get(typeClass);
                if (result == null) {
                    return DataTypeManager.getDataTypeName(typeClass.getComponentType()) + ARRAY_SUFFIX;
                }
                return result;
            }
            result = "object";
        }
        return result;
    }

    public static Class<?> determineDataTypeClass(Object value) {
        if (value == null) {
            return DefaultDataClasses.NULL;
        }
        Class<?> clazz = value.getClass();
        if (DATA_TYPE_CLASSES.contains(clazz)) {
            return clazz;
        }
        clazz = DataTypeManager.convertToRuntimeType(value, true).getClass();
        if (DATA_TYPE_CLASSES.contains(clazz)) {
            return clazz;
        }
        return DefaultDataClasses.OBJECT;
    }

    public static Transform getTransform(Class<?> sourceType, Class<?> targetType) {
        if (sourceType == null || targetType == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ERR.003.029.0002", sourceType, targetType));
        }
        return DataTypeManager.getTransformFromMaps(DataTypeManager.getDataTypeName(sourceType), DataTypeManager.getDataTypeName(targetType));
    }

    public static Transform getTransform(String sourceTypeName, String targetTypeName) {
        if (sourceTypeName == null || targetTypeName == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ERR.003.029.0003", sourceTypeName, targetTypeName));
        }
        return DataTypeManager.getTransformFromMaps(sourceTypeName, targetTypeName);
    }

    public static boolean isTransformable(Class<?> sourceType, Class<?> targetType) {
        return DataTypeManager.getTransform(sourceType, targetType) != null;
    }

    public static boolean isTransformable(String sourceTypeName, String targetTypeName) {
        if (sourceTypeName == null || targetTypeName == null) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("ERR.003.029.0003", sourceTypeName, targetTypeName));
        }
        return DataTypeManager.getTransformFromMaps(sourceTypeName, targetTypeName) != null;
    }

    static void addTransform(Transform transform) {
        ArgCheck.isNotNull(transform);
        String sourceName = transform.getSourceTypeName();
        String targetName = transform.getTargetTypeName();
        Map<String, Transform> innerMap = transforms.get(sourceName);
        if (innerMap == null) {
            innerMap = new LinkedHashMap<String, Transform>();
            transforms.put(sourceName, innerMap);
        }
        innerMap.put(targetName, transform);
    }

    public static void getImplicitConversions(String type, Collection<String> result) {
        Map<String, Transform> innerMap = transforms.get(type);
        if (innerMap != null) {
            for (Map.Entry<String, Transform> entry : innerMap.entrySet()) {
                if (entry.getValue().isExplicit()) continue;
                result.add(entry.getKey());
            }
            result.add("object");
            return;
        }
        String previous = "object";
        result.add(previous);
        while (DataTypeManager.isArrayType(type)) {
            previous = previous + ARRAY_SUFFIX;
            result.add(previous);
            type = DataTypeManager.getComponentType(type);
        }
    }

    public static boolean isImplicitConversion(String srcType, String tgtType) {
        Transform t = DataTypeManager.getTransform(srcType, tgtType);
        if (t != null) {
            return !t.isExplicit();
        }
        if ("null".equals(srcType) && !"null".equals(tgtType)) {
            return true;
        }
        if ("object".equals(tgtType) && !"object".equals(srcType)) {
            return true;
        }
        if (DataTypeManager.isArrayType(srcType) && DataTypeManager.isArrayType(tgtType)) {
            return DataTypeManager.isImplicitConversion(DataTypeManager.getComponentType(srcType), DataTypeManager.getComponentType(tgtType));
        }
        return false;
    }

    public static String getComponentType(String srcType) {
        return srcType.substring(0, srcType.length() - ARRAY_SUFFIX.length());
    }

    public static boolean isExplicitConversion(String srcType, String tgtType) {
        Transform t = DataTypeManager.getTransform(srcType, tgtType);
        if (t != null) {
            return t.isExplicit();
        }
        return false;
    }

    public static boolean isLOB(Class<?> type) {
        return DefaultDataClasses.BLOB.equals(type) || DefaultDataClasses.CLOB.equals(type) || DefaultDataClasses.XML.equals(type) || DefaultDataClasses.GEOMETRY.equals(type);
    }

    public static boolean isLOB(String type) {
        return "blob".equals(type) || "clob".equals(type) || "xml".equals(type) || "geometry".equals(type);
    }

    static void loadDataTypes() {
        DataTypeManager.addDataType("boolean", DefaultDataClasses.BOOLEAN);
        DataTypeManager.addDataType("byte", DefaultDataClasses.BYTE);
        DataTypeManager.addDataType("short", DefaultDataClasses.SHORT);
        DataTypeManager.addDataType("char", DefaultDataClasses.CHAR);
        DataTypeManager.addDataType("integer", DefaultDataClasses.INTEGER);
        DataTypeManager.addDataType("long", DefaultDataClasses.LONG);
        DataTypeManager.addDataType("biginteger", DefaultDataClasses.BIG_INTEGER);
        DataTypeManager.addDataType("float", DefaultDataClasses.FLOAT);
        DataTypeManager.addDataType("double", DefaultDataClasses.DOUBLE);
        DataTypeManager.addDataType("bigdecimal", DefaultDataClasses.BIG_DECIMAL);
        DataTypeManager.addDataType("date", DefaultDataClasses.DATE);
        DataTypeManager.addDataType("time", DefaultDataClasses.TIME);
        DataTypeManager.addDataType("timestamp", DefaultDataClasses.TIMESTAMP);
        DataTypeManager.addDataType("string", DefaultDataClasses.STRING);
        DataTypeManager.addDataType("clob", DefaultDataClasses.CLOB);
        DataTypeManager.addDataType("xml", DefaultDataClasses.XML);
        DataTypeManager.addDataType("object", DefaultDataClasses.OBJECT);
        DataTypeManager.addDataType("null", DefaultDataClasses.NULL);
        DataTypeManager.addDataType("blob", DefaultDataClasses.BLOB);
        DataTypeManager.addDataType("varbinary", DefaultDataClasses.VARBINARY);
        DataTypeManager.addDataType("geometry", DefaultDataClasses.GEOMETRY);
        DATA_TYPE_NAMES = Collections.unmodifiableSet(new LinkedHashSet<String>(dataTypeNames.keySet()));
        dataTypeNames.put("bigint", DefaultDataClasses.LONG);
        dataTypeNames.put("decimal", DefaultDataClasses.BIG_DECIMAL);
        dataTypeNames.put("real", DefaultDataClasses.FLOAT);
        dataTypeNames.put("smallint", DefaultDataClasses.SHORT);
        dataTypeNames.put("tinyint", DefaultDataClasses.BYTE);
        dataTypeNames.put("varchar", DefaultDataClasses.STRING);
        valueMaps.put(DefaultDataClasses.BOOLEAN, new ValueCache<Boolean>(){

            @Override
            public Boolean getValue(Boolean value) {
                return (boolean)value;
            }
        });
        valueMaps.put(DefaultDataClasses.BYTE, new ValueCache<Byte>(){

            @Override
            public Byte getValue(Byte value) {
                return (byte)value;
            }
        });
        if (USE_VALUE_CACHE) {
            valueMaps.put(DefaultDataClasses.SHORT, new HashedValueCache(13));
            valueMaps.put(DefaultDataClasses.CHAR, new HashedValueCache(13));
            valueMaps.put(DefaultDataClasses.INTEGER, new HashedValueCache(14));
            valueMaps.put(DefaultDataClasses.LONG, new HashedValueCache(14));
            valueMaps.put(DefaultDataClasses.BIG_INTEGER, new HashedValueCache(15));
            valueMaps.put(DefaultDataClasses.FLOAT, new HashedValueCache(14));
            valueMaps.put(DefaultDataClasses.DOUBLE, new HashedValueCache(14));
            valueMaps.put(DefaultDataClasses.DATE, new HashedValueCache(14));
            valueMaps.put(DefaultDataClasses.TIME, new HashedValueCache(14));
            valueMaps.put(DefaultDataClasses.TIMESTAMP, new HashedValueCache(14));
            valueMaps.put(DefaultDataClasses.BIG_DECIMAL, new WeakReferenceHashedValueCache(17));
            valueMaps.put(DefaultDataClasses.STRING, stringCache);
            valueMaps.put(DefaultDataClasses.VARBINARY, new WeakReferenceHashedValueCache(17));
        }
    }

    static void loadBasicTransforms() {
        DataTypeManager.addTransform(new BooleanToNumberTransform((byte)1, (byte)0));
        DataTypeManager.addTransform(new BooleanToNumberTransform((short)1, (short)0));
        DataTypeManager.addTransform(new BooleanToNumberTransform(1, 0));
        DataTypeManager.addTransform(new BooleanToNumberTransform(1L, 0L));
        DataTypeManager.addTransform(new BooleanToNumberTransform(BigInteger.valueOf(1L), BigInteger.valueOf(0L)));
        DataTypeManager.addTransform(new BooleanToNumberTransform(Float.valueOf(1.0f), Float.valueOf(0.0f)));
        DataTypeManager.addTransform(new BooleanToNumberTransform(1.0, 0.0));
        DataTypeManager.addTransform(new BooleanToNumberTransform(BigDecimal.valueOf(1L), BigDecimal.valueOf(0L)));
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.BOOLEAN));
        DataTypeManager.addTransform(new NumberToBooleanTransform(Byte.valueOf((byte)0)));
        DataTypeManager.addTransform(new NumberToShortTransform(DefaultDataClasses.BYTE, false));
        DataTypeManager.addTransform(new NumberToIntegerTransform(DefaultDataClasses.BYTE, false));
        DataTypeManager.addTransform(new NumberToLongTransform(DefaultDataClasses.BYTE, false, false));
        DataTypeManager.addTransform(new FixedNumberToBigIntegerTransform(DefaultDataClasses.BYTE));
        DataTypeManager.addTransform(new NumberToFloatTransform(DefaultDataClasses.BYTE, false, false));
        DataTypeManager.addTransform(new NumberToDoubleTransform(DefaultDataClasses.BYTE, false, false));
        DataTypeManager.addTransform(new FixedNumberToBigDecimalTransform(DefaultDataClasses.BYTE));
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.BYTE));
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.CHAR));
        DataTypeManager.addTransform(new NumberToBooleanTransform(Short.valueOf((short)0)));
        DataTypeManager.addTransform(new NumberToByteTransform(DefaultDataClasses.SHORT));
        DataTypeManager.addTransform(new NumberToIntegerTransform(DefaultDataClasses.SHORT, false));
        DataTypeManager.addTransform(new NumberToLongTransform(DefaultDataClasses.SHORT, false, false));
        DataTypeManager.addTransform(new FixedNumberToBigIntegerTransform(DefaultDataClasses.SHORT));
        DataTypeManager.addTransform(new NumberToFloatTransform(DefaultDataClasses.SHORT, false, false));
        DataTypeManager.addTransform(new NumberToDoubleTransform(DefaultDataClasses.SHORT, false, false));
        DataTypeManager.addTransform(new FixedNumberToBigDecimalTransform(DefaultDataClasses.SHORT));
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.SHORT));
        DataTypeManager.addTransform(new NumberToBooleanTransform(Integer.valueOf(0)));
        DataTypeManager.addTransform(new NumberToByteTransform(DefaultDataClasses.INTEGER));
        DataTypeManager.addTransform(new NumberToShortTransform(DefaultDataClasses.INTEGER, true));
        DataTypeManager.addTransform(new NumberToLongTransform(DefaultDataClasses.INTEGER, false, false));
        DataTypeManager.addTransform(new FixedNumberToBigIntegerTransform(DefaultDataClasses.INTEGER));
        DataTypeManager.addTransform(new NumberToFloatTransform(DefaultDataClasses.INTEGER, false, true));
        DataTypeManager.addTransform(new NumberToDoubleTransform(DefaultDataClasses.INTEGER, false, false));
        DataTypeManager.addTransform(new FixedNumberToBigDecimalTransform(DefaultDataClasses.INTEGER));
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.INTEGER));
        DataTypeManager.addTransform(new NumberToBooleanTransform(Long.valueOf(0L)));
        DataTypeManager.addTransform(new NumberToByteTransform(DefaultDataClasses.LONG));
        DataTypeManager.addTransform(new NumberToShortTransform(DefaultDataClasses.LONG, true));
        DataTypeManager.addTransform(new NumberToIntegerTransform(DefaultDataClasses.LONG, true));
        DataTypeManager.addTransform(new FixedNumberToBigIntegerTransform(DefaultDataClasses.LONG));
        DataTypeManager.addTransform(new NumberToFloatTransform(DefaultDataClasses.LONG, false, true));
        DataTypeManager.addTransform(new NumberToDoubleTransform(DefaultDataClasses.LONG, false, true));
        DataTypeManager.addTransform(new FixedNumberToBigDecimalTransform(DefaultDataClasses.LONG));
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.LONG));
        DataTypeManager.addTransform(new NumberToBooleanTransform(BigInteger.valueOf(0L)));
        DataTypeManager.addTransform(new NumberToByteTransform(DefaultDataClasses.BIG_INTEGER));
        DataTypeManager.addTransform(new NumberToShortTransform(DefaultDataClasses.BIG_INTEGER, true));
        DataTypeManager.addTransform(new NumberToIntegerTransform(DefaultDataClasses.BIG_INTEGER, true));
        DataTypeManager.addTransform(new NumberToLongTransform(DefaultDataClasses.BIG_INTEGER, true, false));
        DataTypeManager.addTransform(new NumberToFloatTransform(DefaultDataClasses.BIG_INTEGER, true, false));
        DataTypeManager.addTransform(new NumberToDoubleTransform(DefaultDataClasses.BIG_INTEGER, true, false));
        DataTypeManager.addTransform(new BigIntegerToBigDecimalTransform());
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.BIG_INTEGER));
        DataTypeManager.addTransform(new NumberToBooleanTransform(BigDecimal.valueOf(0L)));
        DataTypeManager.addTransform(new NumberToByteTransform(DefaultDataClasses.BIG_DECIMAL));
        DataTypeManager.addTransform(new NumberToShortTransform(DefaultDataClasses.BIG_DECIMAL, true));
        DataTypeManager.addTransform(new NumberToIntegerTransform(DefaultDataClasses.BIG_DECIMAL, true));
        DataTypeManager.addTransform(new NumberToLongTransform(DefaultDataClasses.BIG_DECIMAL, true, false));
        DataTypeManager.addTransform(new BigDecimalToBigIntegerTransform());
        DataTypeManager.addTransform(new NumberToFloatTransform(DefaultDataClasses.BIG_DECIMAL, true, false));
        DataTypeManager.addTransform(new NumberToDoubleTransform(DefaultDataClasses.BIG_DECIMAL, true, false));
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.BIG_DECIMAL));
        DataTypeManager.addTransform(new NumberToBooleanTransform(Float.valueOf(0.0f)));
        DataTypeManager.addTransform(new NumberToByteTransform(DefaultDataClasses.FLOAT));
        DataTypeManager.addTransform(new NumberToShortTransform(DefaultDataClasses.FLOAT, true));
        DataTypeManager.addTransform(new NumberToIntegerTransform(DefaultDataClasses.FLOAT, true));
        DataTypeManager.addTransform(new NumberToLongTransform(DefaultDataClasses.FLOAT, false, true));
        DataTypeManager.addTransform(new FloatingNumberToBigIntegerTransform(DefaultDataClasses.FLOAT));
        DataTypeManager.addTransform(new NumberToDoubleTransform(DefaultDataClasses.FLOAT, false, false));
        DataTypeManager.addTransform(new FloatingNumberToBigDecimalTransform(DefaultDataClasses.FLOAT));
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.FLOAT));
        DataTypeManager.addTransform(new NumberToBooleanTransform(Double.valueOf(0.0)));
        DataTypeManager.addTransform(new NumberToByteTransform(DefaultDataClasses.DOUBLE));
        DataTypeManager.addTransform(new NumberToShortTransform(DefaultDataClasses.DOUBLE, true));
        DataTypeManager.addTransform(new NumberToIntegerTransform(DefaultDataClasses.DOUBLE, true));
        DataTypeManager.addTransform(new NumberToLongTransform(DefaultDataClasses.DOUBLE, false, true));
        DataTypeManager.addTransform(new FloatingNumberToBigIntegerTransform(DefaultDataClasses.DOUBLE));
        DataTypeManager.addTransform(new NumberToFloatTransform(DefaultDataClasses.DOUBLE, true, false));
        DataTypeManager.addTransform(new FloatingNumberToBigDecimalTransform(DefaultDataClasses.DOUBLE));
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.DOUBLE));
        DataTypeManager.addTransform(new DateToTimestampTransform());
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.DATE));
        DataTypeManager.addTransform(new TimeToTimestampTransform());
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.TIME));
        DataTypeManager.addTransform(new TimestampToTimeTransform());
        DataTypeManager.addTransform(new TimestampToDateTransform());
        DataTypeManager.addTransform(new AnyToStringTransform(DefaultDataClasses.TIMESTAMP));
        DataTypeManager.addTransform(new StringToBooleanTransform());
        DataTypeManager.addTransform(new StringToByteTransform());
        DataTypeManager.addTransform(new StringToShortTransform());
        DataTypeManager.addTransform(new StringToIntegerTransform());
        DataTypeManager.addTransform(new StringToLongTransform());
        DataTypeManager.addTransform(new StringToBigIntegerTransform());
        DataTypeManager.addTransform(new StringToFloatTransform());
        DataTypeManager.addTransform(new StringToDoubleTransform());
        DataTypeManager.addTransform(new StringToBigDecimalTransform());
        DataTypeManager.addTransform(new StringToTimeTransform());
        DataTypeManager.addTransform(new StringToDateTransform());
        DataTypeManager.addTransform(new StringToTimestampTransform());
        DataTypeManager.addTransform(new StringToCharacterTransform());
        DataTypeManager.addTransform(new StringToClobTransform());
        DataTypeManager.addTransform(new StringToSQLXMLTransform());
        DataTypeManager.addTransform(new BinaryToBlobTransform());
        DataTypeManager.addTransform(new ClobToStringTransform());
        DataTypeManager.addTransform(new BlobToBinaryTransform());
        DataTypeManager.addTransform(new SQLXMLToStringTransform());
        DataTypeManager.addTransform(new AnyToStringTransform((Class)DefaultDataClasses.OBJECT){

            @Override
            public boolean isExplicit() {
                return true;
            }
        });
    }

    public static Object convertToRuntimeType(Object value, boolean allConversions) {
        if (value == null) {
            return null;
        }
        Class<?> c = value.getClass();
        if (DATA_TYPE_CLASSES.contains(c)) {
            return value;
        }
        if (allConversions) {
            if (c == char[].class) {
                return new ClobType(ClobImpl.createClob((char[])value));
            }
            if (c == byte[].class) {
                return new BinaryType((byte[])value);
            }
            if (Date.class.isAssignableFrom(c)) {
                return new Timestamp(((Date)value).getTime());
            }
            if (Object[].class.isAssignableFrom(c)) {
                return new ArrayImpl((Object[])value);
            }
        }
        if (Clob.class.isAssignableFrom(c)) {
            return new ClobType((Clob)value);
        }
        if (Blob.class.isAssignableFrom(c)) {
            return new BlobType((Blob)value);
        }
        if (SQLXML.class.isAssignableFrom(c)) {
            return new XMLType((SQLXML)value);
        }
        return value;
    }

    public static Class<?> getRuntimeType(Class<?> c) {
        if (c == null) {
            return DefaultDataClasses.NULL;
        }
        if (DATA_TYPE_CLASSES.contains(c)) {
            return c;
        }
        if (c == char[].class) {
            return DefaultDataClasses.CLOB;
        }
        if (c == byte[].class) {
            return DefaultDataClasses.VARBINARY;
        }
        if (Date.class.isAssignableFrom(c)) {
            return DefaultDataClasses.DATE;
        }
        if (Clob.class.isAssignableFrom(c)) {
            return DefaultDataClasses.CLOB;
        }
        if (Blob.class.isAssignableFrom(c)) {
            return DefaultDataClasses.BLOB;
        }
        if (SQLXML.class.isAssignableFrom(c)) {
            return DefaultDataClasses.XML;
        }
        if (c == ArrayImpl.class) {
            return DataTypeManager.getArrayType(DefaultDataClasses.OBJECT);
        }
        if (c.isArray()) {
            return DataTypeManager.getDataTypeClass(DataTypeManager.getDataTypeName(c));
        }
        return DefaultDataClasses.OBJECT;
    }

    public static Object transformValue(Object value, Class<?> targetClass) throws TransformationException {
        if (value == null) {
            return value;
        }
        return DataTypeManager.transformValue(value, value.getClass(), targetClass);
    }

    public static Object transformValue(Object value, Class<?> sourceType, Class<?> targetClass) throws TransformationException {
        if (value == null || sourceType == targetClass || DefaultDataClasses.OBJECT == targetClass) {
            return value;
        }
        Transform transform = DataTypeManager.getTransform(sourceType, targetClass);
        if (transform == null) {
            Object[] params = new Object[]{sourceType, targetClass, value};
            throw new TransformationException((BundleUtil.Event)CorePlugin.Event.TEIID10076, CorePlugin.Util.gs(CorePlugin.Event.TEIID10076, params));
        }
        Object result = transform.transform(value, targetClass);
        return DataTypeManager.getCanonicalValue(result);
    }

    public static boolean isNonComparable(String type) {
        return !COMPARABLE_OBJECT && "object".equals(type) || !COMPARABLE_LOBS && "blob".equals(type) || !COMPARABLE_LOBS && "clob".equals(type) || "xml".equals(type);
    }

    public static void setValueCacheEnabled(boolean enabled) {
        valueCacheEnabled = enabled;
    }

    public static final boolean isValueCacheEnabled() {
        return valueCacheEnabled;
    }

    public static final <T> T getCanonicalValue(T value) {
        if (valueCacheEnabled) {
            if (value == null) {
                return null;
            }
            ValueCache<?> valueCache = valueMaps.get(value.getClass());
            if (valueCache != null) {
                value = valueCache.getValue(value);
            }
        }
        return value;
    }

    public static final String getCanonicalString(String value) {
        if (value == null) {
            return null;
        }
        return stringCache.getValue(value);
    }

    public static boolean isHashable(Class<?> type) {
        if (type == DefaultDataClasses.STRING) {
            return !PAD_SPACE && COLLATION_LOCALE == null;
        }
        return type != DefaultDataClasses.BIG_DECIMAL && type != DefaultDataClasses.BLOB && type != DefaultDataClasses.CLOB && type != DefaultDataClasses.OBJECT;
    }

    public static Class<?> getArrayType(Class<?> classType) {
        Class<?> result = arrayTypes.get(classType);
        if (result != null) {
            return result;
        }
        return Array.newInstance(classType, 0).getClass();
    }

    static {
        typeMap.put(DefaultDataClasses.STRING, 0);
        typeMap.put(DefaultDataClasses.CHAR, 1);
        typeMap.put(DefaultDataClasses.BOOLEAN, 2);
        typeMap.put(DefaultDataClasses.BYTE, 3);
        typeMap.put(DefaultDataClasses.SHORT, 4);
        typeMap.put(DefaultDataClasses.INTEGER, 5);
        typeMap.put(DefaultDataClasses.LONG, 6);
        typeMap.put(DefaultDataClasses.BIG_INTEGER, 7);
        typeMap.put(DefaultDataClasses.FLOAT, 8);
        typeMap.put(DefaultDataClasses.DOUBLE, 9);
        typeMap.put(DefaultDataClasses.BIG_DECIMAL, 10);
        typeMap.put(DefaultDataClasses.DATE, 11);
        typeMap.put(DefaultDataClasses.TIME, 12);
        typeMap.put(DefaultDataClasses.TIMESTAMP, 13);
        typeMap.put(DefaultDataClasses.OBJECT, 14);
        typeMap.put(DefaultDataClasses.BLOB, 15);
        typeMap.put(DefaultDataClasses.CLOB, 16);
        typeMap.put(DefaultDataClasses.XML, 17);
        typeMap.put(DefaultDataClasses.NULL, 18);
        typeMap.put(DefaultDataClasses.VARBINARY, 19);
        typeMap.put(DefaultDataClasses.GEOMETRY, 20);
        typeList = new ArrayList(typeMap.keySet());
        transforms = new HashMap<String, Map<String, Transform>>(128);
        dataTypeNames = new LinkedHashMap(128);
        dataTypeClasses = new LinkedHashMap(128);
        arrayTypes = new HashMap(128);
        arrayTypeNames = new HashMap(128);
        DATA_TYPE_CLASSES = Collections.unmodifiableSet(dataTypeClasses.keySet());
        DataTypeManager.loadDataTypes();
        DataTypeManager.loadBasicTransforms();
        for (Map.Entry<String, Class<?>> entry : dataTypeNames.entrySet()) {
            Class<?> arrayType = DataTypeManager.getArrayType(entry.getValue());
            arrayTypes.put(entry.getValue(), arrayType);
            arrayTypeNames.put(arrayType, DataTypeManager.getDataTypeName(arrayType));
        }
    }

    public static final class DefaultTypeCodes {
        public static final int STRING = 0;
        public static final int CHAR = 1;
        public static final int BOOLEAN = 2;
        public static final int BYTE = 3;
        public static final int SHORT = 4;
        public static final int INTEGER = 5;
        public static final int LONG = 6;
        public static final int BIGINTEGER = 7;
        public static final int FLOAT = 8;
        public static final int DOUBLE = 9;
        public static final int BIGDECIMAL = 10;
        public static final int DATE = 11;
        public static final int TIME = 12;
        public static final int TIMESTAMP = 13;
        public static final int OBJECT = 14;
        public static final int BLOB = 15;
        public static final int CLOB = 16;
        public static final int XML = 17;
        public static final int NULL = 18;
        public static final int VARBINARY = 19;
        public static final int GEOMETRY = 20;
    }

    public static final class DefaultDataClasses {
        public static final Class<String> STRING = String.class;
        public static final Class<Boolean> BOOLEAN = Boolean.class;
        public static final Class<Byte> BYTE = Byte.class;
        public static final Class<Short> SHORT = Short.class;
        public static final Class<Character> CHAR = Character.class;
        public static final Class<Integer> INTEGER = Integer.class;
        public static final Class<Long> LONG = Long.class;
        public static final Class<BigInteger> BIG_INTEGER = BigInteger.class;
        public static final Class<Float> FLOAT = Float.class;
        public static final Class<Double> DOUBLE = Double.class;
        public static final Class<BigDecimal> BIG_DECIMAL = BigDecimal.class;
        public static final Class<java.sql.Date> DATE = java.sql.Date.class;
        public static final Class<Time> TIME = Time.class;
        public static final Class<Timestamp> TIMESTAMP = Timestamp.class;
        public static final Class<Object> OBJECT = Object.class;
        public static final Class<NullType> NULL = NullType.class;
        public static final Class<BlobType> BLOB = BlobType.class;
        public static final Class<ClobType> CLOB = ClobType.class;
        public static final Class<XMLType> XML = XMLType.class;
        public static final Class<BinaryType> VARBINARY = BinaryType.class;
        public static final Class<GeometryType> GEOMETRY = GeometryType.class;
    }

    public static final class DefaultDataTypes {
        public static final String STRING = "string";
        public static final String BOOLEAN = "boolean";
        public static final String BYTE = "byte";
        public static final String SHORT = "short";
        public static final String CHAR = "char";
        public static final String INTEGER = "integer";
        public static final String LONG = "long";
        public static final String BIG_INTEGER = "biginteger";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String BIG_DECIMAL = "bigdecimal";
        public static final String DATE = "date";
        public static final String TIME = "time";
        public static final String TIMESTAMP = "timestamp";
        public static final String OBJECT = "object";
        public static final String NULL = "null";
        public static final String BLOB = "blob";
        public static final String CLOB = "clob";
        public static final String XML = "xml";
        public static final String VARBINARY = "varbinary";
        public static final String GEOMETRY = "geometry";
    }

    public static final class DataTypeAliases {
        public static final String VARCHAR = "varchar";
        public static final String TINYINT = "tinyint";
        public static final String SMALLINT = "smallint";
        public static final String BIGINT = "bigint";
        public static final String REAL = "real";
        public static final String DECIMAL = "decimal";
    }

    public static class WeakReferenceHashedValueCache<T>
    extends HashedValueCache<T> {
        public WeakReferenceHashedValueCache(int size) {
            super(size);
        }

        public T getByHash(Object obj) {
            int index = WeakReferenceHashedValueCache.hash(obj.hashCode()) & this.cache.length - 1;
            return this.get(index);
        }

        @Override
        protected T get(int index) {
            WeakReference ref = (WeakReference)this.cache[index];
            if (ref != null) {
                Object result = ref.get();
                if (result == null) {
                    this.cache[index] = null;
                }
                return result;
            }
            return null;
        }

        @Override
        protected void set(int index, T value) {
            this.cache[index] = new WeakReference<T>(value);
        }
    }

    private static class HashedValueCache<T>
    implements ValueCache<T> {
        final Object[] cache;

        HashedValueCache(int size) {
            this.cache = new Object[1 << size];
        }

        @Override
        public T getValue(T value) {
            int index = HashedValueCache.hash(this.primaryHash(value)) & this.cache.length - 1;
            Object canonicalValue = this.get(index);
            if (value.equals(canonicalValue)) {
                return (T)canonicalValue;
            }
            this.set(index, value);
            return value;
        }

        protected Object get(int index) {
            return this.cache[index];
        }

        protected void set(int index, T value) {
            this.cache[index] = value;
        }

        protected int primaryHash(T value) {
            return value.hashCode();
        }

        static final int hash(int h) {
            h ^= h >>> 20 ^ h >>> 12;
            h ^= h >>> 7 ^ h >>> 4;
            return h;
        }
    }

    private static interface ValueCache<T> {
        public T getValue(T var1);
    }
}

