/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.OutStream;
import com.vividsolutions.jts.io.OutputStreamOutStream;
import com.vividsolutions.jts.io.WKBWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.XMLType;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.resolver.TestFunctionResolving;
import org.teiid.query.sql.symbol.Expression;

public class TestGeometry {
    @Test
    public void testRoundTrip() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))')");
        GeometryType geom = (GeometryType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((long)0L, (long)geom.getSrid());
        byte[] bytes = geom.getBytes(1L, (int)geom.length());
        Expression ex1 = TestFunctionResolving.getExpression("ST_GeomFromBinary(X'" + new BinaryType(bytes) + "', 8307)");
        GeometryType geom1 = (GeometryType)Evaluator.evaluate((Expression)ex1);
        Assert.assertEquals((long)8307L, (long)geom1.getSrid());
        Assert.assertEquals((Object)geom, (Object)geom1);
    }

    @Test
    public void testAsText() throws Exception {
        Expression ex2 = TestFunctionResolving.getExpression("st_astext(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Clob val = (Clob)Evaluator.evaluate((Expression)ex2);
        Assert.assertEquals((Object)"POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))", (Object)ClobType.getString((Clob)val));
    }

    @Test
    public void testAsBinary() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_asbinary(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Assert.assertTrue((boolean)(Evaluator.evaluate((Expression)ex) instanceof Blob));
    }

    @Test
    public void testContains() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("st_contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((43 0, 50 50, 0 50, 0 0, 43 0))'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void testIntersects() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_intersects(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("st_intersects(ST_GeomFromText('POLYGON ((100 100, 200 200, 75 75, 100 100))'), ST_GeomFromText('POLYGON ((43 0, 50 50, 0 50, 0 0, 43 0))'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void testAsGeoJson() throws Exception {
        this.assertEval("ST_AsGeoJson(ST_GeomFromText('POINT (-48.23456 20.12345)'))", "{\"coordinates\":[-48.23456,20.12345],\"type\":\"Point\"}");
        this.assertEval("ST_AsGeoJson(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))", "{\"coordinates\":[[[40.0,0.0],[50.0,50.0],[0.0,50.0],[0.0,0.0],[40.0,0.0]]],\"type\":\"Polygon\"}");
    }

    @Test
    public void testFromGeoJson() throws Exception {
        this.assertEval("ST_AsText(ST_GeomFromGeoJSON('{\"coordinates\":[-48.23456,20.12345],\"type\":\"Point\"}'))", "POINT (-48.23456 20.12345)");
        this.assertEval("ST_AsText(ST_GeomFromGeoJSON('{\"coordinates\":[[[40.0,0.0],[50.0,50.0],[0.0,50.0],[0.0,0.0],[40.0,0.0]]],\"type\":\"Polygon\"}'))", "POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))");
    }

    @Test
    public void testAsGml() throws Exception {
        this.assertEval("ST_AsGML(ST_GeomFromText('POINT (-48.23456 20.12345)'))", "<gml:Point>\n  <gml:coordinates>\n    -48.23456,20.12345 \n  </gml:coordinates>\n</gml:Point>\n");
        this.assertEval("ST_AsGML(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))", "<gml:Polygon>\n  <gml:outerBoundaryIs>\n    <gml:LinearRing>\n      <gml:coordinates>\n        40.0,0.0 50.0,50.0 0.0,50.0 0.0,0.0 40.0,0.0 \n      </gml:coordinates>\n    </gml:LinearRing>\n  </gml:outerBoundaryIs>\n</gml:Polygon>\n");
    }

    @Test
    public void testFromGml() throws Exception {
        this.assertEval("ST_AsText(ST_GeomFromGML('<gml:Point>\n  <gml:coordinates>\n    -48.23456,20.12345 \n  </gml:coordinates>\n</gml:Point>'))", "POINT (-48.23456 20.12345)");
        this.assertEval("ST_AsText(ST_GeomFromGML('<gml:Polygon>\n  <gml:outerBoundaryIs>\n    <gml:LinearRing>\n      <gml:coordinates>\n        40.0,0.0 50.0,50.0 0.0,50.0 0.0,0.0 40.0,0.0 \n      </gml:coordinates>\n    </gml:LinearRing>\n  </gml:outerBoundaryIs>\n</gml:Polygon>'))", "POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))");
    }

    private void assertEval(String expr, String result) throws Exception {
        Expression ex = TestFunctionResolving.getExpression(expr);
        Object val = Evaluator.evaluate((Expression)ex);
        String valStr = null;
        if (val instanceof Clob) {
            valStr = ClobType.getString((Clob)((Clob)val));
        } else if (val instanceof XMLType) {
            valStr = ((XMLType)val).getString();
        }
        Assert.assertEquals((Object)result, (Object)valStr);
    }

    @Test
    public void testEquals() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_Equals (ST_GeomFromText('LINESTRING(-1 2, 0 3)'), ST_GeomFromText('LINESTRING(0 3, -1 2)'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("ST_Equals (ST_GeomFromText('LINESTRING(0 0, 0 1, 0 3)'), ST_GeomFromText('LINESTRING(0 3, 0 0)'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("ST_Equals (ST_GeomFromText('LINESTRING(0 1, 0 3)'), ST_GeomFromText('LINESTRING(0 3, 0 0)'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testEwkb() throws Exception {
        WKBWriter writer = new WKBWriter(3, true);
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(0.0, 0.0, 0.0));
        point.setSRID(100);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write((Geometry)point, (OutStream)new OutputStreamOutStream((OutputStream)baos));
        Expression ex1 = TestFunctionResolving.getExpression("ST_GeomFromBinary(X'" + new BinaryType(baos.toByteArray()) + "', 8307)");
        Evaluator.evaluate((Expression)ex1);
    }

    @Test
    public void testGmlParseSrid() throws Exception {
        String gml = "<gml:Polygon srsName=\"SDO:8307\" xmlns:gml=\"http://www.opengis.net/gml\"><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">5,1 8,1 8,6 5,7 5,1 </gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon>";
        GeometryType gt = GeometryUtils.geometryFromGml((ClobType)new ClobType(ClobImpl.createClob((char[])gml.toCharArray())));
        Assert.assertEquals((long)8307L, (long)gt.getSrid());
    }
}

