/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.common.buffer.LobManager;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;

public class TestLobManager {
    @Test
    public void testLobPeristence() throws Exception {
        BufferManager buffMgr = BufferManagerFactory.getStandaloneBufferManager();
        FileStore fs = buffMgr.createFileStore("temp");
        ClobType clob = new ClobType((Clob)new ClobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return new ReaderInputStream((Reader)new StringReader("Clob contents One"), Charset.forName("UTF-8"));
            }
        }, -1L));
        BlobType blob = new BlobType((Blob)new BlobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return new ReaderInputStream((Reader)new StringReader("Blob contents Two"), Charset.forName("UTF-8"));
            }
        }));
        FileStore fs1 = buffMgr.createFileStore("blob");
        FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(fs1, "UTF-8");
        FileStore.FileStoreOutputStream fsos = fsisf.getOuputStream();
        byte[] b = new byte[DataTypeManager.MAX_LOB_MEMORY_BYTES + 1];
        fsos.write(b);
        fsos.close();
        BlobType blob1 = new BlobType((Blob)new BlobImpl((InputStreamFactory)fsisf));
        Assert.assertNotNull((Object)blob1.getReferenceStreamId());
        LobManager lobManager = new LobManager(new int[]{0, 1, 2}, fs);
        lobManager.setMaxMemoryBytes(4);
        List<Streamable> tuple = Arrays.asList(clob, blob, blob1);
        lobManager.updateReferences(tuple, LobManager.ReferenceMode.CREATE);
        Assert.assertNotNull((Object)blob1.getReferenceStreamId());
        lobManager.persist();
        Streamable lob = lobManager.getLobReference(clob.getReferenceStreamId());
        Assert.assertTrue((boolean)lob.getClass().isAssignableFrom(ClobType.class));
        ClobType clobRead = (ClobType)lob;
        Assert.assertEquals((Object)ClobType.getString((Clob)clob), (Object)ClobType.getString((Clob)clobRead));
        Assert.assertTrue((clobRead.length() != -1L ? 1 : 0) != 0);
        lob = lobManager.getLobReference(blob.getReferenceStreamId());
        Assert.assertTrue((boolean)lob.getClass().isAssignableFrom(BlobType.class));
        BlobType blobRead = (BlobType)lob;
        Assert.assertTrue((boolean)Arrays.equals(ObjectConverterUtil.convertToByteArray((InputStream)blob.getBinaryStream()), ObjectConverterUtil.convertToByteArray((InputStream)blobRead.getBinaryStream())));
        lobManager.updateReferences(tuple, LobManager.ReferenceMode.REMOVE);
        Assert.assertEquals((long)0L, (long)lobManager.getLobCount());
    }

    @Test
    public void testInlining() throws Exception {
        BufferManager buffMgr = BufferManagerFactory.getStandaloneBufferManager();
        FileStore fs = buffMgr.createFileStore("temp");
        ClobType clob = new ClobType((Clob)new ClobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return new ReaderInputStream((Reader)new StringReader("small"), Charset.forName("UTF-8"));
            }
        }, 5L));
        Assert.assertEquals((Object)InputStreamFactory.StorageMode.OTHER, (Object)InputStreamFactory.getStorageMode((Object)clob));
        LobManager lobManager = new LobManager(new int[]{0}, fs);
        lobManager.updateReferences(Arrays.asList(clob), LobManager.ReferenceMode.CREATE);
        Assert.assertEquals((Object)InputStreamFactory.StorageMode.MEMORY, (Object)InputStreamFactory.getStorageMode((Object)clob));
    }
}

