/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.message;

import java.io.Serializable;
import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.message.RequestID;

public class TestRequestID
extends TestCase {
    public TestRequestID(String name) {
        super(name);
    }

    public void testGetters1() {
        String connID = "100";
        long executionID = 200L;
        RequestID r = new RequestID(connID, executionID);
        TestRequestID.assertEquals((String)"Lost connectionID", (String)connID, (String)r.getConnectionID());
        TestRequestID.assertEquals((String)"Lost executionID", (long)executionID, (long)r.getExecutionID());
        TestRequestID.assertEquals((String)"Wrong string representation", (String)"100.200", (String)r.toString());
    }

    public void testGetters2() {
        long executionID = 200L;
        RequestID r = new RequestID(executionID);
        TestRequestID.assertEquals((String)"Lost connectionID", null, (String)r.getConnectionID());
        TestRequestID.assertEquals((String)"Lost executionID", (long)executionID, (long)r.getExecutionID());
        TestRequestID.assertEquals((String)"Wrong string representation", (String)"C.200", (String)r.toString());
    }

    public void testEquivalence1() {
        RequestID r1 = new RequestID("100", 200L);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)r1, (Object)r1);
    }

    public void testEquivalence2() {
        RequestID r1 = new RequestID("100", 200L);
        RequestID r2 = new RequestID("100", 200L);
        UnitTestUtil.helpTestEquivalence((int)0, (Object)r1, (Object)r2);
    }

    public void testEquivalence3() {
        RequestID r1 = new RequestID("101", 200L);
        RequestID r2 = new RequestID("100", 200L);
        UnitTestUtil.helpTestEquivalence((int)1, (Object)r1, (Object)r2);
    }

    public void testEquivalence4() {
        RequestID r1 = new RequestID("100", 200L);
        RequestID r2 = new RequestID("100", 201L);
        UnitTestUtil.helpTestEquivalence((int)1, (Object)r1, (Object)r2);
    }

    public void testEquivalence7() {
        RequestID r1 = new RequestID(200L);
        RequestID r2 = new RequestID("100", 200L);
        UnitTestUtil.helpTestEquivalence((int)1, (Object)r1, (Object)r2);
    }

    public void testSerialize1() throws Exception {
        RequestID copy = (RequestID)UnitTestUtil.helpSerialize((Serializable)new RequestID("1", 100L));
        TestRequestID.assertEquals((String)"1", (String)copy.getConnectionID());
        TestRequestID.assertEquals((long)100L, (long)copy.getExecutionID());
        TestRequestID.assertEquals((String)"1.100", (String)copy.toString());
    }

    public void testSerialize2() throws Exception {
        RequestID copy = (RequestID)UnitTestUtil.helpSerialize((Serializable)new RequestID(100L));
        TestRequestID.assertEquals(null, (String)copy.getConnectionID());
        TestRequestID.assertEquals((long)100L, (long)copy.getExecutionID());
        TestRequestID.assertEquals((String)"C.100", (String)copy.toString());
    }
}

