/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.query.util.CommandContext;

public class BatchCollector {
    private BatchProducer sourceNode;
    private boolean done = false;
    private TupleBuffer buffer;
    private boolean forwardOnly;
    private int rowLimit = -1;
    private boolean hasFinalBuffer;
    private boolean saveLastRow;

    public BatchCollector(BatchProducer sourceNode, BufferManager bm, CommandContext context, boolean forwardOnly) throws TeiidComponentException {
        this.sourceNode = sourceNode;
        this.forwardOnly = forwardOnly;
        this.hasFinalBuffer = this.sourceNode.hasBuffer(false);
        if (!this.hasFinalBuffer) {
            this.buffer = bm.createTupleBuffer(sourceNode.getOutputElements(), context.getConnectionId(), BufferManager.TupleSourceType.PROCESSOR);
            this.buffer.setForwardOnly(forwardOnly);
        }
    }

    public TupleBuffer collectTuples() throws TeiidComponentException, TeiidProcessingException {
        return this.collectTuples(false);
    }

    public TupleBuffer collectTuples(boolean singleBatch) throws TeiidComponentException, TeiidProcessingException {
        TupleBatch batch = null;
        while (!this.done) {
            if (this.hasFinalBuffer) {
                if (this.buffer == null) {
                    TupleBuffer finalBuffer = this.sourceNode.getBuffer(this.rowLimit);
                    Assertion.isNotNull((Object)finalBuffer);
                    this.buffer = finalBuffer;
                }
                if (this.buffer.isFinal()) {
                    this.buffer.setForwardOnly(this.forwardOnly);
                    this.done = true;
                    break;
                }
            }
            batch = this.sourceNode.nextBatch();
            if (this.rowLimit > 0 && this.rowLimit <= batch.getEndRow()) {
                if (!this.done) {
                    this.sourceNode.close();
                }
                List<?> lastTuple = null;
                if (this.saveLastRow) {
                    if (batch.getTerminationFlag()) {
                        lastTuple = batch.getTuples().get(batch.getTuples().size() - 1);
                    } else if (this.rowLimit < batch.getBeginRow()) continue;
                }
                boolean modified = false;
                if (this.rowLimit < batch.getEndRow()) {
                    int firstRow = Math.min(this.rowLimit + 1, batch.getBeginRow());
                    List<List<?>> tuples = batch.getTuples().subList(0, this.rowLimit - firstRow + 1);
                    batch = new TupleBatch(firstRow, tuples);
                    modified = true;
                }
                if (lastTuple != null) {
                    if (!modified) {
                        batch = new TupleBatch(batch.getBeginRow(), batch.getTuples());
                    }
                    batch.getTuples().add(lastTuple);
                }
                batch.setTerminationFlag(true);
            }
            this.flushBatch(batch);
            if (batch.getTerminationFlag()) {
                this.done = true;
                if (this.sourceNode.hasBuffer(false)) break;
                this.buffer.close();
                break;
            }
            if (!singleBatch) continue;
            return null;
        }
        return this.buffer;
    }

    public TupleBuffer getTupleBuffer() {
        return this.buffer;
    }

    private void flushBatch(TupleBatch batch) throws TeiidComponentException, TeiidProcessingException {
        if (batch.getRowCount() == 0 && batch.getTermination() == 0) {
            return;
        }
        this.flushBatchDirect(batch, true);
    }

    protected void flushBatchDirect(TupleBatch batch, boolean add) throws TeiidComponentException, TeiidProcessingException {
        if (!this.hasFinalBuffer) {
            this.buffer.addTupleBatch(batch, add);
        }
    }

    public int getRowCount() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getRowCount();
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public void setSaveLastRow(boolean saveLastRow) {
        this.saveLastRow = saveLastRow;
    }

    public boolean isSaveLastRow() {
        return this.saveLastRow;
    }

    public static class BatchProducerTupleSource
    implements TupleSource {
        private final BatchProducer sourceNode;
        private TupleBatch sourceBatch;
        private int sourceRow = 1;

        public BatchProducerTupleSource(BatchProducer sourceNode) {
            this.sourceNode = sourceNode;
        }

        public BatchProducerTupleSource(BatchProducer sourceNode, int startRow) {
            this.sourceNode = sourceNode;
            this.sourceRow = startRow;
        }

        public List<Object> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            while (true) {
                if (this.sourceBatch == null) {
                    this.sourceBatch = this.sourceNode.nextBatch();
                }
                if (this.sourceBatch.getRowCount() > 0 && this.sourceRow <= this.sourceBatch.getEndRow()) {
                    List<Object> tuple = this.sourceBatch.getTuple(this.sourceRow);
                    tuple = this.updateTuple(tuple);
                    ++this.sourceRow;
                    return tuple;
                }
                if (this.sourceBatch.getTerminationFlag()) {
                    this.sourceBatch = null;
                    return null;
                }
                this.sourceBatch = null;
            }
        }

        protected List<?> updateTuple(List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
            return tuple;
        }

        @Override
        public void closeSource() {
        }
    }

    public static interface BatchProducer {
        public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException;

        public List getOutputElements();

        public TupleBuffer getBuffer(int var1) throws BlockedException, TeiidComponentException, TeiidProcessingException;

        public boolean hasBuffer(boolean var1);

        public void close() throws TeiidComponentException;
    }
}

