/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.function.aggregate.Count;
import org.teiid.query.processor.relational.SortingFilter;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TestDuplicateFilter {
    public void helpTestDuplicateFilter(Object[] input, Class<?> dataType, int expected) throws TeiidComponentException, TeiidProcessingException {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        Count count = new Count();
        count.setArgIndexes(new int[]{0});
        SortingFilter filter = new SortingFilter((AggregateFunction)count, mgr, "test", true);
        filter.initialize(dataType, new Class[]{dataType});
        ElementSymbol element = new ElementSymbol("val");
        element.setType(dataType);
        filter.setElements(Arrays.asList(element));
        filter.setArgIndexes(new int[]{0});
        filter.reset();
        for (int i = 0; i < input.length; ++i) {
            filter.addInputDirect(Arrays.asList(input[i]), null);
        }
        Integer actual = (Integer)filter.getResult(null);
        Assert.assertEquals((String)"Did not get expected number of results", (long)expected, (long)actual.intValue());
    }

    @Test
    public void testNoInputs() throws Exception {
        this.helpTestDuplicateFilter(new Object[0], DataTypeManager.DefaultDataClasses.STRING, 0);
    }

    @Test
    public void testSmall() throws Exception {
        Object[] input = new Object[]{"a", "b", "a", "c", "a", "c", "c", "f"};
        this.helpTestDuplicateFilter(input, DataTypeManager.DefaultDataClasses.STRING, 4);
    }

    @Test
    public void testBig() throws Exception {
        int NUM_VALUES = 10000;
        int NUM_OUTPUT = 200;
        Object[] input = new Object[NUM_VALUES];
        for (int i = 0; i < NUM_VALUES; ++i) {
            input[i] = new Integer(i % NUM_OUTPUT);
        }
        this.helpTestDuplicateFilter(input, DataTypeManager.DefaultDataClasses.INTEGER, NUM_OUTPUT);
    }
}

