/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalNodeStatistics;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.util.CommandContext;

public class TestRelationalNodeStatistics {
    @Test
    public void testBatchTimer() {
        RelationalNodeStatistics testnodeStatistics = new RelationalNodeStatistics();
        testnodeStatistics.startBatchTimer();
        Assert.assertTrue((String)"The batch timer did not yield a start time", (testnodeStatistics.getBatchStartTime() != 0L ? 1 : 0) != 0);
        testnodeStatistics.stopBatchTimer();
        Assert.assertTrue((String)"The batch timer did not yield an end time", (testnodeStatistics.getBatchEndTime() != 0L ? 1 : 0) != 0);
    }

    @Test
    public void testStatsCollection() throws TeiidComponentException, TeiidProcessingException {
        TupleBatch batch;
        List[] data = this.createData(1000);
        FakeRelationalNode fakeNode = this.createFakeNode(data);
        while (!(batch = fakeNode.nextBatch()).getTerminationFlag()) {
        }
        int actualNodeBlocks = fakeNode.getNodeStatistics().getNodeBlocks();
        int actualNodeNextBatchCalls = fakeNode.getNodeStatistics().getNodeNextBatchCalls();
        int actualNodeOutputRows = fakeNode.getNodeStatistics().getNodeOutputRows();
        Assert.assertEquals((String)("The NodeOutputRows was Inccorrect. Correct: 1000 Actual: " + actualNodeOutputRows), (long)1000L, (long)actualNodeOutputRows);
        Assert.assertEquals((String)("The NodeNextBatchCalls was Inccorrect. Correct: 10 Actual: " + actualNodeNextBatchCalls), (long)10L, (long)actualNodeNextBatchCalls);
        Assert.assertEquals((String)("The NodeBlocks was Inccorrect. Correct: 0 Actual: " + actualNodeBlocks), (long)0L, (long)actualNodeBlocks);
    }

    @Test
    public void testCumulativeCalculation() {
        RelationalNode[] children = new RelationalNode[]{this.createFakeNode(this.createData(1)), this.createFakeNode(this.createData(1))};
        children[0].getNodeStatistics().setBatchEndTime(100L);
        children[0].getNodeStatistics().collectCumulativeNodeStats(new TupleBatch(1, Collections.EMPTY_LIST), 0);
        children[0].getNodeStatistics().collectNodeStats(new RelationalNode[0]);
        children[1].getNodeStatistics().setBatchEndTime(200L);
        children[1].getNodeStatistics().collectCumulativeNodeStats(new TupleBatch(1, Collections.EMPTY_LIST), 0);
        children[1].getNodeStatistics().collectNodeStats(new RelationalNode[0]);
        RelationalNodeStatistics stats = new RelationalNodeStatistics();
        stats.setBatchEndTime(1000L);
        stats.setBatchStartTime(0L);
        stats.collectCumulativeNodeStats(null, 1);
        stats.collectNodeStats(children);
        Assert.assertEquals((long)1000L, (long)stats.getNodeCumulativeProcessingTime());
        Assert.assertEquals((long)700L, (long)stats.getNodeNextBatchProcessingTime());
    }

    @Test
    public void testDescriptionProperties() throws Exception {
        TupleBatch batch;
        List[] data = this.createData(1000);
        FakeRelationalNode fakeNode = this.createFakeNode(data);
        while (!(batch = fakeNode.nextBatch()).getTerminationFlag()) {
        }
        Assert.assertEquals((Object)"FakeRelationalNode", (Object)fakeNode.getDescriptionProperties().getName());
    }

    private FakeRelationalNode createFakeNode(List[] data) {
        ElementSymbol element = new ElementSymbol("a");
        element.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(element);
        FakeRelationalNode fakeNode = new FakeRelationalNode(1, data, 100);
        fakeNode.setElements(elements);
        CommandContext context = new CommandContext("group", null, null, null, 1, true);
        fakeNode.initialize(context, BufferManagerFactory.getStandaloneBufferManager(), null);
        return fakeNode;
    }

    private List[] createData(int rows) {
        List[] data = new List[rows];
        for (int i = 0; i < rows; ++i) {
            data[i] = new ArrayList();
            data[i].add(new Integer(i));
        }
        return data;
    }
}

