/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.transaction.SystemException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.ProcedureErrorInstructionException;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.xa.XATransactionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.events.EventDistributor;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.proc.CreateCursorResultSetInstruction;
import org.teiid.query.processor.proc.Program;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.processor.proc.RepeatedInstruction;
import org.teiid.query.processor.relational.SubqueryAwareEvaluator;
import org.teiid.query.resolver.command.UpdateProcedureResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;

public class ProcedurePlan
extends ProcessorPlan
implements ProcessorDataManager {
    static final ElementSymbol ROWCOUNT = new ElementSymbol("VARIABLES.ROWCOUNT");
    private Program originalProgram;
    private ProcessorDataManager parentDataMrg;
    private BufferManager bufferMgr;
    private int batchSize;
    private boolean done = false;
    private CursorState currentState;
    private TupleSource finalTupleSource;
    private int beginBatch = 1;
    private List<List<?>> batchRows;
    private boolean lastBatch = false;
    private LinkedHashMap<ElementSymbol, Expression> params;
    private boolean runInContext = true;
    private List<ElementSymbol> outParams;
    private QueryMetadataInterface metadata;
    private VariableContext cursorStates;
    private VariableContext currentVarContext;
    private VariableContext parentContext;
    private List outputElements;
    private SubqueryAwareEvaluator evaluator;
    private Stack<Program> programs = new Stack();
    private boolean evaluatedParams;
    private boolean requiresTransaction = true;
    private TransactionContext blockContext;
    private LinkedList<WeakReference<DataTierTupleSource>> txnTupleSources = new LinkedList();

    public ProcedurePlan(Program originalProgram) {
        this.originalProgram = originalProgram;
        this.createVariableContext();
    }

    public Program getOriginalProgram() {
        return this.originalProgram;
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.bufferMgr = bufferMgr;
        this.batchSize = bufferMgr.getProcessorBatchSize(this.getOutputElements());
        this.parentContext = context.getVariableContext();
        this.setContext(context.clone());
        this.parentDataMrg = dataMgr;
        if (this.evaluator == null) {
            this.evaluator = new SubqueryAwareEvaluator(Collections.emptyMap(), this.getDataManager(), this.getContext(), this.bufferMgr);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.evaluator != null) {
            this.evaluator.reset();
        }
        this.evaluatedParams = false;
        if (this.parentContext != null) {
            super.getContext().setVariableContext(this.parentContext);
        }
        this.createVariableContext();
        this.done = false;
        this.currentState = null;
        this.finalTupleSource = null;
        this.beginBatch = 1;
        this.batchRows = null;
        this.lastBatch = false;
        this.programs.clear();
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"ProcedurePlan reset");
    }

    public ProcessorDataManager getDataManager() {
        return this;
    }

    @Override
    public void open() throws TeiidProcessingException, TeiidComponentException {
        if (!this.evaluatedParams) {
            if (this.outParams != null) {
                for (ElementSymbol elementSymbol : this.outParams) {
                    this.setParameterValue(elementSymbol, this.getCurrentVariableContext(), null);
                }
            }
            if (this.params != null) {
                for (Map.Entry entry : this.params.entrySet()) {
                    ElementSymbol param = (ElementSymbol)entry.getKey();
                    Expression expr = (Expression)entry.getValue();
                    VariableContext context = this.getCurrentVariableContext();
                    if (context.getVariableMap().containsKey(param)) continue;
                    Object value = this.evaluateExpression(expr);
                    this.checkNotNull(param, value);
                    this.setParameterValue(param, context, value);
                }
                this.evaluator.close();
            } else if (this.runInContext) {
                this.currentVarContext.setParentContext(this.parentContext);
            }
            this.push(this.originalProgram);
        }
        this.evaluatedParams = true;
    }

    private void checkNotNull(ElementSymbol param, Object value) throws TeiidComponentException, QueryMetadataException, QueryValidatorException {
        if (this.metadata.elementSupports(param.getMetadataID(), 4)) {
            return;
        }
        if (value == null) {
            throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30164, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30164, new Object[]{param}));
        }
        if (value instanceof ArrayImpl && this.metadata.isVariadic(param.getMetadataID())) {
            ArrayImpl av = (ArrayImpl)value;
            for (Object o : av.getValues()) {
                if (o != null) continue;
                throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30164, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30164, new Object[]{param}));
            }
        }
    }

    protected void setParameterValue(ElementSymbol param, VariableContext context, Object value) {
        context.setValue(param, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.blockContext != null) {
            this.getContext().getTransactionServer().resume(this.blockContext);
        }
        try {
            TupleBatch tupleBatch = this.nextBatchDirect();
            return tupleBatch;
        }
        finally {
            if (this.blockContext != null) {
                this.getContext().getTransactionServer().suspend(this.blockContext);
            }
        }
    }

    public TupleBatch nextBatchDirect() throws TeiidComponentException, TeiidProcessingException, BlockedException {
        if (this.done) {
            TupleBatch emptyTerminationBatch = new TupleBatch(this.beginBatch, new List[0]);
            emptyTerminationBatch.setTerminationFlag(true);
            return emptyTerminationBatch;
        }
        if (this.finalTupleSource == null) {
            this.finalTupleSource = this.processProcedure();
        }
        while (!this.isBatchFull()) {
            List<?> tuple = this.finalTupleSource.nextTuple();
            if (tuple == null) {
                if (this.outParams != null) {
                    VariableContext vc = this.getCurrentVariableContext();
                    List<Object> paramTuple = Arrays.asList(new Object[this.getOutputElements().size()]);
                    int i = this.getOutputElements().size() - this.outParams.size();
                    for (ElementSymbol param : this.outParams) {
                        Object value = vc.getValue(param);
                        this.checkNotNull(param, value);
                        paramTuple.set(i++, value);
                    }
                    this.addBatchRow(paramTuple, true);
                }
                this.terminateBatches();
                this.done = true;
                break;
            }
            this.addBatchRow(tuple, false);
        }
        return this.pullBatch();
    }

    private TupleSource processProcedure() throws TeiidComponentException, TeiidProcessingException, BlockedException {
        ProgramInstruction inst = null;
        while (!this.programs.empty()) {
            Program program = this.peek();
            inst = program.getCurrentInstruction();
            if (inst == null) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Finished program", (Object)program);
                VariableContext vc = this.cursorStates.getParentContext();
                CursorState last = (CursorState)this.cursorStates.getValue(null);
                if (last != null) {
                    if (last.resultsBuffer == null && (last.usesLocalTemp || !this.txnTupleSources.isEmpty())) {
                        last.resultsBuffer = this.bufferMgr.createTupleBuffer(last.processor.getOutputElements(), this.getContext().getConnectionId(), BufferManager.TupleSourceType.PROCESSOR);
                        last.returning = true;
                    }
                    if (last.returning) {
                        while (last.ts.hasNext()) {
                            List<?> tuple = last.ts.nextTuple();
                            last.resultsBuffer.addTuple(tuple);
                        }
                        last.resultsBuffer.close();
                        last.ts = last.resultsBuffer.createIndexedTupleSource(true);
                        last.returning = false;
                    }
                }
                this.pop(true);
                continue;
            }
            try {
                if (inst instanceof RepeatedInstruction) {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Executing repeated instruction", (Object)inst);
                    RepeatedInstruction loop = (RepeatedInstruction)((Object)inst);
                    if (loop.testCondition(this)) {
                        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)("Passed condition, executing program " + loop.getNestedProgram()));
                        inst.process(this);
                        this.push(loop.getNestedProgram());
                        continue;
                    }
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Exiting repeated instruction", (Object)inst);
                    loop.postInstruction(this);
                } else {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Executing instruction", (Object)inst);
                    inst.process(this);
                    this.evaluator.close();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (TeiidComponentException e) {
                throw e;
            }
            catch (Exception e) {
                TransactionContext tc;
                boolean atomic = program.isAtomic();
                while (program.getExceptionGroup() == null) {
                    this.pop(false);
                    if (this.programs.empty()) {
                        if (e instanceof TeiidProcessingException) {
                            throw (TeiidProcessingException)((Object)e);
                        }
                        throw new ProcedureErrorInstructionException((BundleUtil.Event)QueryPlugin.Event.TEIID30167, e);
                    }
                    program = this.peek();
                    atomic |= program.isAtomic();
                }
                this.pop(false);
                if (atomic && (tc = this.getContext().getTransactionContext()) != null && tc.getTransactionType() != TransactionContext.Scope.NONE) {
                    try {
                        tc.getTransaction().setRollbackOnly();
                    }
                    catch (IllegalStateException e1) {
                        throw new TeiidComponentException((Throwable)e1);
                    }
                    catch (SystemException e1) {
                        throw new TeiidComponentException((Throwable)e1);
                    }
                }
                if (program.getExceptionProgram() == null) continue;
                Program exceptionProgram = program.getExceptionProgram();
                this.push(exceptionProgram);
                TeiidSQLException tse = TeiidSQLException.create((Throwable)e);
                GroupSymbol gs = new GroupSymbol(program.getExceptionGroup());
                this.currentVarContext.setValue(this.exceptionSymbol(gs, 0), tse.getSQLState());
                this.currentVarContext.setValue(this.exceptionSymbol(gs, 1), tse.getErrorCode());
                this.currentVarContext.setValue(this.exceptionSymbol(gs, 2), tse.getTeiidCode());
                this.currentVarContext.setValue(this.exceptionSymbol(gs, 3), tse);
                this.currentVarContext.setValue(this.exceptionSymbol(gs, 4), tse.getCause());
                continue;
            }
            program.incrementProgramCounter();
        }
        CursorState last = (CursorState)this.cursorStates.getValue(null);
        if (last == null) {
            return CollectionTupleSource.createNullTupleSource();
        }
        return last.ts;
    }

    private ElementSymbol exceptionSymbol(GroupSymbol gs, int pos) {
        ElementSymbol es = UpdateProcedureResolver.exceptionGroup.get(pos).clone();
        es.setGroupSymbol(gs);
        return es;
    }

    @Override
    public void close() throws TeiidComponentException {
        while (!this.programs.isEmpty()) {
            try {
                this.pop(false);
            }
            catch (TeiidComponentException e) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)((Object)e), (Object)"Error closing program");
            }
        }
        if (this.evaluator != null) {
            this.evaluator.close();
        }
        if (this.cursorStates != null) {
            this.removeAllCursors(this.cursorStates);
            this.cursorStates = null;
        }
        this.txnTupleSources.clear();
        this.blockContext = null;
        this.currentVarContext = null;
    }

    public String toString() {
        return "ProcedurePlan:\n" + this.originalProgram;
    }

    @Override
    public ProcessorPlan clone() {
        ProcedurePlan plan = new ProcedurePlan(this.originalProgram.clone());
        plan.setOutputElements(this.getOutputElements());
        plan.setParams(this.params);
        plan.setOutParams(this.outParams);
        plan.setMetadata(this.metadata);
        plan.requiresTransaction = this.requiresTransaction;
        plan.runInContext = this.runInContext;
        return plan;
    }

    private void addBatchRow(List<?> row, boolean last) {
        if (this.batchRows == null) {
            this.batchRows = new ArrayList(this.batchSize / 4);
        }
        if (!last && this.outParams != null) {
            List<Object> newRow = Arrays.asList(new Object[row.size() + this.outParams.size()]);
            for (int i = 0; i < row.size(); ++i) {
                newRow.set(i, row.get(i));
            }
            row = newRow;
        }
        this.batchRows.add(row);
    }

    protected void terminateBatches() {
        this.lastBatch = true;
    }

    protected boolean isBatchFull() {
        return this.batchRows != null && this.batchRows.size() == this.batchSize;
    }

    protected TupleBatch pullBatch() {
        TupleBatch batch = null;
        if (this.batchRows != null) {
            batch = new TupleBatch(this.beginBatch, this.batchRows);
            this.beginBatch += this.batchRows.size();
        } else {
            batch = new TupleBatch(this.beginBatch, Collections.EMPTY_LIST);
        }
        batch.setTerminationFlag(this.lastBatch);
        this.batchRows = null;
        this.lastBatch = false;
        return batch;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode node = this.originalProgram.getDescriptionProperties();
        node.addProperty("Output Columns", AnalysisRecord.getOutputColumnProperties(this.getOutputElements()));
        return node;
    }

    public void setMetadata(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    public void setOutParams(List<ElementSymbol> outParams) {
        this.outParams = outParams;
    }

    public void setParams(LinkedHashMap<ElementSymbol, Expression> params) {
        this.params = params;
    }

    private void createVariableContext() {
        this.currentVarContext = new VariableContext(this.runInContext && this.params == null);
        this.currentVarContext.setValue(ROWCOUNT, 0);
        this.cursorStates = new VariableContext(false);
        this.cursorStates.setValue(null, null);
    }

    public VariableContext getCurrentVariableContext() {
        return this.currentVarContext;
    }

    public void executePlan(ProcessorPlan command, String rsName, Map<ElementSymbol, ElementSymbol> procAssignments, CreateCursorResultSetInstruction.Mode mode, boolean usesLocalTemp) throws TeiidComponentException, TeiidProcessingException {
        CursorState state = (CursorState)this.cursorStates.getValue(rsName);
        if (state == null || rsName == null) {
            CursorState old;
            if (this.currentState != null && this.currentState.processor.getProcessorPlan() != command) {
                this.removeState(this.currentState);
                this.currentState = null;
            }
            if (this.currentState == null) {
                command.reset();
                CommandContext subContext = this.getContext().clone();
                subContext.setVariableContext(this.currentVarContext);
                state = new CursorState();
                state.usesLocalTemp = usesLocalTemp;
                state.processor = new QueryProcessor(command, subContext, this.bufferMgr, this);
                state.ts = new BatchIterator(state.processor);
                if (mode == CreateCursorResultSetInstruction.Mode.HOLD && procAssignments != null && state.processor.getOutputElements().size() - procAssignments.size() > 0) {
                    state.resultsBuffer = this.bufferMgr.createTupleBuffer(state.processor.getOutputElements().subList(0, state.processor.getOutputElements().size() - procAssignments.size()), this.getContext().getConnectionId(), BufferManager.TupleSourceType.PROCESSOR);
                } else if (!(this.blockContext == null && !this.programs.peek().isTrappingExceptions() || mode != CreateCursorResultSetInstruction.Mode.HOLD && rsName == null)) {
                    state.resultsBuffer = this.bufferMgr.createTupleBuffer(state.processor.getOutputElements(), this.getContext().getConnectionId(), BufferManager.TupleSourceType.PROCESSOR);
                }
                this.currentState = state;
            }
            this.currentState.ts.hasNext();
            if (procAssignments != null) {
                while (this.currentState.ts.hasNext()) {
                    if (this.currentState.currentRow != null && this.currentState.resultsBuffer != null) {
                        this.currentState.resultsBuffer.addTuple(this.currentState.currentRow.subList(0, this.currentState.resultsBuffer.getSchema().size()));
                        this.currentState.currentRow = null;
                    }
                    this.currentState.currentRow = this.currentState.ts.nextTuple();
                }
                Assertion.assertTrue((this.currentState.currentRow != null ? 1 : 0) != 0);
                for (Map.Entry<ElementSymbol, ElementSymbol> entry : procAssignments.entrySet()) {
                    if (entry.getValue() == null || !this.metadata.elementSupports(entry.getValue().getMetadataID(), 5)) continue;
                    int index = this.currentState.processor.getOutputElements().indexOf(entry.getKey());
                    this.getCurrentVariableContext().setValue(entry.getValue(), DataTypeManager.transformValue(this.currentState.currentRow.get(index), entry.getValue().getType()));
                }
            } else if (this.currentState.resultsBuffer != null) {
                while (this.currentState.ts.hasNext()) {
                    List<?> tuple = this.currentState.ts.nextTuple();
                    this.currentState.resultsBuffer.addTuple(tuple);
                }
                this.getCurrentVariableContext().setValue(ROWCOUNT, 0);
            } else if (mode == CreateCursorResultSetInstruction.Mode.UPDATE) {
                List<?> t = this.currentState.ts.nextTuple();
                if (this.currentState.ts.hasNext()) {
                    throw new AssertionError((Object)"Invalid update count result - more than 1 row returned");
                }
                this.removeState(this.currentState);
                this.currentState = null;
                int rowCount = 0;
                if (t != null) {
                    rowCount = (Integer)t.get(0);
                }
                this.getCurrentVariableContext().setValue(ROWCOUNT, rowCount);
                return;
            }
            if (rsName == null && mode == CreateCursorResultSetInstruction.Mode.NOHOLD) {
                while (this.currentState.ts.hasNext()) {
                    this.currentState.ts.nextTuple();
                }
                this.currentState = null;
                this.getCurrentVariableContext().setValue(ROWCOUNT, 0);
                return;
            }
            if (this.currentState.resultsBuffer != null) {
                this.currentState.resultsBuffer.close();
                this.currentState.ts = this.currentState.resultsBuffer.createIndexedTupleSource(true);
            }
            if ((old = (CursorState)this.cursorStates.setValue(rsName, this.currentState)) != null) {
                this.removeState(old);
            }
            this.currentState = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pop(boolean success) throws TeiidComponentException {
        block8: {
            this.evaluator.close();
            Program program = this.programs.pop();
            VariableContext vc = this.currentVarContext;
            VariableContext cs = this.cursorStates;
            try {
                this.currentVarContext = this.currentVarContext.getParentContext();
                this.cursorStates = this.cursorStates.getParentContext();
                program.getTempTableStore().removeTempTables();
                this.getContext().setTempTableStore(this.getTempTableStore());
                if (!program.startedTxn()) break block8;
                TransactionService ts = this.getContext().getTransactionServer();
                TransactionContext tc = this.blockContext;
                this.blockContext = null;
                try {
                    ts.resume(tc);
                    for (WeakReference weakReference : this.txnTupleSources) {
                        DataTierTupleSource dtts = (DataTierTupleSource)weakReference.get();
                        if (dtts == null) continue;
                        dtts.fullyCloseSource();
                    }
                    this.txnTupleSources.clear();
                    if (success) {
                        ts.commit(tc);
                    } else {
                        ts.rollback(tc);
                    }
                }
                catch (XATransactionException e) {
                    throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30165, (Throwable)e);
                }
            }
            finally {
                this.removeAllCursors(cs);
            }
        }
    }

    private void removeAllCursors(VariableContext cs) {
        for (Map.Entry<Object, Object> entry : cs.getVariableMap().entrySet()) {
            this.removeState((CursorState)entry.getValue());
        }
    }

    public void push(Program program) throws XATransactionException {
        TransactionContext tc;
        this.evaluator.close();
        program.reset(this.getContext().getConnectionId());
        program.setTrappingExceptions(program.getExceptionGroup() != null || !this.programs.isEmpty() && this.programs.peek().isTrappingExceptions());
        TempTableStore tts = this.getTempTableStore();
        this.getContext().setTempTableStore(program.getTempTableStore());
        program.getTempTableStore().setParentTempTableStore(tts);
        this.programs.push(program);
        VariableContext context = new VariableContext(true);
        context.setParentContext(this.currentVarContext);
        this.currentVarContext = context;
        VariableContext cc = new VariableContext(true);
        cc.setParentContext(this.cursorStates);
        this.cursorStates = cc;
        if (program.isAtomic() && this.blockContext == null && (tc = this.getContext().getTransactionContext()) != null && tc.getTransactionType() == TransactionContext.Scope.NONE) {
            this.getContext().getTransactionServer().begin(tc);
            this.blockContext = tc;
            program.setStartedTxn(true);
        }
    }

    public void incrementProgramCounter() throws TeiidComponentException {
        if (this.programs.isEmpty()) {
            return;
        }
        Program program = this.peek();
        ProgramInstruction instr = program.getCurrentInstruction();
        if (instr instanceof RepeatedInstruction) {
            RepeatedInstruction repeated = (RepeatedInstruction)((Object)instr);
            repeated.postInstruction(this);
        }
        this.peek().incrementProgramCounter();
    }

    public List<?> getCurrentRow(String rsName) throws TeiidComponentException {
        return this.getCursorState((String)rsName).currentRow;
    }

    public boolean iterateCursor(String rsName) throws TeiidComponentException, TeiidProcessingException {
        CursorState state = this.getCursorState(rsName);
        state.currentRow = state.ts.nextTuple();
        return state.currentRow != null;
    }

    private CursorState getCursorState(String rsKey) throws TeiidComponentException {
        CursorState state = (CursorState)this.cursorStates.getValue(rsKey);
        if (state == null) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30166, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30166, new Object[]{rsKey}));
        }
        return state;
    }

    public void removeResults(String rsName) {
        CursorState state = (CursorState)this.cursorStates.remove(rsName);
        this.removeState(state);
    }

    private void removeState(CursorState state) {
        if (state != null) {
            state.processor.closeProcessing();
            if (state.resultsBuffer != null) {
                state.resultsBuffer.remove();
            }
        }
    }

    public List getSchema(String rsName) throws TeiidComponentException {
        CursorState cursorState = this.getCursorState(rsName);
        List schema = cursorState.processor.getOutputElements();
        return schema;
    }

    public boolean resultSetExists(String rsName) {
        return this.cursorStates.containsVariable(rsName);
    }

    @Override
    public CommandContext getContext() {
        CommandContext context = super.getContext();
        if (this.evaluatedParams) {
            context.setVariableContext(this.currentVarContext);
        }
        return context;
    }

    @Override
    public List getOutputElements() {
        return this.outputElements;
    }

    public void setOutputElements(List outputElements) {
        this.outputElements = outputElements;
    }

    public TempTableStore getTempTableStore() {
        if (this.programs.isEmpty()) {
            if (this.runInContext) {
                return this.getContext().getTempTableStore();
            }
            return null;
        }
        return this.peek().getTempTableStore();
    }

    boolean evaluateCriteria(Criteria condition) throws BlockedException, TeiidProcessingException, TeiidComponentException {
        this.evaluator.initialize(this.getContext(), this.getDataManager());
        return this.evaluator.evaluate(condition, Collections.emptyList());
    }

    Object evaluateExpression(Expression expression) throws BlockedException, TeiidProcessingException, TeiidComponentException {
        this.evaluator.initialize(this.getContext(), this.getDataManager());
        return this.evaluator.evaluate(expression, Collections.emptyList());
    }

    public Program peek() {
        if (this.programs.isEmpty()) {
            return null;
        }
        return this.programs.peek();
    }

    public void setRequiresTransaction(boolean requiresTransaction) {
        this.requiresTransaction = requiresTransaction;
    }

    @Override
    public boolean requiresTransaction(boolean transactionalReads) {
        return this.requiresTransaction || transactionalReads;
    }

    public void setRunInContext(boolean runInContext) {
        this.runInContext = runInContext;
    }

    @Override
    public TupleSource registerRequest(CommandContext context, Command command, String modelName, RegisterRequestParameter parameterObject) throws TeiidComponentException, TeiidProcessingException {
        TupleSource ts = this.parentDataMrg.registerRequest(context, command, modelName, parameterObject);
        if (this.blockContext != null && ts instanceof DataTierTupleSource) {
            this.txnTupleSources.add(new WeakReference<DataTierTupleSource>((DataTierTupleSource)ts));
        }
        return ts;
    }

    @Override
    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return this.parentDataMrg.lookupCodeValue(context, codeTableName, returnElementName, keyElementName, keyValue);
    }

    @Override
    public EventDistributor getEventDistributor() {
        return this.parentDataMrg.getEventDistributor();
    }

    static {
        ROWCOUNT.setType(DataTypeManager.DefaultDataClasses.INTEGER);
    }

    private static class CursorState {
        QueryProcessor processor;
        IndexedTupleSource ts;
        List<?> currentRow;
        TupleBuffer resultsBuffer;
        public boolean returning;
        public boolean usesLocalTemp;

        private CursorState() {
        }
    }
}

