/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.StringUtil;

public class TestStringUtil {
    public void helpTestComputeDisplayableForm(String input, String expectedResult) {
        String result = StringUtil.computeDisplayableForm((String)input, (String)input);
        Assert.assertEquals((String)"Unexpected ComputeDisplayableForm result", (Object)expectedResult, (Object)result);
    }

    public void helpTestComputePluralForm(String input, String expectedResult) {
        String result = StringUtil.computePluralForm((String)input);
        Assert.assertEquals((String)"Unexpected ComputePluralForm result", (Object)expectedResult, (Object)result);
    }

    public void helpTestJoin(List input, String delimiter, String expectedResult) {
        String result = StringUtil.join((Collection)input, (String)delimiter);
        Assert.assertEquals((String)"Unexpected Join result", (Object)expectedResult, (Object)result);
    }

    public void helpTestReplace(String source, String search, String replace, String expectedResult) {
        String result = StringUtil.replace((String)source, (String)search, (String)replace);
        Assert.assertEquals((String)"Unexpected Replace result", (Object)expectedResult, (Object)result);
    }

    public void helpTestReplaceAll(String source, String search, String replace, String expectedResult) {
        String result = StringUtil.replaceAll((String)source, (String)search, (String)replace);
        Assert.assertEquals((String)"Unexpected ReplaceAll result", (Object)expectedResult, (Object)result);
    }

    public void helpTestTruncString(String input, int length, String expectedResult) {
        String result = StringUtil.truncString((String)input, (int)length);
        Assert.assertEquals((String)"Unexpected TruncString result", (Object)expectedResult, (Object)result);
    }

    @Test
    public void testComputeDisplayableForm1() {
        this.helpTestComputeDisplayableForm("testString", "Test String");
    }

    @Test
    public void testComputeDisplayableForm2() {
        this.helpTestComputeDisplayableForm("TEST STRING", "TEST STRING");
    }

    @Test
    public void testComputeDisplayableForm3() {
        this.helpTestComputeDisplayableForm("TestSTRING", "Test STRING");
    }

    @Test
    public void testComputeDisplayableForm4() {
        this.helpTestComputeDisplayableForm("MetaMatrix", "Meta Matrix");
    }

    @Test
    public void testComputeDisplayableForm5() {
        this.helpTestComputeDisplayableForm("metaMatrix", "Meta Matrix");
    }

    @Test
    public void testComputeDisplayableForm6() {
        this.helpTestComputeDisplayableForm("Metamatrix", "Metamatrix");
    }

    @Test
    public void testComputeDisplayableForm7() {
        this.helpTestComputeDisplayableForm("SomeMetaMatrixEmbedded", "Some Meta Matrix Embedded");
    }

    @Test
    public void testComputeDisplayableForm8() {
        this.helpTestComputeDisplayableForm("SomeMetaMetaMatrixMetaEmbedded", "Some Meta Meta Matrix Meta Embedded");
    }

    @Test
    public void testComputeDisplayableForm9() {
        this.helpTestComputeDisplayableForm("SomemetaMatrixMetaMatrixMetaEmbedded", "Somemeta Matrix Meta Matrix Meta Embedded");
    }

    @Test
    public void testComputePluralForm1() {
        this.helpTestComputePluralForm("Test", "Tests");
    }

    @Test
    public void testComputePluralForm2() {
        this.helpTestComputePluralForm("ss", "sses");
    }

    @Test
    public void testComputePluralForm3() {
        this.helpTestComputePluralForm("x", "xes");
    }

    @Test
    public void testComputePluralForm4() {
        this.helpTestComputePluralForm("ch", "ches");
    }

    @Test
    public void testComputePluralForm5() {
        this.helpTestComputePluralForm("zy", "zies");
    }

    @Test
    public void testComputePluralForm6() {
        this.helpTestComputePluralForm("ay", "ays");
    }

    @Test
    public void testComputePluralForm7() {
        this.helpTestComputePluralForm("ey", "eys");
    }

    @Test
    public void testComputePluralForm8() {
        this.helpTestComputePluralForm("iy", "iys");
    }

    @Test
    public void testComputePluralForm9() {
        this.helpTestComputePluralForm("oy", "oys");
    }

    @Test
    public void testComputePluralForm10() {
        this.helpTestComputePluralForm("uy", "uys");
    }

    @Test
    public void testComputePluralForm11() {
        this.helpTestComputePluralForm("any", "anys");
    }

    @Test
    public void testComputePluralForm12() {
        this.helpTestComputePluralForm("classes", "classes");
    }

    @Test
    public void testJoin1() {
        ArrayList<String> input = new ArrayList<String>();
        input.add("One");
        input.add("Two");
        this.helpTestJoin(input, null, null);
    }

    @Test
    public void testJoin2() {
        this.helpTestJoin(null, "/", null);
    }

    @Test
    public void testJoin3() {
        ArrayList<String> input = new ArrayList<String>();
        input.add("One");
        input.add("Two");
        this.helpTestJoin(input, "/", "One/Two");
    }

    @Test
    public void testReplace1() {
        this.helpTestReplace("12225", null, "234", "12225");
    }

    @Test
    public void testReplace2() {
        this.helpTestReplace("12225", "222", null, "12225");
    }

    @Test
    public void testReplace3() {
        this.helpTestReplace("12225", "222", "234", "12345");
    }

    @Test
    public void testReplaceAll() {
        this.helpTestReplaceAll("1121121112", "2", "1", "1111111111");
    }

    @Test
    public void testTruncString() {
        this.helpTestTruncString("123456", 5, "12345");
    }

    @Test
    public void testGetStackTrace() {
        String expectedStackTrace = "java.lang.RuntimeException: Test";
        RuntimeException t = new RuntimeException("Test");
        String trace = StringUtil.getStackTrace((Throwable)t);
        if (!trace.startsWith("java.lang.RuntimeException: Test")) {
            Assert.fail((String)("Stack trace: \n" + trace + "\n did not match expected stack trace: \n" + "java.lang.RuntimeException: Test"));
        }
    }

    @Test
    public void testToString() {
        Object[] input = new String[]{"string1", "string2", "string3"};
        String output = StringUtil.toString((Object[])input);
        Assert.assertEquals((Object)"[string1,string2,string3]", (Object)output);
    }

    @Test
    public void testGetTokens() {
        String input = "string with; tokens ; delimited by ; ; semicolons; there;; are 7 tokens.";
        List tokens = StringUtil.getTokens((String)"string with; tokens ; delimited by ; ; semicolons; there;; are 7 tokens.", (String)";");
        Assert.assertEquals((long)7L, (long)tokens.size());
        Assert.assertEquals((Object)"string with", tokens.get(0));
        Assert.assertEquals((Object)" tokens ", tokens.get(1));
        Assert.assertEquals((Object)" delimited by ", tokens.get(2));
        Assert.assertEquals((Object)" ", tokens.get(3));
        Assert.assertEquals((Object)" semicolons", tokens.get(4));
        Assert.assertEquals((Object)" there", tokens.get(5));
        Assert.assertEquals((Object)" are 7 tokens.", tokens.get(6));
    }

    @Test
    public void testIndexOfIgnoreCase() {
        String text = "test";
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase(null, (String)text));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)"", (String)text));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)text, null));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)text, (String)""));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfIgnoreCase((String)text, (String)"testing"));
        Assert.assertEquals((long)1L, (long)StringUtil.indexOfIgnoreCase((String)text, (String)"es"));
        Assert.assertEquals((long)1L, (long)StringUtil.indexOfIgnoreCase((String)text, (String)"Es"));
        Assert.assertEquals((long)1L, (long)StringUtil.indexOfIgnoreCase((String)text, (String)"eS"));
        Assert.assertEquals((long)2L, (long)StringUtil.indexOfIgnoreCase((String)text, (String)"ST"));
    }

    @Test
    public void testStartsWithIgnoreCase() {
        String text = "test";
        Assert.assertEquals((Object)false, (Object)StringUtil.startsWithIgnoreCase(null, (String)text));
        Assert.assertEquals((Object)false, (Object)StringUtil.startsWithIgnoreCase((String)"", (String)text));
        Assert.assertEquals((Object)false, (Object)StringUtil.startsWithIgnoreCase((String)text, null));
        Assert.assertEquals((Object)true, (Object)StringUtil.startsWithIgnoreCase((String)text, (String)""));
        Assert.assertEquals((Object)false, (Object)StringUtil.startsWithIgnoreCase((String)text, (String)"testing"));
        Assert.assertEquals((Object)false, (Object)StringUtil.startsWithIgnoreCase((String)text, (String)"es"));
        Assert.assertEquals((Object)true, (Object)StringUtil.startsWithIgnoreCase((String)text, (String)"te"));
        Assert.assertEquals((Object)true, (Object)StringUtil.startsWithIgnoreCase((String)text, (String)"Te"));
        Assert.assertEquals((Object)true, (Object)StringUtil.startsWithIgnoreCase((String)text, (String)"tE"));
        Assert.assertEquals((Object)true, (Object)StringUtil.startsWithIgnoreCase((String)text, (String)"TE"));
    }

    @Test
    public void testEndsWithIgnoreCase() {
        String text = "test";
        Assert.assertEquals((Object)false, (Object)StringUtil.endsWithIgnoreCase(null, (String)text));
        Assert.assertEquals((Object)false, (Object)StringUtil.endsWithIgnoreCase((String)"", (String)text));
        Assert.assertEquals((Object)false, (Object)StringUtil.endsWithIgnoreCase((String)text, null));
        Assert.assertEquals((Object)true, (Object)StringUtil.endsWithIgnoreCase((String)text, (String)""));
        Assert.assertEquals((Object)false, (Object)StringUtil.endsWithIgnoreCase((String)text, (String)"testing"));
        Assert.assertEquals((Object)false, (Object)StringUtil.endsWithIgnoreCase((String)text, (String)"es"));
        Assert.assertEquals((Object)true, (Object)StringUtil.endsWithIgnoreCase((String)text, (String)"st"));
        Assert.assertEquals((Object)true, (Object)StringUtil.endsWithIgnoreCase((String)text, (String)"St"));
        Assert.assertEquals((Object)true, (Object)StringUtil.endsWithIgnoreCase((String)text, (String)"sT"));
        Assert.assertEquals((Object)true, (Object)StringUtil.endsWithIgnoreCase((String)text, (String)"ST"));
    }

    @Test
    public void testIsDigits() {
        Assert.assertTrue((boolean)StringUtil.isDigits((String)"012872"));
        Assert.assertTrue((boolean)StringUtil.isDigits((String)"634644"));
        Assert.assertFalse((boolean)StringUtil.isDigits((String)"A634644"));
        Assert.assertFalse((boolean)StringUtil.isDigits((String)"634A644"));
    }

    @Test
    public void testToFixedLengthNull() {
        Assert.assertEquals((Object)"    ", (Object)StringUtil.toFixedLength(null, (int)4));
    }

    @Test
    public void testToFixedLengthPad() {
        Assert.assertEquals((Object)"a   ", (Object)StringUtil.toFixedLength((String)"a", (int)4));
    }

    @Test
    public void testToFixedLengthNoChange() {
        Assert.assertEquals((Object)"abcd", (Object)StringUtil.toFixedLength((String)"abcd", (int)4));
    }

    @Test
    public void testToFixedLengthChop() {
        Assert.assertEquals((Object)"abcd", (Object)StringUtil.toFixedLength((String)"abcdefgh", (int)4));
    }

    @Test
    public void testIsLetter() {
        Assert.assertTrue((boolean)StringUtil.isLetter((char)'a'));
        Assert.assertTrue((boolean)StringUtil.isLetter((char)'A'));
        Assert.assertFalse((boolean)StringUtil.isLetter((char)'5'));
        Assert.assertFalse((boolean)StringUtil.isLetter((char)'_'));
        Assert.assertTrue((boolean)StringUtil.isLetter((char)'\u00cf'));
        Assert.assertFalse((boolean)StringUtil.isLetter((char)'\u0967'));
        Assert.assertTrue((boolean)StringUtil.isLetter((char)'\u0905'));
    }

    @Test
    public void testIsDigit() {
        Assert.assertFalse((boolean)StringUtil.isDigit((char)'a'));
        Assert.assertFalse((boolean)StringUtil.isDigit((char)'A'));
        Assert.assertTrue((boolean)StringUtil.isDigit((char)'5'));
        Assert.assertFalse((boolean)StringUtil.isDigit((char)'_'));
        Assert.assertFalse((boolean)StringUtil.isDigit((char)'\u00cf'));
        Assert.assertTrue((boolean)StringUtil.isDigit((char)'\u0967'));
        Assert.assertFalse((boolean)StringUtil.isDigit((char)'\u0905'));
    }

    @Test
    public void testIsLetterOrDigit() {
        Assert.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'a'));
        Assert.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'A'));
        Assert.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'5'));
        Assert.assertFalse((boolean)StringUtil.isLetterOrDigit((char)'_'));
        Assert.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'\u00cf'));
        Assert.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'\u0967'));
        Assert.assertTrue((boolean)StringUtil.isLetterOrDigit((char)'\u0905'));
    }

    @Test
    public void testCreateFileName() {
        Assert.assertEquals((Object)"ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890", (Object)StringUtil.createFileName((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890"));
        Assert.assertEquals((Object)"http:__www.metamatrix.com_parm1=test;parm2=testy2", (Object)StringUtil.createFileName((String)"http://www.metamatrix.com?parm1=test;parm2=testy2"));
    }

    @Test
    public void testGetFirstToken() {
        Assert.assertEquals((Object)"/foo/bar", (Object)StringUtil.getFirstToken((String)"/foo/bar.vdb", (String)"."));
        Assert.assertEquals((Object)"", (Object)StringUtil.getFirstToken((String)"/foo/bar.vdb", (String)"/"));
        Assert.assertEquals((Object)"/foo", (Object)StringUtil.getFirstToken((String)"/foo./bar.vdb", (String)"."));
        Assert.assertEquals((Object)"bar", (Object)StringUtil.getFirstToken((String)StringUtil.getLastToken((String)"/foo/bar.vdb", (String)"/"), (String)"."));
        Assert.assertEquals((Object)"vdb", (Object)StringUtil.getLastToken((String)"/foo/bar.vdb", (String)"."));
    }

    @Test
    public void testValueOf() throws Exception {
        Assert.assertEquals((Object)21, (Object)StringUtil.valueOf((String)"21", Integer.class));
        Assert.assertEquals((Object)true, (Object)StringUtil.valueOf((String)"true", Boolean.class));
        Assert.assertEquals((Object)"Foo", (Object)StringUtil.valueOf((String)"Foo", String.class));
        Assert.assertEquals((Object)Float.valueOf(10.12f), (Object)StringUtil.valueOf((String)"10.12", Float.class));
        Assert.assertEquals((Object)121.123, (Object)StringUtil.valueOf((String)"121.123", Double.class));
        Assert.assertEquals((Object)12334567L, (Object)StringUtil.valueOf((String)"12334567", Long.class));
        Assert.assertEquals((Object)21, (Object)StringUtil.valueOf((String)"21", Short.class));
        List list = (List)StringUtil.valueOf((String)"foo,bar,x,y,z", List.class);
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("foo"));
        Assert.assertTrue((boolean)list.contains("x"));
        int[] values = (int[])StringUtil.valueOf((String)"1,2,3,4,5", new int[0].getClass());
        Assert.assertEquals((long)5L, (long)values.length);
        Assert.assertEquals((long)5L, (long)values[4]);
        Map m = (Map)StringUtil.valueOf((String)"foo=bar,x=,y=z", Map.class);
        Assert.assertEquals((long)3L, (long)m.size());
        Assert.assertEquals(m.get("foo"), (Object)"bar");
        Assert.assertEquals(m.get("x"), (Object)"");
        Assert.assertEquals((Object)((Object)EnumTest.HELLO), (Object)StringUtil.valueOf((String)"HELLO", EnumTest.class));
        Assert.assertEquals((Object)new URL("http://teiid.org"), (Object)StringUtil.valueOf((String)"http://teiid.org", URL.class));
    }

    public static enum EnumTest {
        HELLO,
        WORLD;

    }
}

