/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.testcases;

import java.util.ArrayList;
import org.junit.Test;
import org.teiid.test.framework.TransactionContainer;
import org.teiid.test.framework.TransactionQueryTestCase;
import org.teiid.test.framework.query.AbstractQueryTransactionTest;
import org.teiid.test.framework.query.QueryExecution;
import org.teiid.test.framework.transaction.TxnAutoTransaction;
import org.teiid.test.testcases.CommonTransactionTests;

public class AutoWrapTransactionTests
extends CommonTransactionTests {
    @Override
    protected TransactionContainer getTransactionContainter() {
        return new TxnAutoTransaction("DETECT");
    }

    @Test
    public void testSingleSourceMultipleCommandsReferentialIntegrityRollback() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourceMultipleCommandsReferentialIntegrityRollback"){

            public void testCase() throws Exception {
                for (int i = 200; i < 210; ++i) {
                    Integer val = new Integer(i);
                    this.execute("insert into pm1.g1 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm1.g2 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                }
                this.execute("insert into pm1.g2 (e1, e2) values(?,?)", new Object[]{new Integer(9999), "9999"});
            }

            public boolean exceptionExpected() {
                return true;
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 200 and e1 < 210");
        test.assertRowCount(10);
        test.execute("select * from g2 where e1 = 9999");
        test.assertRowCount(0);
    }

    @Test
    public void testSingleSourceBatchCommandReferentialIntegrityRollback() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourceBatchCommandReferentialIntegrityRollback"){

            public void testCase() throws Exception {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 200; i < 210; ++i) {
                    list.add("insert into pm1.g1 (e1, e2) values(" + i + ",'" + i + "')");
                }
                list.add("insert into pm1.g2 (e1, e2) values(9999,'9999')");
                this.executeBatch(list.toArray(new String[list.size()]));
            }

            public boolean exceptionExpected() {
                return true;
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 200 and e1 < 210");
        test.assertRowCount(0);
        test.execute("select * from g2 where e1 = 9999");
        test.assertRowCount(0);
    }

    @Test
    public void testMultipleSourceBulkRowInsertRollback() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceBulkRowInsertRollback"){
            ArrayList list;
            {
                this.list = new ArrayList();
            }

            public void testCase() throws Exception {
                for (int i = 100; i < 120; ++i) {
                    this.list.add("insert into vm.g1 (pm1e1, pm1e2, pm2e1, pm2e2) values(" + i + ",'" + i + "'," + i + ",'" + i + "')");
                }
                this.list.add("select pm1.g1.e1, pm1.g1.e2 into pm2.g2 from pm1.g1 where pm1.g1.e1 >= 100");
                this.list.add("insert into pm1.g2 (e1, e2) values(9999,'9999')");
                this.executeBatch(this.list.toArray(new String[this.list.size()]));
            }

            public boolean exceptionExpected() {
                return true;
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 100 and e1 < 120");
        test.assertRowCount(0);
        test = new QueryExecution(userTxn.getSource("pm2"));
        test.execute("select * from g1 where e1 >= 100 and e1 < 120");
        test.assertRowCount(0);
        test.execute("select * from g2 where e1 >= 100 and e1 < 120");
        test.assertRowCount(0);
    }
}

