/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.netty.handler.codec.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.AccessibleBufferedInputStream;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.netty.handler.codec.serialization.ObjectDecoderInputStream;
import org.teiid.netty.handler.codec.serialization.ObjectEncoderOutputStream;

public class TestObjectDecoderInputStream {
    @Test
    public void testTimeoutException() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectEncoderOutputStream oeos = new ObjectEncoderOutputStream(new DataOutputStream(baos), 512);
        List<Integer> obj = Arrays.asList(1, 2, 3);
        oeos.writeObject(obj);
        oeos.close();
        final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStream is = new InputStream(){
            int count;

            @Override
            public int read() throws IOException {
                if (this.count++ % 2 == 0) {
                    throw new SocketTimeoutException();
                }
                return bais.read();
            }
        };
        ObjectDecoderInputStream odis = new ObjectDecoderInputStream(new AccessibleBufferedInputStream(is, 1024), Thread.currentThread().getContextClassLoader(), 1024);
        Object result = null;
        do {
            try {
                result = odis.readObject();
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (result == null);
        Assert.assertEquals(obj, (Object)result);
    }

    @Test
    public void testReplaceObject() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectEncoderOutputStream out = new ObjectEncoderOutputStream(new DataOutputStream(baos), 512);
        ClobImpl clob = new ClobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return new ReaderInputStream((Reader)new StringReader("Clob contents"), Charset.forName("UTF-8"));
            }
        }, -1L);
        out.writeObject((Object)clob);
        ObjectDecoderInputStream in = new ObjectDecoderInputStream(new AccessibleBufferedInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), 1024), Thread.currentThread().getContextClassLoader(), 1024);
        Object result = in.readObject();
        Assert.assertTrue((boolean)(result instanceof ClobImpl));
    }
}

