/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.activation.DataSource;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.teiid.GeometryInputSource;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.ResizingArrayList;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.StandardXMLTranslator;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.ProcedureBatchHandler;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.dqp.internal.process.SaveOnReadInputStream;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.language.BatchedCommand;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Call;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;
import org.teiid.resource.spi.WrappedConnection;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.ReusableExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.util.XMLInputStream;

public class ConnectorWorkItem
implements ConnectorWork {
    private AtomicRequestID id;
    private ConnectorManager manager;
    private AtomicRequestMessage requestMsg;
    private ExecutionFactory<Object, Object> connector;
    private RuntimeMetadataImpl queryMetadata;
    private Object connection;
    private Object connectionFactory;
    private ExecutionContextImpl securityContext;
    private volatile ResultSetExecution execution;
    private ProcedureBatchHandler procedureBatchHandler;
    private int expectedColumns;
    private boolean lastBatch;
    private int rowCount;
    private boolean error;
    private AtomicBoolean isCancelled = new AtomicBoolean();
    private org.teiid.language.Command translatedCommand;
    private DataNotAvailableException dnae;
    private FileStore lobStore;
    private byte[] lobBuffer;
    private boolean[] convertToRuntimeType;
    private boolean[] convertToDesiredRuntimeType;
    private boolean[] isLob;
    private Class<?>[] schema;
    private boolean explicitClose;
    private boolean copyLobs;
    private boolean areLobsUsableAfterClose;
    private TeiidException conversionError;

    ConnectorWorkItem(AtomicRequestMessage message, ConnectorManager manager) throws TeiidComponentException {
        this.id = message.getAtomicRequestID();
        this.requestMsg = message;
        this.manager = manager;
        AtomicRequestID requestID = this.requestMsg.getAtomicRequestID();
        this.securityContext = new ExecutionContextImpl(message.getCommandContext(), this.requestMsg.getConnectorName(), Integer.toString(requestID.getNodeID()), Integer.toString(requestID.getExecutionId()));
        SourceHint hint = message.getCommand().getSourceHint();
        if (hint != null) {
            this.securityContext.setGeneralHints(hint.getGeneralHints());
            this.securityContext.setHints(hint.getSpecificHint(message.getConnectorName()).getHints());
        }
        this.securityContext.setBatchSize(this.requestMsg.getFetchSize());
        this.securityContext.setSession((Session)this.requestMsg.getWorkContext().getSession());
        this.connector = manager.getExecutionFactory();
        VDBMetaData vdb = this.requestMsg.getWorkContext().getVDB();
        QueryMetadataInterface qmi = (QueryMetadataInterface)vdb.getAttachment(QueryMetadataInterface.class);
        qmi = new TempMetadataAdapter(qmi, new TempMetadataStore());
        this.queryMetadata = new RuntimeMetadataImpl(qmi);
        this.securityContext.setRuntimeMetadata(this.queryMetadata);
        this.securityContext.setTransactional(this.requestMsg.isTransactional());
        LanguageBridgeFactory factory = new LanguageBridgeFactory(this.queryMetadata);
        factory.setConvertIn(!this.connector.supportsInCriteria());
        factory.setMaxInPredicateSize(this.connector.getMaxInCriteriaSize());
        try {
            factory.setSupportsConcat2(manager.getCapabilities().supportsFunction("concat2"));
        }
        catch (TranslatorException e) {
            throw new TeiidComponentException((Throwable)e);
        }
        this.translatedCommand = factory.translate(message.getCommand());
        List<Expression> symbols = this.requestMsg.getCommand().getProjectedSymbols();
        this.schema = new Class[symbols.size()];
        this.convertToDesiredRuntimeType = new boolean[symbols.size()];
        this.convertToRuntimeType = new boolean[symbols.size()];
        this.isLob = new boolean[symbols.size()];
        for (int i = 0; i < symbols.size(); ++i) {
            Expression symbol = symbols.get(i);
            this.schema[i] = symbol.getType();
            this.convertToDesiredRuntimeType[i] = true;
            this.convertToRuntimeType[i] = true;
            this.isLob[i] = DataTypeManager.isLOB(this.schema[i]);
        }
        this.areLobsUsableAfterClose = this.connector.areLobsUsableAfterClose();
        this.copyLobs = this.connector.isCopyLobs();
    }

    @Override
    public AtomicRequestID getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        try {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Processing CANCEL request"});
            if (this.isCancelled.compareAndSet(false, true)) {
                this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.CANCEL, -1);
                if (this.execution != null) {
                    this.execution.cancel();
                }
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)QueryPlugin.Util.getString("DQPCore.The_atomic_request_has_been_cancelled", new Object[]{this.id}));
            }
        }
        catch (TranslatorException e) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30024, new Object[]{this.id}));
        }
    }

    @Override
    public synchronized AtomicResultsMessage more() throws TranslatorException {
        if (this.dnae != null) {
            DataNotAvailableException e = this.dnae;
            this.dnae = null;
            throw e;
        }
        if (this.conversionError != null) {
            throw this.handleError(this.conversionError);
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Processing MORE request"});
        try {
            return this.handleBatch();
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void close() {
        block16: {
            this.lobBuffer = null;
            if (this.lobStore != null) {
                this.lobStore.remove();
                this.lobStore = null;
            }
            if (!this.manager.removeState(this.id)) {
                return;
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Processing Close :", this.requestMsg.getCommand()});
            if (!this.error) {
                this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.END, this.rowCount);
            }
            if (this.execution != null) {
                this.execution.close();
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed execution"});
                if (this.execution instanceof ReusableExecution) {
                    this.requestMsg.getCommandContext().putReusableExecution(this.manager.getId(), (ReusableExecution)this.execution);
                }
            }
            if (this.connection == null) break block16;
            try {
                this.connector.closeConnection(this.connection, this.connectionFactory);
            }
            catch (Throwable e) {
                LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)e.getMessage());
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed connection"});
            break block16;
            catch (Throwable e) {
                try {
                    LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)e.getMessage());
                    if (this.connection == null) break block16;
                }
                catch (Throwable throwable) {
                    if (this.connection != null) {
                        try {
                            this.connector.closeConnection(this.connection, this.connectionFactory);
                        }
                        catch (Throwable e2) {
                            LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e2, (Object)e2.getMessage());
                        }
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed connection"});
                    }
                    throw throwable;
                }
                try {
                    this.connector.closeConnection(this.connection, this.connectionFactory);
                }
                catch (Throwable e3) {
                    LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e3, (Object)e3.getMessage());
                }
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed connection"});
            }
        }
    }

    private TranslatorException handleError(Throwable t) {
        if (t instanceof DataNotAvailableException) {
            throw (DataNotAvailableException)t;
        }
        this.error = true;
        if (t instanceof RuntimeException && t.getCause() != null) {
            t = t.getCause();
        }
        this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.ERROR, null);
        String msg = QueryPlugin.Util.getString("ConnectorWorker.process_failed", new Object[]{this.id});
        if (this.isCancelled.get()) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)msg);
        } else {
            Throwable toLog = t;
            if (this.requestMsg.getCommandContext().getOptions().isSanitizeMessages() && !LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR", (int)5)) {
                toLog = ExceptionUtil.sanitize((Throwable)toLog, (boolean)true);
            }
            if (toLog instanceof TranslatorException || toLog instanceof TeiidProcessingException) {
                LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)toLog, (Object)msg);
            } else {
                LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)toLog, (Object)msg);
            }
        }
        if (t instanceof TranslatorException) {
            return (TranslatorException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return new TranslatorException(t);
    }

    @Override
    public synchronized void execute() throws TranslatorException {
        if (this.isCancelled()) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30476, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30476, new Object[0]));
        }
        try {
            if (this.execution == null) {
                Execution exec;
                if (this.connection == null) {
                    block15: {
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.requestMsg.getAtomicRequestID(), "Processing NEW request:", this.requestMsg.getCommand()});
                        try {
                            this.connectionFactory = this.manager.getConnectionFactory();
                        }
                        catch (TranslatorException e) {
                            if (!this.connector.isSourceRequired()) break block15;
                            throw e;
                        }
                    }
                    if (this.connectionFactory != null) {
                        this.connection = this.connector.getConnection(this.connectionFactory, (ExecutionContext)this.securityContext);
                    }
                    if (this.connection == null && this.connector.isSourceRequired()) {
                        throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID31108, QueryPlugin.Util.getString("datasource_not_found", new Object[]{this.manager.getConnectionName()}));
                    }
                }
                Connection unwrapped = null;
                if (this.connection instanceof WrappedConnection) {
                    try {
                        unwrapped = ((WrappedConnection)this.connection).unwrap();
                    }
                    catch (ResourceException e) {
                        throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30477, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30477, new Object[0]));
                    }
                }
                Command command = this.requestMsg.getCommand();
                this.expectedColumns = command.getProjectedSymbols().size();
                if (command instanceof StoredProcedure) {
                    this.expectedColumns = ((StoredProcedure)command).getResultSetColumns().size();
                }
                if ((exec = this.requestMsg.getCommandContext().getReusableExecution(this.manager.getId())) != null) {
                    exec.reset(this.translatedCommand, (ExecutionContext)this.securityContext, this.connection);
                } else {
                    exec = this.connector.createExecution(this.translatedCommand, (ExecutionContext)this.securityContext, (RuntimeMetadata)this.queryMetadata, unwrapped == null ? this.connection : unwrapped);
                }
                this.setExecution(command, this.translatedCommand, exec);
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.requestMsg.getAtomicRequestID(), "Obtained execution"});
                this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.NEW, null);
            }
            this.execution.execute();
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Executed command"});
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    private void setExecution(Command command, org.teiid.language.Command translatedCommand, final Execution exec) {
        if (translatedCommand instanceof Call) {
            this.execution = (ResultSetExecution)Assertion.isInstanceOf((Object)exec, ProcedureExecution.class, (String)"Call Executions are expected to be ProcedureExecutions");
            StoredProcedure proc = (StoredProcedure)command;
            if (proc.returnParameters()) {
                this.procedureBatchHandler = new ProcedureBatchHandler((Call)translatedCommand, (ProcedureExecution)exec);
            }
        } else if (command instanceof QueryCommand) {
            this.execution = (ResultSetExecution)Assertion.isInstanceOf((Object)exec, ResultSetExecution.class, (String)"QueryExpression Executions are expected to be ResultSetExecutions");
        } else {
            final boolean singleUpdateCount = this.connector.returnsSingleUpdateCount() && (translatedCommand instanceof BatchedUpdates || translatedCommand instanceof BatchedCommand && ((BatchedCommand)translatedCommand).getParameterValues() != null);
            Assertion.isInstanceOf((Object)exec, UpdateExecution.class, (String)"Update Executions are expected to be UpdateExecutions");
            this.execution = new ResultSetExecution(){
                private int[] results;
                private int index;

                public void cancel() throws TranslatorException {
                    exec.cancel();
                }

                public void close() {
                    exec.close();
                }

                public void execute() throws TranslatorException {
                    exec.execute();
                }

                public List<?> next() throws TranslatorException, DataNotAvailableException {
                    if (this.results == null) {
                        this.results = ((UpdateExecution)exec).getUpdateCounts();
                    }
                    if (singleUpdateCount) {
                        if (this.index < this.results[0]) {
                            return CollectionTupleSource.UPDATE_ROW;
                        }
                        return null;
                    }
                    if (this.index < this.results.length) {
                        return Arrays.asList(this.results[this.index++]);
                    }
                    return null;
                }
            };
        }
    }

    protected AtomicResultsMessage handleBatch() throws TranslatorException {
        List<?> row;
        ResizingArrayList rows;
        block17: {
            int batchSize;
            Assertion.assertTrue((!this.lastBatch ? 1 : 0) != 0);
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Getting results from connector"});
            rows = new ResizingArrayList(batchSize / 4);
            try {
                for (batchSize = 0; batchSize < this.requestMsg.getFetchSize(); ++batchSize) {
                    row = this.execution.next();
                    if (row == null) {
                        this.lastBatch = true;
                        break;
                    }
                    if (row.size() != this.expectedColumns) {
                        throw new AssertionError((Object)("Inproper results returned.  Expected " + this.expectedColumns + " columns, but was " + row.size()));
                    }
                    try {
                        row = this.correctTypes(row);
                    }
                    catch (TeiidException e) {
                        this.conversionError = e;
                        break;
                    }
                    if (this.procedureBatchHandler != null) {
                        row = this.procedureBatchHandler.padRow(row);
                    }
                    ++this.rowCount;
                    rows.add(row);
                    if (this.requestMsg.getMaxResultRows() <= -1 || this.rowCount < this.requestMsg.getMaxResultRows()) continue;
                    if (this.rowCount != this.requestMsg.getMaxResultRows() || this.requestMsg.isExceptionOnMaxRows()) continue;
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Exceeded max, returning", this.requestMsg.getMaxResultRows()});
                    this.lastBatch = true;
                    break;
                }
            }
            catch (DataNotAvailableException e) {
                if (rows.size() == 0) {
                    throw e;
                }
                if (e.getWaitUntil() == null) break block17;
                this.dnae = e;
            }
        }
        if (this.lastBatch) {
            if (this.procedureBatchHandler != null && (row = this.procedureBatchHandler.getParameterRow()) != null) {
                try {
                    row = this.correctTypes(row);
                    rows.add(row);
                    ++this.rowCount;
                }
                catch (TeiidException e) {
                    this.lastBatch = false;
                    this.conversionError = e;
                }
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Obtained last batch, total row count:", this.rowCount});
        } else {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Obtained results from connector, current row count:", this.rowCount});
        }
        int currentRowCount = rows.size();
        if (!this.lastBatch && currentRowCount == 0) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30004, new Object[]{this.requestMsg.getConnectorName()}));
        }
        AtomicResultsMessage response = ConnectorWorkItem.createResultsMessage(rows.toArray(new List[currentRowCount]));
        response.setSupportsImplicitClose(!this.securityContext.keepExecutionAlive() && !this.explicitClose);
        response.setWarnings(this.securityContext.getWarnings());
        if (this.securityContext.getCacheDirective() != null) {
            response.setScope(this.securityContext.getCacheDirective().getScope());
        }
        if (this.lastBatch) {
            response.setFinalRow(this.rowCount);
        }
        return response;
    }

    public static AtomicResultsMessage createResultsMessage(List<?>[] batch) {
        return new AtomicResultsMessage(batch);
    }

    boolean isCancelled() {
        return this.isCancelled.get();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public boolean isDataAvailable() {
        return this.securityContext.isDataAvailable();
    }

    @Override
    public CacheDirective getCacheDirective() throws TranslatorException {
        CacheDirective cd = this.connector.getCacheDirective(this.translatedCommand, (ExecutionContext)this.securityContext, (RuntimeMetadata)this.queryMetadata);
        this.securityContext.setCacheDirective(cd);
        return cd;
    }

    @Override
    public boolean isForkable() {
        return this.connector.isForkable();
    }

    @Override
    public boolean isThreadBound() {
        return this.connector.isThreadBound();
    }

    private List<?> correctTypes(List row) throws TransformationException, TeiidComponentException {
        for (int i = 0; i < row.size(); ++i) {
            Object result;
            Object value = row.get(i);
            if (value == null) continue;
            if (this.convertToRuntimeType[i]) {
                result = ConnectorWorkItem.convertToRuntimeType(this.requestMsg.getBufferManager(), value, this.schema[i], this.requestMsg.getCommandContext());
                if (value == result && !DataTypeManager.DefaultDataClasses.OBJECT.equals(this.schema[i])) {
                    this.convertToRuntimeType[i] = false;
                } else {
                    if (!this.explicitClose && this.isLob[i] && !this.copyLobs && !this.areLobsUsableAfterClose && DataTypeManager.isLOB(result.getClass()) && DataTypeManager.isLOB(DataTypeManager.convertToRuntimeType(value, (boolean)false).getClass())) {
                        this.explicitClose = true;
                    }
                    row.set(i, result);
                    value = result;
                }
            }
            if (this.convertToDesiredRuntimeType[i]) {
                if (value == null) continue;
                result = DataTypeManager.transformValue(value, value.getClass(), this.schema[i]);
                if (this.isLob[i] && this.copyLobs) {
                    if (this.lobStore == null) {
                        this.lobStore = this.requestMsg.getBufferManager().createFileStore("lobs");
                        this.lobBuffer = new byte[16384];
                    }
                    this.requestMsg.getBufferManager().persistLob((Streamable)result, this.lobStore, this.lobBuffer);
                } else if (value == result) {
                    this.convertToDesiredRuntimeType[i] = false;
                    continue;
                }
                row.set(i, result);
                continue;
            }
            if (!DataTypeManager.isValueCacheEnabled()) continue;
            row.set(i, DataTypeManager.getCanonicalValue(value));
        }
        return row;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object convertToRuntimeType(BufferManager bm, Object value, Class<?> desiredType, CommandContext context) throws TransformationException {
        Source ss;
        InputStream is;
        if (desiredType != DataTypeManager.DefaultDataClasses.XML || !(value instanceof Source)) {
            if (value instanceof InputStreamFactory) {
                return new BlobType((Blob)new BlobImpl((InputStreamFactory)value));
            }
            if (value instanceof DataSource) {
                FileStore fs = bm.createFileStore("bytes");
                FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(fs, "UTF-8");
                try {
                    SaveOnReadInputStream is2 = new SaveOnReadInputStream(((DataSource)value).getInputStream(), fsisf);
                    if (context == null) return new BlobType((Blob)new BlobImpl(is2.getInputStreamFactory()));
                    context.addCreatedLob(fsisf);
                    return new BlobType((Blob)new BlobImpl(is2.getInputStreamFactory()));
                }
                catch (IOException e) {
                    throw new TransformationException((BundleUtil.Event)QueryPlugin.Event.TEIID30500, (Throwable)e, e.getMessage());
                }
            }
            if (value instanceof GeometryInputSource) {
                GeometryInputSource gis = (GeometryInputSource)value;
                try {
                    is = gis.getEwkb();
                    if (is != null) {
                        return GeometryUtils.geometryFromEwkb(is, gis.getSrid());
                    }
                }
                catch (Exception e) {
                    throw new TransformationException(e);
                }
                try {
                    Reader r = gis.getGml();
                    if (r != null) {
                        return GeometryUtils.geometryFromGml(r, gis.getSrid());
                    }
                }
                catch (Exception e) {
                    throw new TransformationException(e);
                }
            }
        }
        if (!(value instanceof Source)) return DataTypeManager.convertToRuntimeType((Object)value, (desiredType != DataTypeManager.DefaultDataClasses.OBJECT ? 1 : 0) != 0);
        if (value instanceof InputStreamFactory) return new XMLType((SQLXML)new SQLXMLImpl((InputStreamFactory)value));
        if (value instanceof StreamSource) {
            ss = (StreamSource)value;
            is = ((StreamSource)ss).getInputStream();
            Reader r = ((StreamSource)ss).getReader();
            if (is == null && r != null) {
                is = new ReaderInputStream(r, Streamable.CHARSET);
            }
            FileStore fs = bm.createFileStore("xml");
            FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(fs, "UTF-8");
            value = new SaveOnReadInputStream(is, fsisf).getInputStreamFactory();
            if (context == null) return new XMLType((SQLXML)new SQLXMLImpl((InputStreamFactory)value));
            context.addCreatedLob(fsisf);
            return new XMLType((SQLXML)new SQLXMLImpl((InputStreamFactory)value));
        }
        if (value instanceof StAXSource) {
            ss = (StAXSource)value;
            try {
                FileStore fs = bm.createFileStore("xml");
                FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(fs, "UTF-8");
                value = new SaveOnReadInputStream((InputStream)new XMLInputStream((StAXSource)ss, XMLSystemFunctions.getOutputFactory(true)), fsisf).getInputStreamFactory();
                if (context == null) return new XMLType((SQLXML)new SQLXMLImpl((InputStreamFactory)value));
                context.addCreatedLob(fsisf);
                return new XMLType((SQLXML)new SQLXMLImpl((InputStreamFactory)value));
            }
            catch (XMLStreamException e) {
                throw new TransformationException((Exception)e);
            }
        }
        StandardXMLTranslator sxt = new StandardXMLTranslator((Source)value);
        try {
            SQLXMLImpl sqlxml = XMLSystemFunctions.saveToBufferManager(bm, (XMLTranslator)sxt, context);
            return new XMLType((SQLXML)sqlxml);
        }
        catch (TeiidComponentException e) {
            throw new TransformationException((Exception)((Object)e));
        }
        catch (TeiidProcessingException e) {
            throw new TransformationException((Exception)((Object)e));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorWork)) {
            return false;
        }
        ConnectorWork other = (ConnectorWork)obj;
        return !(this.id == null ? other.getId() != null : !this.id.equals(other.getId()));
    }
}

