/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.translator.ExecutionFactory;

public class CapabilitiesConverter {
    private CapabilitiesConverter() {
    }

    public static SourceCapabilities convertCapabilities(ExecutionFactory srcCaps) {
        return CapabilitiesConverter.convertCapabilities(srcCaps, null);
    }

    public static BasicSourceCapabilities convertCapabilities(ExecutionFactory srcCaps, Object connectorID) {
        List pushDowns;
        List functions;
        BasicSourceCapabilities tgtCaps = new BasicSourceCapabilities();
        tgtCaps.setTranslator(srcCaps);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, srcCaps.supportsSelectExpression());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, srcCaps.supportsSelectDistinct());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, srcCaps.supportsAliasedTable());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, srcCaps.supportsInnerJoins());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, srcCaps.supportsSelfJoins(), SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, srcCaps.supportsOuterJoins());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, srcCaps.supportsFullOuterJoins());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, srcCaps.supportsInlineViews(), SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, srcCaps.supportsCompareCriteriaEquals());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, srcCaps.supportsCompareCriteriaOrdered());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, srcCaps.supportsLikeCriteria());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE, srcCaps.supportsLikeCriteriaEscapeCharacter(), SourceCapabilities.Capability.CRITERIA_LIKE);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, srcCaps.supportsInCriteria() || srcCaps.supportsCompareCriteriaEquals() && srcCaps.supportsOrCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, srcCaps.supportsInCriteriaSubquery());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ISNULL, srcCaps.supportsIsNullCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_OR, srcCaps.supportsOrCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, srcCaps.supportsNotCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_EXISTS, srcCaps.supportsExistsCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME, srcCaps.supportsQuantifiedCompareCriteriaSome());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_ALL, srcCaps.supportsQuantifiedCompareCriteriaAll());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, srcCaps.supportsOrderBy());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, srcCaps.supportsAggregatesSum());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, srcCaps.supportsAggregatesAvg());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MIN, srcCaps.supportsAggregatesMin());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, srcCaps.supportsAggregatesMax());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, srcCaps.supportsAggregatesCount());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, srcCaps.supportsAggregatesCountStar());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_DISTINCT, srcCaps.supportsAggregatesDistinct());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, srcCaps.supportsScalarSubqueries());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, srcCaps.supportsCorrelatedSubqueries());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, srcCaps.supportsSearchedCaseExpressions());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, srcCaps.supportsUnions());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_INTERSECT, srcCaps.supportsIntersect());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_EXCEPT, srcCaps.supportsExcept());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, srcCaps.supportsSetQueryOrderBy());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.BULK_UPDATE, srcCaps.supportsBulkUpdate());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, srcCaps.supportsBatchedUpdates());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FUNCTIONS_IN_GROUP_BY, srcCaps.supportsFunctionsInGroupBy());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, srcCaps.supportsRowLimit());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.ROW_OFFSET, srcCaps.supportsRowOffset());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_ANSI_JOIN, srcCaps.useAnsiJoin());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.REQUIRES_CRITERIA, srcCaps.requiresCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, srcCaps.supportsGroupBy());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ONLY_SINGLE_TABLE_GROUP_BY, srcCaps.supportsOnlySingleTableGroupBy());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_HAVING, srcCaps.supportsHaving());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.INSERT_WITH_QUERYEXPRESSION, srcCaps.supportsInsertWithQueryExpression());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_UNRELATED, srcCaps.supportsOrderByUnrelated());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_ENHANCED_NUMERIC, srcCaps.supportsAggregatesEnhancedNumeric());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_NULL_ORDERING, srcCaps.supportsOrderByNullOrdering());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.INSERT_WITH_ITERATOR, srcCaps.supportsBulkUpdate());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.COMMON_TABLE_EXPRESSIONS, srcCaps.supportsCommonTableExpressions());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.RECURSIVE_COMMON_TABLE_EXPRESSIONS, srcCaps.supportsRecursiveCommonTableExpressions());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.ELEMENTARY_OLAP, srcCaps.supportsElementaryOlapOperations());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.ADVANCED_OLAP, srcCaps.supportsAdvancedOlapOperations(), SourceCapabilities.Capability.ELEMENTARY_OLAP);
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.WINDOW_FUNCTION_ORDER_BY_AGGREGATES, srcCaps.supportsWindowOrderByWithAggregates(), SourceCapabilities.Capability.ELEMENTARY_OLAP);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_ARRAY, srcCaps.supportsArrayAgg());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_SIMILAR, srcCaps.supportsSimilarTo());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE_REGEX, srcCaps.supportsLikeRegex());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.WINDOW_FUNCTION_DISTINCT_AGGREGATES, srcCaps.supportsWindowDistinctAggregates(), SourceCapabilities.Capability.ELEMENTARY_OLAP, SourceCapabilities.Capability.QUERY_AGGREGATES_DISTINCT);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.ONLY_FORMAT_LITERALS, srcCaps.supportsOnlyFormatLiterals());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ONLY_LITERAL_COMPARE, srcCaps.supportsOnlyLiteralComparison());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.DEPENDENT_JOIN, srcCaps.supportsDependentJoins());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.FULL_DEPENDENT_JOIN, srcCaps.supportsFullDependentJoins());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ON_SUBQUERY, srcCaps.supportsSubqueryInOn());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.ARRAY_TYPE, srcCaps.supportsArrayType());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_ONLY_CORRELATED, srcCaps.supportsOnlyCorrelatedSubqueries());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_STRING, srcCaps.supportsStringAgg());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.SELECT_WITHOUT_FROM, srcCaps.supportsSelectWithoutFrom());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY_ROLLUP, srcCaps.supportsGroupByRollup());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_EXTENDED_GROUPING, srcCaps.supportsOrderByWithExtendedGrouping());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED_EXCLUSIVE, srcCaps.supportsCompareCriteriaOrderedExclusive());
        if (srcCaps.supportsPartialFiltering()) {
            tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.PARTIAL_FILTERS, true);
            Assertion.assertTrue((!srcCaps.supportsOuterJoins() ? 1 : 0) != 0);
            Assertion.assertTrue((!srcCaps.supportsFullOuterJoins() ? 1 : 0) != 0);
            Assertion.assertTrue((!srcCaps.supportsInlineViews() ? 1 : 0) != 0);
            Assertion.assertTrue((!srcCaps.supportsIntersect() ? 1 : 0) != 0);
            Assertion.assertTrue((!srcCaps.supportsExcept() ? 1 : 0) != 0);
            Assertion.assertTrue((!srcCaps.supportsSelectExpression() ? 1 : 0) != 0);
            Assertion.assertTrue((!srcCaps.supportsUnions() ? 1 : 0) != 0);
            Assertion.assertTrue((!srcCaps.supportsSelectDistinct() ? 1 : 0) != 0);
            Assertion.assertTrue((!srcCaps.supportsGroupBy() ? 1 : 0) != 0);
        }
        if ((functions = srcCaps.getSupportedFunctions()) != null && functions.size() > 0) {
            for (String func : functions) {
                tgtCaps.setFunctionSupport(func, true);
            }
        }
        if ((pushDowns = srcCaps.getPushDownFunctions()) != null && pushDowns.size() > 0) {
            for (FunctionMethod func : pushDowns) {
                tgtCaps.setFunctionSupport(func.getName(), true);
            }
        }
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, new Integer(srcCaps.getMaxInCriteriaSize()));
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, new Integer(srcCaps.getMaxDependentInPredicates()));
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.CONNECTOR_ID, connectorID);
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.MAX_QUERY_FROM_GROUPS, new Integer(srcCaps.getMaxFromGroups()));
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, srcCaps.getSupportedJoinCriteria());
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.QUERY_ORDERBY_DEFAULT_NULL_ORDER, srcCaps.getDefaultNullOrder());
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.COLLATION_LOCALE, srcCaps.getCollationLocale());
        return tgtCaps;
    }

    private static void setSupports(Object connectorID, BasicSourceCapabilities tgtCaps, SourceCapabilities.Capability cap, boolean supports, SourceCapabilities.Capability ... required) {
        if (!supports) {
            return;
        }
        for (SourceCapabilities.Capability capability : required) {
            if (tgtCaps.supportsCapability(capability)) continue;
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30003, new Object[]{cap, capability, connectorID}));
            supports = false;
        }
        tgtCaps.setCapabilitySupport(cap, supports);
    }
}

