/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.unittest.TimestampUtil;

public class TestFunctionMethods {
    @BeforeClass
    public static void oneTimeSetup() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-0600"));
    }

    @AfterClass
    public static void oneTimeTearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    @Test
    public void testUnescape() {
        Assert.assertEquals((Object)"a\t\n\n%6", (Object)FunctionMethods.unescape((String)"a\\t\\n\\012\\456"));
    }

    @Test
    public void testUnescape1() {
        Assert.assertEquals((Object)"a\u45aa'", (Object)FunctionMethods.unescape((String)"a\\u45Aa'"));
    }

    @Test
    public void testIso8601Week() {
        Assert.assertEquals((long)53L, (long)FunctionMethods.week((Date)TimestampUtil.createDate((int)105, (int)0, (int)1)));
    }

    @Test
    public void testIso8601Week1() {
        Assert.assertEquals((long)52L, (long)FunctionMethods.week((Date)TimestampUtil.createDate((int)106, (int)0, (int)1)));
    }

    @Test
    public void testDayOfWeek() {
        Assert.assertEquals((long)2L, (long)FunctionMethods.dayOfWeek((Date)TimestampUtil.createDate((int)111, (int)10, (int)28)));
    }

    @Test
    public void testTimestampDiffTimeStamp_ErrorUsingEndDate2304() throws Exception {
        Assert.assertEquals((Object)106753L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_DAY", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)1).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)404, (int)3, (int)13).getTime()), (boolean)false));
    }

    @Test
    public void testTimestampDiffTimeStamp_ErrorUsingEndDate2304a() throws Exception {
        Assert.assertEquals((Object)32244L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_DAY", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)1).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)200, (int)3, (int)13).getTime()), (boolean)true));
    }

    @Test
    public void testTimestampDiffCalendarBasedHour() throws Exception {
        Assert.assertEquals((Object)2562072L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_HOUR", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)1).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)404, (int)3, (int)13).getTime()), (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestampDiffCalendarBasedHour1() throws Exception {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("America/New York"));
        try {
            Assert.assertEquals((Object)2472L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_HOUR", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)1).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)3, (int)13).getTime()), (boolean)true));
        }
        finally {
            TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-0600"));
        }
    }

    @Test
    public void testTimestampDiffCalendarBasedMonth() throws Exception {
        Assert.assertEquals((Object)1L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_MONTH", (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)0, (int)10).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)112, (int)1, (int)1).getTime()), (boolean)true));
    }

    @Test
    public void testTimestampDiffCalendarBasedWeek() throws Exception {
        Assert.assertEquals((Object)1L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_WEEK", (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)2).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)3).getTime()), (boolean)true));
    }

    @Test
    public void testTimestampDiffCalendarBasedWeek1() throws Exception {
        Assert.assertEquals((Object)0L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_WEEK", (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)3).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)4).getTime()), (boolean)true));
    }

    @Test
    public void testTimestampDiffCalendarBasedWeek2() throws Exception {
        Assert.assertEquals((Object)0L, (Object)FunctionMethods.timestampDiff((String)"SQL_TSI_WEEK", (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)4).getTime()), (Timestamp)new Timestamp(TimestampUtil.createDate((int)113, (int)2, (int)3).getTime()), (boolean)true));
    }

    @Test
    public void regexpReplaceOkay() throws Exception {
        Assert.assertEquals((Object)"fooXbaz", (Object)FunctionMethods.regexpReplace(null, (String)"foobarbaz", (String)"b..", (String)"X"));
        Assert.assertEquals((Object)"fooXX", (Object)FunctionMethods.regexpReplace(null, (String)"foobarbaz", (String)"b..", (String)"X", (String)"g"));
        Assert.assertEquals((Object)"fooXarYXazY", (Object)FunctionMethods.regexpReplace(null, (String)"foobarbaz", (String)"b(..)", (String)"X$1Y", (String)"g"));
        Assert.assertEquals((Object)"fooBXRbXz", (Object)FunctionMethods.regexpReplace(null, (String)"fooBARbaz", (String)"a", (String)"X", (String)"gi"));
    }

    @Test(expected=FunctionExecutionException.class)
    public void regexpInvalidFlagsBad() throws Exception {
        FunctionMethods.regexpReplace(null, (String)"foobarbaz", (String)"b..", (String)"X", (String)"y");
    }

    @Test(expected=FunctionExecutionException.class)
    public void testAbsIntBounds() throws FunctionExecutionException {
        FunctionMethods.abs((int)Integer.MIN_VALUE);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testAbsLongBounds() throws FunctionExecutionException {
        FunctionMethods.abs((long)Long.MIN_VALUE);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testPlusLongBounds() throws FunctionExecutionException {
        FunctionMethods.plus((long)Long.MIN_VALUE, (long)-1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testPlusLongBounds1() throws FunctionExecutionException {
        FunctionMethods.plus((long)Long.MAX_VALUE, (long)1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testPlusIntBounds() throws FunctionExecutionException {
        FunctionMethods.plus((int)Integer.MIN_VALUE, (int)-1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testPlusIntBounds1() throws FunctionExecutionException {
        FunctionMethods.plus((int)Integer.MAX_VALUE, (int)1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMinusIntBounds1() throws FunctionExecutionException {
        FunctionMethods.minus((int)Integer.MAX_VALUE, (int)-1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMinusLongBounds() throws FunctionExecutionException {
        FunctionMethods.minus((long)Long.MIN_VALUE, (long)1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMinusLongBounds1() throws FunctionExecutionException {
        FunctionMethods.minus((long)Long.MAX_VALUE, (long)-1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMinusIntBounds() throws FunctionExecutionException {
        FunctionMethods.minus((int)Integer.MIN_VALUE, (int)1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testDivideIntBounds() throws FunctionExecutionException {
        FunctionMethods.divide((int)Integer.MIN_VALUE, (int)-1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testDivedLongBounds() throws FunctionExecutionException {
        FunctionMethods.divide((long)Long.MIN_VALUE, (long)-1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultLongBounds() throws FunctionExecutionException {
        FunctionMethods.multiply((long)Long.MIN_VALUE, (long)-1L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultLongBounds1() throws FunctionExecutionException {
        FunctionMethods.multiply((long)Long.MAX_VALUE, (long)2L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultLongBounds2() throws FunctionExecutionException {
        FunctionMethods.multiply((long)Long.MIN_VALUE, (long)-2L);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultIntBounds() throws FunctionExecutionException {
        FunctionMethods.multiply((int)Integer.MIN_VALUE, (int)-1);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultIntBounds1() throws FunctionExecutionException {
        FunctionMethods.multiply((int)Integer.MAX_VALUE, (int)2);
    }

    @Test(expected=FunctionExecutionException.class)
    public void testMultIntBounds2() throws FunctionExecutionException {
        FunctionMethods.multiply((int)Integer.MIN_VALUE, (int)-2);
    }
}

