/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.client.DQP;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.net.ServerConnection;

public class TestConnection {
    protected static final String STD_DATABASE_NAME = "QT_Ora9DS";
    protected static final int STD_DATABASE_VERSION = 1;
    static String serverUrl = "jdbc:teiid:QT_Ora9DS@mm://localhost:7001;version=1;user=metamatrixadmin;password=mm";

    public static ConnectionImpl getMMConnection() {
        return TestConnection.getMMConnection(serverUrl);
    }

    public static ConnectionImpl getMMConnection(String url) {
        ServerConnection mock = (ServerConnection)Mockito.mock(ServerConnection.class);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        try {
            Mockito.stub((Object)dqp.start((XidImpl)Mockito.anyObject(), Mockito.anyInt(), Mockito.anyInt())).toAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return ResultsFuture.NULL_FUTURE;
                }
            });
            Mockito.stub((Object)dqp.rollback((XidImpl)Mockito.anyObject())).toAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return ResultsFuture.NULL_FUTURE;
                }
            });
            Mockito.stub((Object)dqp.rollback()).toAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return ResultsFuture.NULL_FUTURE;
                }
            });
        }
        catch (XATransactionException e) {
            throw new RuntimeException(e);
        }
        Properties props = new Properties();
        try {
            new InnerDriver(url).parseUrl(props);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Mockito.stub((Object)mock.getService(DQP.class)).toReturn((Object)dqp);
        Mockito.stub((Object)mock.getLogonResult()).toReturn((Object)new LogonResult(new SessionToken(1L, "admin"), STD_DATABASE_NAME, 1, "fake"));
        return new ConnectionImpl(mock, props, url);
    }

    @Test
    public void testGetMetaData() throws Exception {
        Assert.assertNotNull((Object)TestConnection.getMMConnection().getMetaData());
    }

    @Test
    public void testGetSchema() throws Exception {
        Assert.assertEquals((String)"Actual schema is not equql to the expected one. ", (Object)STD_DATABASE_NAME, (Object)TestConnection.getMMConnection().getVDBName());
    }

    @Test
    public void testNativeSql() throws Exception {
        String sql = "SELECT * FROM BQT1.SmallA";
        Assert.assertEquals((String)"Actual schema is not equql to the expected one. ", (Object)sql, (Object)TestConnection.getMMConnection().nativeSQL(sql));
    }

    @Test
    public void testGetUserName2() throws Exception {
        Assert.assertEquals((String)"Actual userName is not equal to the expected one. ", (Object)"admin", (Object)TestConnection.getMMConnection().getUserName());
    }

    @Test
    public void testIsReadOnly() throws Exception {
        Assert.assertEquals((Object)false, (Object)TestConnection.getMMConnection().isReadOnly());
    }

    @Test
    public void testSetReadOnly1() throws Exception {
        ConnectionImpl conn = TestConnection.getMMConnection();
        conn.setReadOnly(true);
        Assert.assertEquals((Object)true, (Object)conn.isReadOnly());
    }

    @Test
    public void testSetReadOnly2() throws Exception {
        ConnectionImpl conn = TestConnection.getMMConnection();
        conn.setAutoCommit(false);
        try {
            conn.setReadOnly(true);
            Assert.fail((String)"Error Expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultSpec() throws Exception {
        Assert.assertEquals((Object)"true", (Object)(TestConnection.getMMConnection().getExecutionProperties().getProperty("useJDBC4ColumnNameAndLabelSemantics") == null ? "true" : "false"));
    }

    @Test
    public void testTurnOnSpec() throws Exception {
        Assert.assertEquals((Object)"true", (Object)TestConnection.getMMConnection(serverUrl + ";useJDBC4ColumnNameAndLabelSemantics=true").getExecutionProperties().getProperty("useJDBC4ColumnNameAndLabelSemantics"));
    }

    @Test
    public void testTurnOffSpec() throws Exception {
        Assert.assertEquals((Object)"false", (Object)TestConnection.getMMConnection(serverUrl + ";useJDBC4ColumnNameAndLabelSemantics=false").getExecutionProperties().getProperty("useJDBC4ColumnNameAndLabelSemantics"));
    }

    @Test
    public void testCreateArray() throws SQLException {
        java.sql.Array array = TestConnection.getMMConnection().createArrayOf("integer[]", (Object[])new Integer[]{3, 4});
        Assert.assertEquals((Object)3, (Object)Array.get(array.getArray(), 0));
    }

    static class InnerDriver
    extends TeiidDriver {
        String iurl = null;

        public InnerDriver(String url) {
            this.iurl = url;
        }

        public void parseUrl(Properties props) throws SQLException {
            TeiidDriver.parseURL((String)this.iurl, (Properties)props);
        }
    }
}

