/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.arquillian.SampleFunctions;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestDynamicViewDefinition
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testViewDefinition() throws Exception {
        this.admin.deploy("dynamicview-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"dynamicview-vdb.xml")));
        Properties props = new Properties();
        props.setProperty("ParentDirectory", ".");
        props.setProperty("AllowParentPaths", "true");
        props.setProperty("class-name", "org.teiid.resource.adapter.file.FileManagedConnectionFactory");
        AdminUtil.createDataSource(this.admin, "marketdata-file", "file", props);
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "dynamic", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:dynamic@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Sys.Columns WHERE tablename='stock'");
        this.assertRowCount(2);
    }

    @Test
    public void testUdfClasspath() throws Exception {
        JavaArchive jar = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"func.jar")).addClasses(new Class[]{SampleFunctions.class});
        this.admin.deploy("func.jar", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
        this.admin.deploy("dynamicfunc-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"dynamicfunc-vdb.xml")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "dynamic-func", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:dynamic-func@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT func('a')");
        this.assertRowCount(1);
    }

    @Test
    public void testVdbZipWithDDL() throws Exception {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"temp.jar")).addAsManifestResource(UnitTestUtil.getTestDataFile((String)"vdb.xml"))).addAsResource(UnitTestUtil.getTestDataFile((String)"test.ddl"));
        this.admin.deploy("dynamic-ddl.vdb", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "dynamic-ddl", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:dynamic-ddl@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * from stock");
        this.assertRowCount(1);
    }
}

